/*
 * This program is released to the public domain by the author.
 *
 * Hopefully it'll stop some of the bitching.
 */

#define INCL_DOS
#define INCL_VIO

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <limits.h>

typedef struct SECTIONS {
  char             *name;
  long              offset;
  long              lines;
  struct SECTIONS  *next;
} SECTIONS;

typedef struct ARTICLES {
  char            *name;
  char            *author;
  long             offset;
  long             lines;
  struct ARTICLES *next;
} ARTICLES;

typedef struct ASSHOLES {
  char            *name;
  struct ASSHOLES *next;
} ASSHOLES;

#define STATE_ERROR         -1
#define STATE_NONE          0
#define STATE_START         1
#define STATE_ISSECTION     2
#define STATE_WASSECTION    3
#define STATE_ISARTICLE     4
#define STATE_INSECTION     5
#define STATE_INARTICLE     6
#define STATE_ASSARTICLE    7

#define WND_TOP   "ķ"
#define WND_SIDEL ""
#define WND_SIDER ""
#define WND_BOT   "ͼ"

/* strip all leading spaces and tabs from a string */
#define lstrip(s)         strip_lead_char(" \t",(s))
/* strip all trailing spaces and tabs from a string */
#define rstrip(s)         strip_trail_char(" \t",(s))
/*strip all trailing linefeeds and carriage returns from a string */
#define stripcr(s)        strip_trail_char("\r\n",(s))

ASSHOLES *asses = NULL,*cusses = NULL;
char      printer[CCHMAXPATH] = "PRN",editor[CCHMAXPATH] = "Q.EXE";
int       pagelen = 54,pagetop = 6,pagemargin = 4;

int       deleteme = FALSE;
char      newsletter[CCHMAXPATH];


void Cleanup (void) {

  fcloseall();
  if(deleteme)
    remove(newsletter);
  deleteme = FALSE;
}


char * stristr (register char *t, char *s) {

  register char *t1,*s1;

  while (*t) {
    t1 = t;
    s1 = s;
    while (*s1) {
      if (toupper (*s1) != toupper (*t))
        break;
      else {
        s1++;
        t++;
      }
    }
    if (!*s1)
      return t1;
    t = t1 + 1;
  }
  return NULL;
}


char * to_delim (char *a,register char *delim) {

  register char *p = a;

  if(p && delim) {
    while(*p) {
      if(strchr(delim,*p))
        break;
      p++;
    }
  }
  return p;
}


char * strip_trail_char (register char *strip,register char *a) {

  register char *p;

  if(a && *a && strip && *strip) {
    p = a + (strlen(a) - 1);
    while (*a && strchr(strip,*p) != NULL) {
      *p = 0;
      p--;
    }
  }
  return a;
}


char * strip_lead_char (register char *strip,register char *a) {

  register char *p = a;

  if(a && *a && strip && *strip) {
    while(*p && strchr(strip,*p) != NULL)
      p++;
    if(p != a)
      memmove(a,p,strlen(p) + 1);
  }
  return a;
}


void FreeArticles (ARTICLES *head) {

  ARTICLES *info,*next;

  info = head;
  while(info) {
    next = info->next;
    if(info->name)
      free(info->name);
    if(info->author)
      free(info->author);
    free(info);
    info = next;
  }
}


void FreeSections (SECTIONS *head) {

  SECTIONS *info,*next;

  info = head;
  while(info) {
    next = info->next;
    if(info->name)
      free(info->name);
    free(info);
    info = next;
  }
}


void LoadAssholes (FILE *cfg) {

  long      pos;
  char      s[81];
  ASSHOLES *info,*last = NULL;

  if(cfg) {
    while(!feof(cfg)) {
      pos = ftell(cfg);
      if(!fgets(s,81,cfg))
        break;
      stripcr(s);
      lstrip(rstrip(s));
      if(*s) {
        if(*s == '[' && s[strlen(s) - 1] == ']') {
          fseek(cfg,pos,SEEK_SET);
          break;
        }
        info = malloc(sizeof(ASSHOLES));
        if(info) {
          memset(info,0,sizeof(ASSHOLES));
          info->name = strdup(s);
          if(info->name) {
            if(last)
              last->next = info;
            else
              asses = info;
            last = info;
          }
          else
            free(info);
        }
      }
    }
  }
}


void LoadCusses (FILE *cfg) {

  long      pos;
  char      s[81];
  ASSHOLES *info,*last = NULL;

  if(cfg) {
    while(!feof(cfg)) {
      pos = ftell(cfg);
      if(!fgets(s,81,cfg))
        break;
      stripcr(s);
      lstrip(rstrip(s));
      if(*s) {
        if(*s == '[' && s[strlen(s) - 1] == ']') {
          fseek(cfg,pos,SEEK_SET);
          break;
        }
        info = malloc(sizeof(ASSHOLES));
        if(info) {
          memset(info,0,sizeof(ASSHOLES));
          info->name = strdup(s);
          if(info->name) {
            if(last)
              last->next = info;
            else
              cusses = info;
            last = info;
          }
          else
            free(info);
        }
      }
    }
  }
}


void LoadConfig (FILE *cfg) {

  char s[CCHMAXPATH + 3],*mine,*notmine;
  int  inmine = FALSE;

  if(cfg) {
    mine = (_osmode == OS2_MODE) ? "[OS/2]" : "[DOS]";
    notmine = (_osmode == OS2_MODE) ? "[DOS]" : "[OS/2]";
    while(!feof(cfg)) {
      if(!fgets(s,81,cfg))
        break;
      s[CCHMAXPATH + 2] = 0;
      stripcr(s);
      lstrip(rstrip(s));
      if(!stricmp(s,mine))
        inmine = TRUE;
      else if(!stricmp(s,notmine))
        inmine = FALSE;
      else if(!stricmp(s,"[Assholes]"))
        LoadAssholes(cfg);
      else if(!stricmp(s,"[Exclude]"))
        LoadCusses(cfg);
      else if(inmine) {
        if(!strnicmp(s,"Printer=",8))
          strcpy(printer,s + 8);
        else if(!strnicmp(s,"Editor=",7))
          strcpy(editor,s + 7);
        else if(!strnicmp(s,"Pagelen=",8))
          pagelen = atoi(s + 8);
        else if(!strnicmp(s,"PageMargin=",11))
          pagemargin = atoi(s + 11);
        else if(!strnicmp(s,"PageTop=",8))
          pagetop = atoi(s + 8);
      }
    }
  }
}


void CursorOff (HVIO hvio) {

  VIOCURSORINFO vc;

  VioGetCurType(&vc,hvio);
  vc.attr = -1;
  VioSetCurType(&vc,hvio);
}


void CursorOn (HVIO hvio) {

  VIOCURSORINFO vc;

  VioGetCurType(&vc,hvio);
  vc.attr = 0;
  VioSetCurType(&vc,hvio);

}


void ClearWindow (VIOMODEINFO *vm,HVIO hvio) {

  USHORT attr = (' ' | ((7 << 4) << 8));

  VioScrollUp(1,1,vm->row - 2,77,(USHORT)-1,(char *)&attr,hvio);
}


void ClearScreen (HVIO hvio) {

  USHORT attr = (' ' | (7 << 8));

  VioScrollUp(0,0,(USHORT)-1,(USHORT)-1,(USHORT)-1,(char *)&attr,hvio);
}


void InitScreen (HVIO hvio) {

  VIOINTENSITY vi;

  memset(&vi,0,sizeof(vi));
  vi.cb = sizeof(vi);
  vi.type = 2;
  vi.fs = 1;
  VioSetState(&vi,hvio);
  CursorOff(hvio);
  ClearScreen(hvio);
}


void ClearKeybuff (void) {

  while(kbhit())
    getch();
}


void DrawStatus (char *status,VIOMODEINFO *vm,HVIO hvio) {

  USHORT rattr = (' ' | ((8 << 4) << 8));
  char   lattr = (8 << 4),wattr = (7 << 4);

  VioWrtCharStrAtt(" ",1,vm->row - 1,0,&wattr,hvio);
  VioWrtCharStrAtt(status,min(strlen(status),79),vm->row - 1,1,
                   &lattr,hvio);
  if(strlen(status) < 79)
    VioWrtNCell((char *)&rattr,79 - min(strlen(status),79),vm->row - 1,
                min(strlen(status),79) + 1,hvio);
}


void DrawWindow (char *filename,char *title,VIOMODEINFO *vm,HVIO hvio) {

  USHORT x;
  char   wattr = (7 << 4) | 15;
  char   battr = (7 << 4);
  char   dattr = (8 << 4) | 15;

  ClearWindow(vm,hvio);
  VioWrtCharStrAtt(WND_TOP,79,0,0,&wattr,hvio);
  VioWrtCharStrAtt(" ",1,0,79,&battr,hvio);
  for(x = 1;x < vm->row - 2;x++) {
    VioWrtCharStrAtt(WND_SIDEL,1,x,0,&wattr,hvio);
    VioWrtCharStrAtt(WND_SIDER,1,x,78,&battr,hvio);
    VioWrtCharStrAtt(" ",1,x,79,&dattr,hvio);
  }
  VioWrtCharStrAtt(WND_BOT,79,vm->row - 2,0,&battr,hvio);
  VioWrtCharStrAtt(" ",1,vm->row - 2,79,&dattr,hvio);
  if(*title)
    VioWrtCharStrAtt(title,min(strlen(title),75),0,
                     (79 - min(strlen(title),75)) / 2,&dattr,hvio);
  if(*filename)
    VioWrtCharStrAtt(filename,min(strlen(filename),75),vm->row - 2,
                     (79 - min(strlen(filename),75)) / 2,&dattr,hvio);
}


void Config (HVIO hvio) {

  char s[CCHMAXPATH + 80];

  sprintf(s,"%s FNEWS.INI",editor);
  ClearScreen(hvio);
  CursorOn(hvio);
  system(s);
  InitScreen(hvio);
}


char * PickFile (VIOMODEINFO *vm,HVIO hvio) {

  FILEFINDBUF  fb;
  long         selected = 0L,start = 0L,numfiles = 0L,x;
  USHORT       nm = 1,key,lattr;
  HDIR         hdir = HDIR_SYSTEM;
  char       **files = NULL,**test,sattr,*p;
  char         check[CCHMAXPATH];
  static char  nums[] = {"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
  static char  filename[CCHMAXPATH],s[CCHMAXPATH + 80];

  *newsletter = *filename = 0;
  if(!DosFindFirst("*.NWS",&hdir,FILE_NORMAL | FILE_ARCHIVED,
                   &fb,sizeof(fb),&nm,0L)) {
    do {
      test = realloc(files,sizeof(char *) * ((USHORT)numfiles + 1));
      if(test) {
        files = test;
        files[numfiles] = strdup(fb.achName);
        if(!files[numfiles])
          break;
        numfiles++;
      }
      else
        break;
      nm = 1;
    } while(!DosFindNext(hdir,&fb,sizeof(fb),&nm));
    DosFindClose(hdir);
  }
  nm = 1;
  hdir = HDIR_SYSTEM;
  if(!DosFindFirst("FNEWS*.LZH",&hdir,FILE_NORMAL | FILE_ARCHIVED,
                   &fb,sizeof(fb),&nm,0L)) {
    do {
      p = strchr(nums,toupper(fb.achName[5]));
      if(!p)
        goto Continuing;
      if(atoi(&fb.achName[6]) < 0 || atoi(&fb.achName[6]) > 52)
        goto Continuing;
      sprintf(check,"FIDO%02d%2.2s.NWS",(int)(p - nums),&fb.achName[6]);
      for(x = 0;x < numfiles;x++) {
        if(!stricmp(files[x],check))
          goto Continuing;
      }
      test = realloc(files,sizeof(char *) * ((USHORT)numfiles + 1));
      if(test) {
        files = test;
        files[numfiles] = strdup(fb.achName);
        if(!files[numfiles])
          break;
        numfiles++;
      }
      else
        break;
Continuing:
      nm = 1;
    } while(!DosFindNext(hdir,&fb,sizeof(fb),&nm));
    DosFindClose(hdir);
  }
  if(numfiles) {
    DrawWindow(" *.NWS "," Select a newsletter to view ",vm,hvio);
    DrawStatus(" [Enter] = select   [Esc] = cancel",vm,hvio);
    do {
      for(x = start;x < numfiles && x - start < (long)vm->row - 3L;x++) {
        sattr = (char)((x == selected) ? (8 << 4) : (7 << 4));
        lattr = (' ' | (((x == selected) ? (8 << 4) : (7 << 4)) << 8));
        VioWrtCharStrAtt(files[x],min(strlen(files[x]),75),
                      (USHORT)(x - start) + 1,2,&sattr,hvio);
        VioWrtNCell((char *)&lattr,77 - (min(strlen(files[x]),75) + 2),
                    (USHORT)(x - start) + 1,
                    min(strlen(files[x]),75) + 2,hvio);
      }
Again:
      key = getch();
      key = toupper(key);
      if(!key || key == 0xe0)
        key = getch() | 256;
      switch(key) {
        case 80 | 256:  /* down arrow */
          selected++;
          if(selected >= numfiles) /* wrap it */
            selected = start = 0L;
          else if(selected > start + (long)(vm->row - 3))     /* scroll it */
            start = selected - (long)(vm->row - 3);
          break;
        case 72 | 256:  /* up arrow */
          selected--;
          if(selected < 0) {                                  /* wrap it */
            selected = numfiles - 1L;
            start = selected - (long)(vm->row - 3);
            if(start < 0L)
              start = 0L;
          }
          else if(selected < start)                           /* scroll it */
            start = selected;
          break;
        case 79 | 256:  /* end */
          selected = numfiles - 1L;
          start = selected - (long)(vm->row - 3);
          if(start < 0L)
            start = 0L;
          break;
        case 71 | 256:  /* home */
          start = selected = 0L;
          break;
        case '\r':
        case '\n':
          if(selected < numfiles && files[selected]) {
            p = strchr(files[selected],'.');
            if(p && !stricmp(p,".LZH")) {
              p = strchr(nums,toupper(files[selected][5]));
              if(p) {
                if(atoi(&files[selected][6]) >= 0 &&
                   atoi(&files[selected][6]) < 52) {
                  sprintf(check,"FIDO%02d%2.2s.NWS",(int)(p - nums),
                          &files[selected][6]);
                  if(_osmode == OS2_MODE)
                    sprintf(s,"LH.EXE x %s %s",files[selected],check);
                  else
                    sprintf(s,"LHA.EXE x %s %s",files[selected],check);
                  VioSetCurPos(vm->row - 1,0,hvio);
                  printf("\n");
                  CursorOn(hvio);
                  system(s);
                  InitScreen(hvio);
                  nm = 1;
                  hdir = HDIR_SYSTEM;
                  if(!DosFindFirst(check,&hdir,FILE_NORMAL | FILE_ARCHIVED,
                                    &fb,sizeof(fb),&nm,0L)) {
                    strcpy(filename,check);
                    deleteme = TRUE;
                    DosFindClose(hdir);
                  }
                  else
                    key = 0;
                }
                else
                  key = 0;
              }
              else
                key = 0;
            }
            else
              strcpy(filename,files[selected]);
          }
          else
            key = 0;
          if(!key) {
            DosBeep(50,100);
            goto Again;
          }
          break;
        case 61 | 256:
        case 45 | 256:
          VioSetCurPos(vm->row - 1,0,hvio);
          exit(0);
        case '\x1b':
          break;
        default:
          DosBeep(50,10);
          goto Again;
      }
    } while(key != '\r' && key != '\n' && key != '\x1b');

  }
  if(files) {
    for(x = 0;x < numfiles;x++) {
      if(files[x])
        free(files[x]);
    }
    free(files);
  }
  return (*filename != 0) ? filename : NULL;
}


void ShowPiece (char *filename,char *title,FILE *fp,long pos,long numlines,
                VIOMODEINFO *vm,HVIO hvio,int immediatereturn) {

  long       *lines,x,start = 0,laststart = -1L;
  int         key,lastblank;
  char        s[81],titl[73];

  if(numlines) {
    /* allocate line pointers */
    lines = malloc((size_t)numlines * sizeof(long));
    if(lines) {
      if(title && *title) {
        strncpy(titl + 1,title,70);
        *titl = ' ';
        titl[72] = 0;
        strcat(titl," ");
      }
      else
        *titl = 0;
      DrawWindow(filename,titl,vm,hvio);
      sprintf(s," Loading %0.70s",title);
      DrawStatus(s,vm,hvio);
      for(x = 1;x < numlines;x++)
        lines[x] = -1L;
      fseek(fp,pos,SEEK_SET);
      lastblank = FALSE;
      for(x = 0;x < numlines;x++) {
        lines[x] = ftell(fp);
        if(feof(fp) || !fgets(s,81,fp))
          break;
        s[78] = 0;
        stripcr(s);
        if((lastblank && !*s) || *s == '\x0c') {
          lines[x] = -1L;
          x--;
          continue;
        }
        lastblank = (*s != 0) ? FALSE : TRUE;
      }
      do {
        if(start != laststart) {
          for(x = start;x < numlines && x - start < (long)vm->row - 3L;x++) {
            fseek(fp,lines[x],SEEK_SET);
            if(feof(fp) || !fgets(s,81,fp))
              break;
            s[78] = 0;
            stripcr(s);
            if(*s)
              VioWrtCharStr(s,min(strlen(s),75),
                            (USHORT)((x - start) + 1L),2,hvio);
            VioWrtNChar(" ",77 - (min(strlen(s),75) + 2),
                        (USHORT)((x - start) + 1L),
                        min(strlen(s),75) + 2,hvio);
          }
          sprintf(s," %ld total lines   %ld-%ld   [P] = Print   [Esc] = return to menu.",
                  numlines,start + 1,
                  min(numlines,(start + ((long)vm->row - 3L))));
          DrawStatus(s,vm,hvio);
        }
        if(!immediatereturn) {
          laststart = start;
Again:
          key = getch();
          key = toupper(key);
          if(!key || key == 0xe0)
            key = getch() | 256;
          switch(key) {
            case 'P':
              if(numlines) {

                FILE *prn;
                long  clines;

                prn = fopen(printer,"w");
                if(prn) {
                  DrawStatus(" Printing piece...",vm,hvio);
                  for(clines = 0L;clines < (long)pagetop;clines++)
                    fputc('\n',prn);
                  for(x = 0;x < numlines;x++) {
                    fseek(fp,lines[x],SEEK_SET);
                    if(feof(fp) || !fgets(s,81,fp))
                      break;
                    s[78] = 0;
                    stripcr(s);
                    fprintf(prn,"%*.*s%s\n",pagemargin,pagemargin," ",s);
                    clines++;
                    if(clines >= pagelen && x + 1 < numlines) {
                      fputc('\x0c',prn);  /* formfeed */
                      for(clines = 0L;clines < (long)pagetop;clines++)
                        fputc('\n',prn);
                    }
                  }
                  fputc('\x0c',prn);
                  fclose(prn);
                }
                ClearKeybuff();
                sprintf(s," %ld total lines   %ld-%ld   [P] = Print   [Esc] = return to menu.",
                        numlines,start + 1,
                        min(numlines,(start + ((long)vm->row - 3L))));
                DrawStatus(s,vm,hvio);
              }
              break;
            case 80 | 256:  /* down arrow */
              start++;
              break;
            case 72 | 256:  /* up arrow */
              start--;
              break;
            case 81 | 256:  /* pgdn */
              start += (vm->row - 4);
              break;
            case 73 | 256:  /* pgup */
              start -= (vm->row - 4);
              break;
            case 79 | 256:  /* end */
              start = LONG_MAX;
              break;
            case 71 | 256:  /* home */
              start = 0;
              break;
            case 45 | 256:
            case 61 | 256:
              VioSetCurPos(vm->row - 1,0,hvio);
              exit(0);
            case '\x1b':
              break;
            default:
              DosBeep(50,10);
              goto Again;
          }
          if(start > numlines - (vm->row - 3))
            start = numlines - (vm->row - 3);
          if(start < 0L)
            start = 0L;
        }
        else
          break;
      } while(key != '\x1b');
      free(lines);
    }
  }
}


void ShowFnews (char *filename,FILE *fp,SECTIONS *sections,
                ARTICLES *articles,VIOMODEINFO *vm,HVIO hvio) {

  SECTIONS *sinfo,**sarray;
  ARTICLES *ainfo,**aarray;
  USHORT    numsecs,numarts,key,x,sects = 1,lattr;
  long      selected = 0L,start = 0L;
  char      s[162],sattr;

  /* build arrays from linked lists */
  numsecs = 0;
  sinfo = sections;
  while(sinfo) {
    numsecs++;
    sinfo = sinfo->next;
  }
  sarray = malloc(sizeof(SECTIONS *) * (numsecs + 1));
  if(!sarray) {
    printf("\n**Out of memory\n");
    return;
  }
  sinfo = sections;
  x = 0;
  while(sinfo) {
    sarray[x++] = sinfo;
    sinfo = sinfo->next;
  }

  numarts = 0;
  ainfo = articles;
  while(ainfo) {
    numarts++;
    ainfo = ainfo->next;
  }
  aarray = malloc(sizeof(ARTICLES *) * (numarts + 1));
  if(!aarray) {
    free(sarray);
    printf("\n**Out of memory\n");
    return;
  }
  ainfo = articles;
  x = 0;
  while(ainfo) {
    aarray[x++] = ainfo;
    ainfo = ainfo->next;
  }

  DrawWindow(filename," Sections ",vm,hvio);
  do {
    strcpy(s," [S] = Sections   [A] = Articles   [C] = Config   [P] = Print   [Esc] = Exit");
    DrawStatus(s,vm,hvio);
    if(sects) {
      for(x = (USHORT)start;x < numsecs && x - (USHORT)start < vm->row - 3;
          x++) {
        sprintf(s,"%s (%ld)",sarray[x]->name,sarray[x]->lines);
        sattr = (char)((x == (USHORT)selected) ? (8 << 4) : (7 << 4));
        lattr = (' ' | (((x == (USHORT)selected) ? (8 << 4) : (7 << 4)) << 8));
        VioWrtCharStrAtt(s,min(strlen(s),75),
                      (x - (USHORT)start) + 1,2,&sattr,hvio);
        VioWrtNCell((char *)&lattr,77 - (min(strlen(s),75) + 2),
                    (x - (USHORT)start) + 1,min(strlen(s),75) + 2,hvio);
      }
    }
    else {
      for(x = (USHORT)start;x < numarts && x - (USHORT)start < vm->row - 3;
          x++) {
        sprintf(s,"\"%s\" by %s (%ld)",aarray[x]->name,aarray[x]->author,
                aarray[x]->lines);
        sattr = (char)((x == (USHORT)selected) ? (8 << 4) : (7 << 4));
        lattr = (' ' | (((x == (USHORT)selected) ? (8 << 4) : (7 << 4)) << 8));
        VioWrtCharStrAtt(s,min(strlen(s),75),
                      (x - (USHORT)start) + 1,2,&sattr,hvio);
        VioWrtNCell((char *)&lattr,77 - (min(strlen(s),75) + 2),
                    (x - (USHORT)start) + 1,min(strlen(s),75) + 2,hvio);
      }
    }
Again:
    key = getch();
    key = toupper(key);
    if(!key || key == 0xe0)
      key = getch() | 256;
    switch(key) {
      case 'A':
        if(!sects)
          goto Again;
        sects = 0;
        selected = 0L;
        start = 0L;
        DrawWindow(filename," Articles ",vm,hvio);
        break;
      case 'C':
        ClearScreen(hvio);
        Config(hvio);
        CursorOff(hvio);
        DrawWindow(filename,(sects != 0) ? " Sections " : " Articles ",
                   vm,hvio);
        break;
      case 'P':
        {
          FILE *prn;

          prn = fopen(printer,"w");
          if(prn) {
            DrawStatus(" Printing newsletter...",vm,hvio);
            fseek(fp,0L,SEEK_SET);
            while(!feof(fp)) {
              if(feof(fp) || !fgets(s,81,fp))
                break;
              s[78] = 0;
              stripcr(s);
              fprintf(prn,"%*.*s%s\n",pagemargin,pagemargin," ",s);
            }
            fclose(prn);
          }
          ClearKeybuff();
        }
        break;
      case 'S':
        if(sects)
          goto Again;
        sects = 1;
        selected = 0L;
        start = 0L;
        DrawWindow(filename," Sections ",vm,hvio);
        break;
      case 80 | 256:  /* down arrow */
        selected++;
        if(selected >= (long)((sects) ? numsecs : numarts)) /* wrap it */
          selected = start = 0L;
        else if(selected > start + (long)(vm->row - 3))     /* scroll it */
          start = selected - (long)(vm->row - 3);
        break;
      case 72 | 256:  /* up arrow */
        selected--;
        if(selected < 0) {                                  /* wrap it */
          selected = (long)((sects) ? numsecs : numarts) - 1L;
          start = selected - (long)(vm->row - 3);
          if(start < 0L)
            start = 0L;
        }
        else if(selected < start)                           /* scroll it */
          start = selected;
        break;
      case 79 | 256:  /* end */
        selected = (long)((sects) ? numsecs : numarts) - 1L;
        start = selected - (long)(vm->row - 3);
        if(start < 0L)
          start = 0L;
        break;
      case 71 | 256:  /* home */
        start = selected = 0L;
        break;
      case '\r':
      case '\n':
        if(sects && selected < (long)numsecs)
          ShowPiece(filename,sarray[selected]->name,fp,
                    sarray[selected]->offset,sarray[selected]->lines,
                    vm,hvio,FALSE);
        else if(!sects && selected < (long)numarts)
          ShowPiece(filename,aarray[selected]->name,fp,
                    aarray[selected]->offset,aarray[selected]->lines,
                    vm,hvio,FALSE);
        else
          DosBeep(250,100);
        DrawWindow(filename,(sects != 0) ? " Sections " : " Articles ",
                   vm,hvio);
        break;
      case 61 | 256:
      case 45 | 256:
        VioSetCurPos(vm->row - 1,0,hvio);
        exit(0);
      case '\x1b':
        break;
      default:
        DosBeep(50,10);
        goto Again;
    }
  } while(key != '\x1b');
  free(sarray);
  free(aarray);
}


int LoadFnews (FILE *fp,SECTIONS **sections,ARTICLES **articles) {

  SECTIONS *sinfo,*slast = NULL;
  ARTICLES *ainfo = NULL,*alast = NULL;
  ASSHOLES *info;
  char      s[81],*p,test[81];
  int       state = STATE_START;
  int       artender,secheader,lastblank;
  long      pos;

  sinfo = malloc(sizeof(SECTIONS));
  if(sinfo) {
    memset(sinfo,0,sizeof(SECTIONS));
    sinfo->name = strdup("Start");
    *sections = slast = sinfo;
  }
  else
    state = STATE_ERROR;
  lastblank = FALSE;
  while(state != STATE_ERROR && !feof(fp)) {
    pos = ftell(fp);
    if(!fgets(s,81,fp))
      break;
    s[80] = 0;
    stripcr(s);
    lstrip(rstrip(s));
    if((!*s && lastblank) || *s == '\x0c')
      continue;
    lastblank = (*s != 0) ? FALSE : TRUE;
    secheader = strcmp(s,"========================================================================");
    artender = strcmp(s,"----------------------------------------------------------------------");
    switch(state) {
      case STATE_START:
        if(!secheader)
          state = STATE_ISSECTION;
        else
          sinfo->lines++;
        break;
      case STATE_NONE:
        if(!secheader)
          state = STATE_ISSECTION;
        break;
      case STATE_ISSECTION:
        if(!strcmp(s,"Articles")) {
          state = STATE_ISARTICLE;
          fgets(s,81,fp);
          break;
        }
        sinfo = malloc(sizeof(SECTIONS));
        if(sinfo) {
          memset(sinfo,0,sizeof(SECTIONS));
          sinfo->lines = 1L;
          sinfo->name = strdup(s);
          if(!sinfo->name)
            state = STATE_ERROR;
          else {
            sinfo->offset = pos;
            if(slast)
              slast->next = sinfo;
            else
              *sections = sinfo;
            slast = sinfo;
          }
          if(state == STATE_ISSECTION)
            state = STATE_WASSECTION;
        }
        break;
      case STATE_WASSECTION:
        sinfo->lines++;
        state = STATE_INSECTION;
        break;
      case STATE_ISARTICLE:
        if(!secheader)
          state = STATE_ISSECTION;
        else if(*s) {
          ainfo = malloc(sizeof(ARTICLES));
          if(ainfo) {
            memset(ainfo,0,sizeof(ARTICLES));
            ainfo->offset = pos;
            ainfo->lines = 1L;
            ainfo->name = strdup(s);
            if(!ainfo->name)
              state = STATE_ERROR;
            else {
              if(alast)
                alast->next = ainfo;
              else
                *articles = ainfo;
              alast = ainfo;
              state = STATE_INARTICLE;
            }
          }
          else
            state = STATE_ERROR;
        }
        break;
      case STATE_INSECTION:
        if(!secheader)
          state = STATE_ISSECTION;
        else
          sinfo->lines++;
        break;
      case STATE_ASSARTICLE:
      case STATE_INARTICLE:
        if(!artender || !secheader) {
          if(!ainfo->author) {

            ARTICLES *walk;

            walk = *articles;
            while(walk) {
              if(walk == ainfo) {
                free(ainfo->name);
                free(ainfo);
                *articles = NULL;
                alast = NULL;
                break;
              }
              else if(walk->next == ainfo) {
                walk->next = NULL;
                alast = walk;
                free(ainfo->name);
                free(ainfo);
              }
              walk = walk->next;
            }
          }
          if(!artender)
            state = STATE_ISARTICLE;
          else if(!secheader)
            state = STATE_ISSECTION;
        }
        else if(state != STATE_ASSARTICLE) {
          ainfo->lines++;
          if(!ainfo->author && *s) {
            if(!strnicmp(s,"by",2) || !strnicmp(s,"from",4)) {
              p = s;
              while(*p != ' ' && *p != ':')
                p++;
              while(*p == ' ' || *p == ':')
                p++;
              if(*p)
                ainfo->author = strdup(p);
              else
                ainfo->author = strdup("**Unknown");
            }
            else
              ainfo->author = strdup("**Unknown");
            if(!ainfo->author)
              state = STATE_ERROR;
            else if(asses) {
              strcpy(test,ainfo->author);
              p = to_delim(test,",([;/|!@#%");
              if(p && *p)
                *p = 0;
              rstrip(test);
              info = asses;
              while(info) {
                if(!stricmp(info->name,test)) {
                  free(ainfo->author);
                  ainfo->author = NULL;
                  state = STATE_ASSARTICLE;
                  break;
                }
                info = info->next;
              }
            }
          }
          if(state != STATE_ASSARTICLE && *s && cusses) {
            info = cusses;
            while(info) {
              if(stristr(s,info->name)) {
                free(ainfo->author);
                ainfo->author = NULL;
                state = STATE_ASSARTICLE;
                break;
              }
              info = info->next;
            }
          }
        }
        break;
    }
  }
  return state;
}


int main (int argc,char *argv[]) {

  FILE        *fp,*cfg;
  SECTIONS    *sections;
  ARTICLES    *articles;
  VIOMODEINFO  vm;
  HVIO         hvio = 0;
  char         *p,*ptr;
  int          selfstarter = FALSE;

  atexit(Cleanup);

  vm.cb = sizeof(VIOMODEINFO);
  VioGetMode(&vm,hvio);
  InitScreen(hvio);
  cfg = fopen("FNEWS.INI","r");
  if(cfg) {
    LoadConfig(cfg);
    fclose(cfg);
  }
  if(argc > 1) {
    ptr = argv[1];
    if(*ptr == '*') {
Again:
      deleteme = FALSE;
      selfstarter = TRUE;
      ptr = PickFile(&vm,hvio);
      if(!ptr) {
        VioSetCurPos(vm.row - 1,0,hvio);
        CursorOn(hvio);
        return 0;
      }
    }
    if(_osmode == OS2_MODE) {
      if(DosQPathInfo(ptr,FIL_QUERYFULLNAME,newsletter,sizeof(newsletter),0L))
        strcpy(newsletter,ptr);
    }
    else
      strcpy(newsletter,ptr);
    fp = fopen(newsletter,"r");
    if(!fp) {
      p = strrchr(newsletter,'.');
      if(!p || !*(p + 1)) {
        if(p)
          *p = 0;
        strcat(newsletter,".NWS");
        fp = fopen(newsletter,"r");
      }
    }
    if(fp) {
      setvbuf(fp,NULL,_IOLBF,BUFSIZ * 4);
      articles = NULL;
      sections = NULL;
      if(LoadFnews(fp,&sections,&articles) != STATE_ERROR) {
        ShowFnews(newsletter,fp,sections,articles,&vm,hvio);
        FreeArticles(articles);
        FreeSections(sections);
        if(selfstarter) {
          fclose(fp);
          if(deleteme) {
            remove(newsletter);
            deleteme = FALSE;
          }
          goto Again;
        }
        VioSetCurPos(vm.row - 1,0,hvio);
      }
      else
        printf("\nLoad error.\n");
      fclose(fp);
    }
    else
      printf("\nCan't open \"%s\"\n",newsletter);
  }
  else
    printf("\nFNEWS, a free Fidonews reader for OS/2 and DOS, with source."
           "\nCompiled %s @ %s\n"
           "\n Usage:     FNEWS <filename> or <*>\n"
           "\n Examples:  FNEWS FIDO1227.NWS"
           "\n            FNEWS *\n"
           "\nTired of articles by particular people?  Place their names, one"
           "\nper line, in FNEWS.INI in the current directory under the header"
           "\n[Assholes].  Tired of certain words or phrases?  Place them in"
           "\nFNEWS.INI in the current directory under the header [Exclude],"
           "\none per line.  See the example that came with this program.\n"
           "\nNeed more help?  Use The Source, Luke.\n"
           "\n Hector wuz here.\n",__DATE__,__TIME__);
  CursorOn(hvio);
  return 0;
}
