#!/usr/local/bin/perl
#
# Create areas, areas.bbs, dirs.bat from list of new newsgroups.
#

# Nodes to add to new groups
$ADDNODES = "242:4900/99 2000/1 3000/1";
$ECHOS    = "i:\\echos";

open(AREAS, ">areas")		|| die "newareas: can't open areas\n";
open(BBS  , ">areas.bbs")	|| die "newareas: can't open areas.bbs\n";
open(DIRS , ">dirs.bat")	|| die "newareas: can't open dirs.bat\n";

while(<>) {
    chop;

    ($group) = split(' ', $_);

    $area  = $group;
    $area  =~ tr/[a-z-+]/[A-Z_P]/;
    
    $dir   = $area;
    $dir   =~ tr/\./\\/;
    $dir   = "$ECHOS\\$dir";

    printf AREAS "%-29s %-29s -z 242\n", $area, $group;
    printf BBS   "#%s %s %s\r\n", $dir, $area, $ADDNODES;
    printf DIRS  "mkdirhier %s\r\n", $dir;
}

close(AREAS);
close(BBS);
close(DIRS);
