#!/usr/local/bin/perl
#
# Generate AREAFIX message
#
$ADDR   = "242:99/99";
$UPLINK = "242:1000/1";
$PASSWD = "TEST";

$PRG    = "/usr/local/lib/fidonet/rfc2fido";

$defzone = 2;


# Convert FIDO address to pfnz

sub node2pfnz {

    local($addr) = @_;
    local($zone,$net,$node,$point);

    if($addr =~ /^(\d+)\/(\d+)$/) {
	$zone  = $defzone;
	$net   = $1;
	$node  = $2;
	$point = 0;
    }
    elsif ($addr =~ /^(\d+):(\d+)\/(\d+)$/) {
	$zone  = $1;
	$net   = $2;
	$node  = $3;
	$point = 0;
    }
    elsif($addr =~ /^(\d+)\/(\d+)\.(\d+)$/) {
	$zone  = $defzone;
	$net   = $1;
	$node  = $2;
	$point = $3;
    }
    elsif ($addr =~ /^(\d+):(\d+)\/(\d+)\.(\d+)$/) {
	$zone  = $1;
	$net   = $2;
	$node  = $3;
	$point = $4;
    }
    else {
	print STDERR "out-manip: can't parse address $addr\n";
	exit 1;
    }

    return $point ? "p$point.f$node.n$net.z$zone" : "f$node.n$net.z$zone";
}


$to  = sprintf("areafix@%s.fidonet.org", &node2pfnz($UPLINK) );
$cmd = "$PRG -vvv $to";

open(PRG, "|$cmd") || die "can't open pipe to $cmd\n";
select(PRG);

printf "From: sysop@%s.fidonet.org\n", &node2pfnz($ADDR);
printf "To: %s\n", $to;
printf "Subject: %s\n", $PASSWD;
printf "Message-ID: <aa%06d@%s.fidonet.org>\n", $$, &node2pfnz($ADDR);
printf "X-Flags: N\n\n";

while(<>) {
    print;
}

close(PRG);

