/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway software UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: version.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * FIDOGATE version number handling stuff
 *
 *****************************************************************************
 * This version hacked and maintained by:
 *    _____ _____
 *   |	   |___	 |   Martin Junius	     FIDO:    2:2452/110.1	  2:242/6.0
 *   | | | |   | |   Republikplatz 3	     DOMAIN:  mj@dfv.rwth-aachen.de
 *   |_|_|_|_____|   W-5100 Aachen, Germany  Phone:   ++49-241-86931 (voice)
 *
 *****************************************************************************/

#include "fidogate.h"

#include "version.h"
#include "patchlevel.h"



static char global_id[]    = { VERSION };
/* static char global_state[] = { STATE   }; */
    
    
static char *get_keyword_arg P((char *));



/*
 * version_global() --- Get global FIDOGATE version string
 */

char *version_global()
{
    static char id[128];

#ifdef BETA
    sprintf(id, "%s.%dBETA%d", get_keyword_arg(global_id), PATCHLEVEL, BETA);
#else
    sprintf(id, "%s.%d", get_keyword_arg(global_id), PATCHLEVEL);
#endif

    return id;
}



/*
 * version_local() --- Get local version from passed RCS Revision string
 */

char *version_local(rev)
char *rev;
{
    static char id[128];
    
    strncpy0(id, rev, 128);
    
    return get_keyword_arg(id);
}



/*
 * get_keyword_arg()
 */

static char *get_keyword_arg(s)
char *s;
{
    char *p;

    while(*s && *s!=':')
	s++;
    if(*s == ':')
	s++;
    while(*s && *s==' ')
	s++;
    
    for(p=s; *p && *p!=' '; p++) ;
    *p = 0;
    
    return s;
}



/*
 * Get major/minor version number
 */
int version_major()
{
    int major=ERROR, minor=ERROR;
    
    strcpy(buffer, version_global());
    sscanf(buffer, "%d.%d", &major, &minor);
    
    return major;
}

int version_minor()
{
    int major=ERROR, minor=ERROR;
    
    strcpy(buffer, version_global());
    sscanf(buffer, "%d.%d", &major, &minor);
    
    return minor;
}
