/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: toaddr.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * toaddr --- parse addresses from message header (To:, Cc:, Bcc:)
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * print_addr() --- print addresses from To, Cc, Bcc headers
 */

void print_addr(file)
FILE *file;
{
    char addr[BUFSIZ];
    char *header, *p;
    
    header_read(file);
    
    /*
     * To:
     */
    for(header=header_get("To"); header; header=header_getnext())
	for(p=addr_token(header); p; p=addr_token(NULL))
	    if(addr_from_rfcaddr(p, addr))
		puts(addr);

    /*
     * Cc:
     */
    for(header=header_get("Cc"); header; header=header_getnext())
	for(p=addr_token(header); p; p=addr_token(NULL))
	    if(addr_from_rfcaddr(p, addr))
		puts(addr);

    /*
     * Bcc:
     */
    for(header=header_get("Bcc"); header; header=header_getnext())
	for(p=addr_token(header); p; p=addr_token(NULL))
	    if(addr_from_rfcaddr(p, addr))
		puts(addr);
}

	    

/***** main() ****************************************************************/

int main(argc, argv)
int argc;
char *argv[];
{
    FILE *file;
    char *name;
    
    log_program("toaddr");
    log_file("stderr");
    
    if(argc == 1)
    {
	print_addr(stdin);
    }
    else 
    {
	while(--argc)
	{
	    name = *++argv;
	    file = fopen(name, R_MODE);
	    if(file == NULL)
	    {
		fprintf(stderr, "toaddr: can't open %s: ", name);
		perror("");
		exit(1);
	    }
	    print_addr(file);
	    fclose(file);
	}
    }
    
    exit(0);

    /**NOT REACHED**/
    return 1;
}
