/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: textlist.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * Store text file as chain of linked text lines in memory
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * Write Textlist to file
 */
int tl_fput(fp, list)
    FILE *fp;
    Textlist *list;
{
    Textline *p;

    for(p=list->first; p; p=p->next)
	fputs(p->line, fp);

    return ferror(fp);
}



/*
 * tl_add() --- append Textline to Textlist
 */
void tl_add(list, line)
    Textlist *list;
    Textline *line;
{
    if(list->last)
	list->last->next = line;
    else
	list->first = line;

    line->next = NULL;
    line->prev = list->last;
    
    list->last = line;
    list->n++;
}



/*
 * tl_remove() --- remove Textline from Textlist
 */
void tl_remove(list, line)
    Textlist *list;
    Textline *line;
{
    if(list->first == line)
	list->first = line->next;
    else
	line->prev->next = line->next;
    
    if(list->last == line)
	list->last = line->prev;
    else
	line->next->prev = line->prev;

    line->next = NULL;
    line->prev = NULL;

    list->n--;
}



/*
 * tl_delete() --- remove Textline from Textlist, delete Textline
 */
void tl_delete(list, line)
    Textlist *list;
    Textline *line;
{
    tl_remove(list, line);
    free(line->line);
    free(line);
}



/***** Textlist_init() --- Initialize structure ******************************/

void Textlist_init(list)
Textlist *list;
{
    list->first = NULL;
    list->last	= NULL;
    list->n     = 0;
}



/***** Textlist_clear() --- Delete text lines and chain **********************/

void Textlist_clear(list)
Textlist *list;
{
    Textline *p, *pn;

    for(p=list->first; p;) {
	pn = p->next;
	free(p->line);
	free(p);
	p  = pn;
    }
    
    list->first = NULL;
    list->last	= NULL;
    list->n     = 0;
}



/***** Textlist_append() --- Append string to text line chain ****************/

void Textlist_append(list, s)
    Textlist *list;
    char *s;
{
    Textline *p;

    s = strsave(s);
    p	    = (Textline *)xmalloc(sizeof(Textline));
    p->line = s;
    p->next = NULL;

    tl_add(list, p);
}



/***** Textlist_appendf() --- Append text to chain, printf like formatting ***/

#ifdef __STDC__

void Textlist_appendf(Textlist *list, char *fmt, ...)
{
    va_list args;
    static char buf[4096];

    va_start(args, fmt);

#else /**!__STDC__**/

void Textlist_appendf(va_alist)
{
    va_list args;
    Textlist *list;
    char *fmt;
    static char buf[4096];

    va_start(args);
    list = va_arg(args, Textlist *);
    fmt	 = va_arg(args, char *);

#endif /**__STDC__**/

    vsprintf(buf, fmt, args);
    Textlist_append(list, (char *)buf);
}



/***** Textlist_print() --- Write text line chain to file ********************/

void Textlist_print(list, fp)
Textlist *list;
FILE *fp;
{
    Textline *p;

    for(p=list->first; p; p=p->next)
	fputs(p->line, fp);
}



/***** Textlist_size() --- Compute size of text in chain *********************/

long Textlist_size(list)
Textlist *list;
{
    Textline *p;
    long n=0;

    for(p=list->first; p; p=p->next)
	n += strlen(p->line);

    return n;
}



/***** Textlist_add() --- Add another textlist ******************************/

void Textlist_add(d, s)
Textlist *d;
Textlist *s;
{
    Textline *p;

    for(p=s->first; p; p=p->next)
	Textlist_append(d, p->line);
}
