#!/bin/sh
#
# $Id: runtoss.sh,v 3.8.0.7 1994/10/04 07:04:45 mj Exp mj $
#
# Wrapper for ftntoss, ftnroute, ftnpack doing the toss process
#
# Usage: runtoss name
#

PRG=??LIB??

if [ $# -ne 1 ]; then
	echo "usage: runtoss name"
	exit 1
fi

NAME=$1

#
# Set input and grade depending von NAME
#
case $NAME in
	normal)
		INPUT=
		GRADE=
		;;
	out)
		INPUT=-I??SPOOL??/out
		GRADE=-gn
		;;
	*)
		echo "runtoss: unknown toss name $NAME"
		exit 1
		;;
esac


#LIB=-Llib
#SPOOL=-S.
#BT=-B`pwd`/bt

MAXFILES=20
MAXMSG=400
MAXARC=2000

V=-v

#
# Lock it
#
$PRG/ftnlock $V $LIB $SPOOL -l $NAME
st=$?
if [ $st -ne 0 ]; then
	exit 2
fi

#
# Processing ftntoss/ftnroute/ftnpack
#
flag="cont"

while [ "$flag" = "cont" ]; do

	echo ----- Tossing ---------------------------------------------------
	
	echo $PRG/ftntoss $V $LIB $SPOOL -M$MAXFILES -x$MAXMSG $INPUT $GRADE
	$PRG/ftntoss $V $LIB $SPOOL -M$MAXFILES -x$MAXMSG $INPUT $GRADE
	st=$?
	if   [ $st -eq 0 ]; then
		flag="exit";
	elif [ $st -eq 3 ]; then
		flag="cont";
	else
		$PRG/ftnlock $V $LIB $SPOOL -u $NAME
		echo "ERROR: ftntoss exit $st"
		exit 1
	fi
	
	echo ----- Routing ---------------------------------------------------
	
	echo $PRG/ftnroute $V $LIB $SPOOL -M$MAXFILES $GRADE
	$PRG/ftnroute $V $LIB $SPOOL -M$MAXFILES $GRADE
	st=$?
	if   [ $st -ne 0 ]; then
		$PRG/ftnlock $V $LIB $SPOOL -u $NAME
		echo "ERROR: ftnroute exit $st"
		exit 1
	fi
	
	echo ----- Packing ---------------------------------------------------
	
	echo $PRG/ftnpack $V $LIB $SPOOL $BT -m$MAXARC $GRADE
	$PRG/ftnpack $V $LIB $SPOOL $BT -m$MAXARC $GRADE
	st=$?
	if   [ $st -ne 0 ]; then
		$PRG/ftnlock $V $LIB $SPOOL -u $NAME
		echo "ERROR: ftnpack exit $st"
		exit 1
	fi

done

#
# Unlock it
#
$PRG/ftnlock $V $LIB $SPOOL -u $NAME


exit 0
