/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: misc.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * Miscellaneous functions
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * strncpy0() --- strncpy() with terminating '\0' char
 */
char *strncpy0(d, s, n)
    char *d, *s;
    int n;
{
    strncpy(d, s, n);
    d[n-1] = 0;
    return d;
}



/*
 * strncat0() --- strncat() with terminating '\0' char and
 *                n == destination buffer size
 */
char *strncat0(d, s, n)
    char *d, *s;
    int n;
{
    int max = n - strlen(d) - 1;
    strncat(d, s, max);
    d[n-1] = 0;
    return d;
}    


    
#ifndef OS2    
/***** strnicmp() --- compare n chars of strings ignoring case ***************/

int strnicmp(sa, sb, len)
register char *sa, *sb;
int len;
{
    while(len--)
	if(tolower(*sa) == tolower(*sb)) {
	    sa++;
	    sb++;
	}
	else if(tolower(*sa) < tolower(*sb))
	    return(-1);
	else
	    return(1);
    return(0);
}



/***** stricmp() --- compare strings ignoring case ***************************/

int stricmp(sa, sb)
register char *sa, *sb;
{
    while(tolower(*sa) == tolower(*sb)) {
	if(!*sa)
	    return(0);
	sa++;
	sb++;
    }
    return(tolower(*sa) - tolower(*sb));
}
#endif /**OS2**/



/***** xtol() --- convert hex string to long *********************************/

long xtol(s)
char *s;
{
long val = 0;
int n;

    while(*s) {
	n = toupper(*s) - (isalpha(*s) ? 'A'-10 : '0');
	val = val*16 + n;
	s++;
    }
    return(val);
}



/*
 * Remove \r\n from end of line
 */
void strip_crlf(line)
    char *line;
{
    int len;
    
    len = strlen(line);
    if( line[len-1] == '\n' )
	line[len-1] = 0;
    
    len = strlen(line);
    if( line[len-1] == '\r' )
	line[len-1] = 0;
}



/*
 * Remove white space at end of line
 */
void strip_space(line)
    char *line;
{
    int i;
    
    for(i=strlen(line)-1; i>=0; i--)
	if(isspace(line[i]))
	    line[i] = 0;
	else
	    break;
}
