/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: mail2news.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * mail2news --- Post mail message in newsgroup
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * print_header() --- print selected fields from RFC header
 */

void print_header(file, group)
FILE *file;
char *group;
{
    int i;
    char *h, *name;
    static char *header[] = 
    {
	"Message-ID",
	"From",
	"Reply-To",
	"Sender",
	"Date",
	"Subject",
	NULL
    };
    
    
    header_read(file);

    /* Newsgroup: */
    printf("Newsgroups: %s\n", group);

    /* Other headers */
    for(i=0; header[i]; i++)
    {
	name = header[i];
	if((h = header_get(name)))
	    printf("%s: %s\n", name, h);
    }
    
    /* End of header */
    printf("\n");
}

	    

/***** main() ****************************************************************/

int main(argc, argv)
int argc;
char *argv[];
{
    char buffer[BUFSIZ];
    
    if(argc != 2)
    {
	fprintf(stderr, "usage: mail2news newsgroups\n");
	exit(1);
    }

    print_header(stdin, argv[1]);

    while(fgets(buffer, sizeof(buffer), stdin))
	fputs(buffer, stdout);

    exit(0);

    /**NOT REACHED**/
    return 1;
}
