#!/bin/sh
#
# $Id: fidorun.sh,v 3.8 1994/08/08 07:05:05 mj Exp mj $
#
# This shell script feeds the msg in SPOOL/unpacked to
# either rnews or rmail, depending on their destination:
#
#     N.xxxx  -> rnews
#     M.xxxx  -> rmail
#
# Must be used after fido mail packets were processed
# with funpack.
#

SPOOL=??SPOOL??
LIB=??LIB??

cd ${SPOOL}/in

#
# Process messages for mail
#
for f in mail/*.msg
do
	if [ -f $f ]
	then
#
# Uncomment this, if your mail receiver needs receiver addresses
# on the command line. toaddr will parse them from the message header.
#
# You MUST add `news' or whoever runs this script as a trusted user
# to /etc/sendmail.cf!!!
#
	rmail `$LIB/toaddr $f` <$f

#
# sendmail can handle addresses in mail body, too. But you'll have to
# pass the -f option, because otherwise From_ and Return-Path won't be
# right.
#
#		/usr/lib/sendmail -t <$f

		status=$?
		if [ $status -eq 0 ]
		then
			rm -f $f
		else
			mv $f bad
		fi
	fi
done

#
# Process news messages
#
for f in news/*.msg
do
	if [ -f $f ]
	then
		rnews < $f
		status=$?
		if [ $status -eq 0 ]
		then
			rm -f $f
		else
			mv $f bad
		fi
	fi
done

exit 0
