/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway software UNIX <-> FIDO
 *
 * $Id: fidogate.h,v 3.8.0.6 1994/09/25 14:39:55 mj Exp mj $
 *
 * Common header file
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

/*
 * Configuration header files
 */
#include "config.h"
#include "paths.h"		    /* Automatically generated by Makefile */


/*
 * heavy includin' ...
 */

/***** System *****/
#include <stdio.h>
#ifdef __STDC__
# include <stdlib.h>
# include <stdarg.h>
#else
# include <varargs.h>
#endif
#include <unistd.h>
#ifdef OS2
# include <io.h>
# include <process.h>
#endif
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <errno.h>
#ifdef M_XENIX
# include <sys/ndir.h>
# define dirent direct
#else
# include <dirent.h>
#endif

#include "sysexits.h"			/* EX_* defines */



/*
 * Defines
 */
#define TRUE	1
#define FALSE	0
#define OK	0
#define ERROR	(-1)

#define bool	int

/*
 * We supply our own version of the toupper()/tolower()
 * macros, because the exact behaviour of those in
 * <ctype.h> varies among systems.
 */
#undef _toupper
#undef _tolower
#undef toupper
#undef tolower

#define _toupper(c) ((c)-'a'+'A')
#define _tolower(c) ((c)-'A'+'a')
#define toupper(c)  (islower(c) ? _toupper(c) : (c))
#define tolower(c)  (isupper(c) ? _tolower(c) : (c))


/*
 * Replacement for exit() doing clean-up
 */
#define exit(x) fidogate_exit(x)


/*
 * Function declaration macro
 */
#ifdef __STDC__
# define P(x)	x
#else
# define P(x)	()
#endif

/*
 * Function declarations for systems like SUNOS, where the standard
 * header files don't have them.
 */
#include "declare.h"

/*
 * Data types
 */
#include "node.h"			/* Node, LON definitions */
#include "packet.h"			/* Packet, Message definitions */
#include "structs.h"

/*
 * Function prototypes
 */
#include "prototypes.h"
