/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: bufstring.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * buf_sprintf() --- sprintf() to SHUFFLE buffer
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"

#include "shuffle.h"



/*
 * sprintf() returning string and using shuffled buffer
 */

#ifdef __STDC__
char *buf_sprintf(char *fmt, ...)
#else
char *buf_sprintf(fmt, va_alist)
char *fmt;
va_dcl
#endif
{
va_list pvar;

#ifdef __STDC__
    va_start(pvar, fmt);
#else
    va_start(pvar);
#endif
    SHUFFLEBUFFERS;
    vsprintf(tcharp, fmt, pvar);
    va_end(pvar);

    return tcharp;
}



/*
 * Copy string to shuffled buffer
 */
char *buf_copy(s)
char *s;
{
    SHUFFLEBUFFERS;
    
    strncpy0(tcharp, s, MAX_CONVERT_BUFLEN);
    
    return tcharp;
}

