/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: areas.c,v 3.8.0.4 1994/09/12 21:05:55 mj Exp mj $
 *
 * Area <-> newsgroups conversion
 *
 *****************************************************************************
 * Copyright (C) 1990, 1993, 1994
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



static Area *area_list = NULL;
static Area *area_last = NULL;


/*
 * Read list of areas from LIBDIR/AREAS file.
 *
 * Format:
 *     AREA       newsgroup   [-options]
 *
 * Options:
 *     -z ZONE    use AKA for zone Z for this area
 */
void areas_init()
{
    FILE *fp;
    Area *p;

    debug(5, "Reading areas file");
    
    fp = libfopen(AREAS, R_MODE);

    while(cf_getline(buffer, BUFFERSIZE, fp))
    {
	char *a, *g, *o;
	
	a = xstrtok(buffer, " \t");	/* FTN area */
	g = xstrtok(NULL,   " \t");	/* Newsgroup */
	if(a==NULL || g==NULL)
	    continue;
	
	p = (Area *)xmalloc(sizeof(Area));
	p->next         = NULL;
	p->area         = strsave(a);
	p->group        = strsave(g);
	p->zone         = cf_defzone();
	p->origin       = NULL;
	p->distribution = NULL;
	p->flags        = 0;
	
	for(o=xstrtok(NULL, " \t");	/* Options */
	    o;
	    o=xstrtok(NULL, " \t")  )
	{
	    if(!strcmp(o, "-z"))
		/* -z ZONE */
		if((o = xstrtok(NULL, " \t")))
		    p->zone = atoi(o);
	    if(!strcmp(o, "-o"))
		/* -o ORIGIN */
		if((o = xstrtok(NULL, " \t")))
		    p->origin = strsave(o);
	    if(!strcmp(o, "-d"))
		/* -d DISTRIBUTION */
		if((o = xstrtok(NULL, " \t")))
		    p->distribution = strsave(o);
	    if(!strcmp(o, "-l"))
		p->flags |= AREA_LOCALXPOST;
	    if(!strcmp(o, "-x"))
		p->flags |= AREA_NOXPOST;
	    if(!strcmp(o, "-m"))
		p->flags |= AREA_NOMAUS;
	    if(!strcmp(o, "-g"))
		p->flags |= AREA_NOGATE;
	    if(!strcmp(o, "-8"))
		p->flags |= AREA_8BIT;
	    
	}

	debug(9, "areas: %s %s Z%d", p->area, p->group, p->zone);
	
	/*
	 * Put into linked list
	 */
	if(area_list)
	    area_last->next = p;
	else
	    area_list       = p;
	area_last       = p;
    }
    
    fclose(fp);
}



/*
 * Lookup area/newsgroup in area_list
 *
 * Parameters:
 *     area, NULL     --- lookup by area
 *     NULL, group    --- lookup by group
 */
Area *areas_lookup(area, group)
char *area;
char *group;
{
    Area *p;
    
    /*
     * FIXME: the search method should use hashing or similar
     */

    for(p=area_list; p; p=p->next)
    {
	if(area  && !strcmp(area,  p->area ))
	    return p;
	if(group && !strcmp(group, p->group))
	    return p;
    }
    
    return NULL;
}
