/* TAUSCH.CMD -- w'94
------------------------------------------------------------------------------
Dieses Script ist Public domain.

Syntax: TAUSCH Maus Nummer "User" "Password"

Fehlercodes: 0 - Alles OK
             1 - fehlerhafte Syntax
             2 - Modem nicht ansprechbar
             3 - Fehler beim Senden des Infiles
             4 - Fehler beim Empfangen des Outfiles
             10 - Sonstiger Fehler

nderungen:
(24.2.1995) Carsten Hrle: rxtimeout auf 2000 gesetzt
(6.1.1995) Carsten Hrle, Werner Hunger: Verbesserte Parameterbergabe.
(18.1.1995) Carsten Hrle: Sichererer Protokollaufruf und Entfernung von Controllcodes.
(19.1.1995) Carsten Hrle: Untersttzung fr Porthandle bei externen Protokollen.
(21.1.1995) Carsten Hrle: Probleme mit langsamen Modems behoben.
(22.1.1995) Werner Hunger: Vor dem Whlen explizit auflegen.
------------------------------------------------------------------------------
*/

/*
Hier knnen diverse Anpassungen vorgenommen werden.
Mu bei einem externen Protokoll nicht der Portname sondern
der Porthandle bergeben werden, kann stattdessen der
String "<porthandle>" (case-sensitive) geschrieben werden. 
Dieser wird spter automatisch ersetzt.
*/

maustimeout  = 60
mauspause    = 120
portname     = 'COM2'
baud         = 38400
ftpsend      = 'cexyz2 /p<porthandle> /l'baud '/b14400 /sz infile.zip'
ftpreceive   = 'cexyz2 /p<porthandle> /l'baud '/b14400 /rz'
/* ftpsend      = 'p -device' portname '-speed 14400' '-send infile.zip'
ftpreceive  = 'p -device' portname '-speed 14400' '-receive' */

data         = 8
parity       = 'N'
stop         = 1
writelim     = 50
readlim      = 50
rxtimeout    = 2000
flags1       = '00001001'
flags2       = '10100000'
flags3       = '11010010'
errchar      = '00'
brkchar      = '00'
xonchar      = '11'
xoffchar     = '13'
enhparms     = '00000010'

porthandle   = ''

true         = 1
false        = 0

regular      = 2
critical     = 3
normallvl    = 0

cr           = D2C(13)
crlf         = cr''D2C(10)
ZmodENQUp = '**' || x2c('18') || 'B01'
ZmodENQDown = '**' || x2c('18') || 'B00'


/* Vorbereitung */
call on error

Call ParseArguments arg(1)
if param.0 \= 4 then do
  say 'Fehler: Nur' param.0 'Parameter bergeben'
  say 'Syntax: TAUSCH Maus Nummer User Password'
  say ''
  say 'Also beispielsweise: TAUSCH HD 477275 "Werner Hunger" xyz'
  exit 1
end
mausname = param.1
mausnummer = param.2
maususer = param.3
mauspassword = param.4

call rxfuncadd 'rxasyncloadfuncs', 'rxasync', 'rxasyncloadfuncs'
call rxasyncloadfuncs

call rxasyncpriority critical, normallvl
call rxasyncopen portname, 'porthandle'
call rxasyncsetlnctrl porthandle, baud, data, parity, stop
call rxasyncsetdcbinfo porthandle, writelim, readlim, flags1, flags2, flags3, errchar, brkchar, xonchar, xoffchar
call rxasyncsetenhparm porthandle, enhparms
if stream('tausch.log', 'c', 'query exists') > '' then 'del tausch.log'

/* Ersetze "<porthandle>" in den Strings ftpsend und ftpreceive durch den richtigen porthandle */
parse value ftpsend with a '<porthandle>' b
if b \= "" Then ftpsend = a || porthandle || b
parse value ftpreceive with a '<porthandle>' b
if b \= "" Then ftpreceive = a || porthandle || b

/* Modem-Reset */
call sende 'ATZ'||cr
antwort = warteauf('OK')
if antwort = '' then do
  say 'Modem nicht ansprechbar! Oder etwa ausgeschaltet?'
  exit 2
end

/* schwierig: whlen ;-) */
verbindung = false
do while verbindung == false
  call sende cr
  call sende 'ATDP'||mausnummer||cr
  say 'Whle '||mausnummer||', Timeout nach '||maustimeout||' Sekunden ...'
  call warteauf 'ATDP'

  call time 'Reset'

  do until (time('Elapsed') > maustimeout) | (verbindung == true)
    s = warteauf('')
    if pos('CONNECT', s) > 0 then verbindung = true
    if pos('NO', s) + pos('OUT OF', s) + pos('DELAY', s) + pos('BUSY', s) > 0 then leave
  end

  if verbindung == false then do
    say 'Warte '||mauspause||' Sekunden ...'
    call rxasyncsleep mauspause * 1000
  end
end


/* jetzt geht's los ... */
rxtimeout = 2000

do until pos('Benutzer?', warteauf('Benutzer?')) > 0; end
call sende 'MausTausch'||maususer||cr||mauspassword||cr||'z'

do until pos(ZmodENQUp, warteauf(ZModENQUp)) > 0 ; end
' 'ftpsend
if rc <> 0 then exit 3

do until pos(ZModENQDown, warteauf(ZModENQDown)) > 0 ; end
' 'ftpreceive
if rc <> 0 then exit 4

call warteauf 'NO CARRIER'

/* Aufrumen */
call rxasyncclose porthandle
call rxasyncpriority regular, normallvl
call rxasyncdropfuncs
call stream 'tausch.log' 'c' 'close'
exit 0


/* interne Funktionen */
sende:
parse arg eingabe
  uebrig = ''
  rc = rxasyncwrite(porthandle, 0, eingabe, 'uebrig')
  if rc <> 0 then say 'Modem nahm 'uebrig' Zeichen nicht an!'
return


warteauf:
parse arg trigger
  antwort = ''
  do until (code <> 0) | (pos(trigger, antwort) > 0) | (trigger = '')
    code = rxasyncread(porthandle, 0, rxtimeout, 'antwort')
    call charout , antwort
    call charout 'tausch.log', antwort
  end
return antwort


ParseArguments:
parse arg line
i = 0
do while line  \= ""
    parse value line with par rest
    if pos('"', par) > 0 then parse value line with '"' par '"' rest
    line = rest
    i = i + 1
    param.i = par
End
param.0 = i
return


/* Fr den Fall aller Flle */
error:
   call rxasyncclose porthandle       /* Verbindung trennen */
   call rxasyncpriority regular, normallvl
   call rxasyncdropfuncs
   call stream 'tausch.log' 'c' 'close'
   exit 10
