/* 
Rexx-Skript fr den Emis/PM MausTausch fr verschiedene
Terminal-Programme. Das Verzeichnis der Mitteilungsbank
mu bergeben werden. Dort wird auch auch die Datei 
'emismt.cfg' gelesen.
*/
arg msgBaseDir

/* Prfe, ob das Verzeichnis existiert */
curDir = directory()
if msgBaseDir \= "" Then do
	if substr(msgBaseDir, length(msgBaseDir),1) = '\' Then
		msgBaseDir = substr(msgBaseDir, 1, length(msgBaseDir)-1)
	msgBaseDir = directory(msgBaseDir)
End
If msgBaseDir = "" Then
	Error("Verzeichnis der Mitteilungsbank nicht gefunden", 10002);
say "Mitteilungsbank im Verzeichnis:" msgBaseDir

/* Packen des INFILEs und Lschen des OUTFILE.ZIP */
'del infile.zip'
'zip infile infile.txt'
if rc \= 0 Then Error("Infile kann nicht gepackt werden", 10003)
'del outfile.zip'

/* Lesen des MausTausch-Programms */
if stream('emismt.cfg', 'c', 'open read') \= 'READY:' then
	Error("Fehler beim Lesen der Datei 'emismt.cfg'", 10001)
progid=linein("emismt.cfg")
if stream('emismt.cfg', 'c', 'close') \= 'READY:' then
	Error("Fehler beim Lesen der Datei 'emismt.cfg'", 10001)

/* Starte das spezielle Skript */
Call directory(curDir)
'call' progid msgBaseDir
if rc  \= 0 Then 
	Error("Fehler beim MausTausch-Skript", rc)

/* Auspacken des OUTFILEs */
Call directory(msgBaseDir)
'del outfile.txt'
'unzip outfile'
if rc \= 0 Then 
	Error("Outfile kann nicht ausgepackt werden", 10004)
Say ("Emis-MausTausch erfolgreich")
exit 0

/* Fehlerbehandlung */
Error:
Say "FEHLER ("arg(2)"): " arg(1)
/* pull a */
Exit arg(2)
