/* Control*/
/* Author (C) Dave Sloan - July 1993*/
/* Dedicated to all NEC's*/
/* Written to completely control inbound and outbound files and mail*/
/* Will dynamically change all message and file cfg*/
/* Displays a window of activitys for each line*/
/* These include squish.cfg - sqafix.cfg*/ 
/* Post changes for easy inserting into msgarea.ctl - tic.cfg*/
/* Adds file descriptions from uplinks for message bases*/
/* Updates nodelist entries as they are received*/
/* Will cross check message base areas and automatically add and*/
/* delete areas as they become available or empty in squish.cfg*/
/* It checks for duplicate files and maintains free space as specified*/
/* on the hard drive - deletes outdated files and large files as needed*/
/* Completely Net Aware*/
/* See 'Special Attaches' for sending files without tick*/
/* Copy Fidonet.na to the CmdPath (Bink) subdirectory as N348.LST*/
/* The descriptions will be placed in the sqafix control file*/
/* and create the M348.LST file which will ultimately place the descriptions*/
/* into the msgarea.ctl file*/
/* Copy descriptions from File.lst into filearea.ctl - not net aware*/
/* Added section to replace nulls with blanks during initial run*/
/* This is due to the fact that Rexx does not recognize tabs*/
/* Class is associated with Net - In the squish.cfg file a few comment lines*/
/* may be added - before the definition of each net address add the network*/
/* description and class as follows:*/
/* Any CDRom files.bbs must be in a path with CDRom in the name*/
/* This is so that the program will ignore these during placement*/
/* All message areas must be under the same subdirectory*/
/* All file areas must be under the same subdirectory*/
/* Acknowlegements*/
/* SRI - Max MSGAPI.dll - Rexx message interface (C) Colin Adams */
/* SQAFIXP - (C) Pete Kvitek of JV Dialogue 1st BBS, 2:5020/6 */
/* Max BBS + Squish - (C) Scott Dudley*/
/* Tick - TICK v2.10 (C) Barry Geller*/
/* The above products can be used in a non-comercial environment without
   a licence*/
/* Fastlstp by Alberto Pasquale */
/*
;Origin Fido F F
Address 1:348/105
Address 1:348/107
Address 1:348/60
;Origin IMEX X X
Address 89:720/106
Address 89:720/111
*/
/* To determine the class for sqafix requests preceed the msgarea statements*/
/* with the following*/
/*
;Start F
EchoArea  12_STEPS       C:\MSG\12_STEPS  -$ -$m250 -$d7 -P1:348/105     1:348/501
...
EchoArea  {COMMO}        C:\MSG\{COMMO}   -$ -$m250 -$d7 -P1:348/105     1:348/501
;Start S   Secured sysop echo that must be manually turned on
EchoArea  CELLBLK17      C:\Msg\CELLBLK1  -$ -$m450 -$d7 -P1:348/105    1:348/702 402
;Start F
*/
/* Use 'echo command line | rxqueue cntl' to activate the following*/
/* command*/
/*TOSS Crash poll a node */
/*NODE     Crash poll a node */
/*FILE     Get a file from a node*/
/*NODELST  Create latest and greatest nodelst*/
/*DAILY    Nightly Cleanup*/
/*STATS    Weekly Statistics Report*/
/*COMPRESS Compress Message Bases*/
/*FILEBBS  Sort Files BBS*/
/*SQMAXUP  Create Max Msg Entries*/
/*TKMAXUP  Create Max File Entries*/
/*MAXMDESC Add Max Message Descriptions*/
/*MAXFDESC Add Max File Descriptions*/
/*SQUISHUP Create Squish.cfg Entries*/
/*SQUAFUP  Create Sqafix.cfg Entries*/
/*POSTMSG  Post Msg Activity Information*/
/*TICIN    Examine Ticks coming in*/
/*POSTFAN  Post File Activity Information*/
/* line 1 - n - see bink1 and bink2 for examples*/

/* This is a Sample Rexx program and as such is only guaranteed to */
/* take up space on your disk*/

/* Record error and get back to work*/
Call on failure name recscreen
Call on halt name recscreen
signal on syntax name recscreen

/* Setup variables and Paths - Change to suite System*/
Call SetVar

/* Setup all nets according to Squish.cfg*/
Call SetSys
/*test routines here
node = 1
Call CompressMsgs
signal EXIT*/


/* All commands come in through cntl queue*/
Call SetQueue

/* This Rexx is taking control!*/
if CntlQueue = "Cntl" then
  /* Clear all flags and get that mail outa here*/
  Call SetMail
else
  /* We're already out there*/
  signal end

/* Monitor Queue******************************************/
say '*******Control Ready and Waiting to Receive Queue Data....'
say '       Go to another partition and type "echo toss 1 | rxqueue cntl"'
say '       to test if queue is receiving data.....'
say '       Ensure that Control.cmd, Control.cfg and win.cmd are in the'
say '       same subdirectory. Always start it from that subdirectory'
say '       otherwise another control program in the path may load.'
Do Forever
  command = ''
  do until command <> ''
    if QUEUED() > 0 then
      PULL command node port rest
    else
      Call syssleep 6
  end
  /* Select the command*/
  select
    when command = 'TOSS'        then Call toss
    when command = 'NODE'        then Call PollCrash
    when command = 'FILE'        then Call PollFile
    when command = 'NODELST'     then Call Nodelst
    when command = 'DAILY'       then Call Daily
    when command = 'STATS'       then Call Stats
    when command = 'COMPRESS'    then Call CompressMsgs
    when command = 'FILEBBS'     then Call PrettyFl
    when command = 'SQMAXUP'     then Call SqMaxUp
    when command = 'TKMAXUP'     then Call TkMaxUp
    when command = 'MAXMDESC'    then Call AddMaxMDsc
    when command = 'MAXFDESC'    then Call AddMaxFDsc
    when command = 'SQUISHUP'    then Call SqUpdate
    when command = 'SQUAFUP'     then Call SqaUpdate
    when command = 'POSTMSG'     then Call PostMsg
    when command = 'TICIN'       then Call Mirtle
    when command = 'POSTFAN'     then Call PostFan
    when command = 'HELLO'       then do
      xx = RXQueue("Set",node)
      /* Send back that I am here - can ya dig it*/
      QUEUE 'OK'
      xx = RXQUEUE("Set",CntlQueue)
    end
    when command = 'X'           then
      signal exit
    otherwise NOP
  end /* select command*/
end /* Do Forever*/

EXIT:

if debug then say 'Exit ------>'
  xx = RXQUEUE('Set',CntlQueue)
  xx = RXQUEUE('Delete',CntlQueue)
  do ii = 1 to wincnt
    xx = RXQUEUE('Set',winqueue.ii)
    queue 'SHUTDOWN'
  end
END:

if debug then say 'End ------>'
  xx = RXQUEUE("Set",oq)
exit

/* Isthere - tests for the existance of a file*/
isthere: ARG wxy

if debug then say 'isthere ------>'
  isthere = LINES(wxy)
  zxy = STREAM(wxy, c, close)
return isthere

/* Check for Inbound Mail and Process it***************************/
Toss:

if debug then say 'Toss ------>'
LineMsg = TIME('N')'  'command
Call DispLine node
/* Check for Inbound*/
Call SysFileTree Mail'\'InMail'\*.*', 'List', 'SFO'
/* Files exist - Process them*/
if List.0 > 0 then do
  Drive
  'CD\'CmdPath
  /* What files came in?*/
  /* Go until we find the first of a type*/
  tossready  = No
  tickready  = No
  /* Assume that no lists are present*/
  do ii = 1 to filetrap
    filetrap.ii = ''
  end
  do i = 1 to List.0
    /* Put into temp storage*/
    infile.i = List.i
  end
  /* Space required to move Messages to drive*/
  ReqMsgSpace = 0
  do i = 1 to List.0
    /* Check for tics coming in*/
    infile = TRANSLATE(infile.i)

    /* Get uppercase extent*/
    dotp = LASTPOS('.',infile)
    if dotp > 0 then
      extent = SUBSTR(infile, dotp+1)
    else
      extent = ''
    /* Call only once - tick will process all*/
    if extent = 'TIC' then do
      LineMsg = TIME('N')' Ticking - 'infile
      Call DispLine node
      tickready = Yes
    end
    else do
      /* Extract the file name*/
      filename = FILESPEC('NAME', infile)
      dotp = POS('.',filename)
      if dotp > 0 then
        filename = DELSTR(filename,dotp)
      /* Check for mail coming in*/
      /* Check for a Hex Site ID*/
      if DATATYPE(filename,'X') then do
        /* Don't look at bad boys*/
        if extent <> 'BAD' then do
          LineMsg = TIME('N')' Processing - 'infile
          Call DispLine node
          tossready = Yes
          SrchFile = Mail'\'InMail'\'FileName
          /* See if we got the file*/
          DiskSpace = 0
          Call SysFileTree infile, 'isthere.', 'F'
          if isthere.0 > 0 then do
            /* Let Squish Handle the move after we check Disk space*/
            ReqMsgSpace = ReqMsgSpace + (WORD(isthere.1, 3) * 2) /* Compression 2 to 1*/
          end
          Drop(isthere.)
        end
      end
      /* Check for special files*/
      do j = 1 to filetrap
        /* Check for a trap file*/
        if filename = trapfile.j then do
          LineMsg = TIME('N')' NodeList - 'filename
          Call DispLine node
          /* Is there more then one data file present*/
          if filetrap.j <> '' then do
            /* Use the override file*/
            if POS('99',extent) > 0 then do
              'erase 'filetrap.j' /n'
              filetrap.j = infile.i
            end
          end
          else do
            /* pull the latest and greatest name*/
            filetrap.j = infile.i
          end
        end
      end
      /* Check for freq files*/
      /* Are there files to be freq'd*/
      if isthere(FreqFile) then do
        do until LINES(FreqFile) = 0
          line = LINEIN(FreqFile)
          trapfile = WORD(line, 1)
          if trapfile = filename then do
            'copy 'infile.i' 'Files'\'FilePath'\'FreqPath
            if RC = 0 then do
              'erase 'infile.i' /n'
              LineMsg = TIME('N')' Freq File - 'filename
              Call DispLine node
            end
          end
          /* Not found - do not delete it from the list*/
          else
            file = LINEOUT(FreqTemp, line)
        end
        file = STREAM(FreqTemp, c, close)
        'copy 'FreqTemp' 'FreqFile
        file = STREAM(FreqFile, c, close)
      end 
    end
  end 
  Drop(List.)
  Drop(infile.) /* End checking files in the inbound*/
  if tickready then do
    Call Tick
  end
  if tossready then do
    tempfree  = FreeSpace
    tempdel   = deletesize
    /* This is the free space needed basis messages coming in*/
    FreeSpace = ReqMsgSpace + TossSpace
    /* This is the size of the large files to delete if we need space*/
    deletesize = TossDelsz
    Call ChkFree
    if FreeLeft >= FreeSpace then do
      /* Files exist - Process them*/
      Drive
      'cd\'SqPath
      'squishp in out squash link'
      Drive
      'cd\'SqPath
      'sqafixp scan'
    end
    FreeSpace = tempfree
    deletesize = tempdel
  end

  /* Act on the unticked files*/
  dofastlst = No
  do i = 1 to filetrap
    if filetrap.i <> '' then do
      LineMsg = trapfile.i' List - 'filetrap.i' used...'
      Call DispLine node

      /* Update with the new file*/
      filename = FILESPEC('NAME',filetrap.i)
      NodeList
      'cd\'Nodelistpath
      xx = Files'\'Filepath'\other\xmit'
      if isthere(xx'\files.bbs') then do
        'copy 'filetrap.i' 'xx

        /* Send out to users*/
        if RC = 0 then do
          /* Special Attaches for this file*/
          select
            when i = 1 then do
              /* 'squishp send 'filename' to 1:xxx/yyy'*/
            end
            otherwise
          end

          /* If action to be performed then do it from nodelist*/
          if trapactn <> '' then do
            'copy 'filetrap.i
            /* Unpack File*/
            trapactn.i' 'filename
            if RC = 0 then do
              'erase 'filename' /n'
              dofastlst = Yes
            end
          end
          erase filetrap.i' /n'
        end
      end
    end
  end
  /* Build new nodelist*/
  if dofastlst then do
    NodeList
    'cd\'Nodelistpath
    nodeprocessor
  end
end
return

/* Processing scheduled by bink for each day at a non mailing time*/
/* This may use a few CPU cycles so don't run this section along*/
/* with high speed transfers unless the processor has lots of poop*/

Daily:

if debug then say 'Daily ------>'
LineMsg = TIME('N')'  'command
Call DispLine node
/* Keep the old logs one day*/
LineMsg = ' - Deleting Logs - '
Call DispLine node

Log
'CD \'Logpath
if isthere('squish.log') then do
  'copy squish.log sq.log'
  'erase squish.log /n'
end

/* IBM list comes in sometimes twice every day*/
Call SysFileTree Files'\'Filepath'\ibmgen\ibm*.*', 'List', 'FO'
if List.0 > 0 then do
  Drive
  'cd\'Filepath'\ibmgen'
  'erase ibm*.* /n'
end
Drop(List.)

Call SysFileTree Mail'\'InMail'\ibm*.*', 'List', 'FO'
if List.0 > 0 then do
  Mail
  'cd\'InMail
  'erase ibm*.* /n'
end
Drop(List.)

/* Pack the Message Bases*/
LineMsg = ' - Packing Message Bases - '
Call DispLine node

Call SysFileTree Drive'\'SqPath'\*.bad', 'List', 'FO'
if List.0 > 0 then do
  Drive
  'cd\'SqPath
  'erase *.bad /n'
end
Drop(List.)

Drive
'cd\'SqPath
'sqpackp 'Messages'\'Messpath'\*.sqd > 'SqPackFile
  /* Quick and dirty get rid of the message base*/
  /* Will change to read and recreate the messages up to the point of corruption*/
do until LINES(SqPackFile) = 0
  line = LINEIN(SqPackFile)
  if POS('Err!', line) > 0 then do
    xx = WORD(line, 2)
    'erase "'xx'.*" /n'
    LineMsg = 'Killed - 'xx' - Corrupt message base.'
    Call DispLine node
  end
end
file = STREAM(SqPackFile, c, close)

/* Check for Duplicate Files*/
Call CheckDupes

/* Update the BBS files list*/
if dofilepost then do
  /* Format the Files.bbs Lists*/
  LineMsg = ' - Formatting/Sorting files.bbs - '
  Call DispLine node

  Call Prettyfl
  LineMsg = ' - Creating Files List - '
  Call DispLine node
  Drive
  'cd\'MaxPath
  'fbp'
  if isthere(Avail'.zip') then
    'erase 'Avail'.zip /n'
  'zip 'Avail' 'FBPReq
end
/* See how much space is left on the drive*/
Call ChkFree
/* Compress HPFS Message Bases*/
Call CompressMsgs
/* End of Compress*/
/* Clear out Non Connect Flags*/
Call SysFileTree Mail'\*.$$0', 'List', 'SFO'
/* Files exist - Process them*/
if List.0 > 0 then do
  do i = 1 to List.0
    'erase 'List.i' /n'
  end
end
DROP(List.)

/* Check to see if there is unprocessed mail*/
Call SysFileTree Drive'\'SqPath'\*.pkt', 'List', 'SFO'
/* Files exist - Process them*/
if List.0 > 0 then do
  Drive
  'cd\'SqPath
  'squishp in out squash link' 
  DROP(List.)
end
/* Check for new message areas*/
else do
  DROP(List.)
  Call SysFileTree BadArea'\*.Msg', 'List', 'FO'
  /* Files exist - Process them*/
  /*If BadMessages then create squish entries*/
  if List.0 > 0 then do
    DROP(List.)
    /* Update Squish.Cfg file*/
    Call SqUpdate
    Drive
    'cd\'SqPath
    'squishp in out squash link'
    /* If they are still there then they are dups*/
    Call SysFileTree BadArea'\*.Msg', 'List', 'FO'
    if List.0 > 0 then do
      FILESPEC('DRIVE', BadArea)
      'cd\'SUBSTR(BadArea, POS(':', BadArea) + 1)
      'erase *.msg /n'
    end
    DROP(List.)
  end
  /* Put up new Msg areas on the Desktop for the Sysop to update*/
  Call SqMaxUp
  /* Look for descriptions from the feed*/
  Call AddMaxMDsc
end
/* Put up new File areas on the Desktop for the Sysop to update*/
Call TkMaxUp

Return

/* Check that enough free space is available to process*/
ChkFree:

if debug then say 'ChkFree ------>'
  /* Clear out .bad files*/
  Call SysFileTree Drive'\'SqPath'\*.bad', 'List', 'FO'
  if List.0 > 0 then do
    Drive
    'cd\'SqPath
    'erase *.bad /n'
  end
  DROP(List.)

  /* See how much space is left on the drive for toss*/
  SysInfo = SysDriveInfo(Drive)
  Parse VAR SysInfo Drive  FreeLeft  Usedspace  DriveName
  /* Clear out some space for tossing*/
  if FreeLeft < FreeSpace then do
    biguns   = TrimLike
    /* Check for Large Files*/
    /* Delete files if we need space for messages*/
    if Drive = Files then
      Call CheckBiguns
    /* Still not enough space*/
    SysInfo = SysDriveInfo(Drive)
    Parse VAR SysInfo Drive  FreeLeft  Usedspace  DriveName
    if FreeLeft < FreeSpace then do
      olduns   = TrimLike
      /* If space can be made for messages by deleteing files then go do it*/
      if Drive = Files then
        Call CheckOlduns
    end
  end
return

/* Update the Nodelist*/
NodeLst:

if debug then say 'NodeLst ------>'
/* Clear out the work file area*/
Drive
'cd\'TempPath
'erase *.* /n'

Nodelist
'cd\'Nodelistpath
/* This is the nodelist processor that I us*/
NodeProcessor
return


Tick:

if debug then say 'Tick ------>'
/* Process Tick File*/
/* Set the string of areas to update to null*/
UpdateFB = ''
/* Then scan ticks and make sure that all the areas are in the .cfg file*/
Call mirtle
/* First check that there is enough space on the Drive*/
tempfree = FreeSpace
FreeSpace = ReqTicSpace
Call ChkFree
FreeSpace = tempfree
/*Tick the files to the area if space is available*/
/* Then create an anounce*/
if FreeLeft >= ReqTicSpace then do
  Drive
  'cd\'TickPath
  'tickp'
  dofilepost = Yes
  /* Now post what we did into a message base*/
  Call postfan
  /* Update the indexes for those areas that have changed*/
  if UpdateFB <> '' then do
    Drive
    'cd\'MaxPath
    'FBP AREA.DAT'UpdateFB
  end
end
return

Mirtle:
 
if debug then say 'Mirtle ------>'
/* Check to see if there are .MIR or .TIC files*/
Call CheckMirTic
/* Files exist - Process them*/
if Files.0 > 0 then do

  /* Log Date and Time since log entries exist*/
  linemsg = DATE()' 'TIME()

  /* Space required to move into Tic Area*/
  ReqTicSpace = 0

  /* Get Areas Defined in Tic.cfg*/
  Call GetTickAreas
  if List.0 > 0 then do
    do ii = 1 to List.0
      Tick.ii = List.ii
    end
    Tick.0 = List.0
  end
  else do
    say 'No Tic.cfg files found.'
    say ' Correct path to Drive - TickPath.'
    say 'Currently - 'Drive'\'TickPath'\Tic.cfg'
    return
  end
  DROP(List.)
  /* Get Max Areas for FBP*/
  Call GetMaxFAreas
  if List.0 > 0 then do
    wordptr = 1
    Call SortList
    do ii = 0 to List.0
      max.ii = SUBWORD(List.ii, 1, 2)
    end
  end
  else do
    say 'No filearea.ctl files found.'
    say 'Correct path to Drive - MaxPath.'
    say 'Currently - 'Drive'\'MaxPath'\filearea.ctl'
    return
  end
  DROP(List.)
  do ii = 1 to Files.0

    /* Default for Tic*/
    Function = 'ADD'

    /* Scan Command File for instructions*/
    Call GetFileInfo

    /* Process the file according to the info*/
    select
    when Function = 'ADD' then do

      /* Log Function*/
      linemsg = 'ADD - 'FileName' to 'AREA' for File - 'Files.ii
      Call postfile
      /* Find the Tick Area in Config File*/
      Call FindTic
      /* If the index has not gone past the end of the array - it's there*/
      if inx > 0 then do

        /* Check if the file is in the area*/
        Call CheckFileThere
        if isthere.0 > 0 then do

          /* Does an old file exist*/
          SrchFile = subdir'\'FileName
          Call SysFileTree SrchFile, 'isthere.', 'F'
          /* Remove old file */
          if isthere.0 > 0 then do
            'erase 'WORD(isthere.1, 5)' /n'
          end

          if DiskSpace > 0 then do
            linemsg = 'File Name - 'FileName' of size 'DiskSpace' will be copied to 'subdir' by Tick'
            /* If the target drive is not the destination drive then*/
            /* add up the disk space*/
            if SUBSTR(subdir, 1, 1) <> TRANSLATE(SUBSTR(FILES.ii, 1, 1)) then
              ReqTicSpace = ReqTicSpace + DiskSpace
          end
        end
        /* File for .Mir or .Tic is not in the inbound*/
        else do
          Call FileNotFound
        end
        Drop(isthere.)
      end 
      /* Tick not found in the config area*/
      else do
        /* Put it on the desktop to be added in*/
        Call TicNotThere
      end
    end

    when Function = 'DELETE' then do

      linemsg = 'DELETE - 'FileName' from 'AREA' for File -'Files.ii
      file = LINEOUT(FanTmp, linemsg)
      file = LINEOUT(FanTmp, ' ')
      file = STREAM(FanTmp, c, close)

      /* Find the Tick Area in Config File*/
      Call FindTic

      /* If the index has not gone past the end of the array - it's there*/
      if (inx <= Tick.0) & (inx > 0) then do

        subdir = WORD(Tick.inx, 1)
        /* Delete the file if it is there*/
        if isthere(subdir'\'FileName) then
          'erase 'subdir'\'FileName' /n'
        /* And get rid of the Tic Command File*/
      end
      /* And get rid of the Tic Command File*/
      'erase 'Files.ii' /n'
    end

    when Function = 'REPLACE' then do

      linemsg = 'REPLACE - 'FileName' in 'AREA' for File -'Files.ii
      Call postfile

      /* Find the Tick Area in Config File*/
      Call FindTic
      /* If the index has not gone past the end of the array - it's there*/
      if inx > 0 then do

        /* Check the file is in the Area*/
        Call CheckFileThere

        /* File for MIR is not found*/
        if isthere.0 = 0 then do
          Call FileNotFound
        end
      end
      else do
        /* Put it on the desktop to be added in*/
        Call TicNotThere
      end
    end
    otherwise
    end
  end
end

Drop(Tick.)
return

CheckMirTic:

if debug then say 'CheckMirTic ------>'
/* Check to see if there are .MIR or .TIC files*/
SrchFile = Mail'\'InMail'\*.TIC'
/* Does the File Exist*/
Call SysFileTree SrchFile, 'Files.', 'FO'
SrchFile = Mail'\'InMail'\*.MIR'
/* Does the File Exist*/
Call SysFileTree SrchFile, 'Mir.', 'FO'
if Mir.0 > 0 then do
  filecnt = Files.0
  do ii = 1 to Mir.0
    filecnt = filecnt + 1
    Files.filecnt = Mir.ii
  end
  Drop(Mir.)
  Files.0 = filecnt
end
return

GetFileInfo:

if debug then say 'GetFileInfo ------>'
  /* Scan Command File for instructions*/
  Desc = ''
  Area = ''
  Origin = ''
  Fromnm = ''
  FileName = ''
  Function = 'ADD'
  Desc = ''
  Password = ''
  seenby.0 = 0
  TicCmd = TicWork'\'FILESPEC('NAME', Files.ii)
  WriteOut = Yes
  do until LINES(Files.ii) = 0
    line = LINEIN(Files.ii)
    /* Avoid blank lines and Pw with no password*/
    if LENGTH(line) > 2 then do
      keyword = TRANSLATE(WORD(line, 1))
      select
        when keyword = 'AREA' then
          Area = TRANSLATE(WORD(line, 2))
        when keyword = 'ORIGIN' then
          Origin = WORD(line, 2)
        when keyword = 'FROM' then
          Fromnm = WORD(line, 2)
        when keyword = 'FILE' then
          FileName = TRANSLATE(WORD(line, 2))
        when keyword = 'STATUS' then
          Function = WORD(line, 2)
        when keyword = 'DESC' then
          Desc = Desc' 'SUBWORD(line, 2, 30)
        when keyword = 'REPLACES' then
          Function = 'REPLACE'
        when keyword = 'SEENBY' then do
          inx = seenby.0 + 1
          Seenby = SUBWORD(line, 2, 30)
          Seenby.inx = Seenby
          Seenby.0 = inx
        end
        when keyword = 'PW' then do
          Password = WORD(line, 2)
          if Password = '' then
            WriteOut = No
        end
        otherwise
      end /* select*/
      /* Do not write out a password line with a null password*/
      if WriteOut then
        file = LINEOUT(TicCmd, line)
      WriteOut = Yes
    end /*if*/
  end/* do*/
  DROP(seenby.)/* do not need these yet*/
  /* Close .tic or .mir file*/
  file = STREAM(Files.ii, c, close)
  /* But first check if there is a password - if not add one*/
  if Password = '' then do
    file = LINEOUT(TicCmd, 'PW x')
    file = STREAM(TicCmd, c, close)
    'copy 'TicCmd' 'Mail'\'InMail
  end
  else
    file = STREAM(TicCmd, c, close)
  'erase 'TicCmd' /n'

return

FindTic:

if debug then say 'FindTic------>'
  /* Find the Tick Area in Config File*/
  inx = 0
  do j = 1 to Tick.0
    if POS(Area, Tick.j) > 0 then do
      inx = j
      /* Get the subdirectory*/
      subdir = TRANSLATE(WORD(Tick.inx, 1))
      /* Do we add area to the fbp command*/
      do jj = 1 to max.0
        /* If this is the subdirectory in max*/
        if subdir = WORD(max.jj, 1) then do
          /* If we do not have the area listed for reindexing then add it*/
          maxarea = WORD(max.jj, 2)
          if WORDPOS(maxarea, UpdateFB) = 0 then
            UpdateFB = UpdateFB' 'maxarea
          leave
        end
      end
      leave
    end
  end
  if inx = 0 & Area.0 > 0 then do
    do j = 1 to Area.0
      /* Found Area - a bunch are coming in*/
      if Area.j = Area then do
        inx = -1
        leave
      end
    end
  end
return

CheckFileThere:

if debug then say 'CheckFileThere ------>'
  /* Put the file into the Area*/
  SrchFile = Mail'\'InMail'\'FileName
  /* See if we got the file*/
  DiskSpace = 0
  Call SysFileTree SrchFile, 'isthere.', 'F'
  if isthere.0 > 0 then
    /* Let Tick Handle the move after we check Disk space*/
    DiskSpace = WORD(isthere.1, 3)
/* isthere.0 is tested by the calling routine*/
return

FileNotFound:

if debug then say 'FileNotFound ------>'FileName
  linemsg = 'File Name - 'FileName' was missing from inbound.'
  /* Save it to examine*/
  'copy 'Files.ii' 'TicWork
  'erase 'Files.ii' /n'
return

/* The tic area is not there - put it on the desktop for the operator to add in*/
TicNotThere:

if debug then say 'TicNotThere ------>'Area
  if Files.ii = '' then
    return
  linemsg = '*****AREA NOT FOUND*****'
  /* Save the info until the operator creates the subdirs and adds to tic.cfg*/
  'COPY 'Files.ii' 'TicWork
  'ERASE 'Files.ii' /n'
  'COPY 'Mail'\'InMail'\'FileName' 'TicWork
  'ERASE 'Mail'\'InMail'\'FileName' /n'
  /* Only record it once*/
  if inx = 0 then do
    file = LINEOUT(TempTic, 'AREA 'Files'\'FilePath'\'Area' 'Area)
    file = LINEOUT(TempTic, '        'Fromnm' 'Password' *&')
    file = STREAM(TempTic, c, close)
    Area.0 = Area.0 + 1
    xxx = Area.0
    Area.xxx = Area
  end
return

/* Put out a message file*/
PostFile:

if debug then say 'PostFile ------>'
/* The sum is picked up and posted by postfan*/
file = LINEOUT(FanTmp, linemsg)
file = LINEOUT(FanTmp, 'From - 'Fromnm)
file = LINEOUT(FanTmp, 'Desc - 'Desc)
file = LINEOUT(FanTmp, ' ')
file = STREAM(FanTmp, c, close)
return

/* Do statistics here*/
Stats:

if debug then say 'Stats ------>'
LineMsg = TIME('N')'  'command
Call DispLine node
return

CheckDupes:

if debug then say 'CheckDupes ------>'
Call DispLine node

/* Check to see if there are duplicate files under this root*/
Dupes = 0
Likes = 0
Call SysFileTree Files'\'Filepath'\*.*', 'List', 'SFT'
/* Files exist - Process them*/
if List.0 > 0 then do
  inx = 0
  /* Remove all Files. lines*/
  do i = 1 to List.0
    FileName = TRANSLATE(FILESPEC('NAME',WORD(List.i,4)))
    if POS('FILES',FileName) = 0 then do
      /* Keep the Name with the Date and Time*/
      inx = inx + 1
      List.inx = TRANSLATE(LEFT(FileName,13))' 'DELWORD(List.i,3,1)
    end
  end

  List.0 = inx
  if inx > 1 then do
    wordptr = 1
    Call SortList
    if isthere(TrimLike) then
      'erase 'TrimLike' /n'
    /* Compare files for dupes*/
    do i = 2 to List.0
      j = i - 1
      oldname = WORD(List.j,1)
      newname = WORD(List.i,1)
      if oldname = newname then do
        file = LINEOUT(TrimLike,List.j)
        file = LINEOUT(TrimLike,List.i)
        file = STREAM(TrimLike, c, close)
        /* Delete the Oldest Date*/
        if WORD(List.j, 2) < Word(List.i, 2) then
          'erase 'WORD(List.j, 4)' /n'
        else
          'erase 'WORD(List.i, 4)' /n'
        Dupes = Dupes + 1
      end
      if clen > 0 then do
        /* The Names are close*/
        if substr(oldname,1,clen) = substr(newname,1,clen) then do
          oldpos = POS('.',oldname)
          newpos = POS('.',newname)
          /* Check the char before the decimal for numeric*/
          if oldpos > 1 then
            oldrev = substr(oldname,oldpos - 1,1)
          else
            oldrev = substr(oldname,LENGTH(oldname),1)
          if newpos > 1 then
            newrev = substr(newname,newpos - 1,1)
          else
            newrev = substr(newname,LENGTH(newname),1)
          if DATATYPE(oldrev) = 'NUM' & DATATYPE(newrev) = 'NUM' then do
            if oldrev <> newrev then do
              /* If dates are different*/
              if SUBSTR(WORD(List.j,2),1,8) <> SUBSTR(WORD(List.i,2),1,8) then do
                file = LINEOUT(TrimLike,List.j)
                file = LINEOUT(TrimLike,List.i)
                file = STREAM(TrimLike, c, close)
                Likes = Likes + 1
              end
            end
          end
        end
      end
    end
  end

  /* Set back to the control queue*/
  if Dupes > 0 then do
    LineMsg = ' - There were 'Dupes' Duplicate Files -'
    Call DispLine node
  end
  if Likes > 0 then do
    LineMsg = ' - There were 'Likes' Similar Files - Check ->'TrimLike
    Call DispLine node
  end
end
Drop(List.)
/* End of the Duplicate Files Check*/
Return

CheckBiguns:

if debug then say 'CheckBiguns ------>'
/* Now Check for Large files that users could not download anyway*/
  LineMsg = Files' has 'FreeLeft' bytes left!'
  Call DispLine node
  LineMsg = ' - Trimming Files Larger then 'deletesize' bytes'
  Call DispLine node
  filecnt = 0
  SrchFile = Files'\'Filepath'\*.*'
  /* Look for all Files*/
  Call SysFileTree SrchFile, 'List', 'SFT'
  if List.0 > 0 then do
    LineMsg = List.0' Files Found to Examine.'
    Call DispLine node
    wordptr = 2
    Call SortList
    do i = List.0 to 1 by -1
      FileDesc = WORD(List.i ,4)
      FileName = FILESPEC('NAME', FileDesc)
      FileType = TRANSLATE(RIGHT(FileName, LENGTH(FileName) - LASTPOS('.',FileName)))
      if POS(FileType, keepfiles) = 0 then do
        FileSize = WORD(List.i, 2)
        if FileSize > deletesize then do
          FreeLeft = FreeLeft + FileSize
          file = LINEOUT(biguns,List.i)
          file = STREAM(biguns, c, close)
          'erase 'FileDesc' /n'
          linemsg = 'DELETING - 'FileName' for lack of space on drive...'
          file = LINEOUT(FanTmp, linemsg)
          linemsg = 'Reason - File is too Large - 'FileSize' bytes'
          file = LINEOUT(FanTmp, linemsg)
          file = LINEOUT(FanTmp, ' ')
          file = STREAM(FanTmp, c, close)
          filecnt = filecnt + 1
        end
        if FreeLeft > FreeSpace then leave
        if FileSize < deletesize then leave
      end
    end
  end
  Drop(List.)

  if filecnt > 0 then do
    LineMsg = filecnt' Large Files Deleted.'
    Call DispLine node
  end
  /* End of the Big Ones*/
Return

CheckOlduns:

if debug then say 'CheckOlduns ------>'
  /* Look for all Files and sort Old to Newest*/
  Call SysFileTree SrchFile, 'List', 'SFT'
  LineMsg = ' - Trimming Outdated Files...'
  Call DispLine node
  filecnt = 0
  if List.0 > 0 then do
    /* Look for Old files*/
    wordptr = 1
    Call SortList
    today = DATE('O')
    thismonth = LEFT(today, 5)
    do i = 1 to List.0
      FileDesc = WORD(List.i ,4)
      FileName = FILESPEC('NAME', FileDesc)
      FileType = RIGHT(FileName, LENGTH(FileName) - LASTPOS('.',FileName))
      if POS(FileType, keepfiles) = 0 then do
        FileDate = WORD(List.i, 1)
        if thismonth = LEFT(FileDate, 5) then leave
        FileSize = WORD(List.i, 2)
        FreeLeft = FreeLeft + FileSize
        file = LINEOUT(olduns,List.i)
        file = STREAM(olduns, c, close)
        'erase 'FileDesc' /n'
        linemsg = 'DELETING - 'FileName' for lack of space on drive...'
        file = LINEOUT(FanTmp, linemsg)
        linemsg = 'Reason - File is too Old - 'FileDate
        file = LINEOUT(FanTmp, linemsg)
        file = LINEOUT(FanTmp, ' ')
        file = STREAM(FanTmp, c, close)
        if FreeLeft > FreeSpace then leave
      end
    end
  end
  Drop(List.)

  if filecnt > 0 then do
    LineMsg = filecnt' Old Files Deleted.'
    Call DispLine node
  end
Return

CompressMsgs:

if debug then say 'CompressMsgs ------>'
Call SysFileTree Messages'\'Messpath'\*.SQI','List','F'
wordptr = 5
Call SortList
LineMsg = 'Compressing 'List.0' Message areas...'
Call DispLine node
filedel.0 = 0

Drive
'cd\'SqPath
/* Read in the Message Aging File*/
FileChk.0 = 0
if isthere(MsgWait) then do
  i = 0
  do until LINES(MsgWait) = 0
    line = LINEIN(MsgWait)
    i = i + 1
    FileChk.i = line
  end
  FileChk.0 = i
end

Drive
'cd\'Messpath

do i = 1 to List.0
  FileName = FILESPEC('NAME',WORD(List.i, 5))
  dotp = POS('.', FileName)
  if dotp > 0 then
    FileName = DELSTR(FileName, dotp)
  size = WORD(List.i, 3)
  if size > 0 then do
    'copy "'FileName'.sqb" temp.$$$ > NUL'
    if RC = 0 then do
      'erase "'FileName'.sqb" /n'
      'ren temp.$$$ "'FileName'.sqb"'
      filedata = FileName'.sqd'
      if isthere(filedata) then do
        'copy "'filedata'" temp.$$$ > NUL'
        if RC = 0 then do
          'erase "'filedata'" /n'
          'rename temp.$$$ "'filedata'"'
        end
      end
    end
    /* else say file' Being used -> not processed'*/
  end
  else do
    MsgAge = 0
    MsgInx = 0
    if FileChk.0 > 0 then do
      do ii = 1 to FileChk.0
        if WORD(FileChk.ii, 1) = FileName then do
          MsgAge = WORD(FileChk.ii, 2)
          MsgInx = ii
          leave
        end
      end
    end
    /* Zero Messages for too long - delete the file*/
    if MsgAge > AgeMsg then do
      FileChk = FileName'.sqi'
      if isthere(FileChk) then
        'erase "'FileChk'" /n'
      FileChk = FileName'.sql'
      if isthere(FileChk) then
        'erase "'FileChk'" /n'
      FileChk = FileName'.sqb'
      if isthere(FileChk) then
        'erase "'FileChk'" /n'
      FileChk = FileName'.sqd'
      if isthere(FileChk) then
        'erase "'FileChk'" /n'
      filedel = filedel.0 + 1
      filedel.filedel = FileName
      filedel.0 = filedel    
      LineMsg = FileName' Message Base Unused.'
      Call DispLine node
      do ii = MsgInx to FileChk.0 - 1
        jj = ii + 1
        FileChk.ii = FileChk.jj
      end
      FileChk.0 = FileChk.0 - 1
    end
    else do
      /* Add new Msg to list or Update age*/
      if MsgInx = 0 then
        FileChk = FileChk.0 + 1
      else
        FileChk = MsgInx
      MsgAge = MsgAge + 1
      FileChk.FileChk = FileName' 'MsgAge
      if MsgInx = 0 then
        FileChk.0 = FileChk
    end
  end
end
Drop(List.)

/* Write back the aging file*/
Drive
'cd\'SqPath
if isthere(MsgWait) then
  'erase 'MsgWait' /n'
if FileChk.0 > 0 then do
  do i = 1 to FileChk.0
    file = LINEOUT(MsgWait, FileChk.i)
  end
end

if filedel.0 > 0 then do
  LineMsg = filedel.0' Empty Message Bases Deleted.'
  Call DispLine node
  do filedel = 1 to filedel.0
    FileName = filedel.filedel
    Call SqDelete
    linemsg = 'Echo Area - 'FileName' deleted on 'Date()' 'Time()
    file = LINEOUT(MsgTmp, linemsg)
    file = LINEOUT(MsgTmp, 'for lack of messages')
    file = LINEOUT(MsgTmp, ' ')
    file = STREAM(MsgTmp, c, close)
  end
  /* Update the sqafix.cfg*/
  Call SqaUpdate
  /* Post Message Announce on Desktop and Message Base*/
  Call postmsg
end
Drop(filedel.)
Return


/* Open the message base interface for read*/
MapiOpn:
/* Needs RXMSGAPI.DLL - SRI.ZIP*/

'RXSUBCOM Register MSGAPI RXMSGAPI RXMSGAPI'
'RXSUBCOM Load MSGAPI RXMSGAPI'
signal on halt name CLEANUP
signal on syntax name CLEANUP
/* Lets look at the bad messages area*/
address MSGAPI 'OPEN_API 1'
if RC <> 0 then
  signal CLOSEO
address MSGAPI 'OPEN_AREA' 'SAREAQ 'msg_base' 'basedef' 'basetype
return

/* Set the message base interface for read*/
MapiSetRead:
address MSGAPI 'OPEN_MSG' 'HANDLE' 'SAREAQ' 'MOPEN_READ' '1'
if RC <> 0 then
  signal CLOSEA
return

/* Set the message base interface for Write*/
MapiSetWrite:
address MSGAPI 'OPEN_MSG' 'HANDLE' 'SAREAQ' 'MOPEN_CREATE' '0'
if RC <> 0 then
  signal CLOSEA
return

/* Read the first message from the message base*/
MapiRdMsg:
  address MSGAPI 'READ_MSG' 'HANDLE' 'XMSG.' '0' '1000' 'MESSAGE' '100' 'CONTROL'
return

/* Write the first message to the message base*/
MapiWtMsg:
if Text <> '' then
  address MSGAPI 'WRITE_MSG' 'HANDLE' '0' 'XMSG.' 'TEXT' TEXTLEN TOTLEN CONTRLEN 'CONTRVAR'
else
  address MSGAPI 'WRITE_MSG' 'HANDLE' '0' 'XMSG.' 'NULL' TEXTLEN TOTLEN CONTRLEN 'CONTRVAR'
return

/* Read the next message*/
MapiNRdMsg:
/* Get the next message*/
address MSGAPI 'CLOSE_MSG' HANDLE
address MSGAPI 'GET_CURRENT_MSG' 'SAREAQ' 'MSGNUM'
address MSGAPI 'CLOSE_MSG' HANDLE
address MSGAPI 'KILL_MSG' 'SAREAQ' 'MSGNUM'
address MSGAPI 'OPEN_MSG' 'HANDLE' 'SAREAQ' 'MOPEN_READ' 'MSGNUM_NEXT'
return
      
MapiCls:
/* Needs RXMSGAPI.DLL*/

CleanUp:

if debug then say 'CleanUp ------>'
/* If we got out of this cleanly*/
if RC = 0 then
  address MSGAPI 'CLOSE_MSG' HANDLE
CLOSEA:
address MSGAPI 'CLOSE_AREA' 'SAREAQ'
CLOSEO:
address CMD 'RXSUBCOM drop MSGAPI'
Call on halt name recscreen
signal on syntax name recscreen

return

/* Post File Announce in the message base*/
PostFan:

if debug then say 'PostFan ------>'
msg_base = TRANSLATE(Messages'\'Messpath'\'FanBase)
if isthere(FanTmp) then do
  PostTmp = FanTmp
  if FanArea <> 'FANAREA' then do
    PostArea = FanArea
    Call post
  end
end
return

/* Post Message Announce in the message base*/
PostMsg:

if debug then say 'PostMsg ------>'
msg_base = TRANSLATE(Messages'\'Messpath'\'MsgBase)
if isthere(MsgTmp) then do
  PostTmp = MsgTmp
  if MsgArea <> 'MSGAREA' then do
    PostArea = MsgArea
    Call post
  end
end
return

/* Send out the Posted Message*/
Post:

if debug then say 'Post ------>'
basedef  = 'MSGAREA_CRIFNEC'
basetype = 'SQUISH'
/* Open and set to write*/
Call MapiOpn
/* attr from to subj orig dest date_written ... MUST NOT BE USED AS VARIABLES*/
XMSG.attr = 256
XMSG.from = 'Sysop'
XMSG.to = 'All'
XMSG.subj = 'Announcement'
XMSG.orig = '1:'SUBSTR(net.1, 3)'.0'
XMSG.dest = XMSG.orig
Name = ' * Origin: 'BBSName' ('SUBSTR(net.1, 3)')'
DATE = DATE('O')
TIME = TIME('N')
/* Correction to msgapi change 9 in 9x of year to 7x*/
XMSG.date_written ='7'SUBSTR(DATE, 2)':'TIME
XMSG.date_arrived = XMSG.date_written
XMSG.utc_ofs = 0
XMSG.replyto = 0
XMSG.replies = 0
do ii = 1 to 10
  XMSG.replies.ii = 0
end
DATE = DATE('N')
XMSG.ftsc_date = DELSTR(DATE, 7)' 'SUBSTR(DATE, 10)'  'TIME
totlen = 0
contrvar = SOH||NULL
contrlen = LENGTH(contrvar)
Text = '    The following Files were Received on - 'DATE('O')' 'TIME()||LF
Textlen = 0
do while LINES(PostTmp) > 0
  line = LINEIN(PostTmp)
  file = LINEOUT(PostArea, line)
  Text = Text||line||LF
end
Text = Text'--- Control 2.1'LF
Text = Text||Name
Textlen = LENGTH(Text)
totlen = Textlen + 8
/* Write out the message*/
Call MapiSetWrite
Call MapiWtMsg
Call MapiCls
file = STREAM(PostTmp, c, close)
file = STREAM(PostArea, c, close)
'erase 'PostTmp' /n'
return

/* Look for netmail requests*/
ReqChange:

if debug then say 'ReqChange ------>'
/* Needs RXMSGAPI.DLL*/

msg_base = BadArea
basedef  = 'MSGAREA_NORMAL'
basetype = 'SDM'

/* Open and set to read*/
Call MapiOpn
Call MapiSetRead
do while RC = 0
  Call MapiRdMsg

  Call MapiNRdMsg
end
return

/* Delete Squish message bases*/
SqDelete:

if debug then say 'SqDelete ------>'
'copy 'squishcfg' 'SquishTmp
if isthere(SquishWrk) then
  'erase 'SquishWrk' /n'

/* Look for the FileName message base*/
FileName = TRANSLATE(FileName)
line = LINEIN(SquishTmp)
do while LINES(SquishTmp) > 0
  if (TRANSLATE(WORD(line, 1)) = 'ECHOAREA') & (FileName = TRANSLATE(FILESPEC('NAME',WORD(line, 3)))) then do
    LineMsg = 'Deleting Echoarea 'FileName
    Call DispLine node
  end
  else
    file = LINEOUT(SquishWrk, line)
  line = LINEIN(SquishTmp)
end
file = LINEOUT(SquishWrk, line)
file = LINEOUT(SquishTmp)
file = LINEOUT(SquishWrk)
'copy 'SquishWrk' 'squishcfg
'erase 'SquishTmp' /n'
'erase 'SquishWrk' /n'

return

/* Look for new messages in the Bad message area and add to squish.cfg*/
SqUpdate:

if debug then say 'SqUpdate ------>'
/* Needs RXMSGAPI.DLL*/

msg_base = BadArea
basedef  = 'MSGAREA_NORMAL'
basetype = 'SDM'

/* Open and set to read*/
Call MapiOpn
Call MapiSetRead

/* Count new areas found in the bad messages*/
NewAreas.0 = 0

/* Until all messages have been scanned*/
LineMsg = 'Looking for New Message Bases...'
Call DispLine node
filecnt = 0

do while RC = 0
  Call MapiRdMsg

  /* Pull Area name out of control info*/
  AreaStart = POS('AREA:',CONTROL)
  if AreaStart > 0 then do
    AreaEnd = POS('',CONTROL,AreaStart)
    if AreaEnd > 0 then do
      AreaStart = AreaStart + 5
      AreaEnd = AreaEnd - 7
      /* And put in Area*/
      Area = SUBSTR(CONTROL, AreaStart, AreaEnd)

      /* Which zone did this message come from - strip :-> from right*/
      semip = POS(semicolon, XMSG.orig)
      if semip > 0 then
        netid = DELSTR(XMSG.orig, semip + 1)
      else
        netid = zonedef':'
      /* Make sure that we got this one from the same net*/
      AreaId = Area' 'netid

      /* OK did we run across this one before*/
      found = 0
      if NewAreas.0 > 0 then do
        do x = 1 to NewAreas.0
          if NewAreas.x = AreaId then do
            found = x
            leave
          end
        end
        if found = 0 then do
          NewAreas = NewAreas.0 + 1
          NewAreas.NewAreas = AreaId
          NewAreas.0 = NewAreas
          filecnt = filecnt + 1
        end
      end
      else do
        NewAreas.1 = AreaId
        NewAreas.0 = 1
        /* Oh boy - a new area - copy .cfg to work area*/
        'copy 'squishcfg' 'SquishTmp
        if isthere(SquishWrk) then
          'erase 'SquishWrk' /n'
        filecnt = 1
      end

      /* Look to see if we are in that net*/
      if found = 0 then do
        netno = 0
        do y = 1 to net
          if POS(netid, net.y) > 0 then do
            netno = y
            leave
          end
        end

        /* Found net so set up line for squish.cfg*/
        if netno > 0 then do
          /* Post for announcement*/
          origin = origin.netno
          linemsg = 'Echo Area - 'area' added on 'Date()' 'Time()
          file = LINEOUT(MsgTmp, linemsg)
          dotp = POS('.', XMSG.orig)
          if dotp > 0 then
            XMSG.orig = DELSTR(XMSG.orig, dotp)
          linemsg = 'Origin System = 'XMSG.orig' of 'WORD(origin, WORDS(origin) - 1)
          file = LINEOUT(MsgTmp, linemsg)
          file = LINEOUT(MsgTmp, ' ')
          file = STREAM(MsgTmp, c, close)

          Area = LEFT(STRIP(Area),14)
          SquishCln = 'EchoArea  'area' 'Messages'\'Messpath'\'LEFT(TRANSLATE(SUBSTR(Area, 1, 8),'-----','&\/%@'),9)' -$ -$m250 -$d7 'net.netno'     'XMSG.orig

          /* And put it in the squish.cfg temp file*/
          do while LINES(SquishTmp) > 0
            line = LINEIN(SquishTmp)
            if TRANSLATE(WORD(line, 1)) = 'ECHOAREA' then
              if POS(net.netno, TRANSLATE(line)) > 0 then
                leave
            file = LINEOUT(SquishWrk, line)
          end
          do while LINES(SquishTmp) > 0
            xline = TRANSLATE(line)
            if POS(net.netno, xline) = 0 then do
              file = LINEOUT(SquishWrk, SquishCln)
              leave
            end
            SqArea = WORD(line, 2)
            /* Safeguard against dupes in Bad Messages*/
            if SqArea = Area then do
              NewAreas = NewAreas.0 - 1
              leave
            end
            if SqArea > Area then do
              file = LINEOUT(SquishWrk, SquishCln)
              leave
            end
            file = LINEOUT(SquishWrk, line)
            line = LINEIN(SquishTmp)
          end
          do while LINES(SquishTmp) > 0
            file = LINEOUT(SquishWrk, line)
            line = LINEIN(SquishTmp)            
          end
          file = LINEOUT(SquishWrk, line)
          /* Close files*/
          file = STREAM(SquishTmp, c, close)
          file = STREAM(SquishWrk, c, close)
          'erase 'SquishTmp' /n'
          'rename 'SquishWrk' 'FILESPEC('NAME',SquishTmp)
        end
      end
    end
  end
  Call MapiNRdMsg
  Drop(xmsg.)
end
/* Update squish config file*/
if NewAreas.0 > 0 then do
  'copy 'SquishTmp' 'squishcfg
  'erase 'SquishTmp' /n'
end

Call MapiCls

if filecnt > 0 then do
  LineMsg = filecnt' New Message Bases Found and Created.'
  Call DispLine node
  /* Update sqafix.cfg with new areas*/
  Call SqaUpdate
  /* Post Message Announce on Desktop and Message Base*/
  Call postmsg
end
Return

/* Update the Maximus File area filearea.ctl*/
/* This will get displayed as a separate desktop item for manual merging*/

TkMaxUp:

if debug then say 'TkMaxUp ------>'
if isthere(TempMaxF) then
  'erase "'TempMaxF'" /n'

/* Get Areas Defined in Tic.cfg as Path Area into tick.*/
Call GetTickAreas
if List.0 > 0 then do
  /* Sort Tick areas then setup for compare*/
  wordptr = 1
  Call SortList
  prearea = ''
  /* Skip dup areas - these are OK*/
  ii = 0
  do i = 1 to List.0
    /* Check for duplicate areas*/
    farea = WORD(List.i, 1)
    if farea <> prearea then do
      ii = ii + 1
      Tick.ii = List.i
      prearea = farea
    end
  end
  Tick.0 = ii
  Drop(List.)
  Call GetMaxFAreas
  if List.0 > 0 then do
    wordptr = 1
    Call SortList
    prearea = ''
    ii = 0
    do i = 1 to List.0
      /* Check for duplicate areas*/
      marea = WORD(List.i, 1)
      if marea <> prearea then do
        ii = ii + 1
        max.ii = WORD(List.i, 1)
        List.ii = WORD(List.i, 2)
        prearea = marea
      end
      /* This Area is duplicated*/
      else do
        file = LINEOUT(TempMaxF, ';****File area - 'prearea' Duplicated in filearea.ctl - fix it***')
        file = STREAM(TempMaxF, c, close)
      end
    end
    max.0 = ii
    List.0 = ii
    /* Sort newnames list*/
    wordptr = 1
    Call SortList
    do i = 1 to List.0
      newname.i = List.i
    end
    newname.0 = List.0
  end
  else do
    say 'No filearea.ctl files found.'
    say 'Correct path to Drive - MaxPath.'
    say 'Currently - 'Drive'\'MaxPath'\filearea.ctl'
    return
  end
  Drop(List.)

end
else do
  say 'No Tic.cfg files found.'
  say ' Correct path to Drive - TickPath.'
  say 'Currently - 'Drive'\'TickPath'\Tic.cfg'
  return
end
/* Get Files.bbs that Do Exist*/
Call GetBBSAreas
if List.0 > 0 then do
  /* Sort BBS areas that exist*/
  wordptr = 1
  Call SortList
  do i = 1 to List.0
    path = WORD(List.i, 1)
    perp = LASTPOS('\', path)
    if perp > 0 then
      bbs.i = DELSTR(path, perp)
    else
      bbs.i = path
  end
  bbs.0 = List.0
end
else do
  say 'No Files.bbs files found.'
  say ' Correct path to Files - FilePath.'
  say 'Currently - 'Files'\'FilePath'\Files.bbs /s'
  return
end
Drop(List.)
say 'Processing Files....'
say 'Cross checking 'tick.0' tick areas. 'max.0' max areas. 'bbs.0 'bbs areas.'
/* Now compare files to find the missing entries*/
mi = 1 /* Max*/
ti = 1 /* Tick*/
bi = 1 /* BBS*/
do until bi > bbs.0 | ti > tick.0 | mi > max.0
  tarea = WORD(tick.ti, 1)
  marea = WORD(max.mi, 1)
  barea = TRANSLATE(bbs.bi)
  say 't='tarea' m='marea' b='barea
  /* Tick area matches Max Area*/
  if tarea = marea then do
    ti = ti + 1
    mi = mi + 1
    /* And the .BBS are present*/
    if tarea = barea then
      bi = bi + 1
    else
      /* But there appears to be a Tick area that was missed*/
      if tarea > barea then do
        ti = ti - 1
        mi = mi - 1
        bi = bi + 1
      end
  end
  else do
    /* Tick area but no Max Area*/
    if tarea > marea then do
      /* In the max ctl but no Tick entry*/
      msgout = 'Max  path - 'marea'->Tick'
      mi = mi + 1
      if tarea = barea then do
        file = LINEOUT(TempMaxF, ';****File area - 'marea' S/B removed - not in Tic***')
      end
      else do
        /* We really missed! A file area was also missed in tick*/
        file = LINEOUT(TempMaxF, ';****File area - 'marea' missed by tick - check***')
        if tarea > barea then do
          /* get rid of the file base - it will get recreated*/
          Drive
          file = LINEOUT(TempMaxF, ';****Also delete Files***')
          bi = bi + 1
        end
      end
    end
    else do
      /* Max area needs to be created*/
      TickArea = WORD(tick.ti, 2)
      msgout = 'Tick path - 'tarea' Area - 'TickArea'->Max Area '
      if tarea = barea then do
        Call MaxFileCreate
        ti = ti + 1
        bi = bi + 1
      end
      else do
        if tarea > barea then do
          file = LINEOUT(TempMaxF, ';****Tick File Area missing for - 'barea'.')
          bi = bi + 1
        end
        else do
          Call MaxFileCreate
          ti = ti + 1
        end
      end
    end
  end
end
file = STREAM(TempMaxF, c, close)
Drop(tick.)
Drop(bbs.)
Drop(max.)
Drop(newname.)
return

/* Update the Maximus Message area msgarea.ctl*/
/* This will get displayed as a separate desktop item for manual merging*/
SqMaxUp:

if debug then say 'SqMaxUp ------>'
if isthere(TempMaxM) then
  'erase "'TempMaxM'" /n'

/* Get Areas Defined in Squish.cfg*/
Call GetSquishAreas
if List.0 > 0 then do
  /* Sort squish areas then setup for compare*/
  wordptr = 1
  Call SortList
  prearea = ''
  ii = 0
  do i = 1 to List.0
    tarea = WORD(List.i, 1)
    if tarea <> prearea then do
      ii = ii + 1
      squish.ii = List.i
      prearea = tarea
    end
    /* This Area is duplicated*/
    else
      file = LINEOUT(TempMaxM, ';****Message area - 'prearea' Duplicated in Squish.cfg - fix it***')
  end

  squish.0 = ii

  Drop(List.)


  /* Now get Max Message Areas*/
  Call GetMaxMAreas
  if List.0 > 0 then do
    wordptr = 1
    Call SortList
    prearea = ''
    ii = 0
    do i = 1 to List.0
      /* Check for duplicate areas*/
      marea = WORD(List.i, 1)
      if marea <> prearea then do
        ii = ii + 1
        max.ii = List.i
        List.ii = WORD(List.i, 2)
        prearea = marea
      end
      /* This Area is duplicated*/
      else do
        file = LINEOUT(TempMaxM, ';****Message area - 'prearea' Duplicated in Msgarea.ctl - fix it***')
        file = STREAM(TempMaxM, c, close)
      end
    end
    max.0 = ii
    List.0 = ii
    /* Sort newnames list*/
    wordptr = 1
    Call SortList
    do i = 1 to List.0
      newname.i = List.i
    end
    newname.0 = List.0
  end
  else do
    say 'No MsgArea.ctl files found.'
    say ' Correct path to Drive - MaxPath.'
    say 'Currently - 'Drive'\'MaxPath'\MsgArea.ctl'
    return
  end
  Drop(List.)

end
else do
  say 'No Squish.cfg files found.'
  say ' Correct path to Drive - SqPath.'
  say 'Currently - 'Drive'\'SqPath'\Squish.cfg'
  return
end

/* Get Message Areas that Do Exist*/
Call GetMsgAreas
if List.0 > 0 then do
  /* Sort msg areas that exist*/
  wordptr = 5
  Call SortList
  j = 0
  do i = 1 to List.0
    /* If there are no messages then it aint there*/
    size = WORD(List.i, 3)
    if size > 0 then do
      file = FILESPEC('NAME',WORD(List.i, 5))
      dotp = POS('.', file)
      if dotp = 0 then
        dotp = LENGTH(file) + 1
      j = j + 1
      msg.j = Messages'\'MessPath'\'DELSTR(file, dotp)
    end
  end
  msg.0 = j
end
else do
  say 'No Message files found.'
  say ' Correct path to Mail - MessPath.'
  say 'Currently - 'Mail'\'MessPath'\*.sqi'
  return
end
Drop(List.)


say 'Processing Messages....'
say 'Cross checking 'squish.0' squish areas. 'max.0' max areas. 'msg.0 'msg areas.'
/* Now compare files to find the missing entries*/
mi = 1 /* Max*/
si = 1 /* Squish*/
fi = 1 /* Message*/
do until si > squish.0 | fi > msg.0 | mi > max.0
  sarea = WORD(squish.si, 1)
  marea = WORD(max.mi, 1)
  farea = TRANSLATE(msg.fi)
  say 's='sarea' m='marea' f='farea
  /* Squish area matches Max Area*/
  if sarea = marea then do
    si = si + 1
    mi = mi + 1
    /* And the messages are present*/
    if sarea = farea then
      fi = fi + 1
    else
      /* But there appears to be a Message area that was missed*/
      if sarea > farea then do
        si = si - 1
        mi = mi - 1
        fi = fi + 1
      end
  end
  else do
    /* Squish area but no Max Area*/
    if sarea > marea then do
      /* In the max ctl but no Squish entry - Probably deleted by compress*/
      msgout = 'Max  path - 'marea'->Squish'
      mi = mi + 1
      if sarea = farea then do
        file = LINEOUT(TempMaxM, ';****Message area - 'marea' S/B removed - not in Squish***')
      end
      else do
        /* We really missed! A message area was also missed in Squish*/
        file = LINEOUT(TempMaxM, ';****Message area - 'marea' missed by squish - check***')
        if sarea > farea then do
          /* get rid of the message base - it will get recreated*/
          Drive
          file = LINEOUT(TempMaxM, ';****Also delete Messages***')
          fi = fi + 1
        end
      end
    end
    else do
      /* Max area needs to be created*/
      SquishArea = WORD(squish.si, 2)
      msgout = 'Squish path - 'sarea' Area - 'SquishArea'->Max Area '
      if sarea = farea then do
        Call MaxMsgCreate
        si = si + 1
        fi = fi + 1
      end
      else do
        if sarea > farea then do
          file = LINEOUT(TempMaxM, ';****Squish Message Area missing for - 'farea'.')
          file = LINEOUT(TempMaxM, ';*****If this is a local area then mark it as local in msgarea.ctl...')
          fi = fi + 1
        end
        else do
          Call MaxMsgCreate
          si = si + 1
        end
      end
    end
  end
end
file = STREAM(TempMaxM, c, close)
Drop(squish.)
Drop(msg.)
Drop(max.)
Drop(newname.)

return

/* Add a new max file area*/
MaxFileCreate:

if debug then say 'MaxFileCreate ------>'
  /* Create Max area as Files are Present*/
  Area      = 'A'DELSTR(TickArea, 2)||SUBSTR(TickArea, LENGTH(TickArea) - 1)
  Call ChkName
  Area = 'Area 'Area
  FileAccess = indent'FileAccess      Normal'
  FileInfo   = indent'FileInfo        'TickArea
  DownLoad  = indent'Download        'WORD(tick.ti, 1)
  UpLoad    = indent'Upload          'Uload
  file = LINEOUT(TempMaxF, Area)
  file = LINEOUT(TempMaxF, FileAccess)
  file = LINEOUT(TempMaxF, FileInfo)
  file = LINEOUT(TempMaxF, DownLoad)
  file = LINEOUT(TempMaxF, UpLoad)
  file = LINEOUT(TempMaxF, EndArea)
  file = STREAM(TempMaxF, c, close)
return

/* Add a new max message area*/
MaxMsgCreate:

if debug then say 'MaxMsgCreate ------>'
  /* Create Max area as Messages are Present*/
  Origin    = indent||SUBWORD(squish.si, 4, 3)' 'bbsName
  Area      = WORD(squish.si, 7)||SUBSTR(SquishArea, POS('.', SquishArea) + 1, 3)
  Call ChkName
  Area = 'Area 'Area
  MsgAccess = indent'MsgAccess       'SUBWORD(squish.si, 3, 1)
  MsgInfo   = indent'MsgInfo         'WORD(squish.si ,6)' 'SquishArea
  EchoMail  = indent'EchoMail        'sarea
  file = LINEOUT(TempMaxM, Area)
  file = LINEOUT(TempMaxM, MsgAccess)
  file = LINEOUT(TempMaxM, Type)
  file = LINEOUT(TempMaxM, MsgInfo)
  file = LINEOUT(TempMaxM, EchoMail)
  file = LINEOUT(TempMaxM, Public)
  file = LINEOUT(TempMaxM, Origin)
  file = LINEOUT(TempMaxM, EndArea)
  file = STREAM(TempMaxM, c, close)
return

/* Check for a unique name in file or message area*/
ChkName:

if debug then say 'ChkName ------>'
  jp = newname.0
  if Area < newname.jp then do
    jp = 1
    do while Area >= newname.jp
      if Area = newname.jp then do
        tail = LENGTH(Area)
        tailchr = SUBSTR(Area, tail)
        /* use next character*/
        Area = DELSTR(Area, tail)||SUBSTR(maxchrs, POS(tailchr, maxchrs) + 1, 1)
        jp = 1
      end
      jp = jp + 1
    end
    /* Insert the new name*/
    do jj = newname.0 to jp by -1
      jn = jj + 1
      newname.jn = newname.jj
    end
    newname.jp = Area
    say 'Adding ='Area
    newname.0 = newname.0 + 1
  end
  else do
    if newname.jj = Area then do
      tail = LENGTH(Area)
      tailchr = SUBSTR(Area, tail)
      /* use next character*/
      Area = DELSTR(Area, tail)||SUBSTR(maxchrs, POS(tailchr, maxchrs) + 1, 1)
    end
    jj = jj + 1
    newname.jj = Area
    newname.0 = jj
  end
return

GetTickAreas:

if debug then say 'GetTickAreas ------>'
  /* Scan for Tick File Areas*/
  tick = 0
  if isthere(tickcfg) then do
    do until LINES(tickcfg) = 0
      line = TRANSLATE(LINEIN(tickcfg))
      if WORD(line, 1) = 'AREA' then do
        tick = tick + 1
        List.tick = SUBWORD(line, 2)
      end
    end
    List.0 = tick
    file = STREAM(tickcfg, c, close)
  end
  else
    List.0 = 0
return

/* Get File Areas from filearea.ctl*/
GetFileAreas:

if debug then say 'GetFileAreas ------>'
/* Read in the filesarea.ctl file until all file areas are found*/
/* Files.bbs count*/
Finx = 0
/* CDRom .bbs count*/
Cinx = 0
do until LINES(filesbbs) = 0
  line = LINEIN(filesbbs)

  /* Find Area Definition*/
  if TRANSLATE(WORD(line, 1)) = 'AREA' then do
    /* Assume Hard Drive*/
    Finx = Finx + 1
    Ftype = 'HD'
    fdesc = ''
    fdown = Drive

    /* Get information about area from the ctl file*/
    do until TRANSLATE(WORD(line, 1)) = 'END'
      line = TRANSLATE(LINEIN(filesbbs))
      Directive = WORD(line, 1)
      select
        when Directive = 'FILEINFO' then
          fdesc = SUBWORD(line, 2)
        when Directive = 'DOWNLOAD' then
          fdown = WORD(line, 2)
        when Directive = 'FILELIST' then do
          /* If CDROM in path then it is CDROM*/
          if POS('CDROM', WORD(line, 2)) > 0 then do 
            fcd = SUBWORD(line, 2)
            Ftype = 'CD'
            Finx = Finx - 1
            Cinx = Cinx + 1
          end
        end
        otherwise
      end
    end

    /* A Harddrive File*/
    if Ftype = 'HD' then do
      List.Finx = fdown'\files.bbs'
      Fdesc.Finx = fdesc
    end

    /* A CD File*/
    else do
      CD.Cinx    = fcd
      Cdesc.Cinx = fdesc
    end
  end
end

/* Get the Number of Dynamic file areas - ie - not on CDRom*/
List.0 = Finx
return

GetSquishAreas:

if debug then say 'GetSquishAreas ------>'
  /* Scan for Squish File Areas*/
  if isthere(squishcfg) then do
    j = 0
    do until LINES(squishcfg) = 0
      line = TRANSLATE(LINEIN(squishcfg))
      if WORD(line, 1) = 'ECHOAREA' then do
        access = ''
        origin = ''
        do k = 1 to net
          if POS(net.k, line) > 0 then do
            origin = origin.k
            access = access.k
            leave
          end
        end
        j = j + 1
        /*       path           name           access  description*/
        List.j = WORD(line,3)' 'WORD(line,2)' 'access' 'origin
      end   
    end
    file = STREAM(squishcfg, c, close)
    List.0 = j
  end
  else
    List.0 = 0
return

/* Find all max msgarea.ctl areas and check for missing config lines*/
GetMaxFAreas:

if debug then say 'GetMaxFAreas ------>'
  /* Get the Max Ctl File Name*/
  maxctl = Drive'\'MaxPath'\filearea.ctl'
  /* Scan for File Areas in Filearea.ctl*/
  if isthere(maxctl) then do
    j = 0
    do until LINES(maxctl) = 0
      line = TRANSLATE(LINEIN(maxctl))
      if WORD(line, 1) = 'AREA' then do
        Area = WORD(line, 2)
        FileInfo  = ''
        Download = ''
        Upload = ''
        /* We ignore any cdrom paths*/
        FileList = ''
        FileAccess = ''
        do until Directive = 'END'
          line = TRANSLATE(LINEIN(maxctl))
          Directive = WORD(line, 1)
          select
            when Directive = 'FILEACCESS' then do
              FileAccess = WORD(line, 2)
              perp = POS('/', FileAccess)
              /* Strip off class*/
              if perp > 0 then
                FileAccess = DELSTR(FileAccess, perp)
            end
            when Directive = 'FILEINFO' then
              FileInfo = SUBWORD(line, 2)
            when Directive = 'DOWNLOAD' then
              DownLoad =  WORD(line, 2)
            when Directive = 'UPLOAD' then
              UpLoad =  WORD(line, 2)
            when Directive = 'FILELIST' then
              FileList =  WORD(line, 2)
            otherwise 
          end
        end
        /* If this is not a Cdrom then process it*/
        if POS('CDROM', FileList) = 0 then do
          msgout = ''
          /* Only flag first error*/
          select
            when FileAccess = '' then
              msgout = ';*****File Access'
            when FileInfo = '' then
              msgout = ';*****File Description' 
            when DownLoad = '' then
              msgout = ';*****Download Section' 
            when Upload = '' then
              msgout = ';*****UpLoad Section' 
            /* Add to Max Message Areas*/
            otherwise do
              j = j + 1
              List.j = DownLoad' 'Area' 'FileAccess' 'FileInfo
            end
          end
          if msgout <> '' then
            file = LINEOUT(TempMaxF, ' Missing for FileArea='DownLoad' Area='Area' FileAccess='FileAccess' FileInfo='FileInfo)
        end
      end   
    end
    file = STREAM(maxctl, c, close)
    List.0 = j
  end
  else
    List.0 = 0
return

GetMaxMAreas:

if debug then say 'GetMaxMAreas ------>'
  /* Get the Max Ctl File Name*/
  maxctl = Drive'\'MaxPath'\msgarea.ctl'
  /* Scan for Max Areas in Msgarea.ctl*/
  if isthere(maxctl) then do
    j = 0
    do until LINES(maxctl) = 0
      line = TRANSLATE(LINEIN(maxctl))
      if WORD(line, 1) = 'AREA' then do
        Area = WORD(line, 2)
        MsgInfo  = ''
        EchoMail = ''
        MsgAccess = ''
        do until Directive = 'END'
          line = TRANSLATE(LINEIN(maxctl))
          Directive = WORD(line, 1)
          select
            when Directive = 'MSGINFO' then
              MsgInfo = SUBWORD(line, 2)
            when Directive = 'ECHOMAIL' then
              EchoMail = WORD(line, 2)
            /* Not Echomail - ignore - This S/B in another subdirectory*/
            when Directive = 'LOCAL' then
              EchoMail = 'NO'
            when Directive = 'MATRIX' then
              EchoMail = 'NO'
            when Directive = 'MSGACCESS' then do
              /* Gets MsgAccess Normal/F */
              perp = POS('/', line)
              if perp > 0 then
                MsgAccess = SUBSTR(line, perp + 1, 1)
              else
                MsgAccess = 'W' /* Sysop can only turn this on*/
            end
            otherwise 
          end
        end
        /* If this isnt echomail then do not bother*/
        if EchoMail <> 'NO' then do
          msgout = ''
          select
            when EchoMail = '' then
              msgout = ';*****EchoMail'
            when Area = '' then
              msgout = ';*****Area' 
            when MsgAccess = '' then
              msgout = ';*****Message Access' 
            when MsgInfo = '' then
              msgout = ';*****Message Description' 
            /* Add to Max Message Areas*/
            otherwise do
              j = j + 1
              List.j = EchoMail' 'Area' 'MsgAccess' 'MsgInfo
            end
          end
          if msgout <> '' then
            file = LINEOUT(TempMaxM, ' Missing for EchoMail='Echomail' Area='Area' MsgAccess='MsgAccess' MsgInfo='MsgInfo)
        end
      end   
    end
    file = STREAM(maxctl, c, close)
    List.0 = j
  end
  else
    List.0 = 0
return

GetBBSAreas:

if debug then say 'GetBBSAreas ------>'
  /* Get the File Areas*/
  fls = Files'\'FilePath'\*.BBS'
  /* Scan for .BBS File Areas*/
  Call SysFileTree fls,'List.','FSO'
  /* Make all uppercase for comparison*/
  do i = 1 to List.0
    List.i = TRANSLATE(List.i)
  end
return

GetMsgAreas:

if debug then say 'GetMsgAreas ------>'
  /* Get the Msg Areas*/
  msg = Messages'\'MessPath'\*.SQI'
  /* Scan for Squish File Areas*/
  Call SysFileTree msg,'List.','F'
  /* Make all uppercase for comparison*/
  do i = 1 to List.0
    List.i = TRANSLATE(List.i)
  end
return

AddMaxMDsc:

if debug then say 'AddMaxMDsc ------>'
/* If descriptions are available from feed then add to Max*/
/* If msgarea.ctl isn't there then look at the desktop file*/
if isthere(TempMaxM) then do
  'copy "'TempMaxM'" "'TempMaxW'"'
  'erase "'TempMaxM'" /n'
  maxctl = TempMaxW
end
/* Otherwise add descriptions to the regular msgarea.ctl file*/
/* And put it on the desktop*/
else
  maxctl = Drive'\'MaxPath'\msgarea.ctl'
/* Scan for Message Areas in the control file*/
if isthere(maxctl) then do
  /* Get Net Addresses from -p1:348/105 to 348*/
  do i = 1 to net
    netaddr = net.i
    semip = POS(':', netaddr)
    if semip > 0 then
      netaddr = SUBSTR(netaddr, semip + 1)
    perp = POS('/', netaddr)
    if perp > 0 then
      netaddr.i = DELSTR(netaddr, perp)
    else
      netaddr.i = netdef
  end
  /* Now look for feed Description File as c:\bink\M348.Lst*/
  do i = 1 to net
    descfile = Drive'\'CmdPath'\M'netaddr.i'.LST'
    if isthere(descfile) then
      descfile.i = descfile
    else
      descfile.i = ''
  end
  Drop(netaddr.)
  do until LINES(maxctl) = 0
    line = LINEIN(maxctl)
    if TRANSLATE(WORD(line, 1)) = 'AREA' then do
      origin = 0
      EchoMail = 'NO'
      /*put it on the stack for processing*/
      lines = 1
      do until Directive = 'END' | LINES(maxctl) = 0
        /* Store all the message statements in line.lines*/
        line.lines = line
        lines = lines + 1
        line = LINEIN(maxctl)
        Directive = TRANSLATE(WORD(line, 1))
        select
          when Directive = 'ORIGIN' then
            /* Pick out the net*/
            origin = WORD(line, 2) + 1
          /* Not Echomail - ignore*/
          when Directive = 'LOCAL' then
            EchoMail = 'NO'
          when Directive = 'MATRIX' then
            EchoMail = 'NO'
          when Directive = 'ECHOMAIL' then
            EchoMail = WORD(line, 2)
          otherwise
        end
      end
      line.lines = line
      do i = 1 to lines
        line = line.i
        /* If this is echomail then get the description if available*/
        if EchoMail <> 'NO' then do
          Directive = TRANSLATE(WORD(line, 1))
          if Directive = 'MSGINFO' then do
            /* Subdirectory and name in upper case*/
            EchoMail = TRANSLATE(EchoMail)
            /* Match the description with the echo*/
            if origin > 0 & descfile.origin <> '' then do
              /* Find the Description*/
              descfile = descfile.origin
              do until Lines(descfile) = 0
                dline = linein(descfile)
                if TRANSLATE(WORD(dline, 1)) = EchoMail then do
                  /* Get the description*/
                  descline = SUBWORD(dline, 2)
say EchoMail'----'descline
                  line = '        MsgInfo         'descline
                  leave
                end
              end
              file = STREAM(descfile, c, close)
            end
          end
        end
        file = LINEOUT(TempMaxM, line)
      end
    end
    /* Not a file control statement*/
    else
      file = LINEOUT(TempMaxM, line)
  end
end
Drop(Line.)

file = STREAM(TempMaxM, c, close)
file = STREAM(maxctl, c, close)
return

AddMaxFDsc:

if debug then say 'AddMaxFDsc ------>'
/* If descriptions are available from feed then add to Max*/
/* If filearea.ctl isn't there then look at the desktop file*/
if isthere(TempMaxF) then do
  'copy "'TempMaxF'" "'TempMaxW'"'
  'erase "'TempMaxF'" /n'
  maxctl = TempMaxW
end
/* Otherwise add descriptions to the regular filearea.ctl file*/
/* And put it on the desktop*/
else
  maxctl = Drive'\'MaxPath'\filearea.ctl'
/* Scan for File Areas in control file*/
if isthere(maxctl) then do
  /* Now look for feed Description File as c:\bink\File.Lst*/
  descfile = Drive'\'CmdPath'\File.Lst'
  if isthere(descfile) then do
    /* Get Areas Defined in Tic.cfg as Path Area into tick.*/
    Call GetTickAreas
    do until LINES(maxctl) = 0
      line = LINEIN(maxctl)
      if TRANSLATE(WORD(line, 1)) = 'AREA' then do
        origin = 0
        /* We don't update CD Areas*/
        FileArea = 'HD'
        /*put it on the stack for processing*/
        lines = 1
        /* Blank lines separate each Area*/
        do until Directive = 'END' | LINES(maxctl) = 0
          /* Store all the message statements in line.lines*/
          line.lines = line
          lines = lines + 1
          line = LINEIN(maxctl)
          Directive = TRANSLATE(WORD(line, 1))
          if (Directive = 'DOWNLOAD') & (FileArea = 'HD') then
            /* Get the path for the search*/
            FileArea = TRANSLATE(WORD(line, 2))
          else
            /* Skip CD Areas*/
            if (Directive = 'FILELIST') & (POS('CDROM', TRANSLATE(line)) > 0) then
              FileArea = 'CD'
        end
        line.lines = line
        do i = 1 to lines
          line = line.i
          /* If this is dynamic then get the description if available*/
          if FileArea <> 'CD' then do
            Directive = TRANSLATE(WORD(line, 1))
            if Directive = 'FILEINFO' then do
              /* Subdirectory and name in upper case*/
              FileArea = TRANSLATE(FileArea)
              /* Match the Path with the Tic description*/
              FileID = ''
              do ii = 1 to List.0
                if FileArea = WORD(List.ii, 1) then do
                  FileID = WORD(List.ii, 2)
                  leave
                end
              end
              if FileID <> '' then do
                do until LINES(descfile) = 0
                  dline = linein(descfile)
                  if TRANSLATE(WORD(dline, 1)) = FileID then do
                    /* Get the description*/
                    descline = SUBWORD(dline, 2)
say FileID'----'descline
                    line = '        FileInfo         'descline
                    leave
                  end
                end
                file = STREAM(descfile, c, close)
              end
            end
          end
          file = LINEOUT(TempMaxF, line)
        end
      end
      /* Not a file control statement*/
      else
        file = LINEOUT(TempMaxF, line)
    end
    Drop(File.)
  end
end
Drop(Line.)

file = STREAM(TempMaxF, c, close)
file = STREAM(maxctl, c, close)
return

/* Update Sqafix.cfg*/
SqaUpdate:

if debug then say 'SqaUpdate ------>'
/* Get the squish areas to match the path List.0 */
/* EchoMail   name   access  description*/
if isthere(sqafixwrk) then
  'erase 'sqafixwrk' /n'
class = 'F'
if isthere(squishcfg) then do
  j = 0
  /* Set previous description file to blank*/
  descfile = ' '
  found = 0
  do until LINES(squishcfg) = 0
    descline = ''
    line = TRANSLATE(LINEIN(squishcfg))
    /* Found an echo area - process it*/
    if WORD(line, 1) = 'ECHOAREA' then do
      /* Get the name of the echo*/
      EchoName = WORD(line, 2)
      EchoPath = TRANSLATE(WORD(line, 3))
      /* Look for a network address*/
      line = SUBWORD(line, 4)
      netpos = POS('-P', line)
      if netpos > 0 then do
        netaddr = SUBSTR(line, netpos)
        semip = POS(':', netaddr)
        if semip > 0 then
          netaddr = SUBSTR(netaddr, semip + 1)
        perp = POS('/', netaddr)
        if perp > 0 then
          netaddr = DELSTR(netaddr, perp)
        else do
          perp = POS(' ', netaddr)
          if perp > 0 then
            netaddr = DELSTR(netaddr, perp)
        end
        if POS(netaddr, descfile) = 0 then do
          descfile = Drive'\'CmdPath'\N'netaddr'.LST'
          found = isthere(descfile)
          if found then
            maxdfile = Drive'\'CmdPath'\M'netaddr'.LST'
        end
        if found then do
          do until LINES(descfile) = 0
            dline = linein(descfile)
            if TRANSLATE(WORD(dline, 1)) = EchoName then do
              /* Get the description*/
              descline = TRANSLATE(SUBWORD(dline, 2), "'", '"')
              /* Create file for MsgArea.ctl descriptions*/
              file = LINEOUT(maxdfile, LEFT(EchoPath, 24)' 'descline)
              file = STREAM(maxdfile, c, close)
              leave
            end
          end
          file = STREAM(descfile, c, close)
        end
      end
      if descline = '' then
        descline = EchoName
      file = LINEOUT(sqafixwrk, 'EchoArea 'LEFT(EchoName, 16)' 'class'   "'descline'"')
say EchoName'---'descline
    end
    else
    /* Change class*/
    if WORD(line, 1) = ';START' then
      class = WORD(line, 2)
  end
  file = STREAM(squishcfg, c, close)
end
sqacfg = Drive'\'SqPath'\'SqFixFile
do until LINES(sqacfg) = 0
  line = linein(sqacfg)
  /* Ignore previous definitions*/
  if TRANSLATE(WORD(line, 1)) <> 'ECHOAREA' then
    file = LINEOUT(sqafixwrk, line)
end
file = STREAM(sqacfg, c, close)
file = STREAM(sqafixwrk, c, close)
perp = LASTPOS('\', sqacfg)
if perp > 0 then
  'copy 'sqafixwrk' 'DELSTR(sqacfg, perp)
else
  'copy 'sqafixwrk' 'sqacfg
'erase 'sqafixwrk' /n'
return

Prettyfl:

if debug then say 'Prettyfl ------>'
/* Use the filearea.ctl from max to determine the file areas available*/
Files.0 = 0
Call GetFileAreas

/* Files exist - Sort Them*/
if List.0 > 0 then do
  wordptr = 2
  Call SortList
  do i = 0 to List.0
    Files.i = List.i
  end
  Drop(List.)
  /* Process each Files.bbs file area*/  
  do i = 1 to Files.0
    if isthere(Files.i) then do
      List.0 = 0
      inx = 0
      filesbbs = Files.i
      line = LINEIN(filesbbs)
      headercnt = 0

      /* Get all files listed into an array*/
      do until LINES(filesbbs) = 0
        /* Remove Tabs*/
        tabpos = POS(tab, line)
        do while tabpos > 0
          line = OVERLAY(' ', line, tabpos)
          tabpos = POS(tab, line)
        end
        firstword = WORD(line, 1)
        /* Is this line a File Line*/
        if firstword  <> '*' & POS('.',firstword) > 0 & POS(firstword, line) = 1 then do
          inx = inx + 1
          List.inx = firstword
        end
        else
          if inx = 0 then
            /* Remember the header*/
            headercnt = headercnt + 1
        line = LINEIN(filesbbs)
      end
      List.0 = inx
      /* Sort Names of Files.bbs*/
      if List.0 > 0 then do
        wordptr = 1
        Call SortList
        do j = 0 to List.0
          FileName.j = List.j
        end
        Drop(List.)
        /* We should be sorted - Now Build new Files.bbs*/
        /* Get rid of the temporary work file*/
        if isthere(workbbs) then
          'ERASE 'workbbs' /n'
        /* Starting with the Header*/
        if headercnt > 0 then do
          do j = 1 to headercnt
            line = LINEIN(filesbbs)
            file = LINEOUT(workbbs)
          end
        end
        firstname = ''
        do j = 1 to FileName.0
          line = LINEIN(filesbbs)
          file = LINEOUT(filesbbs)
          if firstname <> FileName.j then do
            firstname = FileName.j
            line = LINEIN(filesbbs)
            do while POS(firstname, line) <> 1 & LINES(filesbbs) <> 0
              /* Find the file description lines*/
              line = LINEIN(filesbbs)
            end
            descnt = 0
            if LINES(filesbbs) <> 0 then
              descnt = WORDS(line) - 1
            /* Description is available*/
            if descnt > 0 then do
              descline = SUBWORD(line, 2, descnt)
              /* If the length is this then merge last word*/
              catlen = 61
              newfile = 0
              do until LINES(filesbbs) = 0 | newfile = 1
                /* Is this line a File Line*/
                /* Build Description String*/
                lenstr = LENGTH(line)
                line = LINEIN(filesbbs)
                if LINES(filesbbs) <> 0 then do
                  firstword = WORD(line, 1)
                  if POS('.',firstword) = 0 | POS(firstword, line) <> 1 then do
                    /* Get how many words in the description*/
                    descnt = WORDS(line)
                    if lenstr >= catlen then
                      descline = descline||STRIP(TRANSLATE(SUBWORD(line, 1, descnt),' ','	'))
                    else
                      descline = descline' 'STRIP(TRANSLATE(SUBWORD(line, 1, descnt),' ','	'))
                    catlen = 84
                  end
                  else
                    newfile = 1
                end
              end
            end
            else
              descline = 'No Description...'
            file = LINEOUT(filesbbs)
            /* Now for the files lines*/
            if LENGTH(descline) > 46 then do
              xline = LEFT(FileName.j, 12)
              inx = 1
              wordtext = STRIP(WORD(descline, inx))
              lentext = 60
              /* Strip off the words until no more left*/
              do while wordtext <> ''
                wordlen = LENGTH(wordtext) + 1
                if LENGTH(xline) + wordlen > lentext then do
                  file = LINEOUT(workbbs, xline)
                  lentext = 78
                  xline = LEFT(' ',20)
                end
                xline = xline' 'wordtext
                inx = inx + 1
                wordtext = STRIP(WORD(descline, inx))
              end
              if LENGTH(xline) > 12 then
                file = LINEOUT(workbbs, xline)
            end
            else do
              file = LINEOUT(workbbs, LEFT(FileName.j, 13)||descline)
            end
          end
          line = LINEIN(filesbbs)
        end
        Drop(FileName.)
      end
      subdir = FILESPEC('DRIVE',filesbbs)||FILESPEC('PATH',filesbbs)
      if isthere(subdir'files.bak') then
        'ERASE 'subdir'files.bak /n'
      file = LINEOUT(filesbbs)
      'RENAME 'subdir'files.bbs files.bak'
      line = LINEOUT(workbbs)
      'COPY 'workbbs' 'subdir'files.bbs'
      'ERASE 'workbbs' /n'
    end
  end
  Drop(Files.)
end
Drop(List.)
return
SortList:
inx = List.0
split = TRUNC(inx / 2)
do while split > 0
  a = inx - split
  b = 1
  do while a >= b
    lptr = b
    do while lptr > 0
      hptr = lptr + split
      if WORD(List.lptr,wordptr) > WORD(List.hptr,wordptr) then do
        /* use xx as this variable is near top of stack (push pull too messy)*/
        xx = List.lptr
        List.lptr = List.hptr
        List.hptr = xx
        lptr = lptr - split
      end
      else
        lptr = 0
    end
    b = b + 1
  end
  split = TRUNC(split / 2)
end
List.0 = inx
return

/* Check that a node is not crashed then set to crash*/
POLLCRASH:

/* extract zone:net/sysid*/
xx = POS(':', node)
if xx > 0 then
  zone  = DELSTR(node, xx)
else
  zone = zonedef
yy    = POS('/', node)
if yy > 0 then do
  netid = SUBSTR(DELSTR(node, yy), xx + 1)
  sysid = SUBSTR(node, yy + 1)
end
else do
  netid = netdef
  sysid = node
end
outbound = ''
do i = 1 to net
  if zone = zone.i then do
    /* outbound for 40:6496/0 would be D:\IBMNET.028*/
    outbound = outbound.i'.'D2X(zone,3)
  end
end
if outbound = '' then do
  say 'Zone 'zone' is not in Squish.cfg'
  signal EXIT
end
/* Bink packets are 19600000.xLO*/
pollid = D2X(netid, 4)||D2X(sysid, 4)

LineMsg = TIME('N')' - node - 'node' -> Set to Crash...'
Call DispLine port

/* Check if a file is there to go out*/
/* Change to the directory*/
FILESPEC('DRIVE', outbound)
perp = POS('\',outbound)
if perp = 0 then do
  outbound = '\'outbound
  perp = 1
end
'cd'SUBSTR(outbound, perp)
/* See if any files are ready to go out*/
'dir /f 'pollid'.h* > poll.txt'
if isthere('poll.txt') then do
  /* Setup for transmission*/
  'rename 'pollid'.h* 'pollid'.c*'
  'erase poll.txt /n'
end
else do
  Drive
  'cd\'SqPath
  'squishp poll 'node' crash'
end
return

/* Poll a file from a node */
PollFile:

if debug then say 'PollFile ------>'
LineMsg = TIME('N')'Getting file 'rest' from node - 'node'...'
Call DispLine port

Drive
'cd\'SqPath
'squishp get 'rest' from 'node' crash'
return


/* Select Window of line to be displayed*/
DispLine:
  linex = ARG(1)

/* If this is the first time the line is used then create the window*/
if win.linex = 'WIN.'linex then
  Call createwindow
xx = RXQUEUE("Set", win.linex)
queue LineMsg
xx = RXQUEUE("Set", xx)
file = LINEOUT(logfile, LineMsg)
file = LINEOUT(logfile)
return

createwindow:

  win.linex = 'WIN'linex
  w = RXQUEUE('Create',win.linex)
  /* if queue is there then ignore*/
  if w <> win.linex then
    w = RXQUEUE("Delete",w)
  Drive
  'cd\'CmdPath
  /* Our new command file will be created - linex = 1 - z*/
  comwin = Drive'\'CmdPath'\win'linex'.cmd'
  if isthere(comwin) then
    'erase 'comwin' /n'
  /* Now get the standard file and create a command file*/
  do until LINES(window) = 0
    xx = LINEIN(window)
    yy = POS(' winx ', xx)
    if yy > 0 then
      xx = OVERLAY(' win'linex, xx, yy, 5)
    file = LINEOUT(comwin, xx)
  end
  file = STREAM(comwin, c, close)
  file = STREAM(window, c, close)

  /* And start up the command file that was created*/
  /* It will suck in the queue lines and display them*/
  'start /win win'linex'.cmd'
  Call syssleep 5
  wincnt = wincnt + 1
  winqueue.wincnt = win.linex
  xx = RXQUEUE("Set", win.linex)
  queue 'Date - 'DATE()'  Time - 'TIME()
  xx = RXQUEUE("Set", xx)
return

/* Setup Variables*/
SetVar:
/* Setup Log Windows*/
/* The count wil increase as lines are added*/
/* This is the standard window command file which is used*/
/* Queues are created as needed from win1 - winz (4 length only)*/
/* If you have more then 128 lines then your outa luck*/
wincnt = 0

/* Temporary storage fast access variable(top of variable stack)*/
xx  = 0
No  = 0
Yes = 1
c = 'C'
close = 'CLOSE'

/* Files received without tic*/
filetrap = 0
actntrap = 0
AliasMsg = 0
IgnoreMsg = 0
NodeMsg = 0
AliasFle = 0
IgnoreFle = 0
NodeFle = 0
/* Set for unknown file areas*/
Area.0 = 0


/* Flag to run FBP*/
dofilepost = No
errorcnt    = 10 /* Ten and goodbye olay!*/
maxchrs = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ0'
debug = 0

/* Environment Definition*/
defile = 'control.cfg'

/* Default Values*/
zonedef    =  1
netdef     =  999
Drive      =  'C:'
Mail       =  'C:'
Files      =  'C:'
Messages   =  'C:'
Log        =  'C:'
Nodelist   =  'C:'

SquishFile =  'squish.cfg'
FreqFile   =  'freq.req'
SqFixFile  =  'sqafix.cfg'

keepfiles  = '.DAT.BBS.DMP.IDX' 
deletesize = 7000000
FreeSpace  = 1
TossSpace  = 600000
TossDelsz  = 300000
AgeMsg     = 7

do until LINES(defile) = 0
  line = LINEIN(defile)
  var = WORD(line, 1)
  if LENGTH(var) > 1 then do
    var = TRANSLATE(var)
    value = TRANSLATE(WORD(line, 2))
    select
    when var = 'DRIVE'    then Drive    = value
    when var = 'MAIL'     then Mail     = value
    when var = 'FILES'    then Files    = value
    when var = 'MESSAGES' then Messages = value
    when var = 'LOG'      then Log      = value
    when var = 'NODELIST' then Nodelist = value
    when var = 'INMAIL'   then InMail   = value
    when var = 'SQPATH'   then SqPath   = value
    when var = 'CMDPATH'  then CmdPath  = value
    when var = 'FILEPATH' then Filepath = value
    when var = 'ULOADPATH' then UloadPath = value
    when var = 'FREQPATH' then FreqPath = value
    when var = 'MESSPATH' then Messpath = value
    when var = 'LOGPATH'  then Logpath  = value
    when var = 'MAXPATH'  then MaxPath  = value
    when var = 'DESKPATH' then DeskPath = value
    when var = 'TEMPPATH' then TempPath = value
    when var = 'NODELISTPATH' then Nodelistpath = value
    when var = 'TICKPATH'   then TickPath   = value
    when var = 'AGEMSG'     then AgeMsg     = value
    when var = 'MSGWAIT'    then MsgWait    = value
    when var = 'SQUISHFILE' then SquishFile = value
    when var = 'FREQFILE'   then FreqFile   = value
    when var = 'SQFIXFILE'  then SqFixFile  = value
    when var = 'TRIMLIKE'   then TrimLike   = value
    when var = 'SQPACKFILE' then SqPackFile = value
    when var = 'SQUISHWRK'  then SquishWrk  = value
    when var = 'TEMPMAXM'   then TempMaxM   = value
    when var = 'TEMPMAXF'   then TempMaxF   = value
    when var = 'TEMPTIC'    then TempTic    = value
    when var = 'FANAREA'    then FanArea    = value
    when var = 'MSGAREA'    then MsgArea    = value
    when var = 'REQAREA'    then ReqArea    = value
    when var = 'FANTMP'     then FanTmp     = value
    when var = 'MSGTMP'     then MsgTmp     = value
    when var = 'REQTMP'     then ReqTmp     = value
    when var = 'FANBASE'    then FanBase    = value
    when var = 'MSGBASE'    then MsgBase    = value
    when var = 'AVAIL'      then Avail      = value
    when var = 'FBPREQ'     then FBPReq     = value
    when var = 'ERRORFILE'  then errorfile  = value
    when var = 'LOGFILE'    then logfile   = value
    when var = 'NODEPROCESSOR' then nodeprocessor = value
    when var = 'KEEPFILES'  then keepfiles  = value
    when var = 'DELETESIZE' then deletesize = value
    when var = 'FREESPACE'  then FreeSpace  = value
    when var = 'TOSSSPACE'  then TossSpace  = value
    when var = 'TOSSDELSZ'  then TossDelsz  = value
    when var = 'ZONEDEF'    then zonedef    = value
    when var = 'NETDEF'     then netdef     = value
    when var = 'BBSNAME'    then bbsName    = SUBWORD(line, 2)
    when var = 'INDENT'     then indent     = STRIP(SUBWORD(line, 2),, "'")
    when var = 'TYPE'       then Type       = STRIP(SUBWORD(line, 2),, "'")
    when var = 'PUBLIC'     then Public     = STRIP(SUBWORD(line, 2),, "'")
    when var = 'ENDAREA'    then EndArea    = SUBWORD(line, 2)
    when var = 'OUTBOUND'   then Outbound   = value

    when var = 'MSGALIAS'   then do
      AliasMsg = AliasMsg + 1
      MsgAlias.AliasMsg = value
    end

    when var = 'MSGIGNORE'   then do
      IgnoreMsg = IgnoreMsg + 1
      MsgIgnore.IgnoreMsg = value
    end

    when var = 'MSGNODE'   then do
      NodeMsg = NodeMsg + 1
      MsgNode.NodeMsg = value
      MsgPass.NodeMsg = WORD(line, 3)
      MsgClas.NodeMsg = WORD(line, 4)
    end

    when var = 'FLEALIAS'   then do
      AliasFle = AliasFle + 1
      FleAlias.AliasFle = value
    end

    when var = 'FLEIGNORE'   then do
      IgnoreFle = IgnoreFle + 1
      FleIgnore.IgnoreFle = value
    end

    when var = 'FLENODE'   then do
      NodeFle = NodeFle + 1
      FleNode.NodeFle = value
      FlePass.NodeFle = WORD(line, 3)
      FleClas.NodeFle = WORD(line, 4)
    end

    when var = 'TRAPFILE'   then do
      filetrap = filetrap + 1
      trapfile.filetrap = value
      trapactn.filetrap = ''
    end
    when var = 'TRAPACTN'   then do
      actntrap = actntrap + 1
      trapactn.actntrap = SUBWORD(line, 2)
    end
    otherwise
    end
  end
end
file = STREAM(defile, c, close)

SquishTmp   =  Drive'\'TempPath'\'SquishFile
sqafixwrk   =  Drive'\'TempPath'\'SqFixFile
FreqFile    = Drive'\'SqPath'\'FreqFile
SquishWrk   = Drive'\'TempPath'\'SquishWrk
FreqWork    = Drive'\'TempPath'\'FreqFile
FanTmp      = Drive'\'TempPath'\'FanTmp
MsgTmp      = Drive'\'TempPath'\'MsgTmp
TempMaxW    = Drive'\'TempPath'\'TempMaxM
TempMaxM    = Drive'\'DeskPath'\'TempMaxM
TempMaxF    = Drive'\'DeskPath'\'TempMaxF
TempTic     = Drive'\'DeskPath'\'TempTic
FanArea     = Drive'\'DeskPath'\'FanArea
MsgArea     = Drive'\'DeskPath'\'MsgArea
Uload       = Files'\'FilePath'\'Uloadpath
TicWork     = Drive'\'TempPath
filesbbs    = Drive'\'MaxPath'\filearea.ctl'
workbbs     = Drive'\'TempPath'\files.bbs'
logfile     = Log'\'Logpath'\'logfile
/* Where the squish.cfg file is located*/
squishcfg   = Drive'\'SqPath'\'SquishFile
/* Get the Tick Config File Name*/
tickcfg = Drive'\'TickPath'\tic.cfg'


/* Error Recording*/
errorfile   = Drive'\'DeskPath'\'errorfile

clen = 4 /* To check Revs make this 3 or 4 - it just lists without deleteing*/
window = Drive'\'CmdPath'\win.cmd'

/* Character to divide zone for net determination*/
semicolon = ':'

/* Setup system functions*/
Call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
Call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
Call RxFuncAdd 'SysFileSearch','RexxUtil','SysFileSearch'
Call RxFuncAdd 'SysDriveInfo','RexxUtil','SysDriveInfo'
Outbound = Mail'\'Outbound

/* A list of nets that this Mailer belongs*/
net = 0

LF   = X2C('0D')
SOH  = X2C('01')
NULL = X2C('00')
line = ''
keyorig  = ';ORIGIN' /* Precedes Address for each net as [Fido F F] to Max access level*/
keyaddr  = 'ADDRESS'
keybad   = 'BADAREA'
origdesc = 'Origin'
accessde = 'Normal'
if isthere(logfile) = 0 then do
  say "First time use - removing Tab's from .cfg, .ctl, .bbs files"
  say 'as rexx does not like these little puppies in the lines...'
  say 'Press enter to continue ->'
  pull xxx
  tab = '	'
  if isthere(SquishTmp) then
    'erase 'SquishTmp' /n'
  do i = 1 to 5
    select
      when i = 1 then
        tabfile = filesbbs /* filearea.ctl*/
      when i = 2 then
        tabfile = Drive'\'MaxPath'\msgarea.ctl'
      when i = 3 then
        tabfile = tickcfg
      when i = 4 then
        tabfile = squishcfg
      when i = 5 then
        tabfile = Drive'\'SqPath'\'sqafix.cfg
      otherwise
    end
    if isthere(tabfile) then do
      say 'Removing tabs from 'tabfile' file...'
      do until LINES(tabfile) = 0
        line = LINEIN(tabfile)
        tabpos = POS(tab, line)
        do while tabpos > 0
          line = OVERLAY(' ', line, tabpos)
          tabpos = POS(tab, line)
        end
        file = LINEOUT(SquishTmp, line)
      end
      file = LINEOUT(SquishTmp)
      file = LINEOUT(tabfile)
      FileName = FILESPEC('NAME', tabfile)
      FileBack = Drive'\'TempPath'\'DELSTR(FileName, POS('.', FileName))'.bak'
      'copy 'tabfile' 'FileBack
      'copy 'SquishTmp' 'tabfile
      'erase 'SquishTmp' /n'
    end
    else do
      say 'Missing or Bad path to 'tabfile
      signal exit
    end
  end
end

return

/* Set up net variables*/
SetSys:
do until LINES(squishcfg) = 0
  preline = line
  line = LINEIN(squishcfg)
  name = TRANSLATE(WORD(line, 1))
  /* Look for the Address keyword*/
  if name = keyaddr && POS(keyaddr, line) = 1 then do
    /* format [line] Address [Address]*/
    address = WORD(line, 2)
    if net = 0 then do
      net = net + 1
      net.net  = '-P'address
      semip = POS(':',address)
      if semip > 0 then
        zone.net = DELSTR(address, semip)
      else
        zone.net = zonedef
      /* Add origin and access*/
      NewZone = Yes
    end
    else do
      /* Check if we have this zone covered*/
      NewZone = Yes
      semip = POS(':',address)
      if semip > 0 then
        zone = DELSTR(address, semip)
      else
        zone.net = zonedef
      do j = 1 to net
        if zone.j = zone then
          NewZone = No
      end
      /* Add in the new zone*/
      if NewZone then do
        net = net + 1
        net.net  = '-P'address
        zone.net = zone
      end
    end
    if NewZone then do
      if TRANSLATE(WORD(preline, 1)) = keyorig then do
        origin.net = origdesc'  'net-1'     'SUBWORD(preline, 2, 2)
        access.net = accessde'/'WORD(preline, 4)
      end
      else do
        /* Default if the comment line [;Origin Fido F F ] does not exist*/
        origin.net = origdesc'  'net-1'     Fido F'
        access.net = accessde'/F'
      end
    end
  end
  else do
    /* Look for Bad Message Area*/
    if name = keybad && POS(keybad, line) = 1 then do
      BadArea = TRANSLATE(WORD(line, 3))
      say 'Bad Areas for new message bases = 'BadArea
    end
  end
end
file = STREAM(squishcfg, c, close)
/* Find the Outbound Areas*/
Call SysFileSearch 'Outbound', squishcfg, 'List.', 'N'

/* The first outbound is always declared*/
outbound.1 = WORD(List.1, 3)
if net > 1 then do
  do i = 2 to List.0
    zone = WORD(List.i, 4)

    /* Match zones*/
    do j = 2 to net until zone.j = zone
      if zone.j = zone then
        /* Extract the outbound directory*/
        outbound.j = WORD(List.i, 3)
    end
  end
end
Drop(List.)
do i = 1 to net
  say 'Zone   = 'zone.i' ID = 'net.i' Outbound = 'outbound.i
  say 'Origin = 'origin.i' Access = 'access.i
end

/* We now have net - net.net for our address as -pxx:yyy/z - zone.net - outbound.net*/
return

/* Queue setup*/
SetQueue:
/* Go reclaim Host Queue*/
CntlQueue = 'Cntl'
CntlQueue = RXQUEUE("Create",CntlQueue)

/* REXX will name queue to another name - otherwise it exists*/
if CntlQueue <> 'Cntl' then do
  /* Queue already exists - send restart command*/
  /* Point to live queue */
  oq = RXQUEUE('Set', 'Cntl')

  /* Check that it is still alive*/
  QUEUE 'HELLO 'CntlQueue

  /* and pull acknowledgement*/
  xx = RXQUEUE('Set',CntlQueue)
  ACK = ''

  /* Wait for an hour to ack*/
  do i = 1 to 12 until ACK <> ''
    if QUEUED() > 0 then
      PULL ACK
    Call syssleep 3
  end

  if ACK = 'OK' then do
    signal END
  end
  else do
    CntlQueue = 'Cntl'
    oq = RXQUEUE('Set',CntlQueue)
  end
end

return

/* Cleanup Flags and Mail*/
SetMail:
  Call SysFileTree Mail'\*.bsy', 'List', 'SFO'
  /* Files exist - Process them*/
  Do i = 1 to List.0
    'erase 'List.i' /n'
  end
  Drop(List.)

  /* Check for unfinished mail*/
  Call SysFileTree Drive'\'SqPath'\*.pkt', 'List', 'SFO'
  /* Files exist - Process them*/
  if List.0 > 0 then do
  /*Rem If Mail Toss It.*/
    /* But first check if there is free space*/
    tempfree = FreeSpace
    FreeSpace = TossSpace
    Call ChkFree
    if FreeLeft >= FreeSpace then do
      Drive
      'cd\'SqPath
      'squishp in out squash link'
    end
    FreeSpace = tempfree
  end
  Drop(List.)
return

/* Called when a cmd function does not complete successfully*/
RECSCREEN:

/* Ten changes to get it right then we are outa here*/
errorcnt = errorcnt - 1
if errorcnt <= 0 then
  signal exit
/* Read the screen with the error on it*/

Call RxFuncAdd 'SysTextScreenRead','RexxUtil','SysTextScreenRead'
do iii = 1 to 24 /* Change for a larger screen*/
  line = SysTextScreenRead(iii,0,80)
  file = LINEOUT(errorfile, line)
end
/* The close*/
file = STREAM(errorfile, c, close)
Call RxFuncDrop 'SysTextScreenRead'
say 'This cat has 'errorcnt' lives!'
/* next time we will catch it*/
return
