/*--------------------------------------------------------------------------*/
/*           Exception Handling REXX Script for AdeptXBBS 1.0               */
/*                        >> PRELIMINARY <<                                 */
/*                  Distributed with CML-Data.Zip                           */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Purpose:  Exception.Cmd is run by AdeptXBBS whenever an exception        */
/*           is encountered in the software.  This REXX script asks         */
/*           the user what s/he was doing at the time of the exception      */
/*           and logs it in Linex.Log for later reference for the sysop.    */
/*           This also helps you furnish vital information to AdeptSoft     */
/*           Quality Control which enables them to to fix the bug, and/or   */
/*           help you to allieviate the problem.                            */
/*                                                                          */  
/* Author:   Matt Davis - 1:3666/107.0@Fidonet  - 7:7/10.0@Alternet         */
/*                        40:4379/110.0@IBMnet  - 11:145/102.0@Illunet      */
/*                        81:140/6.0@OS2net     - 205:205/0.0@Ekonet        */
/*                        54:704/0.0@Teknonet                               */
/*                                                                          */
/* Home BBS: The Computerman's Lair/2 (CML)                                 */
/*           Hickory,  North Carolina (USA)                                 */
/*           (704) 324-9949           (Sprint)                              */
/*                                                                          */  
/* Version:  1                                                              */
/* Revision: 0                                                              */
/* Date: 4/29/95                                                            */
/*__________________________________________________________________________*/

ARG line

  AdeptPrint(line,'{CS\r\n')
  AdeptPrint(line,'{FDERROR!  ERROR!  {FGAdeptXBBS has detected an EXCEPTION!\r\n')
  AdeptPrint(line,'{F9(Recovery Successful - exception area logged)\r\n\n\n')
  AdeptPrint(line,'{F4 Hello, {U0.\r\n\n')
  AdeptPrint(line,'{F3AdeptXBBS has logged an exception, which is a fault in the software.  Now,\r\n')
  AdeptPrint(line,'{F3do not panic, you are okay and Adept recovered just fine.  However, AdeptSoft\r\n')
  AdeptPrint(line,'{F3needs to be alerted about this problem, and also needs detailed information\r\n')
  AdeptPrint(line,'{F3so that they can duplicate, and fix it.  Here is where you come in!\r\n\n')
  AdeptPrint(line,'{F4Since the sysop does not see every error which occurs here, I am going to ask\r\n')
  AdeptPrint(line,'{F4you what you were doing when the error happened, and put it in the logs for\r\n')
  AdeptPrint(line,'{F4him or her to see. \r\n\n\n')
  AdeptHitReturn(line)

SetupText:  
  AdeptPrint(line,'{CS\r\n\n')
  AdeptPrint(line,'{F8(You will have three lines to write.  Press [ENTER] at the end of each.)\r\n')
  AdeptPrint(line,'{F9:\r\n')
  AdeptPrint(line,'{F9:\r\n')
  AdeptPrint(line,'{F9:\r\n')

Snatchnfo:
  option = AdeptInput(line,1,78,,,'[4;2H{F4',,,)
           IF option = '' THEN 
              CALL UserRef
           ELSE DO 
              AdeptLog(line,1,'WHY: 'option'')  
  option = AdeptInput(line,1,78,,,'[5;2H{F4',,,)
           IF option = '' THEN 
              CALL PreEmail
           ELSE DO 
              AdeptLog(line,1,'WHY: 'option'')  
  option = AdeptInput(line,1,78,,,'[6;2H{F4',,,)
           IF option = '' THEN
              CALL PreMail
           ELSE DO
              AdeptLog(line,1,'WHY: 'option'')  
              CALL PreEMail
  END

UserRef:
  AdeptPrint(line,'[1;1H{FD Come on, I need your help!  Please tell me what you were doing when the\r\n')
  AdeptPrint(line,' exception occured![4;2H')
  CALL Snatchnfo
 END

PreEmail:
  AdeptPrint(line,'{CS\r\n')
  AdeptPrint(line,'{F3I am going to let you leave some E-Mail to tell the sysop an exception\r\n')
  AdeptPrint(line,'{F3occured in case s/he is not one to read the logs regularly.\r\n\n')
  AdeptHitReturn(line)

SendMail:
  AdeptMenuType(line, 201 ,"Sysop;EXCEPTION!!! on {D7;1;1,0")

DaEnd:
  AdeptPrint(line,'{CS\r\n')
  AdeptPrint(line,'{F3Thanks for helping us out over here!  I am sure the sysop, and AdeptSoft\r\n')
  AdeptPrint(line,'{F3appreciate you taking the time to give us the information to fix this\r\n')
  AdeptPrint(line,'{F3problem you encountered!!\r\n\n')
  AdeptHitReturn(line)
EXIT
