/*  REXX program to allow sysops to rotate CD-ROMS on their MAXIMUS BBS  */
/*  Requires: VREXX (available on most OS/2 BBSs)      
                   A CD-ROM in designated drives 
                         - (doesn't have to be the correct one)
		     

	I wrote this program to make it easier for me to rotate my cd-roms on
	my BBS, as I have more cd-roms than drives. Since I figured other sysops
	were facing the same problem, I have made some changes to allow you 
	to configure it for your settup. Some things are mandatory though. 
	This program assumes that there is a "filearea.ctl" for each cd-rom
	called driveX.ctl, where X is the drive the cd-rom will be in. (eg. driveD.ctl)
	I set it up this way because I wanted the ability to put any cd-rom in any
	drive without going and changing the DOWNLOAD drive designations in all 
	the .CTL files. If you don't want to do it this way, feel free to change the 
	program to suit your needs, although I should warn you that this was my 
	first attempt at writing a REXX program and you may not be able to follow
	the wierd things I have done. Don't let my previous sentence scare you from
	using this program though. I did extensive testing and it works great, on
	MY system. In other words, you USE THIS PROGRAM AT YOUR OWN RISK! I AM 
           NOT RESPONSIBLE FOR ANY PROBLEMS AND/OR DAMAGE TO YOUR SYSTEM!
*/
/* -----------------------------------------------------------------------*/

/*---------------------CONFIGURATION AREA-------------------------------*/

/*  Your MAXIMUS path, directory and filearea.ctl  */
areafile = 'C:\MAX\FILEAREA.CTL'             

/*   Your MAXIMUS path, directory and filearea.ctl FOR YOUR HARD DRIVE AREAS */
hdd = 'C:\MAX\FILEAREA.HDD'

/*------------DESIGNATE NAME OF CD-ROM AND ENTIRE PATH OF -----------------
   ------------THE CD-ROM AREA CONTROL FILE----------------------------------*/

cd_rom.0 = 7                                   /*  Enter the total number of CD-ROMS here  */
cd_rom.1 = "Swine Review 93"
cd_rom.1.path = 'C:\MAX\SW93\'            /* TRAILING BACKSLASH MUST BE INCLUDED */
cd_rom.2 = "Secrets of the Universe"
cd_rom.2.path = 'C:\MAX\CRAP\'            /* These paths are NOT checked, so if a */
cd_rom.3 = "10001 Recipes for Snake"    /* certain cd-rom does not show up in */
cd_rom.3.path = 'C:\MAX\SNAKE\'           /* the final 'filearea.ctl', then the path */
cd_rom.4 = "Neurotic Encounters"          /* is wrong                                       */
cd_rom.4.path = 'C:\MAX\LOONEY\'
cd_rom.5 = "Swine Reference Library"
cd_rom.5.path = 'C:\MAX\SWINE\'
cd_rom.6 = "Hobbes OS/2"
cd_rom.6.path = 'C:\MAX\HOBBES1\'
cd_rom.7 = "Monster Disk #2"
cd_rom.7.path = 'C:\MAX\MONSTER1\'


/*-----DESIGNATE WHICH DRIVES ARE CD-ROMS------------*/

drive.0 = 3                   /* Enter total number of drives here */
drive.1 = "E"                /* Enter drive letters like this  */
drive.2 = "F"
drive.3 = "G"
/*drive.4 = "H"
   drive.5 = "I"
   drive.6 = "J" */

/*-------------------END OF CONFIGURATION AREA---------------------------*/







/*---------------------BEGINNING OF PROGRAM-------------------------------*/

/* initialize VREXX */

   call RxFuncAdd 'VInit','VREXX','VINIT'
   initcode = VInit()
    if initcode = "ERROR" then signal CLEANUP

    signal on failure name CLEANUP
    signal on halt name CLEANUP
    signal on syntax name CLEANUP

/* initialize REXX functions */

   call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
   call SysLoadFuncs




/* check to see if the designated drives are cd-roms  */
   Do i = 1 to drive.0
     driveinfo = SysDriveInfo(drive.i)
     drivespace = subword(driveinfo, 2 ,1)
     if drivespace <> 0 then signal nocd
   end

/* position of info window */
   pos.left = 25
   pos.bottom = 25
   pos.right = 75
   pos.top = 75


/* create the intro window */
   new_id = VOpenWindow(' ',white,pos)

/* Set font and color */
   call VSetFont ' ','TIMEB',55
   call VForeColor ' ',BLUE
   call VSay " ",180,800,'ChangeCD'
   call VSetFont ' ','TIME',15
   call VForeColor ' ',BLACK
   call VSay " ",315,600,'By ROGER DEMPSEY'
   call VSetFont ' ','TIME',15
   call VForeColor ' ',PINK
   call VSay " ",290,500,'BANANA REPUBLIC BBS'
   call VSetFont ' ','TIME',15
   call VForeColor ' ',BLACK
   call VSay " " ,275,450,'New Westminster, BC, Canada'
   call VSay " " ,390,400,'(604) 524-6990'
   call SysSleep 5 
   call VCloseWindow (' ')


/* position of info window  (adjust for number of drives) */
   pos.left = 2
   pos.bottom = 43 + drive.0
   pos.right = 50
   pos.top = 90

/* Set font and color */
   new_id = VOpenWindow('ChangeCD',white,pos)
   call VSetFont 'ChangeCD','TIME',15
   call VForeColor 'ChangeCD',RED

/* position of radio box  */
   call VDialogPos 64,50

/* loop back if they made a mistake */
oops:

/* find out what cd-rom will be in each drive and display it in info window */
   x= 800
   Do i = 1 to drive.0
     call VRadioBox 'CD-ROM in drive 'drive.i'?',cd_rom,1    
       Do k = 1 to cd_rom.0
         if cd_rom.vstring = cd_rom.k then areapath.i =cd_rom.k.path'drive'drive.i'.ctl'
       end
     call VForeColor 'ChangeCD',BLACK
     call VSay "ChangeCD",100,x,'The CD in drive 'drive.i' is/will be: '
     call VForeColor 'ChangeCD',RED
     call VSay "ChangeCD",560,x,cd_rom.vstring
     x = x - 60
   end

/* double check the info */  
   prompt.0 = 1
   prompt.1 = '       Are these correct?'
   call VDialogPos 60, 50
   button = VMsgBox('ChangeCD', prompt, 6)
   
   if button = 'NO' 
      then call VClearWindow ('ChangeCD')
   if button = "NO"
      then signal oops

/* delete the current filearea.ctl */
   rc = SysFileDelete(areafile)
   if rc <> 0 
        then signal nofile
   call VForeColor 'ChangeCD',PINK
   call VSay "ChangeCD",100,x-60,areafile' has been deleted!'
   call VSay "ChangeCD",100,x-120,'Creating new 'areafile

/* Create the new filearea.ctl */
/* Add the hard drive areas */
   line = lines(hdd)
   Do while line <> 0 
      data = linein(hdd)
      rc = lineout(areafile, data)   
      if rc <> 0 then signal cleanup
      line = lines(hdd)
   end

/* now add the cd-rom areas */   
   Do i = 1 to drive.0
      line = lines(areapath.i)
      Do while line <> 0 
         data = linein(areapath.i)
         rc = lineout(areafile, data)
          if rc <> 0 then signal cleanup
         line = lines(areapath.i)
      end
   end

/* let them know how it went  */
   call VSay "ChangeCD",100,x-180, 'New 'areafile 'has been created'
   call VForeColor 'ChangeCD',BLUE
   call VSay "ChangeCD",100,x-240, 'Install the cd-roms and run'
   call VSay "ChangeCD",100,x-300, '      SILTP MAX'
   call VSay "ChangeCD",100,x-360, 'to initialize these changes.'

/* prompt to end program */
   prompt.0 = 1
   prompt.1 = ' '
   call VDialogPos 60, 50
   button = VMsgBox('ChangeCD', prompt, 1)
   



/* if there was a problem or the program is done then come here */
   CLEANUP:
	call VExit

    exit



/* one of the designated drives is not a cd-rom */
   nocd:
   prompt.0 = 3
   prompt.1 = '      Drive 'drive.i 'is not a CD-ROM!'
   prompt.2 = '      Or there is no CD-ROM in that drive!'
   prompt.3 = '      Please check the drives you have designated!'
   call VDialogPos 50,50
   button = VmsgBox('ChangeCD', prompt, 1)
   signal CLEANUP

/* problem with deleteing the filearea.ctl */
   nofile:
   prompt.0 = 2
   if rc = 2 then prompt.1 = '      ChangeCD could not find 'areafile
   if rc = 3 then prompt.1 = '      ChangeCD could not find the path to 'areafile
   if rc = 5 then prompt.1 = '      ChangeCD was denied access to 'areafile
   if rc > 5 then prompt.1 = '      Unknown problem accessing 'areafile
   if rc <= 3 then prompt.2 = '      Please check what you have designated!'
   if rc = 5 then prompt.2 = '       Please check if it is write protected!'
   if rc > 5 then prompt.2 = '       Oh Oh! Tell author rc = 'rc
   call VDialogPos 50,50
   button = VmsgBox(' ', prompt, 1)
   signal CLEANUP
