/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                 This module was written by Bob Hartman                   */
/*                                                                          */
/*                 BinkleyTerm FTSC Mail Session Routines                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int 
Whack_CR ()
{
	long t1, t2;
	unsigned char j;
	char fGotAChar;				/* When set we have gotten at least 1 char */
	char fDoingALine;			/* When set we're in middle of line        */
	char fDidALine;				/* When set we've already gotten 1 CR      */
	int k, l;
	unsigned short i;
	char buf[180];

	t1 = timerset (3000);		/* set 30 second timeout */
	j = CR;
	(void) strcpy (buf, MSG_TXT (M_INTRO));
	l = (int) strlen (buf);
	fGotAChar = fDoingALine = fDidALine = 0;
	k = 2;
	while (!timeup (t1) && CARRIER)	/* till then or CD lost  */
	{
		time_release ();		/*PLF Sun  12-01-1991  05:13:51 */

		/* We send two XON's to try to unstick a V.42 miscue */
		if (k-- > 0)
			SENDBYTE (XON);		/* Unstick other side?   */

		/* Send either the CR or SPACE */
		SENDBYTE (j);

		/* Now switch to either CR or SPACE based on last output */
		j = (unsigned char) (45 - j);

		/* Set a one second timer */
		t2 = timerset (100);

		/* Now read what we get back to see if we get anything useful.
		   But only allow up to that one second to get it. */

		while (!timeup (t2))
		{
			/* Get a character if there is one. Otherwise give up cycles
			   to the system. */

			if ((i = (unsigned short) PEEKBYTE ()) == (unsigned short) -1)
			{
				if (fDidALine)
					break;
				time_release ();
				continue;
			}

			/* If we're doing EMSI, this is the first char and it's
			   an asterisk, exit now without losing it. */

			if (!fDoingALine && !no_EMSI_Session && (i == (unsigned short)'*'))
			{
				if (un_attended && fullscreen)
					clear_filetransfer ();
				return (0);
			}

			/* Eat the character */

			(void) TIMED_READ (0);

			/* If the character is a CR and we got a response, we can leave. */

			if (i == CR && fGotAChar)
			{
				if (fDoingALine && !fDidALine)
				{
					if (un_attended && fullscreen)
					{
						clear_filetransfer ();

						sb_move (filewin, 1, 2);
						sb_puts (filewin, buf);
						sb_show ();
						status_line ("*%s", buf);
					}
					else
					{
						set_xy (NULL);
						scr_printf (buf);
					}
					/* We got what we wanted */
					/* Now try to stop output on an Opus */
					SENDBYTE ('');

				}
				fDoingALine = 0;
				fDidALine = 1;
			}

			/* Otherwise, if it's a printing character, save it for logging. */

			else if (i >= ' ')
			{
				if (fDoingALine || i != ' ')
				{
					fDoingALine = 1;
					if (fDidALine)
						continue;
					buf[l++] = (char) (i & 0xff);
					buf[l] = '\0';
					if (l > (int) SB_COLS - 6)
						l = SB_COLS - 6;
				}

				/* One-shot: reset the 1-second timeout for the first printable
				   character we get. */

				if (!fGotAChar)
				{
					fGotAChar = 1;
					t2 = timerset (100);
				}
			}
		} /* End 1-second inner timer loop */

		if (fDidALine)
		{
			if (un_attended && fullscreen)
				clear_filetransfer ();
			return (0);
		}

		/* Bail out for keyboard escape */

		if (got_ESC ())
		{
			status_line (MSG_TXT (M_CONNECT_ABORTED));
			mdm_hangup ();
			return (-1);
		}

	} /* End 30-second braindead timer loop */

	if (CARRIER)
		status_line (MSG_TXT (M_NOBODY_HOME));
	else
		status_line (MSG_TXT (M_NO_CARRIER));
	return (-1);
}
