/* Yes FOLKS!  This is ReXX ! */

/* This batch file 'cleans' Binkley style outbound,         */
/* removes empty NN.PNT and empty Outbound.ZZZ dirs, where  */
/* ZZZ are any hexadecimal numbers, and NN must be eight    */
/* digit long hexadecimal number.                           */
/*                                                          */
/* Author:                                                  */
/* Radim Kolar             Fidonet: 2:423/66.111            */
/*                         Dark side of Avalon              */
/*                                                          */
/* Errorlevels:                                             */
/*       0 success                                          */
/*       2 home directory doesn't exists                    */
/*       3 out of memory                                    */
/*      10 bad arguments count                              */
/*                                                          */
/* Version 0.30.011 FREEWARE                                */
/*                                                          */
/* Rev. history:                                            */
/*                                                          */
/* 08/08/95        development started                      */
/* 10/08/95        0.10.000 done, first working version     */
/*                 limitations: don't check .PNT dirs for   */
/*                              hexadecimal numbers in name */
/* 17/08/95        0.11.006 done, added help text           */
/* 20/08/95        0.20 done, fixed very stupid bug in      */
/*                 loading and unloading RexxUtil.Dll       */
/*                 0.21   improved Dll (re)loading code     */
/*                 0.30   check *.PNT directories, if dir   */
/*                          name is valid (hexnumbers)      */
/*                        also corrected error, when home   */ 
/*                          dir was root                    */
/*                        improved docs                     */
/*                        Limitations: None                 */
/*  I hope, that this is final version                      */              
          
Version='Version 0.30.011'
Progname='REXX Binkley Outbound cleaner'
Copyright='Copyright (C) Radim Kolar 1995. (Fidonet 2:423/66.111)'
Copyright2='This program is free to use without any modifications only.'

START:
select
  when 0=RXFuncQuery('SysDropFuncs') then udrop=0
  when 0=RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs") then udrop=1
  otherwise
  /* something may be wrong, reload all Package */
  say 'Reloading REXXUtil Package.'
  RXFuncDrop("SysLoadFuncs")
  RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
  call SysLoadFuncs;
  udrop=0
end

if udrop=1 then call SysLoadFuncs

parse upper arg home dname

say Progname
say Version
say Copyright
say Copyright2
say

/* parse test */

if (length(home)=0)|(length(dname)=0)|(POS(' ',dname)>0) then call helptext;
tst=directory(home)
if (length(tst)=0) then do
   say 'Directory: 'home' does not exists.'
   call cleanup 2
   end

/* scan for Outbound.ZZZ and process them */

rc=SysFileTree(dname'*','list','DO')
if rc=2 then do
 say 'Not enough memory'
 call cleanup 3
 end
do i=1 to list.0
  if pos('\',home)=length(home) then
    call BOClean substr(list.i,length(tst)+1,length(list.i)-length(tst))
                                else
    call BOClean substr(list.i,length(tst)+2,length(list.i)-length(tst)-1)

end

/* End of Main part */

say
say 'bclean.cmd' Version 'done.'

call cleanup 0

/* Procedures BEGINS */

helptext: procedure expose udrop
  say 'Bclean.cmd cleans your binkley-style outbound directory tree.'
  say 'Bclean works in 4 steps.'
  say '1) if OUTBOUND.ZZZ has good name (ZZZ=hex number), bclean goes in.'
  say '2) removes all empty AAA.PNT directories.'
  say '   where AAA is 8-digit long hexadecimal number.'
  say '3) repeats steps 1 and 2, until all OUTBOUND.* dirs are checked.'
  say '4) removes all empty OUTBOUND.ZZZ directories, where ZZZ is any hexadecimal'
  say '   number.'
  say
  say 'Bclean.cmd requires two parameters:'
  say 'first parameter is name of ''root'' binkley directory, directory where'
  say '  primary binkley outbound resides in.'
  say '2nd is name of outbound.ZZZ directories (without .ZZZ extension)'
  say 
  say 'Example:'
  say 'Your primary binkley outbound directory is E:\T-MAIL\OUTBOUND'
  say 'then simply run:'
  say '  bclean.cmd e:\t-mail outbound'
  call cleanup 10
return

cleanup: procedure expose udrop
   arg n
   if udrop=1 then call SysDropFuncs
   exit n
return

testname: procedure
   arg name
   a=pos('.',name)
   if a=0 then return 1
   do i=a+1 to length(name)
     if POS(substr(name,i,1),'0123456789ABCDEF')=0 then return 0
   end
return 1

testpnt: procedure
   arg name
   a=pos('.',name)
   if a\=9 then return 0 /* short of long directory name */
   do i=1 to 8
     if POS(substr(name,i,1),'0123456789ABCDEF')=0 then return 0
   end
   call SysRmDir name
return 1


/* if name is Good, Clean it! */
BOClean: procedure
   arg dir
   if testname(dir)=1 then do
                            tmpdir=directory()
                            call directory(dir)
                            tst=directory()
                            say 'Processing 'tst
                            call PNTdel dir,tst
                            call directory(tmpdir)
                            if pos('.',dir)>0 then call SysRmDir dir
                           end

return

/* removes all *.PNT in dir */
PNTdel: procedure
arg dir,tst
 rc=SysFileTree('*.PNT','list','DO')
 if rc=2 then do
   say 'Not enough memory'
   call cleanup 3
 end
do i=1 to list.0
  call testpnt substr(list.i,length(tst)+2,length(list.i)-length(tst)-1) 
end

return