@echo off
REM /////////////////////////////////////////////
REM This is a sample ExtractDIZ.Cmd for AdeptXBBS
REM /////////////////////////////////////////////

REM /////////////////////////////////////////////
REM It will check for a FILE_ID.DIZ in arch.files
REM and extract, rename it, and return to the BBS
REM /////////////////////////////////////////////

REM //////////////////////////////////////////
REM Command line parms are as follows:
REM %1 = Complete filename to work on
REM %2 = Line number
REM %3 = Com port file handle
REM %4 = Just filename (no path, no extension)
REM %5 = Just extension
REM %6 = Just Drive:Path
REM //////////////////////////////////////////

REM /////////////////////////////////////////////
REM 02/15/96
REM Adept now looks for the description to be in
REM the file called: Filename.Ext.Description
REM instead of Filename.Description
REM /////////////////////////////////////////////

CD \Adept\System\Line%2

REM ////////////////////////
REM add more lines for more
REM archive types..
REM ////////////////////////
IF %5==ARC GOTO ARC
IF %5==ARJ GOTO ARJ
IF %5==LZH GOTO LZH
IF %5==RAR GOTO RAR
IF %5==ZIP GOTO ZIP
IF %5==ZOO GOTO ZOO

GOTO End

:ARC
ARC e %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:ARJ
UNARJ E %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:LZH
LH X %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:RAR
RAR e -y %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:ZIP
UNZIP -oC %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:ZOO
ZOO -extract %1 FILE_ID.DIZ
IF EXIST FILE_ID.DIZ REN FILE_ID.DIZ %4.%5.Description
   ELSE GOTO NONE
CD \Adept

:NONE
CD \Adept

:End
