/* REXX program to convert Fido style .MSG file attaches to Adept style.    */
/* Checks for presence of BRNODES in the filename and will not kill that    */
/* file attach from the BRE outbound mail dir (League Coordinator support). */
/*                                                                          */
/* by Jerry Jones * Enigma, A Piece of the Puzzle * 1:3602/212 *  07/22/95  */
/*                                                                          */

ADDRESS CMD

/* Edit these lines to reflect your Adept outbound_mail directory and your  */
/* BRE outbound packet directory. Have BRE store *.MSG files in BRE\OUTBOUND*/

  adept = 'd:\adept'
  admail = 'd:\adept\mailer\outbound_mail'
  bremail = directory('.\outbound')
  stripchar = X2C('00')

  goto = directory(bremail)

  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
      call SysLoadFuncs

     rc = SysFileTree('*.Msg',files,O)
       if Files.0 == 0 then signal exit
          do i = 1 to files.0
              locfile = charin(files.i,73,0)
                 attach1 = charin(files.i,,43)
                     attach = strip(attach1,'B',stripchar)

/* If your number of directories to your BRE dir is more or less than 4 you  */
/* must add or remove dir# variables as needed. (League Coordinator support) */

      parse var attach disk':\'dir1'\'dir2'\'dir3'\'dir4'\'filename'.'ext
            if filename = 'BRNODES' then attach = left(attach,41)
                 if filename = 'BRNODES' then Kill = ''
                          else Kill = '^'

        locaddr = charin(files.i,197,0)
             fidoaddr = charin(files.i,,12)
                adeptaddr = translate(fidoaddr,'..',':/')
                   address = word(adeptaddr,1)

/* Insert 'if net = #### the network = netname' statements as needed.        */

      parse var address zone'.'net'.'node

                if net = 10 then network = Fidonet

                if net = 3602 then network = Fidonet

                if net = 100 then network = VLinkNet

/* Insert 'if node    = #.####.#### then packet = H' to make hold packets.   */

   packet =  C

        if address = 1.10.110 then packet = H

        if address = 1.3602.1776 then packet = H

        if address = 44.100.4 then packet = H

        if address = 44.100.9 then packet = H

/* Ensure that the 'else packet = C' statement is the first line in this     */
/* section. This will send all packets not held as crash mail.               */

/* This section actually creates the Adept file attach files.                */

      if attach <> ''
            then do

            adout = lineout(admail'\'packet'.'address'.0.'network,kill''attach)
                 say 'Created 'admail'\'packet'.'address'.0.'network''
                     inclose = lineout(files.i)
                         say 'Deleting 'files.i
                             del files.i
        end

  end

exit:
  goto1 = directory(adept)
  return
