/* -------------------------------------------------- */
/* Title:               tapec.cmd                     */
/*                                                    */
/* Author:              J.Cobb                        */
/*                                                    */
/* Change History:      11/11/1997 - Created JAC      */
/*                                                    */
/* Function:            Looks throuh the config.sys   */
/*                      file for and adds tape support*/
/* -------------------------------------------------- */


Parse Arg featurehandle featureid bootdrv

_proddmd  = 'BASEDEV=?OS2SCSI.DMD'     /* SCSI Device Manager we need */

/* Query the system functions */
if RxFuncQuery(RexxInstDeselect) <> 0 then
   if RxFuncAdd(RexxInstDeselect,WPINSTAL,RexxInstDeselect) <> 0 then Exit

if RxFuncQuery(RexxInstSelect) <> 0 then
   if RxFuncAdd(RexxInstSelect,WPINSTAL,RexxInstSelect) <> 0 then Exit
Call Search_Config

Exit

Search_Config:Procedure expose bootdrv _proddmd featurehandle featureid 

   in_file = bootdrv'\config.sys'
   found_dmd = 0
   do i=1 by 1 while lines(in_file) > 0
      raw_line = linein(in_file)
      if IsTypeDMD(raw_line) then found_dmd = 1 /* found OS2SCSI.DMD */
   end
   call lineout in_file /* Close file */
   if found_dmd =1 then rc=RexxInstSelect(featurehandle,featureid)
   else rc=RexxInstDeselect(featurehandle,featureid) 
return

IsTypeDMD: procedure expose _proddmd
/* Local subroutine to detect corequisite OS2SCSI.DMD statement. */
   parse upper arg string
   return Match_HeadTail(string, _proddmd)

Match_HeadTail: procedure
/* Search "string" to see if "head" is the leading substring and */
/* "tail" is the ending substring.  Case insensitive, ignores */
/* comment lines.  Returns 0 or 1. */
   parse upper arg string, head '?' tail
   parse var string token .
   if token = 'REM' then               /* Comment line? */
      return 0
   string = space(string, 0)           /* Remove all blanks. */
   n=length(head)
   if n > length(string) then          /* More "head" than "string"? */
      return 0
   if left(string, n) \= head then
      return 0
   n=length(tail)
   if n > length(string) then          /* More "tail" than "string"? */
      return 0
   if right(string, n) \= tail then
      return 0
   return 1

