/* -------------------------------------------------- */
/* Title:               tapec.cmd                     */
/*                                                    */
/* Author:              J.Cobb                        */
/*                                                    */
/* Change History:      11/11/1997 - Created JAC      */
/*                                                    */
/* Function:            Looks throuh the config.sys   */
/*                      file for and adds tape support*/
/* -------------------------------------------------- */


Parse Arg bootdrv target_path

_proddmd  = 'BASEDEV=?OS2SCSI.DMD'     /* SCSI Device Manager we need */
_prodsdid = 'DEVICE=?ADSMSDID.SYS'     /* SCSI tape auto detect driver */
_prodtape = 'DEVICE=?ADSMTAPE.SYS'     /* SCSI tape interface */
prodddmd = 'OS2SCSI.DMD'
prodsdid = 'ADSMSDID.SYS'     
prodtape = 'ADSMTAPE.SYS'     

/* Query the system functions */
if RxFuncQuery(SysTempFileName) <> 0 then
   if RxFuncAdd(SysTempFileName,Rexxutil,SysTempFileName) <> 0 then Exit

if RxFuncQuery(SysFileDelete) <> 0 then
   if RxFuncAdd(SysFileDelete,Rexxutil,SysFileDelete) <> 0 then Exit
Call Modify_Config

Exit

Modify_Config:Procedure expose bootdrv _proddmd _prodsdid _prodtape target_path

   in_file = bootdrv'\config.sys'
   temp_file = systempfilename(bootdrv'\pssconf.???')
   back_file = systempfilename(bootdrv'\config.???')
   action = 'COPY' in_file back_file
   action
   if rc <> 0 then Return   /* not continuing without backup of config.sys */
   /*  First, copy CONFIG.SYS in its entirety *except* lines that we */
   /*  placed (or will place) there. If we find such lines, they are */
   /*  discarded, possibly to be re-added later. */
   /*  n.b. We also notice whether BASEDEV=OS2SCSI.DMD is installed. */
   /*       If it isn't, the SCSI tape interface isn't applicable. */
   found_dmd = 0
   do i=1 by 1 while lines(in_file) > 0
      raw_line = linein(in_file)
      if IsTypeDMD(raw_line) then found_dmd = 1 /* found OS2SCSI.DMD */
     
      if \IsTypeSDID(raw_line) then
         if \IsTypeTAPE(raw_line) then
         do
            call lineout temp_file, raw_line
            iterate i
         end
   end
   call lineout in_file /* Close file */

   /* Install the SCSI tape device interface. */
   if found_dmd = 1 then do
      parse var _prodtape '?' device
      device = 'DEVICE='target_path'\'device
      call lineout temp_file, device

      parse var _prodsdid '?' device
      device = 'DEVICE='target_path'\'device
      call lineout temp_file, device
   end


   /* Close our temporary copy of CONFIG.SYS. */
   call lineout temp_file


   /* Delete old config.sys. */
/*   call sysfiledelete in_file */

   /* Copy temp_file to give new config.sys. */
   action = 'COPY' temp_file in_file
   action
   if rc <> 0 then do
      action = 'COPY' back_file in_file
      action
   end

   call sysfiledelete temp_file

return

IsTypeDMD: procedure expose _proddmd
/* Local subroutine to detect corequisite OS2SCSI.DMD statement. */
   parse upper arg string
   return Match_HeadTail(string, _proddmd)

IsTypeSDID: procedure expose _prodsdid
/* Local subroutine to detect our scsi tape identifier driver. */
   parse upper arg string
   return Match_HeadTail(string, _prodsdid)

IsTypeTAPE: procedure expose _prodtape
/* Local subroutine to detect our scsi tape device driver. */
   parse upper arg string
   return Match_HeadTail(string, _prodtape)

Match_HeadTail: procedure
/* Search "string" to see if "head" is the leading substring and */
/* "tail" is the ending substring.  Case insensitive, ignores */
/* comment lines.  Returns 0 or 1. */
   parse upper arg string, head '?' tail
   parse var string token .
   if token = 'REM' then               /* Comment line? */
      return 0
   string = space(string, 0)           /* Remove all blanks. */
   n=length(head)
   if n > length(string) then          /* More "head" than "string"? */
      return 0
   if left(string, n) \= head then
      return 0
   n=length(tail)
   if n > length(string) then          /* More "tail" than "string"? */
      return 0
   if right(string, n) \= tail then
      return 0
   return 1

