/* -------------------------------------------------- */
/* Title:               Invtapec.cmd                  */
/*                                                    */
/* Author:              J.Cobb                        */
/*                                                    */
/* Change History:      13/1/1998 - Created JAC       */
/*                                                    */
/* Function:            Looks throuh the config.sys   */
/*                      file and removes tape support */
/* -------------------------------------------------- */


Parse Upper Arg bootdrv target_path

_prodsdid = 'ADSMSDID.SYS'     /* SCSI tape auto detect driver */
_prodtape = 'ADSMTAPE.SYS'     /* SCSI tape interface */


/* Query the system functions */
if RxFuncQuery(SysTempFileName) <> 0 then
   if RxFuncAdd(SysTempFileName,Rexxutil,SysTempFileName) <> 0 then Exit

if RxFuncQuery(SysFileDelete) <> 0 then
   if RxFuncAdd(SysFileDelete,Rexxutil,SysFileDelete) <> 0 then Exit

Call Modify_Config

Exit

Modify_Config:Procedure expose bootdrv _prodsdid _prodtape target_path

   in_file = bootdrv'\config.sys'

   temp_file = systempfilename(bootdrv'\pssconf.???')

   do i=1 by 1 while lines(in_file) > 0
      raw_line = linein(in_file)
      traw_line = translate(strip(raw_line))
      Select  
         when (traw_line = 'DEVICE='target_path || '\' || _prodtape),
              | (traw_line = 'DEVICE='target_path || '\' || _prodsdid),
              then NOP
         otherwise call lineout temp_file, raw_line
      end  /* select */
   end

   call lineout in_file /* Close file */


   /* Close our temporary copy of CONFIG.SYS. */
   call lineout temp_file

   /* Copy temp_file to give new config.sys. */
   action = 'COPY' temp_file in_file
   action

   call sysfiledelete temp_file

return

