/* -------------------------------------------------- */
/* Title:               etc.cmd                       */
/*                                                    */
/* Author:              J.Cobb                        */
/*                                                    */
/* Change History:      11/11/1997 - Created JAC      */
/*                                                    */
/* Function:            Updates the TCP/IP services   */
/*                      file with the port for psnsapi*/
/* -------------------------------------------------- */


parse arg featurehandle featureid port prodsvc

/* Query the system functions */
if RxFuncQuery(RexxInstDeselect) <> 0 then
   if RxFuncAdd(RexxInstDeselect,WPINSTAL,RexxInstDeselect) <> 0 then Exit

if RxFuncQuery(RexxInstSelect) <> 0 then
   if RxFuncAdd(RexxInstSelect,WPINSTAL,RexxInstSelect) <> 0 then Exit

found = 0
etc_path = value( 'ETC',,'OS2ENVIRONMENT')                   
svcfile = etc_path'\services'                                
parse var port pnum '/' ptext
                                                             
if FileExists(svcfile) = 0 then do
   rc=RexxInstDeselect(featurehandle,featureid) 
   Exit
end

do while lines( svcfile) > 0                              
   raw_line = linein( svcfile)                            
   if left( raw_line, 1) \= '#' then do                   
      parse var raw_line svcname port .                   
      if svcname = prodsvc then do                  
         rc=RexxInstDeselect(featurehandle,featureid)
         call lineout svcfile /* Close the services file */                                     
         Exit
      end /* do */
   end                                                    
end                                                       
call lineout svcfile /* Close the services file */                                     

/* Now go through until we find a unique tcp address */
done = 0
do until done = 1
   clash = 0
   do while lines( svcfile) > 0                              
      raw_line = linein( svcfile)                            
      if left( raw_line, 1) \= '#' then do                   
         parse var raw_line svcname port .                   
         parse var port num '/' .
         if num = pnum then do
            pnum = pnum + 1
            leave
            clash = 1
         end /* do */
      end
   end
   if clash = 0 then done = 1
end /* do */

/* If we get here then we have a unique port number */
port = pnum || '/' || ptext
rc=RexxInstSelect(featurehandle,featureid)
rc = RexxInstSetVariable(featurehandle,'port',port)
Exit

FileExists: Procedure
/**********************************************************************/
/* Local subroutine to check existence of a file.                     */
/* input:  "arg(1)" contains the subject fileid.                      */
/* output: returns  1 := file exists,  0:= file doesn't exist         */
/**********************************************************************/
   return ('' \= stream( arg(1), 'c', 'query exists') )

