/* Rexx */
/***************************************************************************/
/* Benutzerausgang fr OS/2 Warp Server Backup/Restore-Zurckschreibung    */
/*                                                                         */
/*      Copyright  1995  IBM Corp.                                         */
/*-------------------------------------------------------------------------*/
/* bergebene Parameter:                                                   */
/*   Complete         = 0 beim Beginn der Zurckschreibung                 */
/*                    = 1 beim Ende der Zurckschreibung                   */
/*                                                                         */
/*   RsMethod         = Name der verwendeten Zurckschreibungsmethode      */
/*                                                                         */
/*   BkpSet           = Name der Sicherungsgruppe, aus der Daten zurck-   */
/*                      geschrieben werden                                 */
/*                                                                         */
/***************************************************************************/
Parse arg Complete' <'RsMethod'> <'BkpSet'>'
/*-------------------------------------------------------------------------*/
/* berprfen der Markierung Complete, um festzustellen, ob dies der       */
/* Beginn oder das Ende einer Zurckschreibung ist                         */
/*-------------------------------------------------------------------------*/
If Complete = 0 Then Do
   /*----------------------------------------------------------------------*/
   /* Dies ist der Beginn einer Zurckschreibung, daher mssen alle Pro-   */
   /* gramme beendet werden, die exklusiven Zugriff auf Dateien bentigen. */
   /*----------------------------------------------------------------------*/
   /*----------------------------------------------------------------------*/
   /* Durch berprfen der Zurckschreibungsmethode (RsMethod) oder Siche- */
   /* rungsgruppe (BkpSet) kann festgestellt werden, welche Anwendungen    */
   /* beendet werden mssen.                                               */
   /*----------------------------------------------------------------------*/
   Select
      When RsMethod = "Datenbank" Then Do
      End
      When RsMethod = "Server" Then Do
      End
      Otherwise
   End /* endselect */
End /* enddo */
Else Do
   /*----------------------------------------------------------------------*/
   /* Die Zurckschreibung ist beendet, daher knnen nun die zu Beginn     */
   /* der Zurckschreibung beendeten Programme erneut gestartet werden.    */
   /*----------------------------------------------------------------------*/
   Select
      When RsMethod = "Datenbank" Then Do
      End
      When RsMethod = "Server" Then Do
      End
      Otherwise
   End /* endselect */
End
return 0
