/*  Module Header  */
/*    Name:                  PsnsRC.HPP                                         */
/*    Description:           PSnS return codes                                  */
/*    Part version:          1.0                                                */
/*    Used in PSnS version:  5.1                                                */
/*    Last update:           29/Aug/1997                                        */
/*    Author:                James Austin                                       */
/*    Owner:                 Michael Fabianski                                  */
/*  */
/*  OCO SOURCE MATERIALS                                                        */
/*  IBM CONFIDENTIAL                                                            */
/*  5622884                                                                    */
/*  Copyright (c) International Business Machines Corporation 1995, 1997        */
/*                        All Rights Reserved                                   */
/*  */
/*    Change history:                                                           */
/*          29/Aug/97  JA  Initial version created                              */
/*  */
/*  Description: PSnS API return codes                                          */
/*  */
/*  Dependencies:                                                               */
/*  */
#ifndef _PSNSRC_H_
#define _PSNSRC_H_

#define PSNS_OK                                         0
#define PSNS_NO_MORE_HANDLES                            1
#define PSNS_DUPLICATE_CONNECTION                       2
#define PSNS_UNKNOWN_ERROR                              3
#define PSNS_HANDLE_IN_USE                              4
#define PSNS_ALREADY_EXISTS                             5
#define PSNS_ARCHIVE_ERROR                              6
#define PSNS_INVALID_HANDLE                             7
#define PSNS_INVALID_LIST_HANDLE                        8
#define PSNS_INVALID_PARAMETER                          9
#define PSNS_INVALID_BACKUP_METHOD                      10
#define PSNS_INVALID_VOLUME                             11
#define PSNS_INVALID_EVENT_TYPE                         12
#define PSNS_INVALID_EVENT_OPTION                       13
#define PSNS_INVALID_MASK                               14
#define PSNS_INVALID_DRIVE_TYPE                         15
#define PSNS_INVALID_GENERATIONS                        16
#define PSNS_INVALID_RULEBOOK                           17
#define PSNS_INVALID_FILE_FILTER                        18
#define PSNS_INVALID_BACKUP_SET                         19
#define PSNS_INVALID_RESTORE_METHOD                     20
#define PSNS_INVALID_SOURCE_DRIVE                       21
#define PSNS_INVALID_POSITION                           22
#define PSNS_INVALID_EVENT                              23
#define PSNS_INVALID_DRIVE                              24
#define PSNS_INVALID_PATH                               25
#define PSNS_INVALID_FILENAME                           26
#define PSNS_ALREADY_ASSOCIATED                         27
#define PSNS_INVALID_NAME                               28
#define PSNS_INVALID_FILE_FILTER_TYPE                   29
#define PSNS_INVALID_STORAGE_DEVICE_TYPE                30
#define PSNS_INVALID_STORAGE_DEVICE                     31
#define PSNS_IN_USE                                     32
#define PSNS_CANNOT_DELETE                              33
#define PSNS_FILE_NOT_FOUND                             34
#define PSNS_INVALID_TIME                               35
#define PSNS_NO_EVENTS                                  36
#define PSNS_TOO_MUCH_DATA                              37
#define PSNS_CANNOT_CONNECT                             38
#define PSNS_INVALID_CONFIGURATION                      39
#define PSNS_INVALID_PRIORITY                           40
#define PSNS_INVALID_GENERATION                         41
#define PSNS_TRANSFERRED_IN                             42
#define PSNS_TRANSFERRED_OUT                            43
#define PSNS_INVALID_COMPRESSION                        44
#define PSNS_MALFORMED_METHOD                           45
#define PSNS_INVALID_DATE                               46
#define PSNS_READONLY                                   47
#define PSNS_NOT_CONFIGURABLE                           48
#define PSNS_INVALID_FLAGS                              49
#define PSNS_COMMUNICATIONS_ERROR                       50
#define PSNS_INVALID_RC                                 51
#define PSNS_INDEX_DISKETTE                             52
#define PSNS_FIXED_VOLUME                               53
#define PSNS_INAPPROPRIATE_BACKUP_SET                   54
#define PSNS_INVALID_KEYWORD                            55
#define PSNS_INVALID_VALUE                              56
#define PSNS_SYNTAX_ERROR                               57
#define PSNS_INCOMPLETE_STRING                          58
#define PSNS_SEMANTIC_ERROR                             59
#define PSNS_ERROR_DURING_BACKUP                        60
#define PSNS_ERROR_DURING_RESTORE                       61 
#define PSNS_UNHANDLED_EXCEPTION                        62 
#define REXX_INVALID_MASK_NAME                          63
#define REXX_INVALID_PARAMETER                          64
#define REXX_INVALID_HANDLE                             65

#endif
/*___________________________________________________________________________*/
