/* -------------------------------------------------- */
/* Title:               Invclic.cmd                   */
/*                                                    */
/* Author:              J.Cobb                        */
/*                                                    */
/* Change History:      29/1/1998 - Created JAC       */
/*                                                    */
/* Function:            Looks throuh the config.sys   */
/*                      file and removes psns from the*/
/*                      path line.                    */
/* -------------------------------------------------- */


Parse Upper Arg bootdrv target_path
target_path=translate(strip(target_path))

/* Query the system functions */
if RxFuncQuery(SysTempFileName) <> 0 then
   if RxFuncAdd(SysTempFileName,Rexxutil,SysTempFileName) <> 0 then Exit

if RxFuncQuery(SysFileDelete) <> 0 then
   if RxFuncAdd(SysFileDelete,Rexxutil,SysFileDelete) <> 0 then Exit

Call Modify_Config

Exit

Modify_Config:Procedure expose bootdrv target_path

   in_file = bootdrv'\config.sys'

   temp_file = systempfilename(bootdrv'\pssconf.???')
   dp = ''
   rest='initial value'
   do i=1 by 1 while lines(in_file) > 0
      raw_line = linein(in_file)
      parse var raw_line first '=' rest
      if strip(translate(first)) = 'SET PATH' then do 
         do until rest = ''
            parse var rest path ';' rest
            if translate(strip(path)) = target_path then NOP
            else dp = dp || path || ';'
         end /* do */
         raw_line = 'SET PATH=' || dp
      end
      call lineout temp_file, raw_line
   end

   call lineout in_file /* Close file */


   /* Close our temporary copy of CONFIG.SYS. */
   call lineout temp_file

   /* Copy temp_file to give new config.sys. */
   action = 'COPY' temp_file in_file
   action

   call sysfiledelete temp_file

return

