/* Rexx */
/***************************************************************************/
/* Benutzerausgang fr Warp Server Backup/Restore-Datenbanksicherung       */
/*                                                                         */
/*      Copyright  1996  IBM Corp.                                         */
/*-------------------------------------------------------------------------*/
/* bergebene Parameter:                                                   */
/*   Complete         = 0 beim Beginn einer Sicherung                      */
/*                    = 1 beim Ende einer Sicherung                        */
/*                                                                         */
/*   BkMethod         = Name der verwendeten Sicherungsmethode             */
/*                                                                         */
/*   BkpSet           = Name der Sicherungsgruppe, in der gesichert wird   */
/*                                                                         */
/*   Incremental      = 0 fr eine Gesamtsicherung                         */
/*                    = 1 fr eine Teilsicherung                           */
/*                                                                         */
/*   Manual           = 0 fr eine manuelle Sicherung                      */
/*                    = 1 fr eine automatische Sicherung                  */
/***************************************************************************/
Parse arg Complete' <'BkMethod'> <'BkpSet'>' Incremental Manual
/*-------------------------------------------------------------------------*/
/* berprfen der Markierung Complete, um festzustellen, ob dies der       */
/* Beginn oder das Ende einer Sicherung ist                                */
/*-------------------------------------------------------------------------*/
If Complete = 0 Then Do
   /*----------------------------------------------------------------------*/
   /* Dies ist der Beginn einer Sicherung. Daher mu jetzt die             */
   /* Sicherungsfunktion fr die DB/2-Datenbank aufgerufen werden.         */
   /*----------------------------------------------------------------------*/
   /*----------------------------------------------------------------------*/
   /* Durch berprfen der Sicherungsmethode (BkMethod) kann festgestellt  */
   /* werden, ob dies eine Datenbanksicherung ist. Wenn dies zutrifft,     */
   /* starten Sie den Datenbankmanager, und erstellen Sie die Sicherungs-  */
   /* datei.                                                               */
   /*----------------------------------------------------------------------*/
   If BkMethod = "Datenbank" Then Do
      '@md c:\dbback'
      '@db2 start database manager'
      '@db2 backup database sample to c:\dbback'
   End
End /* enddo */
Else Do
   /*----------------------------------------------------------------------*/
   /* Die Sicherung ist beendet. Daher kann nun die Datenbanksicherungs-   */
   /* datei gelscht werden (vorausgesetzt, es handelt sich tatschlich    */
   /* um eine Datenbanksicherung).                                         */
   /*----------------------------------------------------------------------*/
   If BkMethod = "Datenbank" Then Do
      Call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
      SysDestroyObject("c:\dbback")
   End
End
return 0
