/* Rexx */
/***************************************************************************/
/* Benutzerausgang fr OS/2 Warp Server Backup/Restore-Sicherung           */
/*                                                                         */
/*      Copyright  1995  IBM Corp.                                         */
/*-------------------------------------------------------------------------*/
/* bergebene Parameter:                                                   */
/*   Complete         = 0 beim Beginn einer Sicherung                      */
/*                    = 1 beim Ende einer Sicherung                        */
/*                                                                         */
/*   BkMethod         = Name der verwendeten Sicherungsmethode             */
/*                                                                         */
/*   BkpSet           = Name der Sicherungsgruppe, in der gesichert wird   */
/*                                                                         */
/*   Incremental      = 0 fr eine Gesamtsicherung                         */
/*                    = 1 fr eine Teilsicherung                           */
/*                                                                         */
/*   Manual           = 0 fr eine manuelle Sicherung                      */
/*                    = 1 fr eine automatische Sicherung                  */
/***************************************************************************/
Parse arg Complete' <'BkMethod'> <'BkpSet'>' Incremental Manual
/*-------------------------------------------------------------------------*/
/* berprfen der Markierung Complete, um festzustellen, ob dies der       */
/* Beginn oder das Ende einer Sicherung ist                                */
/*-------------------------------------------------------------------------*/
If Complete = 0 Then Do
   /*----------------------------------------------------------------------*/
   /* Dies ist der Beginn einer Sicherung, daher mssen alle Programme     */
   /* beendet werden, die exklusiven Zugriff auf Dateien bentigen.        */
   /*----------------------------------------------------------------------*/
   /*----------------------------------------------------------------------*/
   /* Durch berprfen der Sicherungsmethode (BkMethod) oder Sicherungs-   */
   /* gruppe (BkpSet) kann festgestellt werden, welche Anwendungen         */
   /* beendet werden mssen.                                               */
   /*----------------------------------------------------------------------*/
   Select
      When BkMethod = "Datenbank" Then Do
      End
      When BkMethod = "Server" Then Do
      End
      Otherwise
   End /* endselect */
End /* enddo */
Else Do
   /*----------------------------------------------------------------------*/
   /* Die Sicherung ist beendet, daher knnen nun die zu Beginn der        */
   /* Sicherung beendeten Programme erneut gestartet werden.               */
   /*----------------------------------------------------------------------*/
   Select
      When BkMethod = "Datenbank" Then Do
      End
      When BkMethod = "Server" Then Do
      End
      Otherwise
   End /* endselect */
End
return 0
