/*************************************************************************** 
 *                                                                         *
 *    File:         fileUp.cpp                                             *
 *                                                                         *
 *    Description:  This file contains the main entry point into the       *
 *                  Test Program system.                                   *
 *                                                                         *
 *    Copyright:                                                           *
 *    Date:         02 Jan 2000                                            *
 *                                                                         *
 *    Note:         Generated by the Guidelines code generation facility.  *
 *                                                                         *
 ***************************************************************************/

#define INCL_PM
#define INCL_NLS
#define INCL_BASE

#define GUIDELINES "3.1A"

#include <os2.h>                                 /* OS/2 include file      */
#include <stdio.h>                               /* Standard I/O functions */
#include <stdlib.h>                              /* Misc. functions        */
#include <string.h>                              /* String functions       */

#include "fileUp.hpp"


/*************************************************************************** 
 *    Private functions.                                                   *
 ***************************************************************************/

static void GuiSetup (void);


/*************************************************************************** 
 *    Global variables.                                                    *
 ***************************************************************************/

WINDOW  wFrame1;                                 /* Frame1 info            */
WINDOW  wDirectoryDialog;                        /* DirectoryDialog info   */
WINDOW  wExcludeDialog;                          /* ExcludeDialog info     */
WINDOW  wFILE_COPY;                              /* FILE_COPY info         */
WINDOW  wSELECT_DIRS_DLG;                        /* SELECT_DIRS_DLG info   */
WINDOW  wDLG_CONFIGURE;                          /* DLG_CONFIGURE info     */




/*************************************************************************** 
 *                                                                         *
 *    Function:     main                                                   *
 *                                                                         *
 *    Description:  This is main entry point into the                      *
 *                  Test Program application.                              *
 *                                                                         *
 ***************************************************************************/

int main (int argc, char *argv[])
{
    SWCNTRL  swctl;
    PAPPINFO pApp;
    
   /******************************
    * Initialize the application *
    ******************************/
    
    GuiInitApp ("fileUp", "Test Program");
    GuiSaveCmdLine (argc, argv);
    
    pApp = GuiAppInfo ();
    GuiInitWindows (pApp);
    GuiSetup ();
    
   /********************************
    * Load and display main window *
    ********************************/
    
    GuiSetWindow (&wFrame1, IDD_FRAME1, WT_FRAME, Frame1WndProc, (HMODULE)0);
    if  (GuiLoadWindow (&wFrame1, GuiDesktopWindow ()))
    {
       /*************************
        * Add entry to tasklist *
        *************************/
        
        strcpy (swctl.szSwtitle, pApp->szPgmTitle);
        
        swctl.hwnd          = wFrame1.hwnd;
        swctl.hwndIcon      = (HWND)0;
        swctl.hprog         = (HPROGRAM)0;
        swctl.idProcess     = pApp->pid;
        swctl.idSession     = 0;
        swctl.uchVisibility = SWL_VISIBLE;
        swctl.fbJump        = SWL_JUMPABLE;
        
        WinAddSwitchEntry (&swctl);
        
       /*******************************
        * Process the window template *
        *******************************/
        
        pApp->hwndMain = wFrame1.hwnd;
        GuiProcessWindow (&wFrame1);
        GuiUnloadWindow (&wFrame1);
    }
    
   /**************************
    * Termination processing *
    **************************/
    
    GuiExitWindows ();
    
    return (pApp->sExitCode);
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     GuiSetup                                               *
 *                                                                         *
 *    Description:  This routine performs any processing required          *
 *                  to initialize the runtime environment for this         *
 *                  application or DLL.                                    *
 *                                                                         *
 ***************************************************************************/

static void GuiSetup (void)
{
    PAPPINFO pApp = GuiAppInfo ();
    
    GuiRegisterButton (pApp->hab);
    GuiRegisterEntry (pApp->hab);
    GuiRegisterMLE (pApp->hab);
    GuiRegisterListbox (pApp->hab);
    GuiRegisterCombobox (pApp->hab);
    GuiRegisterStatic (pApp->hab);
    
    /* Register window class Frame1 */
    WinRegisterClass (pApp->hab,
                      "Frame1",
                      Frame1WndProc,
                      CS_SIZEREDRAW | CS_MOVENOTIFY,
                      0);
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     Frame1WndProc                                          *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  Frame1 window.                                         *
 *                                                                         *
 ***************************************************************************/

PMENTRY Frame1WndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wFrame1;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wFrame1.hwnd)
        return (GuiDefFrameProc (WinDefWindowProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /********************
        * Paint background *
        ********************/
        
        case WM_PAINT:
             {
                 HPS hps;
                 hps = WinBeginPaint (hwnd, (HPS)0, (PRECTL)0);
                 if  (WinIsWindowShowing (hwnd))
                     GuiFillBackground (hwnd, hps);
                 WinEndPaint (hps);
             }
             return (FALSE);
        
       /**********************************
        * Presentation parameter changed *
        **********************************/
        
        case WM_PRESPARAMCHANGED:
             WinInvalidateRect (hwnd, (PRECTL)0, TRUE);
             return (FALSE);
        
       /*********************
        * Check for tabbing *
        *********************/
        
        case WM_CHAR:
             if  (GuiTabbing (hwnd, msg, mp1, mp2))
                 return ((MRESULT)TRUE);
             break;
        
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             return (GuiDefFrameProc (WinDefWindowProc, wFrame1.hwnd, msg, mp1, mp2));
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
       /********************************
        * User request to close window *
        ********************************/
        
        case WM_CLOSE:
             GuiDismissWindow (&wFrame1, FALSE);
             return (FALSE);
        
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefWindowProc, hwnd, msg, mp1, mp2));
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     DirectoryDialogWndProc                                 *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  DirectoryDialog window.                                *
 *                                                                         *
 ***************************************************************************/

PMENTRY DirectoryDialogWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wDirectoryDialog;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wDirectoryDialog.hwnd)
        return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             break;
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     ExcludeDialogWndProc                                   *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  ExcludeDialog window.                                  *
 *                                                                         *
 ***************************************************************************/

PMENTRY ExcludeDialogWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wExcludeDialog;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wExcludeDialog.hwnd)
        return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             break;
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     FILE_COPYWndProc                                       *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  FILE_COPY window.                                      *
 *                                                                         *
 ***************************************************************************/

PMENTRY FILE_COPYWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wFILE_COPY;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wFILE_COPY.hwnd)
        return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             break;
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     SELECT_DIRS_DLGWndProc                                 *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  SELECT_DIRS_DLG window.                                *
 *                                                                         *
 ***************************************************************************/

PMENTRY SELECT_DIRS_DLGWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wSELECT_DIRS_DLG;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wSELECT_DIRS_DLG.hwnd)
        return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             break;
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
}


/*************************************************************************** 
 *                                                                         *
 *    Function:     DLG_CONFIGUREWndProc                                   *
 *                                                                         *
 *    Description:  This is the window procedure handler for the           *
 *                  DLG_CONFIGURE window.                                  *
 *                                                                         *
 ***************************************************************************/

PMENTRY DLG_CONFIGUREWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mResult = FALSE;
    
    if  (msg == WM_GUIGETWINDOW)
    {
        *((PWINDOW)mp2) = wDLG_CONFIGURE;
        return (FALSE);
    }
    
    /* Check if window fully loaded */
    if  (!wDLG_CONFIGURE.hwnd)
        return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
    
    switch (msg)
    {
       /***********************
        * Property processing *
        ***********************/
        
        case WM_GUIGETPROPERTY:
        case WM_GUISETPROPERTY:
             break;
        
       /*******************************
        * Window resized/repositioned *
        *******************************/
        
        case WM_WINDOWPOSCHANGED:
             {
                 PSWP pSwp = (PSWP) mp1;
                 if  (pSwp->fl & SWP_SIZE)
                 {
                     GuiBroadcastMsg (hwnd, WM_GUIPARENTRESIZED, 0, 0);
                 }
             }
             break;
        
       /***************************
        * User command processing *
        ***************************/
        
        case WM_COMMAND:
             switch (SHORT1FROMMP (mp1))
             {
                 
                 default:
                      break;
             }
             return (mResult);
        
        default:
             break;
    }
    
    return (GuiDefFrameProc (WinDefDlgProc, hwnd, msg, mp1, mp2));
}


