/* OS/2 REXX: get rid of ZIP SFX header (zip.EXE => zip.ZIP)      */

/* Normally ZIP option -J should strip any UNZIPSFX.EXE header,   */
/* but sometimes ZIP cannot handle valid archives (i.e. ZIP -T    */
/* reports an error, but an unzip-test resp. self test of the     */
/* archive shows no error).  To get around this misbehaviour use  */
/* ZIP -F -T (repairing spurious errors) before ZIP -J.           */

/* Not yet implemented:  use TMP directory for ZIP manipulation   */
/* Not yet implemented:  use UNZIP -t before forcing ZIP -F -T    */

   signal on  novalue name TRAP  ;  signal on syntax name TRAP
   signal on  failure name TRAP  ;  signal on halt   name TRAP

   NAME = strip( strip( strip( translate( arg( 1 ))), 'B', '"' ))
   parse var NAME NAME '.' EXE   ;  ZIP = '"' || NAME || '.zip"'
   if EXE <> 'EXE' then exit TRAP( 'bad argument' arg( 1 ))
   OPT = '-T'                    ;  EXE = '"' || NAME || '.exe"'

   signal on  error   name TRAP  ;  address CMD '@COPY' EXE ZIP
   signal off error              ;  address CMD '@ZIP'  OPT ZIP
   signal on  error   name FAIL  ;  if rc = 3 then OPT = '-F -T'
   if rc <> 0 then                  address CMD '@ZIP'  OPT ZIP
   OPT = '-o -J'                 ;  address CMD '@ZIP'  OPT ZIP
   signal on  error   name TRAP  ;  address CMD '@ERASE'    EXE
   exit rc

FAIL:                            /* erase new ZIP, drop into TRAP */
   signal on  error   name TRAP  ;  address CMD '@ERASE'    ZIP

TRAP:                            /* select REXX exception handler */
   call trace 'O' ;  trace N           /* don't trace interactive */
   parse source TRAP                   /* source on separate line */
   TRAP = x2c( 0D ) || right( '+++', 10 ) TRAP || x2c( 0D0A )
   TRAP = TRAP || right( '+++', 10 )   /* = standard trace prefix */
   TRAP = TRAP condition( 'c' ) 'trap:' condition( 'd' )
   select
      when wordpos( condition( 'c' ), 'ERROR FAILURE' ) > 0 then do
         if condition( 'd' ) > ''      /* need an additional line */
            then TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
         TRAP = TRAP '(RC' rc || ')'   /* any system error codes  */
         if condition( 'c' ) = 'FAILURE' then rc = -3
      end
      when wordpos( condition( 'c' ), 'HALT SYNTAX'   ) > 0 then do
         if condition( 'c' ) = 'HALT' then rc = 4
         if condition( 'd' ) > '' & condition( 'd' ) <> rc then do
            if condition( 'd' ) <> errortext( rc ) then do
               TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
               TRAP = TRAP errortext( rc )
            end                        /* future condition( 'd' ) */
         end                           /* may use errortext( rc ) */
         else  TRAP = TRAP errortext( rc )
         rc = -rc                      /* rc < 0: REXX error code */
      end
      when condition( 'c' ) = 'NOVALUE'  then rc = -2 /* dubious  */
      when condition( 'c' ) = 'NOTREADY' then rc = -1 /* dubious  */
      otherwise                        /* force non-zero whole rc */
         if datatype( value( 'RC' ), 'W' ) = 0 then rc = 1
         if condition() = '' then TRAP = TRAP arg( 1 )
   end                                 /* direct: TRAP( message ) */

   TRAP = TRAP || x2c( 0D0A ) || format( sigl, 6 )
   signal on syntax name TRAP.SIGL     /* throw syntax error 3... */
   if 0 < sigl & sigl <= sourceline()  /* if no handle for source */
      then TRAP = TRAP '*-*' strip( sourceline( sigl ))
      else TRAP = TRAP '+++ (source line unavailable)'
TRAP.SIGL:                             /* ...catch syntax error 3 */
   if abbrev( right( TRAP, 2 + 6 ), x2c( 0D0A )) then do
      TRAP = TRAP '+++ (source line unreadable)'   ;  rc = -rc
   end
   select
      when 0 then do                   /* in pipes STDERR: output */
         parse version TRAP.REXX . .   /* REXX/Personal: \dev\con */
         signal on syntax name TRAP.FAIL
         if TRAP.REXX = 'REXXSAA'      /* fails if no more handle */
            then call lineout 'STDERR'  , TRAP
            else call lineout '\dev\con', TRAP
      end
      when 0 then do                   /* OS/2 PM: RxMessageBox() */
         signal on syntax name TRAP.FAIL
         call RxMessageBox ,           /* fails if not in PMREXX  */
            translate( TRAP, ' ', x2c( 0D )), , 'CANCEL', 'WARNING'
      end                              /* replace any CR by blank */
      otherwise   say TRAP ; trace ?L  /* interactive Label trace */
   end

   if condition() = 'SIGNAL' then signal TRAP.EXIT
TRAP.CALL:  return rc                  /* continue after CALL ON  */
TRAP.FAIL:  say TRAP ;  rc = 0 - rc    /* force TRAP error output */
TRAP.EXIT:  exit   rc                  /* exit for any SIGNAL ON  */
