/* Formats suitable for use "naked" with Word for Windows */
/* Si Dobson, 14-9-1992 */

description "Word for Windows (sequence numbers)"

/* use RTF to communicate with Word */
language { RTF }

/* tags are complicated... */
tag { "["
      "{\field{\*\fldinst ref "
      MajorAuthor(Surname) Date(Century) Unique
      "}{\fldrslt 1}}"
      "]" }

/* paper from journal */
format { Title Authors Journal [ Vol No ] Date [ Pages ] [ Others ] }
as { "["
     "{\field{\*\fldinst set "
     MajorAuthor(Surname) Date(Century) Unique
     " {\field{\*\fldinst seq Reference}{\fldrslt 1}}}{\fldrslt 1}}{\field{\*\fldinst ref "
     MajorAuthor(Surname) Date(Century) Unique
     "}{\fldrslt 1}}"
     "]" Tab
     MajorAuthor(Surname ", " Initials)  [ ", " MinorAuthors(Initials " " Surname) ]
     ", " 66 italic { Title "," } 99
     " " Journal [ " " Vol [ "(" bold { No } ")" ] ] " (" Date ")" [ " pp." Pages ]
     "."
     [ "  " Others "." ]
     Para }

/* book */
format { Title Authors Publisher [ City ] Date [ Others ] }
as { "["
     "{\field{\*\fldinst set "
     MajorAuthor(Surname) Date(Century) Unique
     " {\field{\*\fldinst seq Reference}{\fldrslt 1}}}{\fldrslt 1}}{\field{\*\fldinst ref "
     MajorAuthor(Surname) Date(Century) Unique
     "}{\fldrslt 1}}"
     "]" Tab
     MajorAuthor(Surname ", " Initials) [ ", " MinorAuthors(Initials " " Surname) ]
     ", " 66 italic { Title "," } 99
     " " Publisher [ ", " City ] [ " (" Date ")" ]
     "."
     [ "  " Others "." ]
     Para }

/* technical report */
format { Title Authors Publisher ReportNo Date [ Others ] }
as { "["
     "{\field{\*\fldinst set "
     MajorAuthor(Surname) Date(Century) Unique
     " {\field{\*\fldinst seq Reference}{\fldrslt 1}}}{\fldrslt 1}}{\field{\*\fldinst ref "
     MajorAuthor(Surname) Date(Century) Unique
     "}{\fldrslt 1}}"
     "]" Tab
     MajorAuthor(Surname ", " Initials) [ ", " MinorAuthors(Initials " " Surname) ]
     ", " 66 italic { Title "," } 99
     " Technical report " ReportNo ", " Publisher [ " (" Date ")" ]
     "."
     [ "  " Others "." ]
     Para }

