##
##  WPM-LMTT.R  (Local Mime Translation Table)
##  Copyright (c) 1994, David Harris, All Rights Reserved.
##
##  This file can be used as a model for a local resource which
##  maps ISO character sets to the code pages in use on the PCs
##  at your site.
##
##  Character translation tables:
##  Each translation table maps the characters in a particular
##  ISO set to your codepage's character set: the table can be used
##  bidirectionally when composing or decoding quoted-printable or
##  8BIT messages. Only characters from 128-255 are included in
##  the table, and each table must end with an ASCII NUL (0).
##
##  The sample tables in this file are the ones Pegasus Mail uses
##  by default: they map ISO character sets to the standard IBM
##  code page 437. You may define as many character sets as you
##  wish and Pegasus Mail will use them to translate incoming mail
##  but for outgoing mail it will only use ISO character sets.
##
##  The last resource in the file must be a "charset_list"
##  structure which ties the character strings naming an ISO
##  character set to the resource which maps it.
##
#==========================================================
#
#   OPTIMAL CHARACTER TRANSLATIONS, should be used as
#   a example for user defined tables in multilanguage fonts
#   environment.
#
# WEST   ISO-8859-1 -->   CP 1252
# CE     ISO-8859-2 -->   CP 1250
# TR,AFR ISO-8859-3 --> ? CP 1252
# BALTIC ISO-8859-4 -->   CP 1257
# CYR    ISO-8859-5 -->   CP 1251
# ARAB   ISO-8859-6 -->   CP 1256
# GREEK  ISO-8859-7 -->   CP 1253
# HEBR   ISO-8859-8 -->   CP 1255
# TR     ISO-8859-9 -->   CP 1254
# RUSS   KOI-8R     -->   CP 1251
# VIETN                   CP 1258 (currently not implemented)
#        ISO-8859-10      ???     (currently not implemented)
#   Conversion tables from Jiri Kuchta, 8-12-96, kuchta@fee.vutbr.cz
#
#=========================================================
##
##  To use this file, modify it as required, then compile it with
##  the Pegasus Mail system resource compiler, RESCOM, using the
##  command 'rescom PM-LMTT.R'. This will produce the file
##  PM-LMTT.RSC, which should be copied into the same directory
##  as PMAIL.EXE, or into your home mailbox.

##
##  The "charset_list" type is used to tie a particular name of
##  a character set to the table used to decode it.
##

typedef charset_list 25
   {
   repeat,
   string 20,     # Character set name
   integer        # resource ID of table to load.
   };


###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 1     (Latin 1)
###----------------------------------------------------------------
## Danish, Dutch, English, Faeroese, Finnish, French, German, Icelandic,
## Irish, Italian, Norwegian, Portuguese, Spanish and Swedish.
##
## optimal conversion into CP850, CP1252

structure iso8859_1
	{
# conversion ISO-1 --> 1252
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', '', '', '', '', '', '|', '',      #a0
	'', '', '', '', '', '', '', '',      #a8
   '', '', '', '', '', '', '', '',      #b0
	'', '', '', '', '', '', '', '',      #b8
   '', '', '', '', '', '', '', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
   '', '', '', '', '', '', '', '',      #d0
   '', '', '', '', '', '', '', '',      #d8
   '', '', '', '', '', '', '', '',      #e0
   '', '', '', '', '', '', '', '',      #e8
   '', '', '', '', '', '', '', '',      #f0
   '', '', '', '', '', '', '', '',      #f8
   0
	};

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 2     (Latin 2)
###----------------------------------------------------------------
## Albanian, Czech, English, German, Hungarian, Polish, Rumanian,
## Serbo-Croatian, Slovak, Slovene and Swedish.
##
## optimal conversion into CP852, CP1250

#structure iso8859_2
#   {
## conversion ISO-2 --> 1252 (WEST)
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', 'A', '', 'L', '', 'L', 'S', '',      #a0
#   '', '', 'S', 'T', 'Z', '', 'Z', 'Z',      #a8
#   '', 'a', '?', 'l', '', 'l', 's', '',      #b0
#   '', '', 's', 't', 'z', '', 'z', 'z',      #b8
#   'R', '', '', '', '', 'L', 'C', '',      #c0
#   'C', '', 'E', '', '', '', '', 'D',      #c8
#   '', 'N', '', '', '', '', '', '',      #d0
#   'R', '', '', '', '', '', 'T', '',      #d8
#   'r', '', '', '', '', 'l', 'c', '',      #e0
#   'c', '', 'e', '', '', '', '', 'd',      #e8
#   '', 'n', '', '', '', '', '', '',      #f0
#   'r', '', '', '', '', '', 't', '',      #f8
#   0
#   };

structure iso8859_2
   {
# conversion ISO-2 --> 1250 (CE)
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', '', '', '', '', '', '', '',      #a0
	'', '', '', '', '', '', '', '',      #a8
	'', '', '', '', '', '', '', '',      #b0
	'', '', '', '', '', '', '', '',      #b8
   '', '', '', '', '', '', '', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
   '', '', '', '', '', '', '', '',      #d0
	'', '', '', '', '', '', '', '',      #d8
   '', '', '', '', '', '', '', '',      #e0
   '', '', '', '', '', '', '', '',      #e8
   '', '', '', '', '', '', '', '',      #f0
   '', '', '', '', '', '', '', '',      #f8
   0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 3     (Latin 3)
###----------------------------------------------------------------
## Afrikaans, Catalan, English, Esperanto, French, Galician, German,
## Italian, Maltese and Turkish.
##
## optimal conversion into CP85x, CP125x

structure iso8859_3
	{
# conversion ISO-3 --> 1252
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', 'H', '', '', '', ' ', 'H', '',      #a0
	'', 'I', 'S', 'G', 'J', '', ' ', 'Z',      #a8
	'', 'h', '', '', '', '', 'h', '',      #b0
	'', 'i', 's', 'g', 'j', '', ' ', 'z',      #b8
	'', '', '', ' ', '', 'C', 'C', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
	' ', '', '', '', '', 'G', '', '',      #d0
	'G', '', '', '', '', 'U', '', '',      #d8
   '', '', '', ' ', '', 'c', 'c', '',      #e0
	'', '', '', '', '', '', '', '',      #e8
   ' ', '', '', '', '', 'g', '', '',      #f0
   'g', '', '', '', '', 'u', '', '',      #f8
  0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 4     (Latin 4)
###----------------------------------------------------------------
## Danish, English, Estonian, Finnish, German, Greenlandic, Lappish,
## Latvian, Lithuanian, Norwegian and Swedish.
##
## optimal conversion into CP85x, CP1257


#structure iso8859_4
#   {
## conversion ISO-4 --> 1252
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', 'A', 'k', 'R', '', 'I', 'L', '',      #a0
#   '', '', '', 'G', 'T', '', 'Z', '',      #a8
#   '', 'a', '', 'r', '', 'N', 'z', 'n',      #b0
#   '', '', '', 'g', 't', 'i', 'l', '',      #b8
#   '', '', '', '', '', '', '', 'I',      #c0
#   'C', '', 'E', '', '', '', '', '',      #c8
#   '', '', '', 'K', '', '', '', '',      #d0
#   '', '', '', '', '', 'U', 'U', '',      #d8
#   '', '', '', '', '', '', '', 'i',      #e0
#   'c', '', 'e', '', '', '', '', '',      #e8
#   '', '', '', 'k', '', '', '', '',      #f0
#   '', '', '', '', '', 'u', 'u', '',      #f8
#   0
#   };

structure iso8859_4
	{
# conversion ISO-4 --> 1257
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', '', 'k', '', '', 'I', '', '',      #a0
	'', '', '', '', 'T', '', '', '',      #a8
	'', '', '', '', '', 'i', '', '',      #b0
	'', '', '', '', 't', '?', '', '?',      #b8
	'', 'A', 'A', 'A', '', '', '', '',      #c0
	'', '', '', 'E', '', 'I', 'I', '',      #c8
	'D', '', '', '', 'O', '', '', '',      #d0
	'', 'U', 'U', '', 'U', 'U', '', '',      #d8
	'', 'a', 'a', 'a', '', '', '', '',      #e0
	'', '', '', 'e', '', 'i', 'i', '',      #e8
	'd', '', '', '', 'o', '', '', '',      #f0
	'', 'u', 'u', '', 'u', 'u', '', '',      #f8
   0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 5     (Cyrilic)
###----------------------------------------------------------------
## Bulgarian, Bielorussian, English, Macedonian, Russian,
## Serbo-Croatian and Ukrainian.
##
## optimal conversion into CP855, CP866, CP1251


#structure iso8859_5
#   {
## conversion ISO-5--> 1252
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', '', '?', 'r', 'E', 'S', 'I', '',      #a0
#   'J', 'L', 'H', '?', 'K', '-', '', '?',      #a8
#   'A', 'B', 'V', 'G', 'D', 'E', 'Z', '3',      #b0
#   'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',      #b8
#   'R', 'S', 'T', 'U', '', 'X', 'C', '',      #c0
#   'S', 'S', '?', '?', '?', '3', '', '',      #c8
#   'a', 'b', 'v', 'g', 'd', 'e', 'z', '3',      #d0
#   'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',      #d8
#   'r', 's', 't', 'u', '', 'x', 'c', '',      #e0
#   's', 's', '?', '?', '?', '3', '', '',      #e8
#   '', '', '?', 'r', 'e', 's', 'i', '',      #f0
#   'j', 'l', 'h', '?', 'k', ' ', '', '?',      #f8
#   0
#   };


structure iso8859_5
   {
# conversion ISO-5 --> 1251
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', '', '', '', '', '', '', '',      #a0
	'', '', '', '', '', '', '', '',      #a8
	'', '', '', '', '', '', '', '',      #b0
	'', '', '', '', '', '', '', '',      #b8
	'', '', '', '', '', '', '', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
	'', '', '', '', '', '', '', '',      #d0
	'', '', '', '', '', '', '', '',      #d8
	'', '', '', '', '', '', '', '',      #e0
	'', '', '', '', '', '', '', '',      #e8
	'', '', '', '', '', '', '', '',      #f0
	'', '', '', '', '', ' ', '', '',      #f8
   0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 6     (Arabic)
###----------------------------------------------------------------
## This set of graphic character is intended for use in information
## interchange as well as in data and text processing applications
## where both the Arabic and the Latin scripts are used.
##
## optimal conversion into CP85x, CP1256

#structure iso8859_6
#   {
## conversion ISO-6--> 1252
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', ' ', ' ', ' ', '', ' ', ' ', ' ',      #a0
#   ' ', ' ', ' ', ' ', '`', '-', ' ', ' ',      #a8
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #b0
#   ' ', ' ', ' ', ';', ' ', ' ', ' ', '',      #b8
#   ' ', '?', '?', '?', '?', '?', '?', '?',      #c0
#   '?', '?', '?', '?', '?', '?', '?', '?',      #c8
#   '?', '?', '?', '?', '?', '?', '?', '?',      #d0
#   '?', '?', '?', ' ', ' ', ' ', ' ', ' ',      #d8
#   '-', '?', '?', '?', '?', '?', '?', '?',      #e0
#   '?', '?', '?', '-', '-', '-', '-', '-',      #e8
#   '-', '-', '-', ' ', ' ', ' ', ' ', ' ',      #f0
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #f8
#   0
#   };


structure iso8859_6
	{
## conversion ISO-6--> 1256
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #80
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #88
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #90
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #98
	'\160',' ',   ' ',   ' ',   '',   ' ',   ' ',   ' ',         #a0
	' ',   ' ',   ' ',   ' ',   '\161','\173',' ',   ' ',         #a8
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #b0
	' ',   ' ',   ' ',   '\186',' ',   ' ',   ' ',   '\191',      #b8
	' ',   '\193','\194','\195','\196','\197','\198','\199',      #c0
	'\200','\201','\202','\203','\204','\205','\206','\207',      #c8
	'\208','\209','\210','\211','\212','\213','\214','\216',      #d0
	'\217','\218','\219',' ',   ' ',   ' ',   ' ',   ' ',         #d8
	'\220','\221','\222','\223','\225','\227','\228','\229',      #e0
	'\230','\236','\237','\240','\241','\242','\243','\245',      #e8
	'\246','\248','\250',' ',   ' ',   ' ',   ' ',   ' ',         #f0
	' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',   ' ',         #f8
	0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 7     (Greek)
###----------------------------------------------------------------
## This set is suited for multiple-language applications involving the
## Latin and the Greek scripts. It allows handling of data and text
## expressed in Greek.
##
## optimal conversion into CP85x, CP1253

structure iso8859_7
	{
## conversion ISO-7--> 1253
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', ',', '`', '', ' ', ' ', '', '',      #a0
	'', '', ' ', '', '', '', ' ', '',      #a8
	'', '', '', '', '', '', '', '',      #b0
   '', '', '', '', '', '', '', '',      #b8
   '', '', '', '', '', '', '', '',      #c0
   '', '', '', '', '', '', '', '',      #c8
   '', '', ' ', '', '', '', '', '',      #d0
   '', '', '', '', '', '', '', '',      #d8
   '', '', '', '', '', '', '', '',      #e0
   '', '', '', '', '', '', '', '',      #e8
   '', '', '', '', '', '', '', '',      #f0
   '', '', '', '', '', '', '', ' ',      #f8
	0
   };

###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 8     (Hebrew)
###----------------------------------------------------------------
## This set is suited for multiple-language applications involving the
## Latin and the Hebrew scripts. It allows handling of data and text
## expressed in Hebrew.
##
## optimal conversion into CP85x, CP1255

#structure iso8859_8
#   {
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', ' ', '', '', '', '', '', '',      #a0
#   '', '', '', '', '', '', '', '?',      #a8
#	 '', '', '', '', '', '', '', '',      #b0
#	 ',', '', '', '', '', '', '', ' ',      #b8
#	 ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #c0
#	 ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #c8
#	 ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #d0
#	 ' ', ' ', ' ', ' ', ' ', ' ', ' ', '?',      #d8
#   '?', '?', '?', '?', '?', '?', '?', '?',      #e0
#   '?', '?', '?', '?', '?', '?', '?', '?',      #e8
#   '?', '?', '?', '?', '?', '?', '?', '?',      #f0
#   '?', '?', '?', '?', '?', '?', '?', '?',      #f8
#   0
#   };


structure iso8859_8
   {
## conversion ISO-8--> 1255
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', ' ', '', '', '', '', '', '',      #a0
	'', '', 'x', '', '', '', '', '?',      #a8
	'', '', '', '', '', '', '', '',      #b0
	',', '', '/', '', '', '', '', ' ',      #b8
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #c0
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #c8
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #d0
	' ', ' ', ' ', ' ', ' ', ' ', ' ', '?',      #d8
	'\224','\225','\226','\227','\228','\229','\230','\231',      #e0
	'\232','\233','\234','\235','\236','\237','\238','\239',      #e8
	'\240','\241','\242','\243','\244','\245','\246','\247',      #f0
	'\248','\249','\250',' ',   ' ',   ' ',   ' ',   ' ',         #f8
	0
	};


###----------------------------------------------------------------
##                I S O - 8 8 5 9 - 9     (Latin 5)
###----------------------------------------------------------------
## English, Finnish, French, German, Irish, Italian, Norwegian,
## Portuguese, Spanish and Swedish and Turkish.
##
## optimal conversion into CP85x, CP1254


#structure iso8859_9
#   {
## conversion ISO-9 --> 1252
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
#   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
#'\160', '', '', '', '', '', '|', '',      #a0
#   '', '', '', '', '', '', '', '',      #a8
#   '', '', '', '', '', '', '', '',      #b0
#   '', '', '', '', '', '', '', '',      #b8
#   '', '', '', '', '', '', '', '',      #c0
#   '', '', '', '', '', '', '', '',      #c8
#   'G', '', '', '', '', '', '', '',      #d0
#   '', '', '', '', '', 'I', 'S', '',      #d8
#   '', '', '', '', '', '', '', '',      #e0
#   '', '', '', '', '', '', '', '',      #e8
#   'g', '', '', '', '', '', '', '',      #f0
#   '', '', '', '', '', 'i', 's', '',      #f8
#   0
#   };


structure iso8859_9
	{
# conversion ISO-9 --> 1254
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #80
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #88
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #90
	' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',      #98
'\160', '', '', '', '', '', '', '',      #a0
	'', '', '', '', '', '', '', '',      #a8
	'', '', '', '', '', '', '', '',      #b0
	'', '', '', '', '', '', '', '',      #b8
	'', '', '', '', '', '', '', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
	'', '', '', '', '', '', '', '',      #d0
	'', '', '', '', '', '', '', '',      #d8
	'', '', '', '', '', '', '', '',      #e0
	'', '', '', '', '', '', '', '',      #e8
	'', '', '', '', '', '', '', '',      #f0
	'', '', '', '', '', '', '', '',      #f8
	0
	};

###----------------------------------------------------------------
##                K O I - 8 R             (Cyrilic)
###----------------------------------------------------------------
## Bulgarian, Bielorussian, English, Macedonian, Russian,
## Serbo-Croatian and Ukrainian.
##
## optimal conversion into CP855, CP866, CP1251


structure koi8_r
   {
# conversion KOI8-R --> 1251
	'-', '|', '+', '+', '+', '+', '|', '|',      #80
	'-', '-', '+', '#', '#', '#', '#', '#',      #88
	'#', '#', '#', '|', '#', '?', '?', '~',      #90
	'?', '?', ' ', '|', '?', '2', '.', '/',      #98
	'-', '|', '+', '', '+', '+', '+', '+',      #a0
	'+', '+', '+', '+', '+', '+', '+', '|',      #a8
	'|', '|', '|', '', '|', '|', '-', '-',      #b0
	'-', '-', '-', '-', '+', '+', '+', '',      #b8
	'', '', '', '', '', '', '', '',      #c0
	'', '', '', '', '', '', '', '',      #c8
	'', '', '', '', '', '', '', '',      #d0
	'', '', '', '', '', '', '', '',      #d8
	'', '', '', '', '', '', '', '',      #e0
	'', '', '', '', '', '', '', '',      #e8
	'', '', '', '', '', '', '', '',      #f0
	'', '', '', '', '', '', '', '',      #f8
   0
	};

charset_list _mime_csets
   {
   "ISO-8859-1", iso8859_1,
   "ISO-8859-2", iso8859_2,
   "ISO-8859-3", iso8859_3,
   "ISO-8859-4", iso8859_4,
   "ISO-8859-5", iso8859_5,
   "ISO-8859-6", iso8859_6,
   "ISO-8859-7", iso8859_7,
   "ISO-8859-8", iso8859_8,
   "ISO-8859-9", iso8859_9,
   "KOI8-R",     koi8_r,
   "", -1
   };


