//************************************************************************************************************************
//
// Function:   EuroConv (Euro Conversion Routine)
//
// Version:    1.01
//
// Written by: Clemens Dannheim, Objective GmbH Mnchen,Tel. DB internal +49 69  910 63364
//             Reinhard Drfler, Focus GmbH Mnchen,	Tel. DB internal +49 69  910 63365
//             Alfred Schut, DAT Dsseldorf				Tel. DB internal +49 211 883 6063
//
// Change Log: 04.06.98 Clemens Dannheim - created
//				C.Dannheim - Parameter and calculation of "round_diff" added
//
//************************************************************************************************************************

#include "defos.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef _WIN32
 #include "windows.h"
 #include "winbase.h"
#endif


#ifdef _WIN16
 #include "windows.h"
#endif

#ifdef __OS2__
 #include <os2.h>
#endif

#include "RdProst.h"
#include "EuroConv.h"

#ifndef __OS2__
 typedef int      BOOL;
#endif


#ifndef FALSE
 #define FALSE               0
#endif

#ifndef TRUE
 #define TRUE                1
#endif

#define OK 0

char 		used_date[8] = "init";
tPSEB		PS_EB;

#ifdef _WIN16
 //#pragma argsused
 int CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
 {
    if (wHeapSize > 0)
        UnlockData (0);
    return(1);
 }
#endif


int iInitializeProst(char *cModName, char *cEbVers, char *cAppName,
                     char *cBookDate, tPSEB *PS_EB)
    {
    tPSSB       PS_SB;
    tDummy      PS_VB;

    memset(&(PS_SB),0,sizeof(tPSSB));

    strcpy(PS_SB.SBF.Version,"01");
    strcpy(PS_SB.SBF.Fkt_Gruppe,"F601");
    strcpy(PS_SB.SBF.Fkt_Einzel,"0001");
    memset(PS_SB.SBF.Funk_Erw,' ',8);
    strcpy(PS_SB.SBF.ModulName,cModName);

    strcpy(PS_SB._EIN.Version_EB,cEbVers);
    strcpy(PS_SB._EIN.Anw_Name,cAppName);
    memcpy(&(PS_SB._EIN.Buch_Datum),cBookDate,8);

    return((int)PS_LesenProstDaten(&PS_SB, &PS_VB, PS_EB));
}


int APIENTRY _export EuroConv(char *ISO_in, double dAmount, char *ISO_out, char *amount_out,
				   double drate1, double drate2, char *date,
               char *phase, char *round_diff)

{
    char   *stopstring;
	 int	   CurrSelect;
    int     i, ISOinInd, ISOoutInd;
    char    post_dec;
    double  rate;
    int     i32Rc = 99;

    ISO_in[3] = '\0';
    ISO_out[3] = '\0';
    amount_out[0] = '\0';
    date[8] = '\0';
    phase[0] = '\0';
    round_diff[0] = '\0';

    if (strcmp(used_date, date)) {
	    i32Rc = iInitializeProst("EuroConv","  ","        ", date,&PS_EB);
   	 if (i32Rc)
	   	return i32Rc;
       strcpy(used_date, date);
    } else
    	i32Rc = OK;

   ISOinInd    = -1;
	ISOoutInd   = -1;
	post_dec    = '2';
	CurrSelect  = 0;
    strcpy(round_diff,"0");

	if (PS_EB.Proj.Land_W == 'N') strcpy(phase,"3"); // after dual phase (no more denominations)
	else if (PS_EB.Proj.EURO == 'N') strcpy(phase,"1"); // before dual phase
	else strcpy(phase,"2"); // dual phase, denominations of EURO existing

    // check if ISO_in is "EUR", "EURO in currency" or "foreign currency"
	if (strncmp(ISO_in,"EUR",3)) {
		for (i=0; i <= PS_EB.Ind_letzter_Eintr; i++) {
			if (strncmp(ISO_in,PS_EB.Kurs_Tab[i].Iso_Code,3) == 0) {
				if ((strtod(&PS_EB.Kurs_Tab[i].Kurs.Sign, &stopstring) != 0)) // rate is defined
					CurrSelect = 10; // it is a denomination
				else
					CurrSelect = 20; // it is still a foreign currency
				ISOinInd=i; // index into the EURO in currency table
				break;
			}
		}
		if (i > PS_EB.Ind_letzter_Eintr) CurrSelect = 20; // not found, it is a foreign currency
	}

    // check if ISO_out is "EUR", "EURO in currency" or "foreign currency"
	if (strncmp(ISO_out,"EUR",3)) {
		for (i=0; i<= PS_EB.Ind_letzter_Eintr; i++) {
			if (strncmp(ISO_out,PS_EB.Kurs_Tab[i].Iso_Code,3) == 0) {
				if ((strtod(&PS_EB.Kurs_Tab[i].Kurs.Sign, &stopstring) != 0)) // rate is defined
					CurrSelect += 1; // it is a denomination
				else
					CurrSelect += 2; // it is still a foreign currency
				ISOoutInd=i;
				break;
			}
		}
		if (i > PS_EB.Ind_letzter_Eintr) CurrSelect += 2; // not found, it is a foreign currency
	}


	switch( CurrSelect )
	{

    case  0: // ISO_in = EURO, ISO_out= EURO, do nothing, return input value
		i32Rc = OK;
        break;
    case 11: // ISO_in = EWU in currency, ISO_out= EWU in currency, CALL U3
		rate =  strtod(&PS_EB.Kurs_Tab[ISOinInd].Kurs.Sign, &stopstring) / 10e6;
        dAmount= dAmount / rate;

		// round to 3 post decimals
		sprintf(amount_out, "%.3f",dAmount);
		dAmount = strtod(amount_out, &stopstring);

		rate =  strtod(&PS_EB.Kurs_Tab[ISOoutInd].Kurs.Sign, &stopstring) / 10e6;
        dAmount= dAmount * rate;
        break;
    case 10: // ISO_in = EWU in currency, ISO_out = EURO, CALL U1
		rate =  strtod(&PS_EB.Kurs_Tab[ISOinInd].Kurs.Sign, &stopstring) / 10e6;
        dAmount= dAmount / rate;
        break;
    case  1: // ISO_in = EURO, ISO_out = EWU in currency , CALL U1
		rate =  strtod(&PS_EB.Kurs_Tab[ISOoutInd].Kurs.Sign, &stopstring) / 10e6;
        dAmount= dAmount * rate;
        break;
    case 12: // ISO_in = EWU in currency, ISO_out = foreign currency, CALL U4
		rate =  strtod(&PS_EB.Kurs_Tab[ISOinInd].Kurs.Sign, &stopstring) / 10e6;
        dAmount= dAmount / rate;

		// round to 3 post decimals
		sprintf(amount_out, "%.3f",dAmount);
		dAmount = strtod(amount_out, &stopstring);

        dAmount= dAmount * drate2; // 1
        break;
    case 21: // ISO_in = foreign currency, ISO_out = EWU in currency, CALL U4
        if (drate1) {
			dAmount= dAmount / drate1;

			// round to 3 post decimals
			sprintf(amount_out, "%.3f",dAmount);
			dAmount = strtod(amount_out, &stopstring);
		
			rate =  strtod(&PS_EB.Kurs_Tab[ISOoutInd].Kurs.Sign, &stopstring) / 10e6;
		    dAmount= dAmount * rate;

		} else {
			dAmount = 0;
			i32Rc = RC_02_BETRAG_UEBERLAUF;
		}
        break;
    case 22: // ISO_in = foreign currency, ISO_out = foreign currency, CALL U4
        if (drate1 && drate2) {
			dAmount = dAmount / drate1;

			// round to 3 post decimals
			sprintf(amount_out, "%.3f",dAmount);
			dAmount = strtod(amount_out, &stopstring);

			dAmount= dAmount * drate2;
		} else {
			dAmount = 0;
			i32Rc = RC_02_BETRAG_UEBERLAUF;
		}
        break;
    case  2: // ISO_in = EURO, ISO_out = foreign currency, CALL U2
        dAmount= dAmount * drate2; // 1
        break;
    case 20: // ISO_in = foreign currency, ISO_out = EURO, CALL U2
        if (drate1) dAmount= dAmount / drate1;
		else dAmount = 0, i32Rc = RC_02_BETRAG_UEBERLAUF;
        break;
	default:
		i32Rc = RC_02_UNZUL_ISO_CODES;
		dAmount = 0;
	}


	// rounding section

	if (i32Rc == OK) {

		if ((ISOoutInd != -1) && (PS_EB.Kurs_Tab[ISOoutInd].Anzahl_NKS == '0')) {
			sprintf(amount_out, "%.0f",dAmount);
			// determine rounding difference (display 15 post decimals)
			sprintf(round_diff, "%.0f", (dAmount - strtod(amount_out, &stopstring)) *1e10);
			strcat(round_diff, "e-10"); // return correct result
        } else {
			dAmount *= 100; // shift 2 decimals to avoid "." or "," as decimal seperator
			sprintf(amount_out, "%.0f",dAmount); // rounding
			// determine rounding difference (diplay 2+13 = 15 post decimals)
			sprintf(round_diff, "%.0f", (dAmount - strtod(amount_out, &stopstring)) *1e8);
			strcat(round_diff, "e-10"); // return correct result
			// return correct result
			strcat(amount_out, "e-2");
		}

	} else  amount_out=0; // returning value error for excel           
	
	
	return i32Rc;
}
