@ECHO OFF
set PK_DIR=C:\DVIFONTS\%3x%4
if %5==%6 set PK_DIR=C:\DVIFONTS\%3

rem     If the font already exists, don't do anything
if exist %PK_DIR%\%1.pk goto GETOUT

rem     If the directory doesn't exist, make it now.
MD %PK_DIR% >NUL
CLS

rem     Initialize device and magstep to empty
set PK_DEV=
set PK_MAG=

rem     Devices with non-square pixels; we support the following modes:
rem     epsdrft (9-pin 120x72dpi), epswlo (9-pin 120x144dpi), epsmed
rem     (9-pin 240x144dpi), epson (9-pin 240x216dpi), lqmed (24-pin
rem     360x180dpi) and DJFiveTwenty (600x300dpi), as well as their
rem     landscape versions.

if %5==%6 goto SQUARE_PIXELS
set PK_MAG=%2
if %6==300      set PK_DEV=DJFiveTwenty
if %6==72       set PK_DEV=epsdrft
if %6==216      set PK_DEV=epson
if %6==180      set PK_DEV=lqmed
if %6==144      goto FX_LOMED
if %5==300      set PK_DEV=DJFiveTwentyl
if %5==72       set PK_DEV=epsdrftl
if %5==216      set PK_DEV=epsonl
if %5==180      set PK_DEV=lqmedl
if %5==144      goto LAND_FX_LOMED
goto DO_IT
:FX_LOMED
if %5==120      set PK_DEV=epswlo
if %5==240      set PK_DEV=epsmed
goto DO_IT
:LAND_FX_LOMED
if %6==120      set PK_DEV=epswlol
if %6==240      set PK_DEV=epsmedl
goto DO_IT


rem     Devices with square pixels. The current code supports the resolutions
rem     used by the Beebe drivers for the screen, 300dpi and 400dpi laser
rem     and inkjet printers, 600dpi laserjets, 24-pin printers at 180x180
rem     and 360x360dpi.

:SQUARE_PIXELS
if %5==180      set PK_DEV=lqlores
if %5==360      set PK_DEV=lqhires
if %5==300      set PK_DEV=hplaser
if %5==400      set PK_DEV=nexthi
if %5==600      set PK_DEV=ljfour
if +%PK_DEV%==+ goto OTHER_SQ
set PK_MAG=%2
goto DO_IT
:OTHER_SQ
if %3==58       set PK_MAG=-9
if %3==64       set PK_MAG=-8.5
if %3==70       set PK_MAG=-8
if %3==76       set PK_MAG=-7.5
if %3==84       set PK_MAG=-7
if %3==92       set PK_MAG=-6.5
if %3==100      set PK_MAG=-6
if %3==110      set PK_MAG=-5.5
if %3==121      set PK_MAG=-5
if %3==132      set PK_MAG=-4.5
if %3==145      set PK_MAG=-4
if %3==158      set PK_MAG=-3.5
if %3==174      set PK_MAG=-3
if %3==190      set PK_MAG=-2.5
if %3==208      set PK_MAG=-2
if %3==228      set PK_MAG=-1.5
if %3==250      set PK_MAG=-1
if %3==274      set PK_MAG=-0.5
if %3==300      set PK_MAG=0
if %3==329      set PK_MAG=0.5
if %3==360      set PK_MAG=1
if %3==394      set PK_MAG=1.5
if %3==432      set PK_MAG=2
if %3==473      set PK_MAG=2.5
if %3==518      set PK_MAG=3
if %3==568      set PK_MAG=3.5
if %3==622      set PK_MAG=4
if %3==681      set PK_MAG=4.5
if %3==746      set PK_MAG=5
if %3==818      set PK_MAG=5.5
if %3==896      set PK_MAG=6
if %3==981      set PK_MAG=6.5
if %3==1075     set PK_MAG=7
if %3==1178     set PK_MAG=7.5
if %3==1290     set PK_MAG=8
if NOT +%PK_MAG%==+ set PK_DEV=hplaser

:DO_IT
if +%PK_DEV%==+ goto UNKNOWN
@ECHO OFF
CLS
ECHO The DVI Viewer must now generate some fonts. Typically, this 
ECHO takes about 6 minutes on a 486/66. But once these particular 
ECHO fonts have been generated, they'll never need to be generated 
ECHO for this machine ever again.
ECHO.
ECHO NOTE: Please be patient. If you quit now (by pressing Ctrl-C
ECHO       in the DVI Viewer), you MUST then go back to the Options
ECHO       menu, Missing Fonts section, and change "Take no action" 
ECHO       back to "Execute command", or else you'll get no fonts.
ECHO.
ECHO NOTE: The first time you print, or when you use a particular 
ECHO       resolution for the first time, or when you open a document
ECHO       that uses symbols not used before, you'll see this again.
ECHO.
ECHO Thanks for your patience ... it should be worth it!
ECHO.
C:
CD \DVIFONTS
IF EXIST COSTELLA\%1.MF ERASE COSTELLA\%1.MF
ECHO \scrollmode;mode:=%PK_DEV%;mag:=magstep(%PK_MAG%);input %1 >> COSTELLA\%1.MF
MF COSTELLA\%1
if errorlevel 1 goto ERROR_EXIT

rem     Find out if the directories already exist to avoid
rem     any warning messages
if not exist C:\DVIFONTS\nul md C:\DVIFONTS
if not exist %PK_DIR%\nul  md %PK_DIR%

rem     This stupid trick is necessary because some versions of Metafont
rem     use an extension of NNNgf (where NNN is the hor. resolution) and
rem     truncate it to 3 chars. while other versions use just NNN which
rem     they also truncate to 3 chars.
set GF_EXT=%3
if exist %1.%9 set GF_EXT=%9

REM Call another batch file, to take care of the case that the resolution
REM is rounded off.
REM
ERASE *.LOG
ERASE *.TFM
FOR %%I IN (%1.*) DO CALL GENFIN %%I %PK_DIR%\%1.PK

goto GETOUT

:UNKNOWN
echo I don't know the metafont mode for this device. Please
echo add this information to the file %0

:ERROR_EXIT
rem     The next line creates a small file in the TEMP directory. This
rem     signals the error to the "genall.bat" file, so it doesn't call
rem     dviwin again when running under NT.
echo ERROR > %TEMP%\error$_$
pause

:GETOUT
