@ECHO OFF

REM Check that we are being called from the directory with the files in it.
REM
IF NOT EXIST DVIWIN.ZIP GOTO WRONGDIR
IF NOT EXIST MF.ZIP GOTO WRONGDIR

REM Check that the windows directory was specified correctly.
rem
IF NOT EXIST %1\WIN.INI GOTO NOPARAM
IF NOT EXIST %1\SYSTEM.INI GOTO NOPARAM

REM If the directory c:\dvifonts does not exist, make it now.
REM
MD C:\DVIFONTS >NUL
ATTRIB +H C:\DVIFONTS >NUL
MD C:\DVIFONTS\COSTELLA >NUL
CLS
ECHO  Setup               DVI Viewer for Microsoft Windows              18 June 1997
ECHO  ==============================================================================
ECHO                  [Comments to jpc@physics.unimelb.edu.au]
ECHO.
ECHO    The files for the DVI Viewer will be unzipped into your Windows directory,
ECHO    which you have specified (and which has been verified) to be %1.
ECHO.
ECHO    A hidden directory c:\dvifonts will also be created, to hold the program
ECHO    Metafont, as well as the fonts that it generates on-the-fly.
ECHO.
ECHO    In all cases, existing files that are NEWER than supplied here will NOT 
ECHO    be overwritten.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO Press Ctrl-Break to abort installation, or else
PAUSE
CLS
ECHO  Setup               DVI Viewer for Microsoft Windows              18 June 1997
ECHO  ==============================================================================
ECHO                  [Comments to jpc@physics.unimelb.edu.au]
ECHO.
ECHO.
ECHO               Decompressing files; please wait a minute or so ...
ECHO.
ECHO.

REM Make the PIF file readable, if we are here a second time.
REM
IF EXIST %1\GENPK.BAT ATTRIB -R %1\GENPK.BAT
IF EXIST %1\GENPK.PIF ATTRIB -R %1\GENPK.PIF

PKUNZIP -do DVIWIN %1\ >NUL
PKUNZIP -do MF C:\DVIFONTS\ >NUL

REM Make the PIF file read only to stop Windows 95 from messing with it.
REM
ATTRIB +R %1\GENPK.BAT
ATTRIB +R %1\GENPK.PIF

CLS
ECHO  Setup               DVI Viewer for Microsoft Windows              18 June 1997
ECHO  ==============================================================================
ECHO                  [Comments to jpc@physics.unimelb.edu.au]
ECHO.
ECHO. 
ECHO                         Files installed successfully!
ECHO.
ECHO.
ECHO.
ECHO   You now have to create links to the viewer program, %1\dviwin.exe.
ECHO.
ECHO       * In Netscape, when you first download a DVI file, add the
ECHO         Helper application %1\dviwin.exe for .dvi files.
ECHO.
ECHO       * In Windows 3.1, go to the Program Manager, go to the File
ECHO         menu, choose New, click Group, click OK. Leave the Description 
ECHO         line empty. Click in the Group File box, type "dviview.grp"
ECHO         (no quotes!), click OK. The DVI Viewer group should appear.
ECHO.
ECHO       * In Windows 95, add %1\dviwin to your Start Programs 
ECHO         menu, or make a shortcut to it on the desktop. (Push Start 
ECHO         and click on Help if you don't know how to do this.)
ECHO.
ECHO.
GOTO END

:WRONGDIR
ECHO.
ECHO You must run Setup from its own directory!
ECHO.
ECHO For example, if you PKUnzipped dviview.zip into the directory
ECHO C:\TEMPINST, then you should go to a DOS prompt within Windows,
ECHO and type the following:
ECHO.
ECHO   c:
ECHO   cd \tempinst
ECHO   setup
ECHO.
GOTO END

:NOPARAM
CLS
ECHO  Setup               DVI Viewer for Microsoft Windows              18 June 1997
ECHO  ==============================================================================
ECHO                  [Comments to jpc@physics.unimelb.edu.au]
ECHO.
ECHO.
ECHO        To install the DVI Viewer, you must type the path to your 
ECHO        Windows directory after the SETUP command:
ECHO.
ECHO                         setup [windows-directory]
ECHO.
ECHO        where [windows-directory] is your Windows 3.1 or Windows 95 
ECHO        directory, WITHOUT a trailing backslash. For example, if your 
ECHO        Windows directory is C:\WINDOWS, then you need to type            
ECHO.
ECHO                             setup c:\windows
ECHO.

REM This is the end.
REM
:END


