;  Copyright, 1988-1992, Russell Nelson, Crynwr Software

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       File: messages.inc
;
;       Jan 17, 1996 - aherrera
;               Changed/added some progress strings for clarity. 
;               Changed a string for identifying the IBM Etherjet adapter.
;               Changed code dependent on "version" constant to be dependent on
;               "minver" contant declared in the makefile. 
;               Added this header.      
;		Jan 22, 1996 - aherrera
;				Added messages for bios scan configuration progress.
;				Changed yes_eeprom message to be clearer.
;		Feb 08, 1996 - aherrera
;				Added ethernet address message
;		Feb 14, 1996 - aherrera
;				Added message to support a engineering change request
;				to allow drivers to load w/o cable connected
;		Feb 27, 1996 - aherrera
;		 		Compressed some of the messages and removed unsued messages.
;		Mar 3, 1996 - aherrera
;				Remove dma support as per request.
;		Apr 23, 1996 - aherrera
;				Removed pnp found/not found messages
;	30-Jul-96	aherrera
;		Removed ISA references in messages.
;		Removed references to 16 bit transfers.
;

if LANGUAGE eq US_ENGLISH
public  usage_msg, copyright_msg
usage_msg       label   byte
	db "usage: ",driver_name
	db " [options] <packet_int_no> <io_addr> <hardware_irq> <Ethernet Address>",CR,LF,'$'

copyright_msg   label byte
ifdef IBMEIPKT
    db "Packet driver for IBM EtherJet ISA Adapter."
else
	db "Crystal LAN(tm) CS89XX Ethernet Adapter"
endif
	db CR,LF
if (majver / 10) EQ 0
  if minver EQ 0
    db "  version ",'0'+(majver mod 10),".00",qual,CR,LF
  else
    if (minver / 10) EQ 0
      db "  version ",'0'+(majver mod 10),".0",'0'+minver,qual,CR,LF
    else
      db "  version ",'0'+(majver mod 10),".",'0'+(minver / 10), '0'+(minver mod 10),qual,CR,LF
    endif
  endif
else
  if minver EQ 0
    db "  version ",'0'+(majver / 10),'0'+(majver mod 10),".00",qual,CR,LF
  else
    if (minver / 10) EQ 0
      db "  version ",'0'+(majver / 10),'0'+(majver mod 10),".0",'0'+minver,qual,CR,LF
    else  
      db "  version ",'0'+(majver / 10),'0'+(majver mod 10),".",'0'+(minver / 10), '0'+(minver mod 10),qual,CR,LF
    endif
  endif
endif

	db "Supports: Plug and Play",CR,LF
	db "Portions written by Morien W. Roberts",CR,LF,'$'

non_pnp_card_msg db  "An ",my_name," was found by I/O scan.",CR,LF,'$'

no_card_found_msg	label 	byte
ifdef IBMEIPKT
    db "Driver IBMEIPKT did not load",CR,LF,'$'
else
	db "Packet Driver did not load",CR,LF,'$'
endif

specified_failed        db "An ",my_name," was not found at the"
					db " specified address.",CR,LF,'$'
scan_failed             db "Scan of I/O space did not find an ",my_name
					db ".",CR,LF,'$'
more_than_one_msg       db "Found more than one ",my_name
					db " at the I/O addresses:",CR,LF,'$'
specify_which_msg       db "You must specify the I/O address of the card you wish"
					db " to use.",CR,LF,'$'
eeprom_read_msg         db "EEPROM read failure",CR,LF,'$'
bios_read_msg         db "BIOS configuration read failure. Use command line to set values.",CR,LF,'$'
eeprom_chksum_bad       db "EEPROM Failed checksum validation",CR,LF,'$'
yes_eeprom_msg          db "Reading EEPROM ....",CR,LF,'$'
no_eeprom_msg           db "No EEPROM, scanning BIOS for configuration ....",CR,LF,'$'
yes_bios_msg            db "BIOS configuration found and read.",CR,LF,'$'
no_bios_msg             db "BIOS configuration not found.",CR,LF,'$'
assumed_msg             db "No EEPROM, using command line parameters.",CR,LF,'$'
missing_add_msg         db "Ethernet address must be specified.",CR,LF,'$'

this_chip               db  "This "
;chip_type_msg   db      "CS89"
chip_part_no    db      ?
				db      "0"
chip_is_a_mongoose      db " $$"
;chip_rev_msg    db  "Revision "
chip_rev_no             db      ?
				db      " found",CR,LF,'$'

;word_msg                db      "Performing 16 bit I/O transfers",CR,LF,'$'

int_bad_msg1    db      "That interrupt number is not supported.",CR,LF,'$'
int_bad_msg2    db      "can only use IRQs "
dummy_msg               db      '$'
int_no_name             db      "Interrupt number $"
io_addr_name    db      "I/O port $"

separator1_msg  db      ", $"
separator2_msg  db      " - $"
separator3_msg  db      " & $"

eeprom_cnf_prob db      "*** EEPROM configuration problem ***"
				db  CR,LF,"Trying to use $"
cnf_10B_T_prob  db      "10-Base-T",CR,LF,'$' 
cnf_AUI_prob    db      "AUI$",CR,LF,'$'
cnf_10B_2_prob  db      "10-Base-2$",CR,LF,'$'
using_10B_T_msg db      "Using twisted pair cable",CR,LF,'$'
using_AUI_msg   db      "Using AUI interface",CR,LF,'$'
using_10B_2_msg db      "Using coax cable",CR,LF,'$'
no_cable_msg    db      "Media not detected",CR,LF,'$'
no_10B_T_msg	db		"Media type twisted pair not detected", CR, LF, '$'
no_AUI_msg		db		"Media type AUI not detected", CR, LF, '$'
no_10B_2_msg	db		"Media type coax not detected", CR, LF, '$'
no_media_msg    db      "but the circuitry is absent",CR,LF,'$'
			 
negotiation_msg db      "Performing auto-negotiation for full / half duplex"
				db      " communication",CR,LF,'$'
full_duplex_msg db      "Using full duplex communication",CR,LF,'$'
half_duplex_msg db      "Using half duplex communication",CR,LF,'$'
neg_problem_msg db      "**** Full / half duplex auto-negotiation timed out ****"
				db      CR,LF,'$'

endif
