;  Copyright, 1988-1992, Russell Nelson, Crynwr Software

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       File: epktisar.asm
;
;       Jan 17, 1996 - aherrera
;               Declared a variable mem_base.
;               Changed the way the CS8920 is configured and activated.
;               Added this header.
;       March 3, 1996 - aherrera
;               Removed dma support as per request.
;       Apr 10, 1996 - aherrera
;               change default value of int_no from 5 to 0 so eeprom can
;               override.
;       Apr 23, 1996 - aherrera
;               Removed mem_base. We are not doing memory mode.
;
;

	include defs.asm
	include epktisa.inc

code    SEGMENT word public
	assume  cs:code, ds:code

	include timeout.asm


	.286
	public  quick_rep_ins_16
quick_rep_ins_16        PROC    NEAR
; Does a repeated in instruction by performing 16 bit reads (186 or better)
; CX holds the number of ins - no minimum value
	shr             cx, 1                   ; Convert the byte count to a word count
	rep             insw                    ; Does the entire transfer to the buffer
	jnc             done_q_i_16             ; Jump if cx was initially even
	insb                                    ; Read the last byte
done_q_i_16:
	ret
quick_rep_ins_16        ENDP
	.8086


	public  rep_ins_16
rep_ins_16      PROC    NEAR
; Does a repeated in instruction by performing 16 bit reads.
; CX holds the number of ins - no minimum value
	shr             cx, 1                   ; Convert the byte count to a word count
	jcxz    rep_i_16_1      ; Jump if no words to copy 
next_i_16:
	in              ax, dx                  ; Get the next word from the port
	stosw                                   ; Store this word in the buffer
	loop    next_i_16               ; Continue if there are more words
	jnc             done_i_16               ; Jump if cx was initially even
rep_i_16_1:
	in              al, dx                  ; Get the last byte from the low address
	stosb                                   ; Store this last byte in the buffer
done_i_16:
	ret
rep_ins_16      ENDP


	.286
	public  quick_rep_outs_16
quick_rep_outs_16       PROC    NEAR
; Does a repeated out instruction by performing 16 bit writes (186 or better)
; CX holds the number of outs and will be at least RUNT
	inc             cx                              ; To cope with odd packet lengths
	shr             cx, 1                   ; Convert the byte count to a word count
	rep             outsw                   ; Does the entire transfer
	ret
quick_rep_outs_16       ENDP


	.8086
	public  rep_outs_16
rep_outs_16     PROC    NEAR
; Does a repeated out instruction by performing 16 bit writes.
; CX holds the number of outs and will be at least RUNT
	inc             cx                              ; To cope with odd packet lengths
	shr             cx, 1                   ; Convert the byte count to a word count
next_o_16:                                      ; Do the transfer of the buffer, a word at a time
	lodsw                                   ; Get the next word from the buffer
	out             dx, ax                  ; Send it to the port
	loop    next_o_16               ; Continue if there are more bytes
done_o_16:
	ret
rep_outs_16     ENDP


	even
	public repins, repouts, send_cmd
repins                  dw      ?       ; Address of subroutine to do multiple word reads
repouts                 dw      ?       ; Address of subroutine to do multiple word writes
send_cmd                dw      ?       ; Either TX_AFTER_381 - broken chips, otherise TX_NOW

; a temp buffer for the received header
; needs to be 4 header bytes + 2 ethernet address bytes + 2 type bytes
;    plus some room for IEEE802.3  bytes
RCV_HDR_SIZE    equ     26              ; header @4 + 2 ids @6 + type @2+6,
rcv_hdr                 db      RCV_HDR_SIZE dup(0)

	public  chip_type, pnp_card_no, int_no, base_addr, isa_config
chip_type       dw      ?
pnp_card_no     db      0                       ; Zero if no PNP card is found
int_no          db      0,0,0,0         ; must be four bytes long for get_number.
base_addr       dw      0000h           ; I/O address as located via the I/O scan
isa_config      dw      0h                      ; ISA configuration read from the eprom
	

	public  driver_class, driver_type, driver_name
	public  driver_function, parameter_list
driver_class    db      BLUEBOOK,IEEE8023,0     ;null terminated list of classes.
driver_type             db      255             ;from the packet spec
driver_name             db      my_name,0       ;name of the driver.

driver_function db      8 + 2   ; Mix capability + packet status returned in DH

parameter_list  label   byte
	db      majver  ;major rev of packet driver
	db      minver  ;minor rev of packet driver
	db      14      ;length of parameter list
	db      EADDR_LEN       ;length of MAC-layer address
	dw      GIANT   ;MTU, including MAC headers
	dw      MAX_MULTICAST * EADDR_LEN       ;buffer size of multicast addrs
	dw      0       ;(# of back-to-back MTU rcvs) - 1
	dw      0       ;(# of successive xmits) - 1

	public  int_num
int_num dw      0       ;Interrupt # to hook for post-EOI
			;processing, 0 == none,

;-> current address
	extrn   my_address: byte

received_ours   db      0
	public  rcv_modes
rcv_modes       dw      8               ;number of receive modes in our table.
		dw      0               ;There is no mode zero
		dw      0
		dw      rcv_mode_2
		dw      rcv_mode_3
		dw      0
		dw      0
		dw      rcv_mode_6
		dw      rcv_mode_7

curr_rcv_mode   dw RX_BROADCAST_ACCEPT  ; The current receive mode
	public  curr_rx_cfg
curr_rx_cfg             dw ?    ; The current receive configuration
save_err        db      0               ; Errors in last frame received (promiscuous mode only)

	public  bad_command_intercept
bad_command_intercept:
;called with ah=command, unknown to the skeleton.
;exit with nc if okay, cy, dh=error if not.
	mov             dh, BAD_COMMAND
	stc
	ret

	public  as_send_pkt
; The Asynchronous Transmit Packet routine.
; Enter with es:di -> i/o control block, ds:si -> packet, cx = packet length,
;   interrupts possibly enabled.
; Exit with nc if ok, or else cy if error, dh set to error number.
;   es:di and interrupt enable flag preserved on exit.
as_send_pkt:
	ret

	public  drop_pkt
; Drop a packet from the queue.
; Enter with es:di -> iocb.
drop_pkt:
	assume  ds:nothing
	ret

	public  xmit
; Process a transmit interrupt with the least possible latency to achieve
;   back-to-back packet transmissions.
; May only use ax and dx.
xmit:
	assume  ds:nothing
	ret


send_pkt_toobig:
	mov     dh,NO_SPACE
	stc
	ret
	public  send_pkt
send_pkt:
;enter with es:di->upcall routine, (0:0) if no upcall is desired.
;  (only if the high-performance bit is set in driver_function)
;enter with ds:si -> packet, cx = packet length.
;if we're a high-performance driver, es:di -> upcall.
;exit with nc if ok, or else cy if error, dh set to error number.
	assume  ds:nothing
	cmp             cx, GIANT                       ; Is this packet too large?
	ja              send_pkt_toobig
; No need for a RUNT check

; Tell the chip that a packet is to be sent
try_again:
	LOAD_PORT       TX_CMD_PORT
	mov             ax, TX_AFTER_381        ; Avoid the problem of tx underrun
	mov             ax, send_cmd            ; TX_AFTER_381 - broken chips, otherise TX_NOW
	outw

; Tell the chip the length of the packet
	SET_PORT        TX_LEN_PORT
	mov             ax, cx
	outw


; Wait for the chip to allocate memory for the packet
	LOAD_WRITE      PP_BusST
	inw
	and             ax, READY_FOR_TX_NOW
	jne             wait_send_done          ; Yes - then we can proceed
	mov             ax, 1
	call    set_timeout
wait_send:
	inw
	and             ax, READY_FOR_TX_NOW
	jne             wait_send_done          ; Yes - then we can proceed
	call    do_timeout
	jnz     wait_send
send_problem:
	mov             dh, CANT_SEND           ; Indicate an error.
	stc
	ret


; Write the contents of the packet.
wait_send_done:
	SET_PORT TX_FRAME_PORT
	call    repouts                         ; Packet length is in CX
	clc
	ret

	public  set_address
set_address:
;enter with ds:si -> Ethernet address, CX = length of address.
;exit with nc if okay, or cy, dh=error if any errors.
	assume    ds:nothing
	call    set_ether       
	xor             dh, dh                                  ; Clear error conditions
	clc
	ret


rcv_mode_2:
	mov             bx, RX_IA_ACCEPT
	jmp     short set_rcv_mode
rcv_mode_3:
	mov             bx, RX_BROADCAST_ACCEPT
	jmp     short set_rcv_mode
rcv_mode_4:
	mov             bx, RX_BROADCAST_ACCEPT
	jmp     short set_rcv_mode
rcv_mode_6:
	mov             bx, RX_ALL_ACCEPT               ; Set promiscuous mode
	jmp     short set_rcv_mode
rcv_mode_7:
	mov             bx, RX_BROADCAST_ACCEPT or RX_IA_HASH_ACCEPT
set_rcv_mode:
	mov             curr_rcv_mode, bx
	LOAD_WRITE      PP_RxCTL
	inw                                                             ; Get current receive mode bits
	and             ax, DEF_RX_ACCEPT               ; Clear all but the default bits
	or              ax, bx                                  ; Set the new recieve mode bits
	outw                                                    ; Write the new recieve mode
	SET_WRITE       PP_RxCFG
	mov             ax, curr_rx_cfg                 ; Get the current receive configuration
	and             ax, RX_CFG_MASK                 ; Mask all the promiscuous mode bits
	cmp             bx, RX_ALL_ACCEPT               ; Now in promiscuous mode ?
	jne             not_prom_mode                   ; Jump is not
	or              ax, RX_CFG_ALL                  ; Set all errors to interrupt
not_prom_mode:
	outw                                                    ; Write the new recieve configuration
	ret

	public  set_multicast_list
set_multicast_list:
;enter with ds:si ->list of multicast addresses, ax = number of addresses,
;  cx = number of bytes.
;return nc if we set all of them, or cy,dh=error if we didn't.
	mov     dh,NO_MULTICAST
	stc
	ret

	public  terminate
terminate:

	call    reset_chip
	ret

	public  set_ether
set_ether       PROC NEAR
; Set the Individual address registers with the Ethernet address
; pointed to by si.
	LOAD_WRITE      <PP_IA + AUTOINCREMENT>
	mov             cx, EADDR_LEN
	call    repouts
	ret
set_ether       ENDP


	public  reset_chip
reset_chip      PROC    NEAR
	LOAD_WRITE       PP_SelfCTL
	inw
	or              ax, POWER_ON_RESET
	outw
	call    wait_27ms
	cmp             chip_type, CS8920
	jne             no_pnp_reconfigure

	; Hardware requires PNP registers to be reconfigured after a reset
    LOAD_WRITE PP_CS8920_ISAINT
    mov     al, int_no
    out     dx, al
    inc     dx
    xor     al, al
    out     dx, al

;       mov             bl, pnp_card_no                         ; Get the PNP card select #
;       or              bl, bl                                          ; Jump if 0 - no PNP BIOS
;       je              no_pnp_reconfigure              
;       WRITE_PNP_REG_BL  PNP_WAKE                      ; Select the correct card
;       mov             bl, BYTE PTR (base_addr+1)      ; Reconfigure the IO base registers
;       WRITE_PNP_REG_BL PNP_CNF_IO_H
;       mov             bl, BYTE PTR base_addr
;       WRITE_PNP_REG_BL PNP_CNF_IO_L
;       mov             bl, int_no                                      ; Reconfigure the interrupt number
;       WRITE_PNP_REG_BL PNP_CNF_INT
;       mov             bl, dma_channel                         ; Reconfigure the dma channel
;       WRITE_PNP_REG_BL PNP_CNF_DMA
;       WRITE_PNP_REG PNP_ACTIVATE 1            ; Activate the card

no_pnp_reconfigure:
	LOAD_WRITE       PP_SelfST              ; Wait until the chip is reset
	mov             ax, 1
	call    set_timeout
wait_until_reset:
	inw                                                     ; Get reset status
	test    ax, INIT_DONE           ; Set when initialization is complete
	jnz             reset_done
	call    do_timeout                      ; Check if there is more time left
	jnz             wait_until_reset        ; Continue to wait only if no timeout
reset_done:
	ret
reset_chip      ENDP

	public  wait_27ms, wait
wait_27ms       PROC    NEAR
	mov     ax,1                    ;only have to wait 4us.
NOWARN  RES
wait:
WARN
	call    set_timeout
wait_27ms_1:
	call    do_timeout
	jne     wait_27ms_1
	ret
wait_27ms       ENDP


	public  reset_interface
reset_interface:
;reset the interface.
	assume  ds:code
	ret

;called when we want to determine what to do with a received packet.
;enter with cx = packet length, es:di -> packet type, dl = packet class.
	extrn   recv_find: near

;called after we have copied the packet into the buffer.
;enter with ds:si ->the packet, cx = length of the packet.
	extrn   recv_copy: near


;call this routine to schedule a subroutine that gets run after the
;recv_isr.  This is done by stuffing routine's address in place
;of the recv_isr iret's address.  This routine should push the flags when it
;is entered, and should jump to recv_exiting_exit to leave.
;enter with ax = address of routine to run.
	extrn   schedule_exiting: near

;recv_exiting jumps here to exit, after pushing the flags.
	extrn   recv_exiting_exit: near

	extrn   count_in_err: near
	extrn   count_out_err: near
	extrn   count_handles : near

;this macro writes the given character to the given row and column on
;  an CGA.
to_scrn macro   r, c, ch
	local   black,done
  if 0
	push    bx
	push    es
	mov     bx,0b800h
	mov     es,bx
	mov     bx,es:[r*160+c*2]
	test    bh,1
	jne     black
	mov     bh,07h
	jmp     short done
black:
	mov     bh,70h
done:
	mov     bl,ch
	mov     es:[r*160+c*2],bx
	pop     es
	pop     bx
  endif
	endm



recv_update:
	to_scrn 23,75,'A'

	public  recv
recv:
; Called from the recv isr.  All registers have been saved, and ds=cs.
	assume  ds:code
	to_scrn 23,74,'R'
	LOAD_PORT       ISQ_PORT
recv_0:
	inw
	mov             bx, ax                                  ; Get copy of what caused the interrupt
	and             ax, ISQ_EVENT_MASK              ; Clear all but the event id bits
	jne             recv_1                                  ; Jump if anything left in the ISQ queue
	to_scrn 23,74,' '                               ; Nothing left so return
	ret
recv_1:
	cmp             ax, ISQ_RECEIVER_EVENT  ; Is this a reqular receive interrupt ?
	je              regular_receive                 ; Jump if so

	jmp             recv_0                                  ; Ignore other interrupt events
									; There should not be any
regular_receive:
repins_ok:
	SET_PORT        RX_FRAME_PORT

next_packet:
; Check to make sure that frame has been received with no errors.
; If errors are found then only return frame if in promiscuous mode.
; In promiscuous mode the frame status is assembled and placed in save_err.
	mov     save_err, 1                                     ; Set default value of no error
	test    bx, RX_OK                               ; Error free frame ? (bx = frame status)
	jne             recv_noerrs                             ; Jump if so
	mov             ax, bx                                  ; Get frame status back into ax

	call    count_in_err
	to_scrn 23,72,'E'

	cmp     curr_rcv_mode, RX_ALL_ACCEPT ; Currently in promiscuous mode ?
	je      recv_bad                                        ; Yes - receive bad frame

	jmp     discard_frame_on_chip                   ; No - ignore bad frame

recv_bad:
; Find the error bits in the status of the current frame and save in save_err
	mov             ch, 0
	test    ax, RX_RUNT
	je              RX_not_short
	or              ch, 02h
	jmp             short RX_crc_ok         ; as per str 172
RX_not_short:
	test    ax, RX_EXTRA_DATA
	je              RX_no_over_run
	or              ch, 10h
	jmp             short RX_crc_ok         ; as per str 172
RX_no_over_run:
	test    ax, RX_CRC_ERROR
	je              RX_crc_ok
	or              ch, 04h
RX_crc_ok:
	test    ax, RX_DRIBBLE
	je              RX_align_ok
	or              ch, 08h
RX_align_ok:
	mov             save_err, ch

recv_noerrs:
	mov             cx, RCV_HDR_SIZE                ; Read the header in.
	mov             ax, cs
	mov             es, ax
	mov             di, offset rcv_hdr
	call    repins

; Did we receive our own broadcast?
	mov             di, offset rcv_hdr+RBUF_HEAD_LEN+EADDR_LEN
	mov             si, offset my_address
	mov             cx, EADDR_LEN/2
	repe    cmpsw
	jne             not_our_own                             ; Jump if not
	to_scrn 23,79,'O'
	inc             received_ours                   ; Remember that we received it.
	jmp             short recv_update_discard

not_our_own:
	mov             cx,  WORD PTR rcv_hdr[RBUF_LEN_LOW]     ; Get frame length
	push    cx
	mov             ax, cs                  ; Set ds = code
	mov             ds, ax
	mov             es, ax
	assume  ds:code
	mov             di, offset rcv_hdr+RBUF_HEAD_LEN+EADDR_LEN+EADDR_LEN
	push    dx                                      ; Need to save the rx frame port address
	mov             dl, BLUEBOOK            ; Assume bluebook Ethernet.
	mov             ax, es:[di]                     ; Get the packet type
	xchg    ah, al
	cmp     ax, 1500
	ja              BlueBookPacket
	inc             di                                      ; Set di to 802.2 header
	inc             di
	mov             dl, IEEE8023
BlueBookPacket:
	mov             dh,     save_err                ; Get the error status into dh for Intel
	call    recv_find                       ; See if type and size are wanted
	pop             dx                                      ; Recover the rx frame port address
	pop             cx
	mov             ax, es                          ; Did recv_find give us a null pointer?
	or              ax, di                          ; ..
	je              recv_update_discard     ; If null, don't copy the data

	push    cx                                      ; We will want the count and pointer
	push    es                                      ;  to hand to client after copying,
	push    di                                      ;  so save them at this point

	push    cx                                      ; Move the receive header in.
	mov             si, offset rcv_hdr + RBUF_HEAD_LEN
	mov             cx, (RCV_HDR_SIZE - RBUF_HEAD_LEN)/2
	rep             movsw                           ; Move rest of packet
	pop             cx
								; Subtract off what we've already copied.
	sub             cx, RCV_HDR_SIZE - RBUF_HEAD_LEN
	xor             ax, ax                          ; Marker to round up the rx_dma_ptr
	call    repins                          ; Read the rest of the packet in.

	pop             si                                      ; Recover pointer to destination
	pop             ds                                      ; Tell client it's his source
	pop             cx                                      ; And it's this long
	assume  ds:nothing
	call    recv_copy                       ; Give it to him
	mov             ax, cs
	mov             ds, ax
	assume  ds: code
	jmp             recv_update

recv_update_discard:
	to_scrn 23,73,'D'

; Tell the chip to skip the rest of the packet
; Dx has been corrupted - quicker to reload rather than save dx
discard_frame_on_chip:
	LOAD_WRITE      PP_RxCFG
	inw
	or              ax, SKIP_1
	outw
	jmp             recv_update

discard_bad_frame:                                      ; Skip over the bad frame
	jmp             discard_frame_on_chip   ; Jump if so - simple skip will work

	public  timer_isr
timer_isr:
;if the first instruction is an iret, then the timer is not hooked
	iret

code    ENDS
	END
