;  Copyright, 1988-1992, Russell Nelson, Crynwr Software

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       Jan 17, 1996 - aherrera
;               Added external reference to mem_base.
;               Changed value of irq_map.
;               Added/removed/changed a number of print statements.
;               Read and saved a number of PnP parameters including memory base 
;               address.
;               Changed algorithm to check for vendor ID of ethernet controller.
;               Checked for the EISA id and part number according to driver built.
;               Added this header.
;       Jan 23, 1996 - aherrera
;               Added CSDEBUG to block out bios scanning debug routines.
;               Moved eeprom checksum calc to get_eeprom_data.
;               Added check for eeprom present.
;               Added bios scan for config info normally found in eeprom.
;               Added bios scanning debug routines and structures for embedded 
;               development.
;       Jan 26, 1996 - aherrera
;               Added support for setting ethernet address from command line.
;       Feb 14, 1996 - aherrera
;               Changed definition of auto_neg_cnf variable to be a pre-set
;               version of the auto_negitiation control register instead of a copy
;               of the eeprom word (Used to be OK in an earlier EEPROM version)
;       Feb 27, 1996 - aherrera
;               Added routines to implement Ignore Missing Media bit.
;               Media detection routines mangled to make it easier for me.
;       March 3, 1996 - aherrera
;               Removed dma support as per request.
;       March 14, 1996 - aherrera
;               Corrected error in reading autonegotiate word from eeprom.
;               Changed method of reading irq_map from PnP so as to not reuse
;               eeprom_buf.
;       Apr 10, 1996 - aherrera
;               Added range checking for parsing command line.
;               Changed method for checking product id to avoid id of the
;               wrong product as per Russ Nelson and Tony O'Toole's sugestions.
;       Apr 18, 1996 - aherrera
;               Corrected error mangling media detection routines. I should know better.
;       Apr 23, 1996 - aherrera
;               Removed setup_plug_and_play. The rationale is that if pnp has activated
;               our card, we will find it in the card scan. 
;               Removed mem_base.
;	Apr 25, 1995 - aherrera
;		Corrected result of bios_scan failure to use defaults instead 
;		of unloading.
;	30-Jul-96	aherrera
;		Removed printing word_msg.
;

ifdef CSDEBUG
include epktisal.lbl
endif


	include defs.asm
	include epktisa.inc
	include options.inc

code    SEGMENT word public
	assume  cs:code, ds:code
extrn   int_no                  : byte
extrn   decout                  : near
extrn   wordout                 : near
extrn   base_addr               : word
extrn   int_num                 : word
extrn   int_msg                                 : byte
extrn   isa_config              : word
extrn   curr_rx_cfg             : word
extrn   sys_features    : byte
extrn   free_mem                : word
extrn   repins                  : word
extrn   repouts                 : word
extrn   send_cmd                : word
extrn   reset_chip              : near
extrn   set_ether               : near
extrn   send_pkt                : near
extrn   wait_27ms               : near
NOWARN  RES
extrn   wait                    : near
WARN
extrn   pnp_card_no             : byte
extrn   chip_type               : word

extrn   flagbyte: byte
extrn   is_186                          : byte          ;=0 if 808[68], =1 if 80[123]86.
extrn   quick_rep_ins_16        : near
extrn   rep_ins_16                      : near
extrn   quick_rep_outs_16       : near
extrn   rep_outs_16                     : near
extrn   set_timeout                     : near
extrn   do_timeout                      : near

;any code after this will not be kept after initialization. Buffers
;used by the program, if any, are allocated from the memory between
;end_resident and end_free_mem.
	public end_resident,end_free_mem
end_resident    label   byte
end_free_mem    label   byte


	even

	extrn   get_hex: near
	include getea.asm
	include messages.inc
imm_flag                dw              0
media_type              dw      0
linectl                 dw      0                       ; save a copy of linectl reg
dc_dc_flag              dw              1               ; dc dc enable bit set in eeprom
io_range_err    db              "Error: I/O address out of range",CR,LF,'$'
multiple_cards  db      0                       ; Set if more than one 'matching' card is found
temp_storage    dw      0, 0
irq_convert_tbl db      0Ah, 0Bh, 0Ch, 05h
irq_map                 dw      0FFFFh    ; Mapping of the interrupt lines
CS89X0_int              dw      ?               ; Int number on the CS89X0 board
auto_neg_cnf                    dw      ?               ; Built from the EEPROM
adapter_cnf             dw      ?               ; Read from the EEPROM
no_prom                 db      0               ; <> 0 if ethernet address specified on command line
io_addr                 dw      0,0     ; I/O address specified on the command line

irq_map_buff    dw      (IRQ_MAP_LEN/2) dup (?)     
			

		even

ifdef CSDEBUG
; this is set up to test a possible embedded application where
; the configuration information is stored in a place in bios
; rather than on an eeprom. The signature should be on a 
; [cdef]000:200h byte boundary in a correct bios application, but 
; in this experiment we align the bios_signature on a 16 (010h) byte
; boundary to ease the problems with alignment.
			public bios_signature
			public padding
			public bios_configuration
			public eeprom_buff
; adjust padding so bios_signature in on a 010h byte boundary
padding                 db              02h dup (?)     
bios_signature          db              "$CS8900$" 
; check sum recalculated at runtime (for easy experimentation)
bios_configuration label word
			dw              00024h                  ; 00 (1Ch) Individual address
			dw              02010h                  ; 02 (1Dh) Individual address
			dw              00000h                  ; 04 (1Eh) Individual address
			dw              01103h                  ; 06 (1Fh) ISA Config
			dw              00000h                  ; 08 (20h) Mem Base
			dw              00D00h                  ; 0a (21h) Boot PROM Base
			dw              0FC00h                  ; 0c (22h) Boot PROM Mask
			dw              00000h                  ; 0e (23h) Auto Neg Control
			dw              08811h                  ; 10 (24h) Adapter Config
			dw              00000h                  ; 12 (25h) Version #
			dw              00000h                  ; 14 (26h) Reserved
			dw              0BF0Fh                  ; 16 (27h) Mfg Date
			dw              00024h                  ; 18 (28h) Individual address
			dw              02010h                  ; 1a (29h) Individual address
			dw              00000h                  ; 1c (2Ah) Individual address
			dw              00000h                  ; 1e (2Bh) Reserved
			dw              00000h                  ; 20 (2Ch) Reserved
			dw              00000h                  ; 22 (2Dh) Reserved
			dw              00000h                  ; 24 (2Eh) Reserved
			dw              0FFFFh                  ; 26 (2Fh) Check Sum

endif

; See Technical ref manual for details on this structure
; that mimicks the eeprom / bios configuration information
; This is a default configuration in case the eeprom fails.

cs8900_sign db      "$CS8900$"      ; cs8900 bios signature
eeprom_buff label word
			dw              00201h                  ; 00 (1Ch) Individual address
			dw              00403h                  ; 02 (1Dh) Individual address
			dw              00605h                  ; 04 (1Eh) Individual address
			dw              01103h                  ; 06 (1Fh) ISA Config
			dw              00000h                  ; 08 (20h) Mem Base
			dw              00000h                  ; 0a (21h) Boot PROM Base
			dw              00000h                  ; 0c (22h) Boot PROM Mask
			dw              00040h                  ; 0e (23h) Auto Neg Control
			dw              08811h                  ; 10 (24h) Adapter Config
			dw              00000h                  ; 12 (25h) Version #
			dw              00000h                  ; 14 (26h) Reserved
			dw              0BF0Fh                  ; 16 (27h) Mfg Date
			dw              00201h                  ; 18 (28h) Individual address
			dw              00403h                  ; 1a (29h) Individual address
			dw              00605h                  ; 1c (2Ah) Individual address
			dw              00000h                  ; 1e (2Bh) Reserved
			dw              00000h                  ; 20 (2Ch) Reserved
			dw              00000h                  ; 22 (2Dh) Reserved
			dw              00000h                  ; 24 (2Eh) Reserved
			dw              0FFFFh                  ; 26 (2Fh) Check Sum
			
			
 
	extrn   set_recv_isr: near

;enter with si -> argument string, di -> wword to store.
;if there is no number, don't change the number.
	extrn   get_number: near

;enter with dx -> argument string, di -> wword to print.
	extrn   print_number: near

;-> the Ethernet address of the card.
	extrn   rom_address: byte

;print the character in al.
	extrn   chrout: near

;print a crlf
	extrn   crlf: near

; Enter with si -> argument string.
; Skip spaces and tabs.  Exit with si -> first non-blank char.
	extrn   skip_blanks: near

	public  parse_args
parse_args:
; Exit with nc if all went well, cy otherwise.
	mov     di, offset io_addr
	call    get_number
; lets do range checking for very large numbers.
	cmp             word ptr [di+2], 0
	jnz             io_outta_range
	cmp             io_addr, 0
	jz              parse_int                                       ; if io address not set on command line
	cmp             io_addr, (FIRST_IO AND 0fff0h)  ;make sure that the io addr is in range
	jb              io_outta_range
	cmp             io_addr, (LAST_IO  AND 0fff0h)  ;make sure that the io addr is in range
	ja              io_outta_range
parse_int:
	; we'll do some range checking here for very large numbers, 
	; and we'll do more later
	mov     di, offset int_no
	call    get_number
	cmp             byte ptr [di+1], 0
	jnz             int_outta_range
	cmp             word ptr [di+2], 0
	jnz             int_outta_range
	call    skip_blanks
	cmp     al, CR                  ; Does an Ethernet address follow?
	je      parse_args_1            ; No.
	inc     no_prom                 ; We don't have an Ethernet PROM.
; Enter with ds:si -> Ethernet address to parse, es:di -> place to put it.
	movseg  es,ds
	mov     di, offset rom_address
	call    get_eaddr
parse_args_1:
	clc
	ret
io_outta_range:
	mov             dx,offset io_range_err
	jmp             short outta_range
int_outta_range:
	mov             dx,offset int_msg
outta_range:    
	mov             ah,9
	int             21h
	stc
	ret

	public  etopen
etopen:
; Initialize the driver.
; Fill in rom_address with the assigned address of the board.
	assume  ds : code, es : code
	mov     ax, cs                      ; Setup es = code
	mov     es, ax
	call    etopen_cs89X0
	jnc     etopen_ok
	print   no_card_found_msg
	mov     byte    ptr     no_card_found_msg, '$' ; No message any more
	ret

; Next check to see if interrupt is available for the board
etopen_ok : 
	mov     cx, WORD        PTR     int_no
	mov     ax, 0001h
	shl     ax, cl
	test    irq_map, ax                 ; If bit is set then this IRQ is OK
	jne     int_no_ok                   ; Jump if this interrupt is OK

; This routine goes through the IRQ map and informs the user which interrupts
; are available. The interrupt list is generated one by one and separated by
; commas except the last two interrupts which are separted with an '&'.
	print   int_bad_msg1
	print   this_chip
	print   int_bad_msg2
	mov     bx, irq_map
	mov     cx, 10h                     ; Maxiumum of 16 bits to process
next_irq_bit : 
	shr     bx, 1                       ; Get the next IRQ bit from the map
	jnc     irq_bit_not_set             ; Nothing to print if bit is not set
	mov     ax, 10h
	sub     ax, cx                      ; Ax = the bit position
	push    bx                          ; Decout routine corrupts bx and cx
	push    cx
	xor     dx, dx                      ; Decout routine prints 1 32 bit number with
	call    decout                      ;   the MSW in dx
	pop     cx
	pop     bx
	cmp     bx, 1                       ; Are there any more bits left if the IRQ map
	jbe     n_m_t_o_i_b_left            ; Jump if only one or if no more bits are set
	print   separator1_msg              ; More then 1 bit left, need a ',' to separate
	jmp     short   irq_bit_not_set
n_m_t_o_i_b_left : 
	jl      no_more_irq_bits            ; Jump if IRQ map is empty - no '&' required
	print   separator3_msg              ; Spearate output with a '&'
irq_bit_not_set : 
	loop    next_irq_bit                ; Contine until all bits ar processed
no_more_irq_bits : 
	call    crlf
	mov     dx, offset      dummy_msg   ; No other message to print
	stc                                 ; Return with an error status
	ret

int_no_ok : 
; Here with cx = IRQ number as seen by the board.
; Need to find which CS89X0 interrupt this is
	mov     bx, cx                      ; Get IRQ number into bx
	cmp     chip_type, CS8920           ; If this is a CS8920 then no int conversion
	je      short   no_int_conversion
	xor     bx, bx
	jcxz    found_it
	mov     ax, irq_map
next_irq_map_bit : 
	shr     ax, 1
	jnc     not_set
	inc     bx
not_set : 
	loop    next_irq_map_bit
found_it : 
	cmp     bx, 00h                     ; Is this the first int ?
	jne     not_first
	mov     bx, 4                       ; First interrupt (IRQ5) will be stored as the last
not_first : 
	dec     bx                          ; Interrupt used is stored as 0 - 3
no_int_conversion : 
	mov     CS89X0_int, bx

	mov     al, int_no                  ; Get board's interrupt vector
	add     al, 8
	cmp     al, 8 + 8                   ; Is it a slave 8259 interrupt?
	jb      set_int_num                 ; No.
	add     al, 70h - 8 - 8             ; Map it to the real interrupt.
set_int_num : 
	xor     ah, ah                      ; Clear high byte
	mov     int_num, ax                 ; Set parameter_list int num.

	call    set_recv_isr
	call    CS89X0_tx_rx_setup
	clc
	ret

	public  CS89X0_tx_rx_setup
CS89X0_tx_rx_setup      PROC    NEAR
	mov     bx, isa_config              ; Bx holds isa config throughout this routine
	cmp     chip_type, CS8900
	jne     cs8920_setup

	LOAD_WRITE      PP_CS8900_ISAINT    ; Specify which of the 3 interrupts to use
	mov     ax, CS89X0_int
	outw

;public cs8920_setup ; debug
cs8920_setup : 
	LOAD_WRITE      PP_CS8920_ISAINT    ; Specify which of the 11 interrupts to use
	inw
	mov     ax, CS89X0_int
	outw

do_common_setup : 
; Turn on both receive and transmit operations
	LOAD_WRITE       PP_LineCTL
	inw
	or      ax, SERIAL_RX_ON + SERIAL_TX_ON
	outw

; Receive only error free packets addressed to this card
	SET_WRITE       PP_RxCTL
	mov     ax, DEF_RX_ACCEPT
	outw

; Allow only RX and DMA events to interrupt
	SET_WRITE       PP_RxCFG
	mov     ax, RX_OK_ENBL + RX_CRC_ERROR_ENBL ; Receive OK frames and CRC errors

	test    bx, STREAM_TRANSFER         ; ISA configuration specifies stream mode
	je      no_stream_mode              ; Jump if not
	or      ax, RX_STREAM_ENBL          ; Enable stream transfer mode
;public no_stream_mode ; debug
no_stream_mode : 
	outw                                ; Set the RX configuration
	mov     curr_rx_cfg, ax             ; Save the current receive configuration

	SET_WRITE       PP_BufCFG
	xor     ax, ax
	outw

; Nothing to set in this register
	SET_WRITE       PP_TxCFG
	xor     ax, ax
	outw

; Allow interrupts to be generated by the chip
	SET_WRITE       PP_BusCTL
	mov     ax, ENABLE_IRQ              ; Allow the chip to interrupt
	outw
	ret
CS89X0_tx_rx_setup      ENDP


	public  print_parameters
print_parameters:
; Echo our command-line parameters
       mov             di, offset int_no
       mov             dx, offset int_no_name
       call    print_number
	mov             di, offset io_addr
	mov             dx, offset io_addr_name
	call    print_number
	ret
	

		public etopen_cs89X0

etopen_cs89X0   PROC    NEAR
	test    flagbyte, S_OPTION           ; Is force I/O scan option set ?
	jne     do_fuller_scan               ; Yes - perform the fuller (destructive) scan
	xor     bx, bx                       ; Set bx - 0 for search via the DATA port
	call    find_base                        ; Go and scan I/O for the card
	jnc     got_base_msg                 ; Jump if one card found
	cmp     multiple_cards, 0            ; Have multiple cards been found
	stc                                  ; Set carry to indicate an error
	jne     exit_etopen_cs89X0           ; Exit if so
do_fuller_scan : 
	mov     bx, DATA_PORT - ADD_PORT     ; Do the ADDRESS port search
	call    find_base                    ; Go and scan for the card
	jc      exit_etopen_cs89X0
got_base_msg : 
	print   non_pnp_card_msg             ; print scanned message
got_base : 
	call    get_chip_type                ; Is this an CS8900 or a CS8920
	jc      exit_etopen_cs89X0
	
	cmp     chip_type, CS8900           ; If this is a CS8900 ?
	je      cont_8900_open              ; Yes - no need to get irq etc.
	
	cmp     int_no, 0                   ; has the irq been set from command line?
	jne     cont_8900_open
public handle_8920 ;debug
handle_8920:    
	;------------------------------------------------------------------------------+
	;See If PNP is disabled
	;------------------------------------------------------------------------------+
	LOAD_WRITE	PP_SelfST
   	in    ax,dx
   	test  ax, PNPDISABLE                     ; Check if PNP is disabled
   	jnz    cont_8900_open
	
	; set up some stuff if we have an 8920 card
	LOAD_WRITE      PP_CS8920_ISAINT
	in      al, dx
	mov     int_no, al                  ; save interrupt

public cont_8900_open ; debug
cont_8900_open:
	call    reset_chip
	call    dump_eeprom                 ; Copy eeprom contents to RAM
	jc      exit_etopen_cs89X0
	call    get_settings                ; Get settings
	jnc     configure                   ; Carry clear if checksum is OK

	cmp     no_prom, 0                  ; Did they specify everything we need?
	jne     add_specified               ; Jump if so
	stc                                 ; Set carry flag - error status
	mov     dx, offset      missing_add_msg ; Set explanation of failure
	ret                                 ; Give up.
add_specified : 
	print   assumed_msg                 ; Yes, tell them we're assuming they're right.
configure : 
	call    set_defaults
	call    config_chip                 ; Configure chip
exit_etopen_cs89X0 : 
	ret
etopen_cs89X0   ENDP


set_defaults    PROC    NEAR
; Checks to see if the CS89X0 has been configured. If so then use those values.
	ret
set_defaults    ENDP

config_chip     PROC    NEAR
; Set the correct transfer routines
	cmp     is_186, 0                   ; Can we use fast routines ?
	je      slow_16_bit                 ; No - have to do use the slower routines
	mov     repins, offset  quick_rep_ins_16
	mov     repouts, offset quick_rep_outs_16
	jmp     short   routines_are_set
slow_16_bit : 
	mov     repins, offset  rep_ins_16
	mov     repouts, offset rep_outs_16
routines_are_set : 
;	print   word_msg                    ; Announce using word transfers

; Set the Individual address registers with the Ethernet address
	mov     si, offset      rom_address
	call    set_ether

; Set the LineCTL quintuplet based on adapter configuration read from EEPROM
	LOAD_WRITE      PP_LineCTL
	xor     ax, ax
	mov     bx, adapter_cnf             ; Copy of the adapter configuration
	mov     cx, bx                      ;   kept in bx and cx

; Test if the low rx squelch bit needed
	test    bx, A_CNF_EXTND_10B_2       ; Using an extended cable ?
	je      no_low_rx_squelch           ; No - then no need set low squelch
	test    bx, A_CNF_LOW_RX_SQUELCH    ; Configured for low squelch ?
	je      no_low_rx_squelch           ; No - then no need set low squelch
	or      ax, LOW_RX_SQUELCH          ; Both conditions met
no_low_rx_squelch : 
; Removed check for disabling autopolarity. 
; We want to do autopolarity all the time as per str 203
;       test    bx, A_CNF_NO_AUTO_POLARITY      ; Is auto polarity correction required
;       je              no_polarity_dis                         ; Jump if so - a 1 disables this
;       or              ax, NO_AUTO_POLARITY            ; Disable the polarity correction
no_polarity_dis : 
	mov     linectl, ax
;
; Check for media 
;
	test    cx, A_CNF_10B_T + A_CNF_AUI + A_CNF_10B_2
	jne     begin_detect 
	
	mov	media_type, A_CNF_MEDIA_AUTO
	call	print_no_circuit
	xor     cx, cx                      ; clear for no media
	stc
	ret
;
; Check for specified media
;
begin_detect : 
	mov     si, adapter_cnf		; get adapter config
	
        and     bx, A_CNF_MEDIA_TYPE        ; Clear all but the media select bits
        cmp     bx, A_CNF_MEDIA_AUTO        ; In Auto detect mode?
        jne     no_auto_detect              ; No - go and check the specified media
        or      ax, AUTO_AUI_10BASET        ; Set auto detect bit
	outw
	
	call 	do_autodetect
	jc      exit_config_chip
	jmp 	short set_up_message

no_auto_detect : 
        TEST_IMM_BIT                        ; check "ignore missing media" bit
        je      cont_detect                 ; Jump. I want to load only with cable
        mov     imm_flag, bx                ; set flag to media to force
cont_detect : 
	outw
	
	call    do_detect           	; Check out each medium, result in cx
	jc      exit_config_chip
set_up_message : 
	cmp     cx, A_CNF_MEDIA_10B_T       ; Configured for 10-Base-T ?
	jne     not_using_10B_T
	mov     dx, offset      using_10B_T_msg ; Setup message for twisted pair
	jmp     short   announce_media
not_using_10B_T : 
	cmp     cx, A_CNF_MEDIA_AUI         ; Configured for AUI ?
	jne     using_10B_2
	mov     dx, offset      using_AUI_msg ; Setup message for AUI
	jmp     short   announce_media
using_10B_2 : 
	mov     dx, offset      using_10B_2_msg ; Setup message for 10_Base_2
announce_media : 
	print_it
	cmp     cx, A_CNF_MEDIA_10B_T       ; Is 10-Base-T is being used
	jne     no_negotiation
	call    do_fdx_hdx_negotiation
no_negotiation : 
	clc
exit_config_chip : 
	ret
config_chip     ENDP



; assumes:
;       si=adapter configuration (circuitry on board)
;       bx=media cable requested
setup_dc_dc proc
	LOAD_WRITE       PP_SelfCTL          ; HCB1 used to enable DC/DC circuitry used
;  by the 10-Base-2 port (HCB1 is inverted)
	mov     ax, HCB1_ENBL               ; Enable the HCB1 bit as an output
	test    si, A_CNF_10B_2             ; Is there 10-Base-2 circuitry ?
	je      no_10B_2                    ; Jump if not
	cmp     bx, A_CNF_MEDIA_10B_2       ; Is 10-Base-2 the media to use
	jne     no_10B_2                    ; Jump if not
	or      ax, HCB1                    ; For 10-Base-2 enable DC/DC converter
no_10B_2 : 
	test    si, A_CNF_DC_DC_POLARITY    ; Check polarity of DC/DC enable bit
	je      dc_dc_polarity_ok           ; Jump if polarity is ok
	xor     ax, HCB1                    ; Inverse the state of the ouput bit
dc_dc_polarity_ok : 
	outw
	
	; Delay for the hardware to work out 
	mov             ax, 18              ; Wait about half a second.
	call            wait
	
	ret
setup_dc_dc endp


;
; If we get here, the eeprom says to use a certain media BUT
; the eeprom also says that the circuitry for that media
; does not exist!!!! .
;       
print_no_circuit proc
	cmp	media_type, A_CNF_MEDIA_10B_T
	je	config_problem_tp
	cmp	media_type, A_CNF_MEDIA_AUI
	je	config_problem_AUI
	cmp	media_type, A_CNF_MEDIA_10B_2
	je	config_problem_10B_2
	jmp	short config_problem
config_problem_AUI : 
	mov     bx, offset      cnf_AUI_prob ; Set appropriate message
	jmp     short   config_problem      ; Announce the problem
config_problem_10B_2 : 
	mov     bx, offset      cnf_10B_2_prob ; Set appropriate message
	jmp     short   config_problem      ; Announce the problem
config_problem_tp : 
	mov     bx, offset      cnf_10B_T_prob ; Set appropriate message
config_problem : 
	print   eeprom_cnf_prob             ; Announce that there is a config problem
	mov     dx, bx                      ; Dx = the offset of the specific problem
	print_it                            ; Print the specific problem
no_circuitry : 
	print   no_media_msg                ; Warn user that no circuitry is present
	ret
print_no_circuit endp


detect_coax proc
	cmp	bx, A_CNF_MEDIA_10B_2
	jne	failed_coax
	
	mov	bx, A_CNF_MEDIA_AUTO
	call	setup_dc_dc
	
	LOAD_WRITE      PP_LineCTL
	mov	ax, linectl
	and     ax, NOT AUTO_AUI_10BASET    ; Clear the auto detect bit
	or      ax, AUI_ONLY 
	outw
	
	call    send_setup                  ; Do the necessary setup

	test    si, A_CNF_10B_2             ; Any 10-Base-2 circuitry ?
	je      failed_coax_no_circuit

	LOAD_WRITE      PP_SelfCTL
	inw
	xor     ax, HCB1                    ; Inverse the converter enable - switch on
	outw
	
; Wait for the DC/DC converter to power up
	mov     ax, 18                      ; Wait about half a second.
	call    wait
 	call    send_test_pkt               ; Send a packet - carry is clear if sent ok
 	jc      turnoff_10B_2
force_10B_2:	
	mov     cx, A_CNF_MEDIA_10B_2       ; Set cx = configured for 10-Base-2
	clc
	ret
turnoff_10B_2 : 
	cmp	imm_flag, 0
	jne	force_10B_2
	LOAD_WRITE      PP_SelfCTL          ; Disable the DC/DC converter for 10-Base-2
	inw                                 ; Get current state
	xor     ax, HCB1                    ; Inverse the converter enable - switch off
	outw                                ; Disable 10-Base-2
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_coax
	mov     dx, offset 	no_10B_2_msg      
	print_it 
failed_coax:	
	xor 	cx, cx
	stc
	ret	
failed_coax_no_circuit:
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_coax
	call	print_no_circuit
	jmp 	failed_coax
detect_coax endp	


detect_aui proc
	cmp	bx, A_CNF_MEDIA_AUI
	jne	failed_aui
	
	call	setup_dc_dc
	
	LOAD_WRITE      PP_LineCTL
	mov	ax, linectl
	and     ax, NOT AUTO_AUI_10BASET    ; Clear the auto detect bit
	or      ax, AUI_ONLY
	outw
	
	call    send_setup                  ; Do the necessary setup
	
	test    si, A_CNF_AUI               ; Any AUI circuitry ?
	je      failed_aui_no_circuit       ; Jump if not
	
	call    send_test_pkt               ; Send a packet - carry is clear if sent ok
	jc      nothing_for_aui
force_aui:	
	mov     cx, A_CNF_MEDIA_AUI         ; Set cx = configured for AUI
	clc
	ret
nothing_for_aui : 
	cmp	imm_flag, 0
	jne	force_aui
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_aui
	mov     dx, offset      no_AUI_msg 
	print_it                            ; Print the specific problem
failed_aui:	
	xor 	cx, cx
	stc
	ret	
failed_aui_no_circuit:
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_aui
	call	print_no_circuit
	jmp 	failed_aui
detect_aui endp	


detect_tp proc
	cmp	bx, A_CNF_MEDIA_10B_T
	jne	failed_tp
	
	call	setup_dc_dc
	
; If connected to another full duplex capable 10-Base-T card the link pulses
; seem to be lost when the auto detect bit in the LineCTL is set.
; To overcome this the auto detect bit will be cleared whilst testing the
; 10-Base-T interface.  This would not be necessary for the sparrow chip but
; is simpler to do it anyway.
	LOAD_WRITE      PP_LineCTL
	mov	ax, linectl
	and     ax, NOT AUTO_AUI_10BASET    ; Clear the auto detect bit
	outw
; Delay for the hardware to work out if the TP cable is present - 150ms
	mov     ax, 18                      ; Wait about half a second.
	call    wait
	
	test    si, A_CNF_10B_T             ; Any 10-Base-T cricuitry ?
	je      failed_tp_no_circuit        ; Jump if not
	
	LOAD_WRITE       PP_LineST           ; Check for a 10-Base-T connection
	inw                                 ; Get current value
	test    ax, LINK_OK                 ; Using a twisted pair ?
	je      nothing_for_tp              ; No 
force_tp:	
	mov     cx, A_CNF_MEDIA_10B_T       ; Set cx = configured for 10-Base-T
	clc
	ret
nothing_for_tp : 
	cmp	imm_flag, 0
	jne	force_tp
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_tp
	mov     dx, offset      no_10B_T_msg 
	print_it                            ; Print the specific problem
failed_tp:	
	xor 	cx, cx
	stc
	ret	
failed_tp_no_circuit:	
	cmp	media_type, A_CNF_MEDIA_AUTO
	je	failed_tp
	call	print_no_circuit
	jmp 	failed_coax
detect_tp endp


; Input:
;	bx = media type requested (autodetect, tp, 10b2, aui)			 
; Output:
;	cx = media type found (0, tp, 10b2, aui)			 
;	carry set   = something went wrong
;	carry clear = something went right
do_detect       PROC NEAR
; Priority - 10-Base-T, AUI, 10-Base-10 :  Result returned in cx
	mov	media_type, bx
	call	detect_tp
	jnc	detected_it
	mov	bx, media_type
	call	detect_aui
	jnc	detected_it
	mov	bx, media_type
	call	detect_coax
	jnc	detected_it
	stc
detected_it:	
	ret	
do_detect       ENDP


; Input:
;	si = adapter_cnf
;	bx = media type requested
; Output:
;	cx = media type found (0, tp, 10b2, aui)			 
;	carry set   = something went wrong
;	carry clear = something went right
do_autodetect       PROC NEAR
; Priority - 10-Base-T, AUI, 10-Base-10 :  Result returned in cx
	mov	media_type, bx
	
	mov	bx,  A_CNF_MEDIA_10B_T
	call	detect_tp
	jnc	autodetected_it 
	
	mov	bx, A_CNF_MEDIA_AUI    
	call	detect_aui
	jnc	autodetected_it 
	
	mov	bx, A_CNF_MEDIA_10B_2
	call	detect_coax
	jnc	autodetected_it 
	
	mov     dx, offset      no_cable_msg 
	print_it                            ; Print the specific problem
	xor 	cx, cx
	stc
	ret	
autodetected_it:
	clc	
	ret
do_autodetect       endp


send_setup      PROC    NEAR
	test    si, A_CNF_AUI + A_CNF_10B_2 ; Any AUI or 10-Base-2 circuitry ?
	je      no_aui_10B2                 ; No - nothing to setup
; Set source and destination addresses in the test packet to be our address
	mov     ax, ds                      ; ES needs to be correct
	mov     es, ax
	mov     cx, EADDR_LEN/2             ; Number of words to copy
	push    si                          ; Still need adapter config info kept in si
	mov     si, offset      rom_address ; Our address
	mov     di, offset      test_packet ; Where to write the ethernet address
	rep     movsw
	mov     cx, EADDR_LEN/2             ; Number of word to copy
	mov     si, offset      rom_address ; Our address,  di is fine
	rep     movsw
	pop     si                          ; Get back adapter configuration
	LOAD_WRITE      PP_LineCTL          ; Now enable transmission of packets
	inw
	or      ax, SERIAL_TX_ON
	outw
no_aui_10B2 : 
	ret
send_setup      ENDP


not_sent_msg db "test packet failed on send", CR, LF, '$'       
tx_fail_msg db "test packet failed on send OK", CR, LF, '$'     

send_test_pkt   PROC    NEAR
; Send a test packet - return with carry clear if carrier bits are ok
	push    cx                          ; Need to preserve cx and si
	push    si
	mov     cx, RUNT                    ; Minimal packet size
	mov     si, offset      test_packet ; Setup start address of packet
	call    send_pkt                    ; Send it
	jc      not_sent                    ; No media if any problem
	call    wait_27ms                   ; Wait for packet to be sent
	LOAD_WRITE      PP_TxEvent          ; Get the TxEvent register
	inw
	and     ax, TX_SEND_OK_BITS         ; Mask all but 2 carrier bits and TxOK Bit
	cmp     ax, TX_OK                   ; Only the TX_OK bit should be set
	jne     not_sent                    ; If not then return with carry set
	clc                                 ; Carrier bits and TX bit ok, return with
	jmp     short   sent_ok             ;   carry clear, we have found the media!
not_sent :                                  ; Carrier problem or not sent
	stc                                 ; Return with carry set
sent_ok : 
	pop     si
	pop     cx
	ret
send_test_pkt   ENDP


do_fdx_hdx_negotiation  PROC NEAR
	cmp     chip_type, CS8900           ; If this is a CS8900 ?
	je      exit_do_fdx_neg             ; Yes - no need to negociate

	LOAD_WRITE      PP_AutoNegCTL       ; Point to the negotiation port
	mov     ax, auto_neg_cnf            ; Get configuration read from the EEPROM
	and     ax, AUTO_NEG_MASK           ; Mask the reserved bits
	outw                                ; Send configuration to the port
	and     ax, AUTO_NEG_BITS           ; Ignore ALLLOW FDX and NEGOCIATE NOW bits
	cmp     ax, AUTO_NEG_ENABLE         ; Check if stauts allows auto hengoctaion
	je      do_negotiation              ; Jump if config allows negotiation
	SET_WRITE       PP_AutoNegST        ; Point to the negotiation status
	inw                                 ; Get status of the 10-Base-10 link
	jmp     short   negotiation_done
do_negotiation : 
	print   negotiation_msg             ; Announce that negotiation is in progress
	mov     ax, 140                     ; Wait, if necessray, for nearly four
	call    set_timeout                 ;    seconds (120 is too small)
	LOAD_WRITE      PP_AutoNegST        ; Point to the negotiation status (dx lost)
get_link_status : 
	inw                                 ; Get status of the 10-Base-2 link
	test    ax, AUTO_NEG_BUSY           ; Will be zero when the negocation is done
	je      negotiation_done            ; Jump if so
	call    do_timeout                  ; Any more time left ?
	jnz     get_link_status             ; Continue to wait if so
	print   neg_problem_msg             ; Otherwise announce negotiation problem
	jmp     short   exit_do_fdx_neg

negotiation_done : 
	test    ax, FDX_ACTIVE              ; Is this a full duplex link ?
	je      half_duplex                 ; Jump if not
	print   full_duplex_msg             ; Announce full duplex
	jmp     short   exit_do_fdx_neg
half_duplex : 
	print   half_duplex_msg             ; Announce half duplex
exit_do_fdx_neg : 
	ret
do_fdx_hdx_negotiation  ENDP


	public  find_base
find_base       PROC    NEAR
; Routine may be called twice :
; If bx = 0 a non-destructive scan is performed via the data port.
; Depending on the state of the CS89X0 chip it may not be found via
; this simple scan. If bx = 2 a destructive scan is performed via the
; address port (destructive = a write is performed to the chip during
; process of confirming that it is a CS89X0).
	test    flagbyte, S_OPTION          ; Is force I/O scan option set ?
	jnz     full_scan                   ; Yes - perform a full scan
	cmp     io_addr, 00h                ; Has the base io address been specified
	je      full_scan                   ; No - do a scan
	mov     dx, io_addr                 ; Start scan from specified address
	add     dx, DATA_PORT
	mov     di, dx                      ; DI holds last I/O address to examine
	jmp     short   adj_port

full_scan : 
	mov     dx, FIRST_IO                ; First I/O Address to examine
	mov     di, LAST_IO                 ; DI holds last I/O address to examine
adj_port : 
	sub     dx, bx                      ; Still at the data ports for the first search
	sub     di, bx                      ; At the address ports for the second call
f_b_cont : 
	inw                                 ; Read the word at the DATA/ADDRESS port
	or      bx, bx                      ; Are we doing a read from the data port
	jz      read_from_d_port            ; Jump if so
	and     ax, ADD_MASK                ; Mask off bits not required
	cmp     ax, ADD_SIG                 ; Do we have the address signature
	jnz     no_sig                      ; Skip packet memory test if no sig

	xor     ax, ax
	outw                                ; Output 0 to the address port.
	add     dx, DATA_PORT - ADD_PORT    ; Now pointing to the DATA port
	inw                                 ; Read the word at location 0
	sub     dx, DATA_PORT - ADD_PORT    ; Now pointing to the ADDRESS port

read_from_d_port : 
	cmp     ax, CHIP_EISA_ID_SIG

	jne     no_sig                      ; Jump if expected signature was not found
	cmp     base_addr, 0h               ; Value should initially be zero
	je      first_found                 ; Ok to proceed
	push    dx
	sub     dx, DATA_PORT               ; Get the BASE port
	add     dx, bx                      ; Compensate for reading from the ADDRESS port
	cmp     base_addr, dx               ; Is this the same IO base address ?
	pop     dx
	je      no_sig                      ; Yes - found earlier by P & P, continue scan
	call    found_many                  ; Deal with multiple cards
	jmp     short   no_sig              ; Continue the search

first_found : 
	mov     base_addr, dx               ; Store the address of the DATA/ADDRESS port
	sub     base_addr, DATA_PORT        ; Get the BASE port
	add     base_addr, bx               ; Compensate for reading from the ADDRESS port

no_sig : 
	add     dx, 10h                     ; Advance the I/O address
	cmp     dx, di                      ; Have we checked them all ?
	jb      f_b_cont                    ; No - then continue
	cmp     base_addr, 0h               ; Did we find a controller ?
	jz      f_b_failed                  ; No - then go and complain       
	cmp     multiple_cards, 0           ; Have multiple cards been found ?
	jnz     short   f_b_failed2         ; Jump if so
	
	mov     ax, base_addr               ; Copy address for the print params routine
	mov     io_addr, ax
	
exit_ok_find_base : 
	clc
	ret
f_b_failed : 
	cmp     io_addr, 0h                 ; Was a base address specified
	jz      f_b_failed1                 ; No - then the scan failed
	mov     dx, offset      specified_failed
	jmp     short   f_b_failed3
f_b_failed1 : 
	mov     dx, offset      scan_failed ; Message to announce later
	jmp     short   f_b_failed3
f_b_failed2 : 
	mov     dx, offset      specify_which_msg
f_b_failed3 : 
	stc                                 ; Set carry and return
	ret
find_base       ENDP


found_many      PROC    NEAR
	; Called when multiple cards are found
	push    bx
	push    di
	push    dx
	cmp             multiple_cards, 0       ; Have multiple cards been previously found
	jnz             no_need_m_error         ; Jump if so
	mov             multiple_cards, 1       ; Mark for next time
	print   more_than_one_msg       ; Announce the multiple cards problem
	mov             ax, base_addr           ; Display the IO address of the first card
	mov             di, offset temp_storage
	mov             [di], ax
	mov             dx, offset dummy_msg
	call    print_number            ; (Corrupts bx)
no_need_m_error:
	pop             ax                                      ; Display the IO base address of current card
	push    ax
	sub             ax, DATA_PORT           ; Get the BASE port
	add             ax, bx                          ; Compensate for reading from the ADDRESS port
	mov             di, offset temp_storage
	mov             [di], ax
	mov             dx, offset dummy_msg
	call    print_number
	pop             dx
	pop             di
	pop             bx
	ret
found_many      ENDP


	public  get_chip_type
get_chip_type   PROC    NEAR
	LOAD_WRITE      <PRODUCT_ID_ADD + AUTOINCREMENT>
	inw
	mov             bx, ax                              ; Store for later use of revison bits
	and             ax, REVISION_MASK                                       ; Mask off the revison bits
	
	cmp                             ax, CS8900                                                      ; am I an 8900?
	je                              ok_productid
	cmp             ax, CS8920M                         ; Is this a mongoose?
	je              im_mongoose                             ; Jump if yes
	cmp             ax, CS8920                          ; Is this an 8920 
	jne             bad_productid                           ; Jump if not
im_mongoose:
	mov             WORD PTR chip_is_a_mongoose, " M"   ; Mark the name
	mov             ax, CS8920                          ; Fix monoose ID to be a CS8920
ok_productid:
	mov             chip_type, ax                           ; Chip type stored for rest of code
	rol             ax, 1                               ; Get chip part bits to LSBits
	rol             ax, 1                               ; Get chip part bits to LSBits
	rol             ax, 1                               ; Get chip part bits to LSBits
	add             al, '0'                             ; Convert to an ASCII value
	mov             chip_part_no, al                        ; Store in the chip name
	and             bx, REVISION_BITS                       ; Mask all but the revison bits
	add             bh, 'A'                             ; Convert to a character
	mov             chip_rev_no, bh                         ; Store in the chip name
;       print   chip_type_msg                                   ; Display chip name
;       print   chip_rev_msg                                    ; Display chip revison

	; Check the chip type and revision in order to set the correct send command
	; CS8920 revision C and CS8900 revision F can use the faster send
	mov             ax, TX_AFTER_381                        ; Default "slow" send command
	mov             bl, 'F'                             ; Revision number for CS8900
	cmp             chip_type, CS8900                       ; Is this is a CS8900 ?
	je              revision_letter_ok                      ; Jump if so - revison letter is set
	mov             bl, 'C'                             ; Set revision letter for CS8920
revision_letter_ok:
	cmp             chip_rev_no, bl                         ; Is this an earlier revision
	jb              set_send_cmd                            ; Yes - jump and use the slow send
	mov             ax, TX_NOW                          ; Use faster send command
set_send_cmd:
	mov             send_cmd, ax                            ; Set the send command
	clc
	ret
bad_productid:
	stc
	ret     
get_chip_type   ENDP


ifdef CSDEBUG

; Use these routines to debug scan bios
;
	public eeprom_no
	public eeprom_no_msg
	public eeprom_addr
eeprom_no       dw      ?
			dw      0
eeprom_no_msg   db      "eeprom word  $ "
eeprom_addr     dw      ?
			dw      0

extrn dwordout:near

pushall  macro
	pushf
	push    ax
	push    bx
	push    cx
	push    dx
	push    si
	push    di
	push    ds
	push    es
endm

popall macro
	pop             es
	pop             ds
	pop             di
	pop             si
	pop             dx
	pop             cx
	pop             bx
	pop             ax
	popf
endm

	public print_eeprom_no
print_eeprom_no proc
; enter with dx -> dollar terminated name of number, 
; di ->dword (number) to print
;exit with the number printed and the cursor advanced to the next line.
	pushall

	mov             dx, offset eeprom_no_msg
	mov             ah,9                    ;print the name of the number.
	int             21h

	mov             di, offset eeprom_addr
	mov             al, '0'
	call    chrout
	mov             al, 'x'
	call    chrout
	mov             ax, [di]                ;print the number in hex.
	mov             dx, [di+2]
	call    dwordout

	mov             al,' '
	call    chrout
	mov             al,':'
	call    chrout
	mov             al,' '
	call    chrout

	mov             di, offset eeprom_no
	mov             al,'0'
	call    chrout
	mov             al,'x'
	call    chrout
	mov             ax, [di]                ;print the number in hex.
	mov             dx, [di+2]
;        mov             bx, ax
;        or              bx, dx
;        jnz             do_nonzero
;        mov             al,'0'
;        call    chrout
;        xor             ax, ax
;        xor             dx, dx
;do_nonzero:
	call    dwordout
	call    crlf

	popall
	ret
print_eeprom_no endp


; print out the eeprom contents
	public print_eeprom_buff
print_eeprom_buff proc
	push    ax
	push    bx
	push    cx
	push    dx
	push    di
	push    si

	mov             si, offset eeprom_buff          ; get pointer to copy of eeprom
	mov             cx, CHKSUM_LEN                  ; get number of words to read
next_eeprom_word:
	mov             eeprom_addr, si
	mov             ax, [si]        
	add             si, 2
	mov             eeprom_no, ax
	call    print_eeprom_no
	loop    next_eeprom_word

	pop             si
	pop             di
	pop             dx
	pop             cx
	pop             bx
	pop             ax
	ret
print_eeprom_buff endp


; calulate the checksum for the bios_configuration
; structure
set_bios_chksum proc
	pushall

	mov             bx, offset bios_configuration
	mov             cx, CHKSUM_LEN - 1
	xor             ax, ax
next_bios_word:
	add             ax, [bx]                        ; add up all the words
	add             bx, 2
	loop    next_bios_word
	xor             ax, 0ffffh                      ; calc complement for zero check sum
	inc             ax
	mov             [bx], ax                        ; place new check sum in structure

	popall
	ret
set_bios_chksum endp
endif

; scan bios for '$CS8900$' string
;
; Input:        dx = segment to search
;               bx = end offset (assumes start from 0)
; Return:       carry clear = success
;               es:di = pointer to start of bios config data
;               carry set = failure
	public scan_bios
scan_bios proc
	mov             es, dx
	xor             di, di
check_next_bios_address:
	mov             cx, 4                                                   ; Number of words to check
	mov             si, offset cs8900_sign                  ; signature
	repe cmpsw       
	je              maybe_cs8900                            ; if I match, jump to check it out
get_next_address:
	and             di, 0fff0h                                                 ; back up offset
	add             di, BIOS_OFFSET_INC             ; bump up offset (assuming I'll wrap to zero)
	cmp             bx, di                          ; check for end point
	jnz             check_next_bios_address         ; keep looping
	
	stc                                             ; Flag error
	ret 
	public maybe_cs8900
maybe_cs8900:
	; look for valid version number
	cmp             word ptr es:[di+EEVER_NUMBER], 1 ; version number < 1?
	jg              get_next_address               ; jump if not

	; calculate valid checksum 
	mov             cx, CHKSUM_LEN                  ; Number of words in the checksum
	xor             ax, ax                          ; Initialize the checksum
check_next_word:
	add             ax, es:[di]                     ; Form the checksum
	inc             di
	inc             di
	loop    check_next_word
	sub             di, CHKSUM_LEN * 2                  ; Recover value of di prior to the check
	or              ax, ax                                          ; Set the flags = result of checksum test
	jne             get_next_address                        ; Contine the search if checksum <> 0
	
	clc                                                                                             ; Flag found    
	ret
scan_bios endp

; find eeprom or bios configuration data and dump it into
; a local buffer
	public dump_eeprom
dump_eeprom     PROC    NEAR
	push    bx
	push    cx
	push    dx
	push    di
	push    si

	; First check to see if an EEPROM is attached
	LOAD_WRITE PP_SelfST
	inw
	test    ax, EEPROM_PRESENT                     ; Does EEPROM EXIST ?
	jnz     eeprom_is_there                        ; Yes it does

	; If I get here, I have no eeprom or the eeprom
	; has problems being read.
	; Scan bios for $CS8900$ string for config. info
check_for_bios_config:
	print   no_eeprom_msg

ifdef CSDEBUG
	call set_bios_chksum
endif

	push            es

	mov             dx, BIOS_START_SEG              ; set segment
	xor             bx, bx
check_next_seg: 
	call            scan_bios               ; look for string
	jnc             copy_bios_config        ; found it
	
	xor             bx, bx                  ; end offset (0 = full segment)
	add             dx, 01000h              ; move to next segment
	jz              no_bios_config          ; if I haven't found the string ...
	cmp             dx, 0f000h              ; look for final segment
	jne             check_next_seg
	mov             bx, BIOS_LAST_OFFSET    ; Tech ref calls for ending here
	jmp             check_next_seg
	
no_bios_config: 
	pop         es
	print no_bios_msg
	
	stc                                                                             ; Flag error
	jmp         short eeprom_faked 
	
copy_bios_config:
	; If I get here, I have found the configuration data in the BIOS
	; so move the configuration data into the buffer (assuming I don't
	; wrap at end of segment)
	print   yes_bios_msg

	mov     si, di                          ; swap
	mov     cx, CHKSUM_LEN                  ; Number of words to read
	mov     di, offset eeprom_buff          ; Where to write the data
	xor     bx, bx
copy_config:
	mov     ax, es:[si][bx]                 ; move that data
	mov     [di][bx], ax
	inc     bx
	inc     bx
	loop    copy_config                                                                                      
	
	pop         es
	clc                                     ; flag as OK
	jmp     short eeprom_faked    
eeprom_is_there:
    print   yes_eeprom_msg
	
	mov     bx, START_EEPROM_DATA           ; Offset into eeprom for start of data
	mov     cx, CHKSUM_LEN                  ; Number of words to read
	mov     di, offset eeprom_buff          ; Where to write the data
	
	call    get_eeprom_data                 ; Get the data
	jnc     eeprom_read_exit                                ; jump if OK

	; if I'm here a read error occurred
	; Try scanning for bios configuration
	print   eeprom_read_msg                                 ; print error message
	jmp             check_for_bios_config                   ; something went wrong

eeprom_faked:
	jnc     eeprom_read_exit	; jump if I found bios config in memory
	print   bios_read_msg           ; print error message
	
	or      no_prom, 0              ; Everything on command line? (clc implied here)
	jnz     eeprom_read_exit        ; Jump if so 
	stc                                                             ; set carry again (we're a gonner)
eeprom_read_exit:
ifdef CSDEBUG
	; print what we dumped to the local eeprom buffer
	call    print_eeprom_buff
endif
	pop             si
	pop             di
	pop             dx
	pop             cx
	pop             bx
	ret
dump_eeprom     ENDP


WAIT_EEPROM_READY MACRO
	local   wait_until_clear, wait_clear_done
; check to see if the EEPROM is ready,  a timeout is used - just in case
; EEPROM is ready when SI_BUSY in the PP_SelfST is clear
	LOAD_WRITE      PP_SelfST
	mov             ax, 40
	call    set_timeout
wait_until_clear:
	inw
	test    ax, SI_BUSY                             ; Is the chip ready ?
	jz              wait_clear_done                         ; Yes it is
	call    do_timeout                                      ; Check if there is more time left
	jnz             wait_until_clear                        ; Continue to wait only if no timeout
	jmp             short eeprom_read_problem       ; Ran out of time
wait_clear_done:
	ENDM


get_eeprom_data PROC NEAR
					; Called with :
					; bx = starting offset address in the EEPROM
					; cx = number of bytes to read
					; ds:di = buffer to place the data

	LOAD_PORT       DATA_PORT
get_next_eeprom_byte:
	WAIT_EEPROM_READY

	SET_PORT        ADD_PORT                                ; Now send the EEPROM read command
	mov             ax, PP_EECMD
	outw
	SET_PORT        DATA_PORT
	mov             ax, bx                                          ; Get the next EEPROM location to read
	or              ax, EEPROM_READ_CMD
	outw

	WAIT_EEPROM_READY

	SET_PORT        ADD_PORT
	mov             ax, PP_EEData
	outw
	SET_PORT        DATA_PORT
	inw
	stosw
	inc             bx                      ; advance the EEPROM address
	loop    get_next_eeprom_byte

	; Now check the eeprom data for the correct checksum
	mov             si, offset eeprom_buff  ; Offset of data
	mov             cx, CHKSUM_LEN          ; Words to chksum
	xor             bx, bx                  ; Seed chksum buffer so that final sum is 0
chksum_loop:
	lodsw                                   ; get a word
	add             bx, ax                  ; sum it
	loop                    chksum_loop
	or              bx, bx                  ; Does it sum to correct signature?
	jnz             eeprom_checksum_problem

	clc
	ret
eeprom_checksum_problem:
	print   eeprom_chksum_bad
eeprom_read_problem: 
	stc
	ret
get_eeprom_data ENDP


	public get_settings
get_settings    PROC    NEAR
	cmp     no_prom, 0                  ; Did user specified ethernet address ?
	jne     user_address                ; Yes - no need to read the eeprom address

	mov     ax, ds                      ; ES needs to be correct to copy the
	mov     es, ax                      ;   ethernet address from the eeprom buffer
	mov     cx, EADDR_LEN/2             ; Number of word to move/byte swap
	mov     di, offset      rom_address ; Where to write the ethernet address
	mov     si, offset      eeprom_buff
	rep     movsw

user_address : 
; Get various (3) configuration words form the EEPROM
	mov     ax, eeprom_buff[AUTO_NEG_CNF_OFFSET] ; get transmission control word
	and     ax, EE_AUTO_NEG_CNF_MASK    ; keep the autonegotiation bits
	mov     auto_neg_cnf, ax            ; Store auto negotiation configuration
	mov     ax, eeprom_buff[ADAPTER_CNF_OFFSET]
	mov     adapter_cnf, ax             ; Store adapter configuration
	test    ax, A_CNF_DC_DC_POLARITY    ; check bit (default is 1)
	jnz     short   dc_dc_set
	mov     dc_dc_flag, 0               ; clear the bit
dc_dc_set : 

	mov     ax, eeprom_buff[ISA_CNF_OFFSET]
	mov     isa_config, ax              ; Store ISA configuration

	cmp     chip_type, CS8900           ; If this is a CS8900 then no pnp soft
	je      get_irq_dma_from_eeprom     ;   reset problem
;       
; If I'm here, I'm looking at 8920
;
	LOAD_WRITE      PP_CS8920_ISAINT    ; Check if the ISA IRQ has been set 
	inw
	and     ax, 00ffh                   ; Mask upper 8 bits and set flags
	je      get_from_eeprom             ; Jump if no interrupt is set
	cmp     al, CS8920_NO_INTS          ; Make certain the int value within range
	ja      get_from_eeprom             ; If invalid get settings from EEPROM
	mov     CS89X0_int, ax
	cmp     int_no, 00                  ; Check if int no was set on command line
	jne     int_no_set1                 ; Jump if so
	mov     int_no, al

int_no_set1 : 
	jmp     short   do_irq_map

get_from_eeprom : 
	cmp     pnp_card_no, 0              ; Has a Plug and Play card been found ?
	jne     do_irq_map                  ; Jump if so - IRQ is set

	mov     ax, isa_config              ; Recover ISA configuration
get_irq_dma_from_eeprom : 
	mov     cx, ax                      ; ISA config now in cx
	and     ax, INT_NO_MASK
	cmp     chip_type, CS8900           ; If this is a CS8900 then convert int no
	jne     no_irq_conversion
	mov     bx, offset      irq_convert_tbl
	xlat
no_irq_conversion : 
	cmp     int_no, 00                  ; Check if int no was set on command line
	jne     int_no_set2                 ; Jump if so
	mov     int_no, al
int_no_set2 : 
do_irq_map : 
	call    get_irq_map
	clc
	ret
get_settings    ENDP

; Get irq map from plug n play area
; (I'm assuming 8920 will never have eeprom embedded in bios)
ifdef CSDEBUG
	 public get_irq_map ; debug
endif
get_irq_map     PROC    NEAR
	cmp             chip_type, CS8900               ; If this is a CS8900 then there is no
	jne             read_map_from_eeprom    ; IRQ map in the EEPROM - jump if a CS8920
	mov             irq_map, CS8900_IRQ_MAP ; Setup the fixed IRQ map for the CS8900
	jmp             short no_irq_map
read_map_from_eeprom:
	mov             bx, IRQ_MAP_EEPROM_DATA ; Offset into eeprom for start of IRQ map
	mov             cx, IRQ_MAP_LEN/2               ; Number of words to read
	mov             di, offset  irq_map_buff     ; Where to write the data
	call                    get_eeprom_data                 ; Get the data
	jc              no_irq_map                              ; Don't set map if there is a read problem
	cmp             BYTE PTR irq_map_buff, PNP_IRQ_FRMT      ; Check for the IRQ format
	jne             no_irq_map                              ; Jump if not
	mov             ax, irq_map_buff+1               ; Get the IRQ map from the EEPROM data
	mov             irq_map, ax                             ; Store the map
no_irq_map:
	ret
get_irq_map     ENDP


test_packet:
	db              EADDR_LEN dup (?)
test_packet1:
	db              EADDR_LEN dup (?)
	db              0Ah, 0Ah                                                ; set for my test protocol
	db              (RUNT - EADDR_LEN*2 - 2) dup (?)
	

code    ENDS
	END
