;  Copyright, 1988-1992, Russell Nelson, Crynwr Software

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       File: epktisa.inc
;
;       Jan 17, 1996 - aherrera
;               Set up to change "my_name" based on which driver is being built.
;               Changed EISA_ID_SIG and PART_NO_SIG to be dependent on the 
;               driver being built.
;               Changed CS8920_NO_INTS to allow different max interrupt allowed 
;               (0x0F).
;               Changed LAST_IO port to scan (0x037C).
;               Created contants to access memory base address: PP_CS8920_ISAMemB, 
;               ISAMemoryBase8920, PNP_CNF_MEM. 
;               Added this header.
;       Jan 19, 1996 - aherrera
;               Added constants for scanning bios for "eeprom" configuration info.
;               Added CSDEBUG to block out bios scanning debug features.
;               Feb 14, 1996 - aherrera
;                               Defined IMM bit for eeprom and added macro to test for it.
;               Mar 14, 1996 - aherrera
;                               Added defines for eeprom autonegotiate bits.
;

ifdef IBMEIPKT
	my_name equ <"IBM EtherJet ISA Adapter">
else
	my_name equ <"CS89X0">
endif

PacketPage_base     EQU 0

PP_ChipID           EQU 0000h

ChipEISA_ID         EQU PacketPage_base + 0000h
; /* offset   0h -> Corp -ID              */
; /* offset   2h -> Model/Product Number  */
; /* offset   3h -> Chip Revision Number  */

PP_ISAIOB           EQU 0020h
ISAIOBaseAddress    EQU PacketPage_base + PP_ISAIOB ; IO base address
PP_CS8900_ISAINT    EQU 0022h
ISAIntNumCS8900     EQU PacketPage_base + PP_CS8900_ISAINT ;ISA interrupt select
PP_CS8920_ISAINT    EQU 0370h
ISAIntNumCS8920     EQU PacketPage_base + PP_CS8920_ISAINT ;ISA interrupt select
PP_CS8900_ISADMA    EQU 0024h
ISADmaChanCS8900    EQU PacketPage_base + PP_CS8900_ISADMA ;ISA Rec DMA channel
PP_CS8920_ISADMA    EQU 0374h
ISADmaChanCS8920    EQU PacketPage_base + PP_CS8920_ISADMA ;ISA Rec DMA channel
PP_ISASOF           EQU 0026h
ISADmaStartOfFrameOffset    EQU PacketPage_base + PP_ISASOF ; ISA DMA offset
PP_DmaFrameCnt      EQU 0028h
ISADmaFrameCount    EQU PacketPage_base + PP_DmaFrameCnt    ; ISA DMA Frame count
PP_DmaByteCnt       EQU 002Ah
ISADmaByteCount     EQU PacketPage_base + PP_DmaByteCnt ; ISA DMA Byte count
PP_ISAMemB          EQU 002Ch
ISAMemoryBaseAddress    EQU PacketPage_base + PP_ISAMemB    ; Memory base

PP_CS8920_ISAMemB       EQU     0348h
ISAMemoryBase8920       EQU     PacketPage_base + PP_CS8920_ISAMemB

PP_ISABootBase      EQU 0030h
BootPROMBaseAddress EQU PacketPage_base + PP_ISABootBase    ; Boot Prom base 
PP_ISABootMask      EQU 0034h
BootPROMAddressMask EQU PacketPage_base + PP_ISABootMask    ; Boot Prom Mask

; EEPROM data and command registers
PP_EECMD            EQU 0040h
EepromCommand       EQU PacketPage_base + PP_EECMD  ; NVR Interface Command register
PP_EEData           EQU 0042h
EepromData          EQU PacketPage_base + PP_EEData ; NVR Interface Data Register
PP_DebugReg         EQU 0044h
DebugRegister       EQU PacketPage_base + PP_DebugReg   ; Debug Register

PP_RxCFG            EQU 0102h
RxConfigReg         EQU PacketPage_base + PP_RxCFG  ; Rx Bus config
PP_RxCTL            EQU 0104h
RxControlReg        EQU PacketPage_base + PP_RxCTL  ; Receive Control Register
PP_TxCFG            EQU 0106h
TxConfigReg         EQU PacketPage_base + PP_TxCFG  ; Transmit Config Register
PP_TxCMD            EQU 0108h
TxCommandReg        EQU PacketPage_base + PP_TxCMD  ; Transmit Command Register
PP_BufCFG           EQU 010Ah
BufConfigReg        EQU PacketPage_base + PP_BufCFG ; Bus configuration Register
PP_LineCTL          EQU 0112h
LineControlReg      EQU PacketPage_base + PP_LineCTL    ; Line Config Register
PP_SelfCTL          EQU 0114h
SelfControlReg      EQU PacketPage_base + PP_SelfCTL    ; Self Command Register
PP_BusCTL           EQU 0116h
BusControlReg       EQU PacketPage_base + PP_BusCTL ; ISA bus control Register
PP_TestCTL          EQU 0118h
TestControlReg      EQU PacketPage_base + PP_TestCTL    ; Test Register
PP_AutoNegCTL       EQU 011Ch
AutoNegControl      EQU PacketPage_base + PP_AutoNegCTL ; Auto Negotiation Ctrl

PP_ISQ              EQU 0120h
InterruptStatusQueue    EQU PacketPage_base + PP_ISQ    ; Interrupt Status
PP_RxEvent          EQU 0124h
RxEventReg          EQU PacketPage_base + PP_RxEvent    ; Rx Event Register
PP_TxEvent          EQU 0128h
TxEventReg          EQU PacketPage_base + PP_TxEvent    ; Tx Event Register
PP_BufEvent         EQU 012Ch
BufEventReg         EQU PacketPage_base + PP_BufEvent   ; Bus Event Register
PP_RxMiss           EQU 0130h
RxMissCount         EQU PacketPage_base + PP_RxMiss     ; Receive Miss Count
PP_TxCol            EQU 0132h
TxColCount          EQU PacketPage_base + PP_TxCol  ; Receive Collision Count
PP_LineST           EQU 0134h
LineStatusReg       EQU PacketPage_base + PP_LineST     ; Line State Register
PP_SelfST           EQU 0136h
SelfStatusReg       EQU PacketPage_base + PP_SelfST     ; Self State register
PP_BusST            EQU 0138h
BusStatusReg        EQU PacketPage_base + PP_BusST      ; Bus Status
PP_TDR              EQU 013Ch
TDRReg              EQU PacketPage_base + PP_TDR    ; Time Domain Reflectometry
PP_AutoNegST        EQU 013Eh
AutoNegST           EQU PacketPage_base + PP_AutoNegST  ; Auto Neg Status
PP_TxCommand        EQU 0144h
TxCommand           EQU PacketPage_base + PP_TxCommand  ; Tx Command
PP_TxLength         EQU 0146h
TxLength            EQU PacketPage_base + PP_TxLength   ; Tx Length
PP_LAF              EQU 0150h
LogicalAddressFilter    EQU PacketPage_base + PP_LAF    ; Hash Table
PP_IA               EQU 0158h
IndividualAddress   EQU PacketPage_base + PP_IA     ; Physical Address Register

PP_RxStatus         EQU 0400h
RxStatus            EQU PacketPage_base + PP_RxStatus   ; Receive start of frame
PP_RxLength         EQU 0402h
RxLength            EQU PacketPage_base + PP_RxLength   ; Receive Length of frame
PP_RxFrame          EQU 0404h
RxFramePtr          EQU PacketPage_base + PP_RxFrame    ; Receive frame pointer
PP_TxFrame          EQU 0A00h
TxFramePtr          EQU PacketPage_base + PP_TxFrame    ; Transmit frame pointer

; Primary I/O Base Address. If no I/O base is supplied by the user, then this
; can be used as the default I/O base to access the PacketPage Area.
DEFAULTIOBASE       EQU 0300h
FIRST_IO            EQU 020Ch   ; First I/O port to check
LAST_IO             EQU 037Ch   ; Last I/O port to check (+10h)
ADD_MASK            EQU 3000h   ; Mask it use of the ADD_PORT register
ADD_SIG             EQU 3000h   ; Expected ID signature

CHIP_EISA_ID_SIG    EQU 630Eh   ; Product ID Code for Crystal Chip (CS8900 spec 4.3)

;
; plug-n-play vendor id values
; These values may or may not correspond to the cs89xx chip eisa id
;
ifdef   IBMEIPKT
	EISA_ID_SIG     EQU     4D24h       ; IBM
	PART_NO_SIG     EQU     1010h       ; IBM
	VENDOR_BIT_MASK EQU     FFFFh       ; IBM
else
	EISA_ID_SIG     EQU     630Eh       ; PnP Vendor ID (same as chip id for Crystal board)
	PART_NO_SIG     EQU     4000h       ; ID code CS8920 board (PnP Vendor Product code)
	VENDOR_BIT_MASK EQU     7000h       ; Mask bits 4,5,6 to id the 8920 card vendor code
endif

PRODUCT_ID_ADD      EQU 0002h   ; Address of product ID

; Mask to find out the types of  registers
REG_TYPE_MASK               EQU 001Fh

; Eeprom Commands
ERSE_WR_ENBL                EQU 00F0h
ERSE_WR_DISABLE             EQU 0000h

; Defines Control/Config register quintuplet numbers
RX_BUF_CFG                  EQU 0003h
RX_CONTROL                  EQU 0005h
TX_CFG                      EQU 0007h
TX_COMMAND                  EQU 0009h
BUF_CFG                     EQU 000Bh
LINE_CONTROL                EQU 0013h
SELF_CONTROL                EQU 0015h
BUS_CONTROL                 EQU 0017h
TEST_CONTROL                EQU 0019h

; Defines Status/Count registers quintuplet numbers
RX_EVENT                    EQU 0004h
TX_EVENT                    EQU 0008h
BUF_EVENT                   EQU 000Ch
RX_MISS_COUNT               EQU 0010h
TX_COL_COUNT                EQU 0012h
LINE_STATUS                 EQU 0014h
SELF_STATUS                 EQU 0016h
BUS_STATUS                  EQU 0018h
TDR                         EQU 001Ch

; Receive  Configuration and Interrupt Mask bit definition -  Read/write
SKIP_1                      EQU 0040h
RX_STREAM_ENBL              EQU 0080h
RX_OK_ENBL                  EQU 0100h
RX_DMA_ONLY                 EQU 0200h
AUTO_RX_DMA                 EQU 0400h
BUFFER_CRC                  EQU 0800h
RX_CRC_ERROR_ENBL           EQU 1000h
RX_RUNT_ENBL                EQU 2000h
RX_EXTRA_DATA_ENBL          EQU 4000h
RX_CFG_MASK         EQU RX_OK_ENBL + RX_DMA_ONLY + AUTO_RX_DMA + BUFFER_CRC
RX_CFG_ALL          EQU RX_CRC_ERROR_ENBL + RX_RUNT_ENBL + RX_EXTRA_DATA_ENBL

; Receive Control bit definition - Read/write
RX_IA_HASH_ACCEPT           EQU 0040h
RX_PROM_ACCEPT              EQU 0080h
RX_OK_ACCEPT                EQU 0100h
RX_MULTCAST_ACCEPT          EQU 0200h
RX_IA_ACCEPT                EQU 0400h
RX_BROADCAST_ACCEPT         EQU 0800h
RX_BAD_CRC_ACCEPT           EQU 1000h
RX_RUNT_ACCEPT              EQU 2000h
RX_EXTRA_DATA_ACCEPT        EQU 4000h
RX_ALL_ACCEPT                           EQU RX_PROM_ACCEPT + RX_BAD_CRC_ACCEPT + \
								RX_RUNT_ACCEPT + RX_EXTRA_DATA_ACCEPT + \
								RX_OK_ACCEPT

; Transmit Configuration Interrupt Mask bit definition - Read/write
TX_LOST_CRS_ENBL            EQU 0040h
TX_SQE_ERROR_ENBL           EQU 0080h
TX_OK_ENBL                  EQU 0100h
TX_LATE_COL_ENBL            EQU 0200h
TX_JBR_ENBL                 EQU 0400h
TX_ANY_COL_ENBL             EQU 0800h
TX_16_COL_ENBL              EQU 8000h

; Transmit Command bit definition - Read-only
TX_START_4_BYTES            EQU 0000h
TX_START_64_BYTES           EQU 0040h
TX_START_128_BYTES          EQU 0080h
TX_START_ALL_BYTES          EQU 00C0h
TX_FORCE                    EQU 0100h
TX_ONE_COL                  EQU 0200h
TX_TWO_PART_DEFF_DISABLE    EQU 0400h
TX_NO_CRC                   EQU 1000h
TX_RUNT                     EQU 2000h

; Buffer Configuration Interrupt Mask bit definition - Read/write
GENERATE_SW_INTERRUPT       EQU 0040h
RX_DMA_ENBL                 EQU 0080h
READY_FOR_TX_ENBL           EQU 0100h
TX_UNDERRUN_ENBL            EQU 0200h
RX_MISS_ENBL                EQU 0400h
RX_128_BYTE_ENBL            EQU 0800h
TX_COL_COUNT_OVRFLOW_ENBL   EQU 1000h
RX_MISS_COUNT_OVRFLOW_ENBL  EQU 2000h
RX_DEST_MATCH_ENBL          EQU 8000h

; Line Control bit definition - Read/write
SERIAL_RX_ON            EQU 0040h
SERIAL_TX_ON            EQU 0080h
AUI_ONLY                EQU 0100h
AUTO_AUI_10BASET        EQU 0200h
MODIFIED_BACKOFF        EQU 0800h
NO_AUTO_POLARITY        EQU 1000h
TWO_PART_DEFDIS         EQU 2000h
LOW_RX_SQUELCH          EQU 4000h

; Software Self Control bit definition - Read/write
POWER_ON_RESET          EQU 0040h
SW_STOP                 EQU 0100h
SLEEP_ON                EQU 0200h
AUTO_WAKEUP             EQU 0400h
HCB0_ENBL               EQU 1000h
HCB1_ENBL               EQU 2000h
HCB0                    EQU 4000h
HCB1                    EQU 8000h

; ISA Bus Control bit definition - Read/write
RESET_RX_DMA            EQU 0040h
MEMORY_ON               EQU 0400h
DMA_BURST_MODE          EQU 0800h
IO_CHANNEL_READY_ON     EQU 1000h
RX_DMA_SIZE_64K         EQU 2000h
ENABLE_IRQ              EQU 8000h

; Test Control bit definition - Read/write
LINK_OFF                EQU 0080h
ENDEC_LOOPBACK          EQU 0200h
AUI_LOOPBACK            EQU 0400h
BACKOFF_OFF             EQU 0800h
FAST_TEST               EQU 8000h

; Receive Event Bit definition - Read-only
RX_IA_HASHED            EQU 0040h
RX_DRIBBLE              EQU 0080h
RX_OK                   EQU 0100h
RX_HASHED               EQU 0200h
RX_IA                   EQU 0400h
RX_BROADCAST            EQU 0800h
RX_CRC_ERROR            EQU 1000h
RX_RUNT                 EQU 2000h
RX_EXTRA_DATA           EQU 4000h

HASH_INDEX_MASK         EQU 0FC00h

; Transmit Event Bit definition - Read-only
TX_LOST_CRS             EQU 0040h
TX_SQE_ERROR            EQU 0080h
TX_OK                   EQU 0100h
TX_LATE_COL             EQU 0200h
TX_JBR                  EQU 0400h
TX_16_COL               EQU 8000h
TX_SEND_OK_BITS         EQU TX_OK + TX_LOST_CRS
TX_COL_COUNT_MASK       EQU 7800h

; Buffer Event Bit definition - Read-only
SW_INTERRUPT            EQU 0040h
RX_DMA                  EQU 0080h
READY_FOR_TX            EQU 0100h
TX_UNDERRUN             EQU 0200h
RX_MISS                 EQU 0400h
RX_128_BYTE             EQU 0800h
TX_COL_OVRFLW           EQU 1000h
RX_MISS_OVRFLW          EQU 2000h
RX_DEST_MATCH           EQU 8000h

; Ethernet Line Status bit definition - Read-only
LINK_OK                 EQU 0080h
AUI_ON                  EQU 0100h
TENBASET_ON             EQU 0200h
POLARITY_OK             EQU 1000h
CRS_OK                  EQU 4000h

; Chip Software Status bit definition
ACTIVE_33V              EQU 0040h
INIT_DONE               EQU 0080h
SI_BUSY                 EQU 0100h
EEPROM_PRESENT          EQU 0200h
EEPROM_OK               EQU 0400h
EL_PRESENT              EQU 0800h
EE_SIZE_64              EQU 1000h
PNPDISABLE				EQU	0040h	; same bit as active_33v on 8900

;ISA Bus Status bit definition
TX_BID_ERROR            EQU 0080h
READY_FOR_TX_NOW        EQU 0100h

; Auto Negotiation Control bit definition
RE_NEG_NOW              EQU 0040h
ALLOW_FDX               EQU 0080h
AUTO_NEG_ENABLE         EQU 0100h
NLP_ENABLE              EQU 0200h
FORCE_FDX               EQU 8000h
AUTO_NEG_BITS           EQU FORCE_FDX+NLP_ENABLE+AUTO_NEG_ENABLE
AUTO_NEG_MASK   EQU FORCE_FDX+NLP_ENABLE+AUTO_NEG_ENABLE+ALLOW_FDX+RE_NEG_NOW

; Auto Negotiation Status bit definition
AUTO_NEG_BUSY           EQU 0080h
FLP_LINK                EQU 0100h
FLP_LINK_GOOD           EQU 0800h
LINK_FAULT              EQU 1000h
HDX_ACTIVE              EQU 4000h
FDX_ACTIVE              EQU 8000h

; The following block defines the ISQ event types
ISQ_RECEIVER_EVENT      EQU 04h
ISQ_TRANSMITTER_EVENT   EQU 08h
ISQ_BUFFER_EVENT        EQU 0ch
ISQ_RX_MISS_EVENT       EQU 10h
ISQ_TX_COL_EVENT        EQU 12h

ISQ_EVENT_MASK          EQU 003Fh   ; ISQ mask to find out type of event
ISQ_HIST                EQU 16      ; small history buffer
AUTOINCREMENT           EQU 8000h   ; Bit mask to set bit-15 for autoincrement

TXRXBUFSIZE             EQU 0600h
RXDMABUFSIZE            EQU 8000h
RXDMASIZE               EQU 4000h
TXRX_LENGTH_MASK        EQU 07FFh

; rx options bits
RCV_WITH_RXON           EQU 1       ; Set SerRx ON
RCV_COUNTS              EQU 2       ; Use Framecnt1
RCV_PONG                EQU 4       ; Pong respondent
RCV_DONG                EQU 8       ; Dong operation
RCV_POLLING             EQU 10h     ; Poll RxEvent
RCV_ISQ                 EQU 20h     ; Use ISQ, int
RCV_AUTO_DMA            EQU 100h    ; Set AutoRxDMAE
RCV_DMA                 EQU 200h    ; Set RxDMA only
RCV_DMA_ALL             EQU 400h    ; Copy all DMA'ed
RCV_FIXED_DATA          EQU 800h    ; Every frame same
RCV_IO                  EQU 1000h   ; Use ISA IO only
RCV_MEMORY              EQU 2000h   ; Use ISA Memory

RAM_SIZE                EQU 1000h       ; The card has 4k bytes or RAM
PKT_START               EQU PP_TxFrame  ; Start of packet RAM

RX_FRAME_PORT           EQU 0000h
TX_FRAME_PORT           EQU RX_FRAME_PORT
TX_CMD_PORT             EQU 0004h
    TX_NOW              EQU 0000h       ; Tx packet after   5 bytes copied
    TX_AFTER_381        EQU 0020h       ; Tx packet after 381 bytes copied
TX_LEN_PORT             EQU 0006h
ISQ_PORT                EQU 0008h
ADD_PORT                EQU 000Ah
DATA_PORT               EQU 000Ch

EEPROM_WRITE_EN         EQU 00F0h
EEPROM_WRITE_DIS        EQU 0000h
EEPROM_WRITE_CMD        EQU 0100h
EEPROM_READ_CMD         EQU 0200h

; Receive Header
; Description of header of each packet in receive area of memory
RBUF_EVENT_LOW      EQU 0   ; Low byte of RxEvent - status of received frame
RBUF_EVENT_HIGH     EQU 1   ; High byte of RxEvent - status of received frame
RBUF_LEN_LOW        EQU 2   ; Length of received data - low byte
RBUF_LEN_HI         EQU 3   ; Length of received data - high byte
RBUF_HEAD_LEN       EQU 4   ; Length of this header

; Default receive mode - individually addressed and error free
DEF_RX_ACCEPT   EQU   RX_IA_ACCEPT + RX_OK_ACCEPT

CHIP_READ   EQU 1   ; Used to mark state of the repins code (chip or dma)
DMA_READ    EQU 2   ; Used to mark state of the repins code (chip or dma)

DEBUG MACRO mess_param
LOCAL @lab1, @lab2
    push    dx
    jmp     @lab2
@lab1       db "&mess_param"
	    db "$"
@lab2:
    PRINT   @lab1
    pop     dx
    ENDM

LOAD_PORT   MACRO port_param
    mov     dx, base_addr
    add     dx, port_param
    port_no = port_param
    ENDM

SET_PORT    MACRO port_param
    if port_param - port_no EQ 1
	inc dx
    else
	if port_param - port_no EQ -1
	    dec dx
	else
	    if port_param - port_no NE 0
		add dx,port_param - port_no
	    endif
	endif
    endif
    port_no = port_param
    ENDM

LOAD_WRITE   MACRO  address_param
    LOAD_PORT   ADD_PORT
    mov     ax, address_param
    outw    
    SET_PORT    DATA_PORT
    ENDM

SET_WRITE    MACRO  address_param
    SET_PORT    ADD_PORT
    mov     ax, address_param
    outw    
    SET_PORT    DATA_PORT
    ENDM

SELECT_PNP_REG macro %1
    mov     dx, PNP_ADD_PORT
    mov     al, %1
    out     dx, al
endm

WRITE_PNP_REG_BL macro %1
    ; Set PNP register %1 to the value of bl
    SELECT_PNP_REG %1
    mov     dx, PNP_WRITE_PORT
    mov     al, bl
    out     dx, al
endm


WRITE_PNP_REG macro %1, %2
    ; Set PNP register %1 to the value of %2
    SELECT_PNP_REG %1
    mov     dx, PNP_WRITE_PORT
    mov     al, %2
    out     dx, al
endm

READ_PNP_REG macro %1
    ; Read PNP register %1
    SELECT_PNP_REG %1
    mov     dx, WORD PTR pnp_isa_struct[PNP_RD_PORT_OFF]
    in      al, dx
endm

pause_  macro
;   jmp $+2
;
; The reason for the pause_ macro is to establish a minimum time between
; accesses to the card hardware. The assumption is that the fetch and execution
; of the jmp $+2 instruction will provide this time. In a fast cache machine
; this may be a false assumption. In a fast cache machine, there may be 
; NO REAL TIME DIFFERENCE between the two I/O instruction streams below:
;
;   in  al,dx       in  al,dx
;   jmp $+2
;   in  al,dx       in  al,dx
;
; To establish a minimum delay, an I/O instruction must be used. A good rule of
; thumb is that ISA I/O instructions take ~1.0 microseconds and MCA I/O
; instructions take ~0.5 microseconds. Reading the NMI Status Register (0x61)
; is a good way to pause on all machines.
;
; The National 8390 Chip (NIC) requires 4 bus clocks between successive
; chip selects (National DP8390 Data Sheet Addendum, June 1990 -- it took them
; long enough to figure this out and tell everyone) or the NIC behaves badly.
; Therefor one I/O instruction should be inserted between each successive
; NIC I/O instruction that could occur 'back - to - back' on a fast cache
; machine.
;   - gft - 910529
;
    push    ax
    in  al, 61h
    pop ax
;
endm

FAST_8_BIT_IO   EQU 1   ; 1 = can do a normal 16 bit I/0 to an 8 bit location   
; Special inw and outw routines are not required for this card

;input a word from I/O port
inw macro
    if FAST_8_BIT_IO eq 1
	in  ax, dx
;   else
;       call    inw_routine
    endif
    endm

; Write a word to an I/O port
outw    macro
    if FAST_8_BIT_IO EQ 1
	out     dx, ax          ; Write to the I/O port
;   else
;       call    outw_routine
    endif
    endm


ifdef CSDEBUG
; use these values for debugging bios scan
BIOS_START_SEG          equ     00000h
BIOS_OFFSET_INC         equ     0010h
else
BIOS_START_SEG          equ     0c000h
BIOS_OFFSET_INC         equ     0200h
endif

BIOS_LAST_OFFSET        equ             0fc00h

; Byte offsets into the EEPROM configuration buffer
ISA_CNF_OFFSET      EQU 6
TX_CTL_OFFSET           EQU ISA_CNF_OFFSET + 8                  ; 8900 eeprom
AUTO_NEG_CNF_OFFSET     EQU ISA_CNF_OFFSET + 8                  ; 8920 eeprom
  ; the assumption here is that the bits in the eeprom are generally 
  ; in the same position as those in the autonegctl register.
  ; Of course the IMM bit is not in that register so it must be 
  ; masked out
  EE_FORCE_FDX          EQU 8000h
  EE_NLP_ENABLE         EQU 0200h
  EE_AUTO_NEG_ENABLE    EQU 0100h
  EE_ALLOW_FDX          EQU 0080h
  EE_AUTO_NEG_CNF_MASK  EQU EE_FORCE_FDX+EE_NLP_ENABLE+EE_AUTO_NEG_ENABLE+EE_ALLOW_FDX

  IMM_BIT                               EQU 0040h               ; ignore missing media  
  
TEST_IMM_BIT            macro
	test    eeprom_buff[AUTO_NEG_CNF_OFFSET], IMM_BIT
	endm

ADAPTER_CNF_OFFSET  EQU AUTO_NEG_CNF_OFFSET + 2
  A_CNF_10B_T               EQU 0001h
  A_CNF_AUI                 EQU 0002h
  A_CNF_10B_2               EQU 0004h
  A_CNF_MEDIA_TYPE          EQU 0060h
    A_CNF_MEDIA_AUTO        EQU 0000h
    A_CNF_MEDIA_10B_T       EQU 0020h
    A_CNF_MEDIA_AUI         EQU 0040h
    A_CNF_MEDIA_10B_2       EQU 0060h
  A_CNF_DC_DC_POLARITY      EQU 0080h
  A_CNF_NO_AUTO_POLARITY    EQU 2000h
  A_CNF_LOW_RX_SQUELCH      EQU 4000h
  A_CNF_EXTND_10B_2         EQU 8000h

; Bit definitions for the ISA configuration word from the EEPROM
INT_NO_MASK         EQU 000Fh
DMA_NO_MASK         EQU 0070h
ISA_DMA_SIZE        EQU 0200h
ISA_AUTO_RxDMA      EQU 0400h
ISA_RxDMA           EQU 0800h
DMA_BURST           EQU 1000h
STREAM_TRANSFER     EQU 2000h
ANY_ISA_DMA         EQU ISA_AUTO_RxDMA + ISA_RxDMA

; DMA controller registers
DMA_BASE            EQU 00h     ; DMA controller base
DMA_BASE_2          EQU 0C0h    ; DMA controller base

DMA_STAT            EQU 0D0h    ; DMA controller status register
DMA_MASK            EQU 0D4h    ; DMA controller mask register
DMA_MODE            EQU 0D6h    ; DMA controller mode register
DMA_RESETFF         EQU 0D8h    ; DMA controller first/last flip flop

; DMA data
DMA_DISABLE         EQU 04h     ; Disable channel n
DMA_ENABLE          EQU 00h     ; Enable channel n
; Demand transfers, incr. address, auto init, writes, ch. n
DMA_RX_MODE         EQU 14h
; Demand transfers, incr. address, auto init, reads, ch. n
DMA_TX_MODE         EQU 18h

DMA_SIZE            EQU 16*1024 ; Size of dma buffer - 16k

CS8900              EQU 0000h
CS8920              EQU 4000h   
CS8920M             EQU 6000h   
REVISION_BITS       EQU 1F00H
REVISION_MASK       EQU 0E000H
EEVER_NUMBER            EQU     12h
CHKSUM_LEN          EQU 14h
CHKSUM_VAL          EQU 0000h
START_EEPROM_DATA   EQU 001ch ; Offset into eeprom for start of data
IRQ_MAP_EEPROM_DATA EQU 0046h ; Offset into eeprom for the IRQ map
IRQ_MAP_LEN         EQU 0004h ; No of bytes to read for the IRQ map
PNP_IRQ_FRMT        EQU 0022h ; PNP small item IRQ format
CS8900_IRQ_MAP      EQU 00001110000100000B ; This IRQ map is fixed

CS8920_NO_INTS      EQU 0Fh   ; Max CS8920 interrupt select #

PNP_ADD_PORT        EQU 0279h
PNP_WRITE_PORT      EQU 0A79h

GET_PNP_ISA_STRUCT  EQU 40h
PNP_ISA_STRUCT_LEN  EQU 06h
PNP_CSN_CNT_OFF     EQU 01h
PNP_RD_PORT_OFF     EQU 02h
PNP_FUNCTION_OK     EQU 00h
PNP_WAKE            EQU 03h
PNP_RSRC_DATA       EQU 04h
    PNP_RSRC_READY  EQU 01H
PNP_STATUS          EQU 05h
PNP_ACTIVATE        EQU 30h
PNP_CNF_IO_H        EQU 60h
PNP_CNF_IO_L        EQU 61h
PNP_CNF_INT         EQU 70h
PNP_CNF_DMA         EQU 74h
PNP_CNF_MEM                     EQU     48h

BIT0                EQU 1
BIT15               EQU 8000h

