/*--------------------------------------------------------------------
         FILE HEADER FOR init.c
         HEADER LAST UPDATED : August 8, 1994
         COMPILER : Borland C++ 4.02
         PURPOSE :
              This file contains initialization code for timeboot.asm.  The
         code here parses the command line and extracts the hours and
         minutes that timeboot.asm uses to schedule a reboot.

  --------------------------------------------------------------------*/


#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>


void dos_write(int iHandle,char *pData,size_t cbData)
{
short sSegment;
short sOffset;

sSegment = FP_SEG(pData);
sOffset = FP_OFF(pData);

asm {
    push ds;
    push cx;
    push dx;

    mov  ds,sSegment;
    mov  dx,sOffset;
    mov  ah,0x40;
    mov  bx,iHandle;
    mov  cx,cbData;
    int  0x21;

    pop  dx;
    pop  cx;
    pop  ds;
    };
}

void dos_puts(char *pData)
{
dos_write(2,pData,strlen(pData));
}

void display_int(int s)
{
char szDigits[5];
itoa(s,szDigits,10);
dos_puts(szDigits);
}

void display_time(int sHour,int sMinute)
{
display_int(sHour);
dos_puts(":");
if (sMinute < 10) dos_puts("0");
display_int(sMinute);
}

void announce(void)
{
dos_puts("CPU Releaser 1.1\r\n");
}

void abend(char *pszMessage)
{
announce();
dos_puts(pszMessage);
asm {  mov ax,0x4C01;
       int 0x21;
    };
}




/*----------------------------------------------------------------------
         FUNCTION HEADER FOR init()
         HEADER LAST UPDATED : June 8, 1995
         PURPOSE :
              This function is called by CPUREL.ASM to parse the command
         line.  If it is unsuccessful, it displays an error message and
         exits to DOS.

         PARAMETER 1 :  pCommand - pointer to DOS command line
         PARAMETER 2 :  piTickCount- output as the hour extracted from the
             command line.

  ----------------------------------------------------------------------*/


void init(char *pCommand,int *piTickCount)
{
char szCommand[129];
size_t cbCommand;
int i, j, iTickCount;

/* COPY COMMAND LINE TO LOCAL STORAGE */
cbCommand = (int)(*pCommand);
if (cbCommand < 1) abend("Command line too short!!");
for (i = 0; i < cbCommand; i++)
    {
    szCommand[i] = pCommand[i+2];
    }
szCommand[cbCommand-1] = '\0';

/*--- GET, CHECK TICK COUNT FROM COMMAND LINE --*/
iTickCount = atoi(szCommand);
if (iTickCount == 0)
   {
   dos_puts("Specify a proportionality factor at which time slices will ");
   dos_puts("be released in an OS/2 VDM.\r\n");
   dos_puts("The higher the number, the fewer time slices released.\n");
   dos_puts("A generally recommended number is 32000.\r\n");
   abend("");
   }

//display_int(iTickCount);
*piTickCount = iTickCount;
}


