COMMENT *
--------------------------------------------------------------------------
         FILE HEADER FOR cpurel.asm
         HEADER LAST UPDATED : June 8, 1995
         PURPOSE :
              This file contains the resident portion and some of the
         initilization code for a TSR which releases time slices for DOS
         program running under OS/2.  This is really a patch for OS/2 not
         keeping DOS sessions from monopolizing the CPU under OS/2, and is
         particularly useful for WordPerfect for DOS.

--------------------------------------------------------------------------
*

.MODEL SMALL
.SEQ
TIMER_VECTOR EQU 28H
_TEXT SEGMENT WORD PUBLIC 'CODE'
ASSUME cs:_TEXT,ds:_TEXT
ORG 100h
start: jmp GoResident

dTimerVector  DD  0               ; address of timer interrupt vector
wMinTickCount    DW  0            ; min tick count before CPU release
wTickCount    DW  0               ; accumulated tick count

NewTimerVector PROC FAR
               ASSUME DS:NOTHING
               inc wTickCount;
               push ax;
               mov  ax,wMinTickCount;
               cmp  wTickCount,ax;
               jne  skip_cpu_release;
               mov  ax,1680h;
               int  2fh;
skip_cpu_release:
               pop  ax;
               jmp   dTimerVector
NewTimerVector ENDP

resident:

local_stack  db     256 dup(0)
stack_top    dw     ?
ss_save      dw     ?
sp_save      dw     ?


EXTRN _init:PROC

GoResident     PROC FAR
               ASSUME cs:_TEXT,ds:_TEXT

; set up C stack
               cli
               mov   cs:sp_save,sp
               mov   cs:ss_save,ss
               mov   ax,cs
               mov   ss,ax
               mov   sp,OFFSET cs:stack_top - 2
               sti

; set up data segment
               ASSUME cs:_TEXT,ds:DGROUP
               mov   ax,cs
               mov   ds,ax

; call C init function
               mov   ax,80h
               mov   bx,OFFSET wMinTickCount
               call  _init  C,ax,bx

; restore local stack
               cli
               mov   sp,cs:sp_save
               mov   ss,cs:ss_save
               sti

; get current timer vector
               mov   ah,35h
               mov   al,TIMER_VECTOR
               int   21h
               mov   WORD PTR dTimerVector,bx
               mov   WORD PTR dTimerVector[2],es

; set new timer vector
               push  ds
               push  cs
               pop   ds
               mov   dx,OFFSET NewTimerVector
               mov   ah,25h
               mov   al,TIMER_VECTOR
               int   21h
               pop   ds


; free environment
               mov   bx,WORD PTR cs:[2Ch]
               cmp   bx,0
               je    no_env
               mov   es,bx
               mov   ah,49h
               int   21h
no_env:

; terminate but stay resident
               mov   dx,OFFSET resident+32
               int   27h

GoResident     ENDP

ENDS _TEXT


DGROUP  group  _TEXT,_DATA,_BSS
ASSUME cs:_TEXT,ds:DGROUP
_BSS    SEGMENT WORD PUBLIC 'BSS'
        DB 255 DUP (0)
_BSS    ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
        DB 255 DUP (0)
_DATA   ENDS


END  start

