;************************************************
;* Header.asm                                   *
;*                                              *
;* Written by Lewis Bassett, 13/01/06           *
;*                                              *
;* Megadrive ROM header, and initialization     *
;* code.                                        *
;*                                              *
;************************************************


InterruptVectors:

	dc.l	$00FFE000;		Initial stack address
	dc.l	START;			Start of program code
	dc.l	Interrupt;		Bus error
	dc.l	Interrupt;		Address error
	dc.l	Interrupt;		Illegal instruction
	dc.l	Interrupt;		Division by zero
	dc.l	Interrupt;		CHK exception
	dc.l	Interrupt;		TRAPV exception
	dc.l	Interrupt;		Privilage violation
	dc.l	Interrupt;		TRACE exception
	dc.l	Interrupt;		Line-A emulator
	dc.l	Interrupt;		Line-F emulator
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Co-processor protocol violation
	dc.l	Interrupt;		Format error
	dc.l	Interrupt;		Uninitialized Interrupt
 	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Spurious Interrupt
	dc.l	Interrupt;		IRQ Level 1
	dc.l	Interrupt;		IRQ Level 2
	dc.l	Interrupt;		IRQ Level 3
	dc.l	HBL;			IRQ Level 4 (VDP Horizontal Interrupt)
	dc.l	Interrupt;		IRQ Level 5
	dc.l	VBL;			IRQ Level 6 (VDP Vertical Interrupt)
	dc.l	Interrupt;		IRQ Level 7
	dc.l	Interrupt;		TRAP #00 Exception
	dc.l	Interrupt;		TRAP #01 Exception
	dc.l	Interrupt;		TRAP #02 Exception
	dc.l	Interrupt;		TRAP #03 Exception
	dc.l	Interrupt;		TRAP #04 Exception
	dc.l	Interrupt;		TRAP #05 Exception
	dc.l	Interrupt;		TRAP #06 Exception
	dc.l	Interrupt;		TRAP #07 Exception
	dc.l	Interrupt;		TRAP #08 Exception
	dc.l	Interrupt;		TRAP #09 Exception
	dc.l	Interrupt;		TRAP #10 Exception
	dc.l	Interrupt;		TRAP #11 Exception
	dc.l	Interrupt;		TRAP #12 Exception
	dc.l	Interrupt;		TRAP #13 Exception
	dc.l	Interrupt;		TRAP #14 Exception
	dc.l	Interrupt;		TRAP #15 Exception
	dc.l	Interrupt;		(FP) Branch or Set on Unordered Condition
	dc.l	Interrupt;		(FP) Inexact Result
	dc.l	Interrupt;		(FP) Divide by Zero
	dc.l	Interrupt;		(FP) Underflow
	dc.l	Interrupt;		(FP) Operand Error
	dc.l	Interrupt;		(FP) Overflow
	dc.l	Interrupt;		(FP) Signaling NAN
	dc.l	Interrupt;		(FP) Unimplemented Data Type
	dc.l	Interrupt;		MMU Configuration Error
	dc.l	Interrupt;		MMU Illegal Operation Error
	dc.l	Interrupt;		MMU Access Violation Error
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)
	dc.l	Interrupt;		Reserved (NOT USED)




ROMHeader:

	dc.b	"SEGA MEGA DRIVE ";                                 Console Name
	dc.b	"(C)SEGA 2006.JAN";                                 Copyright Information
	dc.b	"SAMPLE PROGRAM                                  "; Domestic Name
	dc.b	"SAMPLE PROGRAM                                  "; Overseas Name
	dc.b	"GM 00000000-00";                                   Serial Number
	dc.b	$a5, 	$FB;                                        Checksum
	dc.b	"JD              ";                                 I/O Support
	dc.l	$00000000;                                          ROM Start Address
	dc.l	ROMEnd;                                             ROM End Address
	dc.l	$00FF0000;                                          Start of Backup RAM
	dc.l	$00FFFFFF;                                          End of Backup RAM
	dc.b	"                        ";                         Modem Support
	dc.b	"DEMONSTRATION PROGRAM                   ";         Memo
	dc.b	"JUE             ";                                 Country Support



START:

	move.b  $A10001,	d0
	andi.b  #$0F,		d0
	beq 	WrongVersion
	move.l  #'SEGA',	$A14000

WrongVersion: