/* -------------------- YM2203(OPN) Interface -------------------- */

/*
** Initialize YM2203 emulator(s).
**
** 'num'           is the number of virtual YM2203's to allocate
** 'baseclock'
** 'rate'          is sampling rate
** 'TimerHandler'  timer callback handler when timer start and clear
** 'IRQHandler'    IRQ callback handler when changed IRQ level
** return      0 = success
*/
DLL_EXPORT void* YM2203Init(int baseclock, int rate);

/*
** shutdown the YM2203 emulators
*/
DLL_EXPORT void YM2203Shutdown(void *chip);

/*
** reset all chip registers for YM2203 number 'num'
*/
DLL_EXPORT void YM2203ResetChip(void *chip);

/*
** update one of chip
*/
DLL_EXPORT void YM2203UpdateOne(void *chip, int *buffer, int length, bool fill);

/*
** Write
** return : InterruptLevel
*/
DLL_EXPORT int YM2203Write(void *chip,int a,unsigned char v);


DLL_EXPORT void YM2203SetMute(void *chip,int mask);


DLL_EXPORT void YM2203GetAllTL(void *chip,int *levels);