#include "stdafx.h"

#pragma comment(lib,"Winmm.lib")

#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>
#include <conio.h>

void tfc_init(unsigned char*);
void tfc_frame(void);
void tfc_play(bool);

void tfd_init(unsigned char*);
void tfd_frame(void);
void tfd_play(bool);

#include "mame\Ym2203_Emu.h"
#include "turbofm.h"
#include "tfcplayer.h"
#include "tfdplayer.h"
#include "waverec.h"
#include "waveout.h"




int main(int argc, char* argv[])
{
	const int rate=44100;
	const int clock=3500000;
	
	printf("TFMPLAY v0.4 by Shiru, 20.12.07\n\n");
	WAVF.write=false;
	
	if(argc<2)
	{
		printf("USAGE: tfmplay.exe filename.tfd or filename.tfc (replay)\n");
		printf("       tfmplay.exe filename.tfd (.tfc) filename.wav (render to wav)\n");
		return 0;
	}
	
	if(tfm_open(argv[1],clock,rate))
	{
		if(argc==3) WAVF.write=wave_open(argv[2],rate);
		
		if(waveout_init(NULL,rate,4096,4))//4096=buffer size, 4=number of buffers
		{
			printf("Press any key to stop\n\n");
			
			while(!kbhit()) Sleep(100);
			
			waveout_shut();
		}
		tfm_close();
		
		if(WAVF.write) wave_close();
	}
	else
	{
		printf("ERR: Can't open file '%s'\n",argv[1]);
	}
	
	return 0;
}

