#define GFXDATA 		0xc00000
#define GFXCNTL 		0xc00004

#define Z80_HALT  		0xa11100
#define Z80_RESET 		0xa11200

#define PSG_DATA		0xc00011

#define YM2612_A0   	0xa04000
#define YM2612_D0   	0xa04001
#define YM2612_A1   	0xa04002
#define YM2612_D1   	0xa04003

#define JOY_UP          0x01
#define JOY_DOWN        0x02
#define JOY_LEFT        0x04
#define JOY_RIGHT       0x08
#define BUTTON_A        0x40
#define BUTTON_B        0x10
#define BUTTON_C        0x20
#define BUTTON_S        0x80


#define GFX_DMA_VRAM(adr)      ((0x4000+((adr)&0x3FFF))<<16)+(((adr)>>14)|0x80)
#define GFX_WRITE_VRAM(adr)    ((0x4000+((adr)&0x3FFF))<<16)+(((adr)>>14)|0x00)
#define GFX_WRITE_CRAM(adr)    ((0xC000+((adr)&0x3FFF))<<16)+(((adr)>>14)|0x00)
#define GFX_WRITE_VSRAM(adr)   ((0x4000+((adr)&0x3FFF))<<16)+(((adr)>>14)|0x10)


typedef char  i8;
typedef short i16;
typedef long  i32;
typedef unsigned char  u8;
typedef unsigned short u16;
typedef unsigned long  u32;

#ifndef FALSE
#define FALSE   0
#endif
#ifndef TRUE
#define TRUE    1
#endif
#ifndef NULL
#define NULL    0
#endif
