UNIT PatternOrderEditor;

INTERFACE

USES Windows,Messages,SysUtils,Classes,Graphics,Controls,Forms,Dialogs,Grids,
     SoundEnginePlayer,Menus,Globals;

TYPE TPatternOrderEditor=CLASS(TStringGrid)
      PRIVATE
       PROCEDURE InsertPattern;
       PROCEDURE DeletePattern;
       PROCEDURE CreateNewPattern;
       PROCEDURE DuplicatePattern;
       PROCEDURE CopyPattern;
       PROCEDURE PastePattern;
       PROCEDURE MarkAsRestartPosition;
      PROTECTED
       PROCEDURE KeyDown(VAR Key:WORD;Shift:TShiftState); OVERRIDE;
       PROCEDURE Click; OVERRIDE;
       PROCEDURE DrawCell(ACol,ARow:Longint;ARect:TRect;AState:TGridDrawState); OVERRIDE;
       FUNCTION SelectCell(ACol,ARow:LONGINT):BOOLEAN; OVERRIDE;
       PROCEDURE MouseDown(Button:TMouseButton;Shift:TShiftState;X,Y:INTEGER); OVERRIDE;
       PROCEDURE MouseUp(Button:TMouseButton;Shift:TShiftState;X,Y:INTEGER); OVERRIDE;
       PROCEDURE OnInsertPattern(Sender:TObject);
       PROCEDURE OnDeletePattern(Sender:TObject);
       PROCEDURE OnCreateNewPattern(Sender:TObject);
       PROCEDURE OnDuplicate(Sender:TObject);
       PROCEDURE OnCopyPattern(Sender:TObject);
       PROCEDURE OnPastePattern(Sender:TObject);
       PROCEDURE OnMarkAsRestartPosition(Sender:TObject);
       PROCEDURE OnPlayAtPattern(Sender:TObject);
       PROCEDURE OnPlayPatternInLoop(Sender:TObject);
       FUNCTION WirdVerwendet(K:BYTE):BOOLEAN;
       FUNCTION IstLeer(K:BYTE):BOOLEAN;
      PUBLIC
       Track:TTrack;
       Form:TForm;
       PatternPopupMenu:TPopupMenu;
       EmptyMemoryPopupMenu:TPopupMenu;
       EmptyPopupMenu:TPopupMenu;
       AktPlayPatternOrder:INTEGER;
       CONSTRUCTOR Create(AOwner:TComponent); OVERRIDE;
       DESTRUCTOR Destroy; OVERRIDE;
       PROCEDURE Aktualisieren;
       PROCEDURE Change;
      PUBLISHED
     END;

IMPLEMENTATION

USES Main;

CONSTRUCTOR TPatternOrderEditor.Create(AOwner:TComponent);
VAR Item:TMenuItem;
BEGIN
 INHERITED Create(AOwner);

 PatternPopupMenu:=TPopupMenu.Create(SELF);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.ShortCut:=ShortCut(VK_INSERT,[]);
 Item.Caption:='&Insert pattern';
 Item.OnClick:=OnInsertPattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.ShortCut:=ShortCut(VK_DELETE,[]);
 Item.Caption:='&Delete pattern';
 Item.OnClick:=OnDeletePattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='-';
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='Create &new pattern';
 Item.OnClick:=OnCreateNewPattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='D&uplicate';
 Item.OnClick:=OnDuplicate;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='&Copy pattern';
 Item.OnClick:=OnCopyPattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='&Paste pattern';
 Item.OnClick:=OnPastePattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='-';
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='Mark as &restart position';
 Item.OnClick:=OnMarkAsRestartPosition;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='-';
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='Play at pattern';
 Item.OnClick:=OnPlayAtPattern;
 PatternPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(PatternPopupMenu);
 Item.Caption:='Play pattern in loop';
 Item.OnClick:=OnPlayPatternInLoop;
 PatternPopupMenu.Items.Add(Item);

 EmptyMemoryPopupMenu:=TPopupMenu.Create(SELF);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.ShortCut:=ShortCut(VK_INSERT,[]);
 Item.Caption:='&Insert pattern';
 Item.OnClick:=OnInsertPattern;
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.ShortCut:=ShortCut(VK_DELETE,[]);
 Item.Caption:='&Delete pattern';
 Item.OnClick:=OnDeletePattern;
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.Caption:='-';
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.Caption:='Create &new pattern';
 Item.OnClick:=OnCreateNewPattern;
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.Caption:='&Paste pattern';
 Item.OnClick:=OnPastePattern;
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.Caption:='-';
 EmptyMemoryPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyMemoryPopupMenu);
 Item.Caption:='Mark as &restart position';
 Item.OnClick:=OnMarkAsRestartPosition;
 EmptyMemoryPopupMenu.Items.Add(Item);

 EmptyPopupMenu:=TPopupMenu.Create(SELF);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.ShortCut:=ShortCut(VK_INSERT,[]);
 Item.Caption:='&Insert pattern';
 Item.OnClick:=OnInsertPattern;
 EmptyPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.ShortCut:=ShortCut(VK_DELETE,[]);
 Item.Caption:='&Delete pattern';
 Item.OnClick:=OnDeletePattern;
 EmptyPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.Caption:='-';
 EmptyPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.Caption:='Create &new pattern';
 Item.OnClick:=OnCreateNewPattern;
 EmptyPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.Caption:='-';
 EmptyPopupMenu.Items.Add(Item);

 Item:=TMenuItem.Create(EmptyPopupMenu);
 Item.Caption:='Mark as &restart position';
 Item.OnClick:=OnMarkAsRestartPosition;
 EmptyPopupMenu.Items.Add(Item);

 AktPlayPatternOrder:=0;
END;

DESTRUCTOR TPatternOrderEditor.Destroy;
BEGIN
 PatternPopupMenu.Free;
 EmptyMemoryPopupMenu.Free;
 EmptyPopupMenu.Free;
 INHERITED Destroy;
END;

PROCEDURE TPatternOrderEditor.InsertPattern;
VAR K:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  FOR K:=256-2 DOWNTO Col DO BEGIN
   Track.PatternOrder[K+1]:=Track.PatternOrder[K];
  END;
  Track.PatternOrder[Col]:=$FE;
  Track.Changed:=TRUE;
  Track.Leave;
  Aktualisieren;
  Change;
 END;
END;

PROCEDURE TPatternOrderEditor.DeletePattern;
VAR K:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  FOR K:=Col TO 256-2 DO BEGIN
   Track.PatternOrder[K]:=Track.PatternOrder[K+1];
  END;
  Track.PatternOrder[256-1]:=$FF;
  Track.Changed:=TRUE;
  Track.Leave;
  Aktualisieren;
  Change;
 END;
END;

PROCEDURE TPatternOrderEditor.CreateNewPattern;
VAR F,J,K,L:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  J:=Track.PatternOrder[Col];
  IF J<255 THEN BEGIN
   Col:=Col+1;
   FOR K:=256-2 DOWNTO Col DO BEGIN
    Track.PatternOrder[K+1]:=Track.PatternOrder[K];
   END;
   F:=Col;
  END ELSE BEGIN
   F:=Col;
  END;
  L:=$FF;
  FOR K:=0 TO 256-1 DO BEGIN
   IF IstLeer(K) AND NOT WirdVerwendet(K) THEN BEGIN
    L:=K;
    BREAK;
   END;
  END;
  IF L<>$FF THEN BEGIN
   Track.PatternOrder[F]:=L;
  END ELSE BEGIN
   Track.PatternOrder[F]:=$FE;
  END;
  Track.Changed:=TRUE;
  Track.Leave;
  Aktualisieren;
  Change;
 END;
END;

PROCEDURE TPatternOrderEditor.DuplicatePattern;
VAR E,F,J,K,L:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  E:=Track.PatternOrder[Col];
  J:=Track.PatternOrder[Col];
  IF J<255 THEN BEGIN
   IF Col>=(256-1) THEN BEGIN
    Track.Leave;
    EXIT;
   END;
   Col:=Col+1;
   FOR K:=256-2 DOWNTO Col DO BEGIN
    Track.PatternOrder[K+1]:=Track.PatternOrder[K];
   END;
   F:=Col;
  END ELSE BEGIN
   Track.Leave;
   EXIT;
  END;
  L:=$FF;
  FOR K:=0 TO 256-1 DO BEGIN
   IF IstLeer(K) AND NOT WirdVerwendet(K) THEN BEGIN
    L:=K;
    BREAK;
   END;
  END;
  IF L<>$FF THEN BEGIN
   Track.Patterns[L]:=Track.Patterns[E];
   Track.PatternOrder[F]:=L;
  END ELSE BEGIN
   Track.PatternOrder[F]:=$FE;
  END;
  Track.Changed:=TRUE;
  Track.Leave;
  Aktualisieren;
  Change;
 END;
END;

PROCEDURE TPatternOrderEditor.CopyPattern;
VAR J:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  J:=Track.PatternOrder[Col];
  IF J<255 THEN BEGIN
   (Form AS TMainForm).PatternMemory:=Track.Patterns[J];
   (Form AS TMainForm).PatternMemoryOk:=TRUE;
  END;
  Track.Leave;
 END;
END;

PROCEDURE TPatternOrderEditor.PastePattern;
VAR F,J,K,L:WORD;
BEGIN
 IF (Col>=0) AND (Col<256) AND (Form AS TMainForm).PatternMemoryOk THEN BEGIN
  Track.Enter;
  J:=Track.PatternOrder[Col];
  IF J<255 THEN BEGIN
   IF Col>=(256-1) THEN BEGIN
    Track.Leave;
    EXIT;
   END;
   Col:=Col+1;
   FOR K:=256-2 DOWNTO Col DO BEGIN
    Track.PatternOrder[K+1]:=Track.PatternOrder[K];
   END;
   F:=Col;
  END ELSE BEGIN
   F:=Col;
  END;
  L:=$FF;
  FOR K:=0 TO 256-1 DO BEGIN
   IF IstLeer(K) AND NOT WirdVerwendet(K) THEN BEGIN
    L:=K;
    BREAK;
   END;
  END;
  IF L<>$FF THEN BEGIN
   Track.Patterns[L]:=(Form AS TMainForm).PatternMemory;
   Track.PatternOrder[F]:=L;
  END ELSE BEGIN
   Track.PatternOrder[F]:=$FE;
  END;
  Track.Changed:=TRUE;
  Track.Leave;
  Aktualisieren;
  Change;
 END;
END;

PROCEDURE TPatternOrderEditor.MarkAsRestartPosition;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  Track.Enter;
  Track.RestartPosition:=Col;
  Track.Changed:=TRUE;
  Track.Leave;
  Invalidate;
 END;
END;

PROCEDURE TPatternOrderEditor.KeyDown(VAR Key:WORD;Shift:TShiftState);
VAR K:WORD;
BEGIN
 IF ASSIGNED(Track) THEN BEGIN
  CASE Key OF
   VK_TAB:BEGIN
    IF NOT (ssShift IN Shift) THEN IF (Row=RowCount-1) AND (Col=ColCount-1) THEN BEGIN
     RowCount:=RowCount+1;
    END;
   END;
   VK_INSERT:InsertPattern;
   VK_DELETE:DeletePattern;
   VK_ADD:BEGIN
    IF (Col>=0) AND (Col<256) THEN BEGIN
     Track.Enter;
     IF Track.PatternOrder[Col]=$FF THEN BEGIN
      Track.PatternOrder[Col]:=0;
     END ELSE IF Track.PatternOrder[Col]=$FE THEN BEGIN
      Track.PatternOrder[Col]:=0;
     END ELSE IF Track.PatternOrder[Col]<$FE THEN BEGIN
      INC(Track.PatternOrder[Col]);
     END;
     Track.Leave;
     Aktualisieren;
     Change;
    END;
   END;
   VK_SUBTRACT:BEGIN
    IF (Col>=0) AND (Col<256) THEN BEGIN
     Track.Enter;
     IF Track.PatternOrder[Col]=0 THEN BEGIN
      Track.PatternOrder[Col]:=$FF;
     END ELSE IF Track.PatternOrder[Col]<>$FF THEN BEGIN
      DEC(Track.PatternOrder[Col]);
     END;
     Track.Changed:=TRUE;
     Track.Leave;
     Aktualisieren;
     Change;
    END;
   END;
   ORD('A')..ORD('F'),ORD('0')..ORD('9'),VK_NUMPAD0..VK_NUMPAD9:BEGIN
    K:=0;
    CASE Key OF
     VK_NUMPAD0,ORD('0'):K:=0;
     VK_NUMPAD1,ORD('1'):K:=1;
     VK_NUMPAD2,ORD('2'):K:=2;
     VK_NUMPAD3,ORD('3'):K:=3;
     VK_NUMPAD4,ORD('4'):K:=4;
     VK_NUMPAD5,ORD('5'):K:=5;
     VK_NUMPAD6,ORD('6'):K:=6;
     VK_NUMPAD7,ORD('7'):K:=7;
     VK_NUMPAD8,ORD('8'):K:=8;
     VK_NUMPAD9,ORD('9'):K:=9;
     ORD('A'):K:=10;
     ORD('B'):K:=11;
     ORD('C'):K:=12;
     ORD('D'):K:=13;
     ORD('E'):K:=14;
     ORD('F'):K:=15;
    END;
    IF (Col>=0) AND (Col<256) THEN BEGIN
     Track.Enter;
     IF Track.PatternOrder[Col]>=$FE THEN BEGIN
      Track.PatternOrder[Col]:=0;
     END;
     Track.PatternOrder[Col]:=((Track.PatternOrder[Col] AND $0F) SHL 4) OR K;
     Track.Changed:=TRUE;
     Track.Leave;
     Aktualisieren;
     Change;
    END;
   END;
   VK_SPACE:BEGIN
    IF (Col>=0) AND (Col<256) THEN BEGIN
     Track.Enter;
     Track.PatternOrder[Col]:=$FE;
     Track.Changed:=TRUE;
     Track.Leave;
     Aktualisieren;
     Change;
    END;
   END;
   VK_BACK:BEGIN
    IF (Col>=0) AND (Col<256) THEN BEGIN
     Track.Enter;
     Track.PatternOrder[Col]:=$FF;
     Track.Changed:=TRUE;
     Track.Leave;
     Aktualisieren;
     Change;
    END;
   END;
   ELSE BEGIN
    INHERITED KeyDown(Key,Shift);
   END;
  END;
 END ELSE BEGIN
  INHERITED KeyDown(Key,Shift);
 END;
END;

PROCEDURE TPatternOrderEditor.Aktualisieren;
BEGIN
 Invalidate;
END;

PROCEDURE TPatternOrderEditor.Change;
BEGIN
 IF (Col>=0) AND (Col<256) THEN BEGIN
  (Form AS TMainForm).PatternEditor.AktPattern:=Track.PatternOrder[Col];
  (Form AS TMainForm).PatternEditor.AktZeile:=0;
  (Form AS TMainForm).PatternEditor.Invalidate;
 END;
END;

PROCEDURE TPatternOrderEditor.Click;
BEGIN
 INHERITED Click;
 Change;
END;

PROCEDURE TPatternOrderEditor.DrawCell(ACol,ARow:Longint;ARect:TRect;AState:TGridDrawState);
VAR S:STRING;
    J:INTEGER;
BEGIN
 INHERITED DrawCell(ACol,ARow,ARect,AState);
 WITH Canvas DO BEGIN
  IF gdSelected IN AState THEN BEGIN
   Canvas.Brush.Color:=$800000;
   Canvas.Font.Color:=clWhite;
  END ELSE IF gdFocused IN AState THEN BEGIN
   Canvas.Brush.Color:=$606060;
   Canvas.Font.Color:=clWhite;
  END ELSE IF (ACol=Track.CurrentPatternOrder) AND Track.Playing AND NOT Track.FollowSong THEN BEGIN
   Canvas.Brush.Color:=$008080;
   Canvas.Font.Color:=clWhite;
  END ELSE IF ACol=Track.RestartPosition THEN BEGIN
   Canvas.Brush.Color:=$000080;
   Canvas.Font.Color:=clWhite;
  END ELSE BEGIN
   Canvas.Brush.Color:=clWhite;
   Canvas.Font.Color:=clBlack;
  END;
  IF gdSelected IN AState THEN BEGIN
   Canvas.Pen.Style:=psSolid;
   Canvas.Pen.Color:=NOT Canvas.Brush.Color;
   Canvas.Pen.Width:=1;
   Canvas.Brush.Style:=bsSolid;
   Canvas.Rectangle(ARect);
   IF ACol=Track.RestartPosition THEN BEGIN
    Canvas.Pen.Style:=psSolid;
    Canvas.Pen.Color:=$0000FF;
    Canvas.Pen.Width:=1;
    Canvas.Rectangle(ARect.Left+1,ARect.Top+1,ARect.Right-1,ARect.Bottom-1);
   END;
  END ELSE BEGIN
   Canvas.Pen.Style:=psSolid;
   Canvas.Pen.Color:=Canvas.Brush.Color;
   Canvas.Pen.Width:=1;
   Canvas.Brush.Style:=bsSolid;
   IF ACol=Track.RestartPosition THEN BEGIN
    Canvas.Pen.Style:=psSolid;
    Canvas.Pen.Color:=$0000FF;
    Canvas.Pen.Width:=1;
   END;
   Canvas.Rectangle(ARect);
  END;
  Canvas.Pen.Width:=1;
  IF ACol<256 THEN BEGIN
   J:=Track.PatternOrder[ACol];
   IF J<$FE THEN BEGIN
    IF J>=256 THEN BEGIN
     Track.PatternOrder[ACol]:=256-1;
     J:=256-1;
    END;
   END;
   IF J<$FE THEN BEGIN
    S:=Hex2C(Track.PatternOrder[ACol]);
   END ELSE IF J=$FE THEN BEGIN
    S:='++';
   END ELSE IF J=$FF THEN BEGIN
    S:='--';
   END;
  END ELSE BEGIN
   S:='--';
  END;
  Canvas.TextOut((ARect.Left+((ARect.Right-ARect.Left)-TextWidth(S)) DIV 2)-1,
                 (ARect.Top+((ARect.Bottom-ARect.Top)-TextHeight(S)) DIV 2)-1,
                 S);
 END;
END;

FUNCTION TPatternOrderEditor.SelectCell(ACol,ARow:LONGINT):BOOLEAN;
BEGIN
 IF (ACol>=0) AND (ACol<256) THEN BEGIN
  IF (Form AS TMainForm).Track.CurrentPatternOrder<>ACol THEN BEGIN
   (Form AS TMainForm).Track.Enter;
   (Form AS TMainForm).Track.CurrentPatternOrder:=ACol;
   (Form AS TMainForm).Track.CurrentRow:=0;
   (Form AS TMainForm).Track.NextPatternOrder:=ACol;
   (Form AS TMainForm).Track.NextRow:=0;
   (Form AS TMainForm).Track.Leave;
  END;
  (Form AS TMainForm).PatternEditor.AktPattern:=Track.PatternOrder[ACol];
  (Form AS TMainForm).PatternEditor.AktZeile:=0;
  (Form AS TMainForm).PatternEditor.Invalidate;
 END;
 RESULT:=INHERITED SelectCell(ACol,ARow);
END;

PROCEDURE TPatternOrderEditor.MouseDown(Button:TMouseButton;Shift:TShiftState;X,Y:INTEGER);
BEGIN
 IF Button=mbRight THEN BEGIN
  INHERITED MouseDown(mbLeft,Shift,X,Y);
 END ELSE IF Button=mbLeft THEN BEGIN
  INHERITED MouseDown(Button,Shift,X,Y);
// IF Track.Playing AND Track.FollowSong THEN (Form AS TTrackForm).ForwardPlayButtonClick(SELF);
  IF (Form AS TMainForm).PatternEditor.Markierung THEN BEGIN
   (Form AS TMainForm).PatternEditor.Markierung:=FALSE;
  END;
 END;
END;

PROCEDURE TPatternOrderEditor.MouseUp(Button:TMouseButton;Shift:TShiftState;X,Y:INTEGER);
BEGIN
 IF Button=mbRight THEN BEGIN
  INHERITED MouseUp(mbLeft,Shift,X,Y);
  IF Track.PatternOrder[Col]<$FF THEN BEGIN
   PatternPopupMenu.Popup(Mouse.CursorPos.X,Mouse.CursorPos.Y);
  END ELSE IF (Form AS TMainForm).PatternMemoryOk THEN BEGIN
   EmptyMemoryPopupMenu.Popup(Mouse.CursorPos.X,Mouse.CursorPos.Y);
  END ELSE BEGIN
   EmptyPopupMenu.Popup(Mouse.CursorPos.X,Mouse.CursorPos.Y);
  END;
 END ELSE BEGIN
  INHERITED MouseUp(Button,Shift,X,Y);
 END;
END;

PROCEDURE TPatternOrderEditor.OnInsertPattern(Sender:TObject);
BEGIN
 InsertPattern;
END;

PROCEDURE TPatternOrderEditor.OnDeletePattern(Sender:TObject);
BEGIN
 DeletePattern;
END;

PROCEDURE TPatternOrderEditor.OnCreateNewPattern(Sender:TObject);
BEGIN
 CreateNewPattern;
END;

PROCEDURE TPatternOrderEditor.OnDuplicate(Sender:TObject);
BEGIN
 DuplicatePattern;
END;

PROCEDURE TPatternOrderEditor.OnCopyPattern(Sender:TObject);
BEGIN
 CopyPattern;
END;

PROCEDURE TPatternOrderEditor.OnPastePattern(Sender:TObject);
BEGIN
 PastePattern;
END;

PROCEDURE TPatternOrderEditor.OnMarkAsRestartPosition(Sender:TObject);
BEGIN
 MarkAsRestartPosition;
END;

PROCEDURE TPatternOrderEditor.OnPlayAtPattern(Sender:TObject);
BEGIN
//(Form AS TMainForm).ForwardPlayButtonClick(SELF);
END;

PROCEDURE TPatternOrderEditor.OnPlayPatternInLoop(Sender:TObject);
BEGIN
//(Form AS TMainForm).PatternPlayButtonClick(SELF);
END;

FUNCTION TPatternOrderEditor.WirdVerwendet(K:BYTE):BOOLEAN;
VAR I:BYTE;
BEGIN
 RESULT:=FALSE;
 FOR I:=0 TO 255 DO IF Track.PatternOrder[I]=K THEN BEGIN
  RESULT:=TRUE;
  BREAK;
 END;
END;

FUNCTION TPatternOrderEditor.IstLeer(K:BYTE):BOOLEAN;
BEGIN
 RESULT:=TRUE;
END;

END.
