
#include "test/TestMidiState.h"
#include "midi.h"
#include "MidiState.h"

#include <cassert>
#include <cstdio>



int	TestMidiState::perform_test ()
{
	int            ret_val = 0;

	printf ("Testing MidiState...\n");
	fflush (stdout);

	if (ret_val == 0)
	{
		// Just a note on
		test_bytestream (
			ByteArray { 0x90, midi::_note_cmid, 0x40 },
			ResultArray {
				{ },
				{ },
				{ { 0x90, midi::_note_cmid, 0x40 } }
			}
		);
	}

	if (ret_val == 0)
	{
		// Note on + note off using running status
		test_bytestream (
			ByteArray { 0x95, midi::_note_cmid, 0x40, midi::_note_cmid, 0 },
			ResultArray {
				{ },
				{ },
				{ { 0x95, midi::_note_cmid, 0x40 } },
				{ },
				{ { 0x85, midi::_note_cmid, 0x40 } }
			}
		);
	}

	if (ret_val == 0)
	{
		// Note on + note off using running status, with RT messages interleaved
		test_bytestream (
			ByteArray {
				0x90, midi::_note_cmid, midi::_st_rt_clock, 0x40,
				midi::_st_rt_act_sens, midi::_note_cmid, 0
			},
			ResultArray {
				{ },
				{ },
				{ { midi::_st_rt_clock } },
				{ { 0x90, midi::_note_cmid, 0x40 } },
				{ { midi::_st_rt_act_sens } },
				{ },
				{ { 0x80, midi::_note_cmid, 0x40 } }
			}
		);
	}

	if (ret_val == 0)
	{
		// Note on + sysex + note off
		test_bytestream (
			ByteArray {
				0x90, midi::_note_cmid, 0x40,
				midi::_st_com_sysex, 1, 2, 3, 4, midi::_st_com_sysex_end,
				0x80, midi::_note_cmid, 0
			},
			ResultArray {
				{ },
				{ },
				{ { 0x90, midi::_note_cmid, 0x40 } },

				{ },
				{ },
				{ },
				{ },
				{ },
				{ {}, { 1, 2, 3, 4 } },

				{ },
				{ },
				{ { 0x80, midi::_note_cmid, 0 } }
			}
		);
	}

	if (ret_val == 0)
	{
		// Note on + 2 sysex + tune request + note off,
		// with an interleaved RT message
		test_bytestream (
			ByteArray {
				0x90, midi::_note_cmid, 0x40,
				midi::_st_com_sysex, 1, 2, midi::_st_rt_clock, 3, 4,
				midi::_st_com_sysex, 5, 6, 7, 8, 9,
				midi::_st_com_tune_req,
				0x80, midi::_note_cmid, 0
			},
			ResultArray {
				{ },
				{ },
				{ { 0x90, midi::_note_cmid, 0x40 } },

				{ },
				{ },
				{ },
				{ { midi::_st_rt_clock } },
				{ },
				{ },

				{ {}, { 1, 2, 3, 4 } },
				{ },
				{ },
				{ },
				{ },
				{ },

				{ { midi::_st_com_tune_req }, { 5, 6, 7, 8, 9 } },

				{ },
				{ },
				{ { 0x80, midi::_note_cmid, 0 } }
			}
		);
	}

	if (ret_val == 0)
	{
		// Illformed streams
		test_bytestream (
			ByteArray {
				midi::_note_cmid,        // Data byte with no running status
				0x90, midi::_note_cmid,  // Truncated message
				0x90, midi::_note_cmid, 0x40,
				midi::_st_com_sysex_end, // No SysEx started
				midi::_note_cmid         // Data byte with no running status
			},
			ResultArray {
				{ },
				{ },
				{ },
				{ },
				{ },
				{ { 0x90, midi::_note_cmid, 0x40 } },
				{ },
				{ }
			}
		);
	}

	printf ("Done.");
	fflush (stdout);

	return ret_val;
}



int	TestMidiState::test_bytestream (const ByteArray &src, const ResultArray &ref)
{
	MidiState      state;

	const auto     len = src.size ();
	assert (ref.size () == len);

	ByteArray      msg;
	for (size_t pos = 0; pos < len; ++pos)
	{
		state.push_byte (src [pos]);
		const auto &   ref_step = ref [pos];
		state.get_message (msg);
		if (msg != ref_step._normal)
		{
			printf ("Error (normal command) at step %d\n", int (pos));
			return -1;
		}
		state.get_sysex (msg);
		if (msg != ref_step._sysex)
		{
			printf ("Error (sysex command) at step %d\n", int (pos));
			return -1;
		}
	}

	return 0;
}
